/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.dao.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchIndexBuilderWorker;
import org.sakaiproject.search.api.rdf.RDFIndexException;
import org.sakaiproject.search.api.rdf.RDFSearchService;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.dao.SearchIndexBuilderWorkerDao;
import org.sakaiproject.search.index.IndexStorage;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.model.impl.SearchBuilderItemImpl;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;

public class SearchIndexBuilderWorkerDaoJdbcImpl
implements SearchIndexBuilderWorkerDao {
    private static final String SEARCH_BUILDER_ITEM_FIELDS = " name, context,  searchaction, searchstate, version, itemscope, id ";
    private static final String SEARCH_BUILDER_ITEM_T = "searchbuilderitem";
    private static final String SEARCH_BUILDER_ITEM_FIELDS_PARAMS = " ?, ?, ?,  ?, ?, ?, ? ";
    private static final String SEARCH_BUILDER_ITEM_FIELDS_UPDATE = " name = ?, context = ?,  searchaction = ?, searchstate = ?, version = ?, itemscope = ? where id = ? ";
    private static Log log = LogFactory.getLog(SearchIndexBuilderWorkerDaoJdbcImpl.class);
    private SearchIndexBuilder searchIndexBuilder = null;
    private boolean enabled = false;
    private RDFSearchService rdfSearchService = null;
    private IndexStorage indexStorage = null;
    private DataSource dataSource = null;
    private ServerConfigurationService serverConfigurationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        block34: {
            this.enabled = "true".equals(this.serverConfigurationService.getString("search.enable", "false"));
            try {
                if (this.rdfSearchService == null) {
                    log.info((Object)"No RDFSearchService has been defined, RDF Indexing not enabled");
                } else {
                    log.warn((Object)("Experimental RDF Search Service is enabled using implementation " + this.rdfSearchService));
                }
                if (!this.enabled) break block34;
                Connection con = null;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    con = this.dataSource.getConnection();
                    stmt = con.createStatement();
                    int nglobal = 0;
                    try {
                        rs = stmt.executeQuery("select count(*) from searchbuilderitem where itemscope = " + SearchBuilderItem.ITEM_GLOBAL_MASTER);
                        if (rs.next()) {
                            nglobal = rs.getInt(1);
                        }
                    }
                    catch (Exception ex) {
                        log.error((Object)"Schema Has not been updated to include itemscope column, please run SAK-9865.sql script on this database ");
                        System.exit(-1);
                    }
                    if (nglobal == 0) {
                        stmt.execute("update searchbuilderitem set itemscope= " + SearchBuilderItem.ITEM);
                        stmt.execute("update searchbuilderitem set itemscope= " + SearchBuilderItem.ITEM_SITE_MASTER + " where name like '" + "_master_control_%" + "'");
                        stmt.execute("update searchbuilderitem set itemscope= " + SearchBuilderItem.ITEM_GLOBAL_MASTER + " where context = '" + "global" + "'");
                        log.info((Object)"Exiting search item builder records have been optimized for itemscope access ");
                    }
                    con.commit();
                }
                catch (Exception ex) {
                    try {
                        if (con != null) {
                            con.rollback();
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    log.error((Object)"Failed to migrate indexes to itemscope based storage, search cant startup, please investigate immediately ");
                    System.exit(-1);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    try {
                        con.close();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Failed to init ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeletes(SearchIndexBuilderWorker worker, Connection connection, List<SearchBuilderItem> runtimeToDo) throws SQLException, IOException {
        if (this.indexStorage.indexExists()) {
            IndexReader indexReader = null;
            try {
                indexReader = this.indexStorage.getIndexReader();
                Iterator<SearchBuilderItem> tditer = runtimeToDo.iterator();
                while (worker.isRunning() && tditer.hasNext()) {
                    SearchBuilderItem sbi = tditer.next();
                    if (!SearchBuilderItem.STATE_LOCKED.equals(sbi.getSearchstate())) {
                        log.warn((Object)(" Found Item that was not pending " + sbi.getName()));
                        continue;
                    }
                    if (SearchBuilderItem.ACTION_UNKNOWN.equals(sbi.getSearchaction())) {
                        sbi.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
                        this.updateOrSave(connection, sbi);
                        continue;
                    }
                    try {
                        indexReader.deleteDocuments(new Term("reference", sbi.getName()));
                        if (SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) {
                            sbi.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
                            this.updateOrSave(connection, sbi);
                            continue;
                        }
                        sbi.setSearchstate(SearchBuilderItem.STATE_PENDING_2);
                    }
                    catch (IOException ex) {
                        log.warn((Object)"Failed to delete Page ", (Throwable)ex);
                    }
                }
            }
            finally {
                if (indexReader != null) {
                    this.indexStorage.closeIndexReader(indexReader);
                    indexReader = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdd(SearchIndexBuilderWorker worker, Connection connection, List<SearchBuilderItem> runtimeToDo) throws Exception {
        IndexWriter indexWrite = null;
        try {
            if (worker.isRunning()) {
                indexWrite = this.indexStorage.getIndexWriter(false);
            }
            long last = System.currentTimeMillis();
            Iterator<SearchBuilderItem> tditer = runtimeToDo.iterator();
            while (worker.isRunning() && tditer.hasNext()) {
                Reader contentReader = null;
                try {
                    long now;
                    SearchBuilderItem sbi = tditer.next();
                    if (!SearchBuilderItem.STATE_PENDING_2.equals(sbi.getSearchstate()) && !SearchBuilderItem.STATE_LOCKED.equals(sbi.getSearchstate())) continue;
                    String ref = sbi.getName();
                    if (ref == null) {
                        log.error((Object)("Unrecognised trigger object presented to index builder " + sbi));
                    }
                    long startDocIndex = System.currentTimeMillis();
                    worker.setStartDocIndex(startDocIndex);
                    worker.setNowIndexing(ref);
                    try {
                        try {
                            EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(ref);
                            boolean indexDoc = true;
                            if (this.searchIndexBuilder.isOnlyIndexSearchToolSites()) {
                                try {
                                    String siteId = sep.getSiteId(sbi.getName());
                                    Site s = SiteService.getSite((String)siteId);
                                    ToolConfiguration t = s.getToolForCommonId("sakai.search");
                                    if (t == null) {
                                        indexDoc = false;
                                        log.debug((Object)("Not indexing " + sbi.getName() + " as it has no search tool"));
                                    }
                                }
                                catch (Exception ex) {
                                    indexDoc = false;
                                    log.debug((Object)("Not indexing  " + sbi.getName() + " as it has no site"), (Throwable)ex);
                                }
                            }
                            if (indexDoc && sep != null && sep.isForIndex(ref) && sep.getSiteId(ref) != null) {
                                Document doc = new Document();
                                String container = sep.getContainer(ref);
                                if (container == null) {
                                    container = "";
                                }
                                doc.add((Fieldable)new Field("indexdate", String.valueOf(System.currentTimeMillis()), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("container", this.filterNull(container), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("id", this.filterNull(sep.getId(ref)), Field.Store.COMPRESS, Field.Index.NO));
                                doc.add((Fieldable)new Field("type", this.filterNull(sep.getType(ref)), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("subtype", this.filterNull(sep.getSubType(ref)), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("reference", this.filterNull(ref), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                if (sep.isContentFromReader(ref)) {
                                    contentReader = sep.getContentReader(ref);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Adding Content for " + ref + " using " + contentReader));
                                    }
                                    doc.add((Fieldable)new Field("contents", contentReader, Field.TermVector.YES));
                                } else {
                                    String content = sep.getContent(ref);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Adding Content for " + ref + " as [" + content + "]"));
                                    }
                                    doc.add((Fieldable)new Field("contents", this.filterNull(content), Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.YES));
                                }
                                doc.add((Fieldable)new Field("title", this.filterNull(sep.getTitle(ref)), Field.Store.COMPRESS, Field.Index.TOKENIZED, Field.TermVector.YES));
                                doc.add((Fieldable)new Field("tool", this.filterNull(sep.getTool()), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("url", this.filterUrl(this.filterNull(sep.getUrl(ref))), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                doc.add((Fieldable)new Field("siteid", this.filterNull(sep.getSiteId(ref)), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                Map m = sep.getCustomProperties(ref);
                                if (m != null) {
                                    for (String key : m.keySet()) {
                                        Object value = m.get(key);
                                        String[] values = null;
                                        if (value instanceof String) {
                                            values = new String[]{(String)value};
                                        }
                                        if (value instanceof String[]) {
                                            values = (String[])value;
                                        }
                                        if (values == null) {
                                            log.info((Object)("Null Custom Properties value has been suppled by " + sep + " in index " + key));
                                            continue;
                                        }
                                        for (int i = 0; i < values.length; ++i) {
                                            if (key.startsWith("T")) {
                                                key = key.substring(1);
                                                doc.add((Fieldable)new Field(key, this.filterNull(values[i]), Field.Store.COMPRESS, Field.Index.TOKENIZED, Field.TermVector.YES));
                                                continue;
                                            }
                                            doc.add((Fieldable)new Field(key, this.filterNull(values[i]), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                                        }
                                    }
                                }
                                log.debug((Object)("Indexing Document " + doc));
                                indexWrite.addDocument(doc);
                                log.debug((Object)("Done Indexing Document " + doc));
                                this.processRDF(ref, sep);
                            } else if (log.isDebugEnabled()) {
                                if (!indexDoc) {
                                    log.debug((Object)("Ignored Document: Fileteed out by site " + ref));
                                } else if (sep == null) {
                                    log.debug((Object)("Ignored Document: No EntityContentProducer " + ref));
                                } else if (!sep.isForIndex(ref)) {
                                    log.debug((Object)("Ignored Document: Marked as Ignore " + ref));
                                } else if (sep.getSiteId(ref) == null) {
                                    log.debug((Object)("Ignored Document: No Site ID " + ref));
                                } else {
                                    log.debug((Object)("Ignored Document: Reason Unknown " + ref));
                                }
                            }
                        }
                        catch (Exception e1) {
                            log.debug((Object)(" Failed to index document for " + ref + " cause: " + e1.getMessage()), (Throwable)e1);
                        }
                        sbi.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
                        this.updateOrSave(connection, sbi);
                    }
                    catch (Exception e1) {
                        log.debug((Object)(" Failed to index document cause: " + e1.getMessage()));
                    }
                    long endDocIndex = System.currentTimeMillis();
                    worker.setLastIndex(endDocIndex - startDocIndex);
                    if (endDocIndex - startDocIndex > 60000L) {
                        log.warn((Object)("Slow index operation " + String.valueOf((endDocIndex - startDocIndex) / 1000L) + " seconds to index " + ref));
                    }
                    if ((now = System.currentTimeMillis()) - last <= 60000L) continue;
                    last = System.currentTimeMillis();
                    if (worker.getLockTransaction(900000L, true)) continue;
                    throw new Exception("Transaction Lock Expired while indexing " + ref);
                }
                finally {
                    if (contentReader == null) continue;
                    try {
                        contentReader.close();
                    }
                    catch (IOException ioex) {
                        log.debug((Object)ioex);
                    }
                }
            }
            worker.setStartDocIndex(System.currentTimeMillis());
            worker.setNowIndexing(Messages.getString("SearchIndexBuilderWorkerDaoJdbcImpl.33"));
        }
        catch (Exception ex) {
            log.error((Object)"Failed to Add Documents ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            if (indexWrite != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing Index Writer With " + indexWrite.docCount() + " documents"));
                    Directory d = indexWrite.getDirectory();
                    String[] s = d.list();
                    log.debug((Object)"Directory Contains ");
                    for (int i = 0; i < s.length; ++i) {
                        File f = new File(s[i]);
                        log.debug((Object)("\t" + String.valueOf(f.length()) + "\t" + new Date(f.lastModified()) + "\t" + s[i]));
                    }
                }
                this.indexStorage.closeIndexWriter(indexWrite);
            }
        }
    }

    private String filterUrl(String url) {
        String serverURL = this.serverConfigurationService.getServerUrl();
        if (url != null && url.startsWith(serverURL)) {
            String absUrl = url.substring(serverURL.length());
            if (!absUrl.startsWith("/")) {
                absUrl = "/" + absUrl;
            }
            return absUrl;
        }
        return url;
    }

    private String filterNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private int completeUpdate(SearchIndexBuilderWorker worker, Connection connection, List runtimeToDo) throws Exception {
        try {
            Iterator tditer = runtimeToDo.iterator();
            while (worker.isRunning() && tditer.hasNext()) {
                SearchBuilderItem sbi = (SearchBuilderItem)tditer.next();
                if (!SearchBuilderItem.STATE_COMPLETED.equals(sbi.getSearchstate())) continue;
                if (SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) {
                    this.delete(connection, sbi);
                    connection.commit();
                    continue;
                }
                this.updateOrSave(connection, sbi);
                connection.commit();
            }
            return runtimeToDo.size();
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to update state in database due to " + ex.getMessage() + " this will be corrected on the next run of the IndexBuilder, no cause for alarm"));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processToDoListTransaction(SearchIndexBuilderWorker worker, int indexBatchSize) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            long startTime = System.currentTimeMillis();
            int totalDocs = 0;
            List runtimeToDo = this.findPending(indexBatchSize, connection, worker);
            totalDocs = runtimeToDo.size();
            log.debug((Object)("Processing " + totalDocs + " documents"));
            if (totalDocs > 0) {
                log.debug((Object)"Preupdate Start");
                this.indexStorage.doPreIndexUpdate();
                log.debug((Object)"Preupdate End");
                log.debug((Object)"Process Deletes Start");
                this.processDeletes(worker, connection, runtimeToDo);
                log.debug((Object)"Process Deletes End");
                log.debug((Object)"Process Add Start");
                this.processAdd(worker, connection, runtimeToDo);
                log.debug((Object)"Process Add End");
                log.debug((Object)"Complete Update Start");
                this.completeUpdate(worker, connection, runtimeToDo);
                log.debug((Object)"Complete Update End");
                try {
                    log.debug((Object)"Post update Start");
                    this.indexStorage.doPostIndexUpdate();
                    log.debug((Object)"Post update End");
                }
                catch (IOException e) {
                    log.error((Object)"Failed to do Post Index Update", (Throwable)e);
                }
            }
            if (worker.isRunning()) {
                long endTime = System.currentTimeMillis();
                float totalTime = endTime - startTime;
                float ndocs = totalDocs;
                if (totalDocs > 0) {
                    float docspersec = 1000.0f * ndocs / totalTime;
                    log.info((Object)("Completed Process List of " + totalDocs + " at " + docspersec + " documents/per second "));
                }
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to perform index cycle " + ex.getMessage()), (Throwable)ex);
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                log.debug((Object)e);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndexTransaction(SearchIndexBuilderWorker worker) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            long startTime = System.currentTimeMillis();
            boolean totalDocs = false;
            log.debug((Object)"Preupdate Start");
            this.indexStorage.doPreIndexUpdate();
            log.debug((Object)"Preupdate End");
            this.createIndex(worker, connection);
            try {
                log.debug((Object)"Post update Start");
                this.indexStorage.doPostIndexUpdate();
                log.debug((Object)"Post update End");
            }
            catch (IOException e) {
                log.error((Object)"Failed to do Post Index Update", (Throwable)e);
            }
            log.info((Object)"Created Index");
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to create Index " + ex.getMessage()));
            log.debug((Object)"Traceback is ", (Throwable)ex);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    private void createIndex(SearchIndexBuilderWorker worker, Connection connection) throws Exception {
        IndexWriter indexWrite = null;
        try {
            if (worker.isRunning()) {
                indexWrite = this.indexStorage.getIndexWriter(false);
            }
            if (indexWrite != null) {
                Document doc = new Document();
                doc.add((Fieldable)new Field("indexdate", String.valueOf(System.currentTimeMillis()), Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                doc.add((Fieldable)new Field("id", "---INDEX-CREATED---", Field.Store.COMPRESS, Field.Index.UN_TOKENIZED));
                indexWrite.addDocument(doc);
            } else {
                log.error((Object)"Couldn't get indexWriter to add document!");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to Add Documents ", (Throwable)ex);
            throw new Exception(ex);
        }
        finally {
            if (indexWrite != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing Index Writer With " + indexWrite.docCount() + " documents"));
                    Directory d = indexWrite.getDirectory();
                    String[] s = d.list();
                    log.debug((Object)"Directory Contains ");
                    for (int i = 0; i < s.length; ++i) {
                        File f = new File(s[i]);
                        log.debug((Object)("\t" + String.valueOf(f.length()) + "\t" + new Date(f.lastModified()) + "\t" + s[i]));
                    }
                }
                this.indexStorage.closeIndexWriter(indexWrite);
            }
        }
    }

    private void processRDF(String ref, EntityContentProducer sep) throws RDFIndexException {
        String s;
        if (this.rdfSearchService != null && (s = sep.getCustomRDF(ref)) != null) {
            this.rdfSearchService.addData(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSiteMasterItems(Connection connection) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where itemscope =   ?  ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.ITEM_SITE_MASTER);
            rst = pst.executeQuery();
            ArrayList<SearchBuilderItemImpl> a = new ArrayList<SearchBuilderItemImpl>();
            while (rst.next()) {
                SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                this.populateSearchBuilderItem(rst, sbi);
                a.add(sbi);
            }
            ArrayList<SearchBuilderItemImpl> arrayList = a;
            return arrayList;
        }
        finally {
            try {
                rst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchBuilderItem getMasterItem(Connection connection) throws SQLException {
        log.debug((Object)("get Master Items with " + connection));
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where itemscope = ? ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.ITEM_GLOBAL_MASTER);
            rst = pst.executeQuery();
            SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
            if (rst.next()) {
                this.populateSearchBuilderItem(rst, sbi);
            } else {
                sbi.setName("_master_control");
                sbi.setContext("global");
                sbi.setSearchaction(SearchBuilderItem.ACTION_UNKNOWN);
                sbi.setSearchstate(SearchBuilderItem.STATE_UNKNOWN);
                sbi.setItemscope(SearchBuilderItem.ITEM_GLOBAL_MASTER);
            }
            SearchBuilderItemImpl searchBuilderItemImpl = sbi;
            return searchBuilderItemImpl;
        }
        finally {
            try {
                rst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    private void populateSearchBuilderItem(ResultSet rst, SearchBuilderItemImpl sbi) throws SQLException {
        sbi.setName(rst.getString(1));
        sbi.setContext(rst.getString(2));
        sbi.setSearchaction(Integer.valueOf(rst.getInt(3)));
        sbi.setSearchstate(Integer.valueOf(rst.getInt(4)));
        sbi.setVersion((java.util.Date)rst.getDate(5));
        sbi.setItemscope(Integer.valueOf(rst.getInt(6)));
        sbi.setId(rst.getString(7));
    }

    private int populateStatement(PreparedStatement pst, SearchBuilderItem sbi) throws SQLException {
        pst.setString(1, sbi.getName());
        pst.setString(2, sbi.getContext());
        pst.setInt(3, sbi.getSearchaction());
        pst.setInt(4, sbi.getSearchstate());
        pst.setDate(5, new Date(sbi.getVersion().getTime()));
        pst.setInt(6, sbi.getItemscope());
        pst.setString(7, sbi.getId());
        return 7;
    }

    private void updateOrSave(Connection connection, SearchBuilderItem sbi) throws SQLException {
        PreparedStatement pst = null;
        try {
            try {
                this.save(connection, sbi);
            }
            catch (SQLException sqlex) {
                pst = connection.prepareStatement("update searchbuilderitem set  name = ?, context = ?,  searchaction = ?, searchstate = ?, version = ?, itemscope = ? where id = ? ");
                this.populateStatement(pst, sbi);
                pst.executeUpdate();
                connection.commit();
            }
        }
        catch (SQLException ex) {
            log.warn((Object)"Failed ", (Throwable)ex);
            connection.rollback();
            throw ex;
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Connection connection, SearchBuilderItem sbi) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = connection.prepareStatement(" insert into searchbuilderitem (  name, context,  searchaction, searchstate, version, itemscope, id  ) values (  ?, ?, ?,  ?, ?, ?, ?  ) ");
            pst.clearParameters();
            this.populateStatement(pst, sbi);
            pst.executeUpdate();
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    private void delete(Connection connection, SearchBuilderItem sbi) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = connection.prepareStatement(" delete from searchbuilderitem where id = ? ");
            pst.clearParameters();
            pst.setString(1, sbi.getId());
            pst.execute();
        }
        catch (SQLException ex) {
            log.warn((Object)"Failed ", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    private Integer getSiteMasterAction(SearchBuilderItem siteMaster) {
        if (siteMaster.getName().startsWith("_master_control") && !"global".equals(siteMaster.getContext()) && SearchBuilderItem.STATE_PENDING.equals(siteMaster.getSearchstate())) {
            return siteMaster.getSearchaction();
        }
        return SearchBuilderItem.STATE_UNKNOWN;
    }

    private String getSiteMasterSite(SearchBuilderItem siteMaster) {
        if (siteMaster.getName().startsWith("_master_control") && !"global".equals(siteMaster.getContext())) {
            return siteMaster.getName().substring("_master_control".length() + 1);
        }
        return null;
    }

    private Integer getMasterAction(SearchBuilderItem master) {
        if (master.getName().equals("_master_control_global") && SearchBuilderItem.STATE_PENDING.equals(master.getSearchstate())) {
            return master.getSearchaction();
        }
        return SearchBuilderItem.STATE_UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List findPending(int batchSize, Connection connection, SearchIndexBuilderWorker worker) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            ArrayList<SearchBuilderItemImpl> arrayList;
            log.debug((Object)("TXFind pending with " + connection));
            SearchBuilderItem masterItem = this.getMasterItem(connection);
            Integer masterAction = this.getMasterAction(masterItem);
            log.debug((Object)(" Master Item is " + masterItem.getName() + ":" + masterItem.getSearchaction() + ":" + masterItem.getSearchstate() + "::" + masterItem.getVersion()));
            if (SearchBuilderItem.ACTION_REFRESH.equals(masterAction)) {
                log.debug((Object)(" Master Action is " + masterAction));
                log.debug((Object)("  REFRESH = " + SearchBuilderItem.ACTION_REFRESH));
                log.debug((Object)("  RELOAD = " + SearchBuilderItem.ACTION_REBUILD));
                this.refreshIndex(connection, masterItem);
            } else if (SearchBuilderItem.ACTION_REBUILD.equals(masterAction)) {
                this.rebuildIndex(connection, masterItem, worker);
            } else {
                List siteMasters = this.getSiteMasterItems(connection);
                for (SearchBuilderItem siteMaster : siteMasters) {
                    Integer action = this.getSiteMasterAction(siteMaster);
                    if (SearchBuilderItem.ACTION_REBUILD.equals(action)) {
                        this.rebuildIndex(connection, siteMaster, worker);
                        continue;
                    }
                    if (!SearchBuilderItem.ACTION_REFRESH.equals(action)) continue;
                    this.refreshIndex(connection, siteMaster);
                }
            }
            PreparedStatement pst = null;
            PreparedStatement lockedPst = null;
            ResultSet rst = null;
            try {
                pst = connection.prepareStatement("select  name, context,  searchaction, searchstate, version, itemscope, id  from searchbuilderitem where searchstate = ? and             itemscope = ?  order by version ");
                lockedPst = connection.prepareStatement("update searchbuilderitem set searchstate = ?  where id = ?  and  searchstate = ? ");
                pst.clearParameters();
                pst.setInt(1, SearchBuilderItem.STATE_PENDING);
                pst.setInt(2, SearchBuilderItem.ITEM);
                rst = pst.executeQuery();
                ArrayList<SearchBuilderItemImpl> a = new ArrayList<SearchBuilderItemImpl>();
                while (rst.next() && a.size() < batchSize) {
                    SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                    this.populateSearchBuilderItem(rst, sbi);
                    if (SearchBuilderItem.ACTION_UNKNOWN.equals(sbi.getSearchaction())) continue;
                    lockedPst.clearParameters();
                    lockedPst.setInt(1, SearchBuilderItem.STATE_LOCKED);
                    lockedPst.setString(2, sbi.getId());
                    lockedPst.setInt(3, SearchBuilderItem.STATE_PENDING);
                    if (lockedPst.executeUpdate() == 1) {
                        sbi.setSearchstate(SearchBuilderItem.STATE_LOCKED);
                        a.add(sbi);
                    }
                    connection.commit();
                }
                arrayList = a;
            }
            catch (Throwable throwable) {
                try {
                    rst.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                try {
                    pst.close();
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                }
                throw throwable;
            }
            try {
                rst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            return arrayList;
        }
        finally {
            long finish = System.currentTimeMillis();
            log.debug((Object)(" findPending took " + (finish - start) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countPending(Connection connection) {
        PreparedStatement pst = null;
        ResultSet rst = null;
        try {
            pst = connection.prepareStatement("select count(*) from searchbuilderitem where searchstate = ? ");
            pst.clearParameters();
            pst.setInt(1, SearchBuilderItem.STATE_PENDING);
            rst = pst.executeQuery();
            if (rst.next()) {
                int n = rst.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (SQLException sqlex) {
            int n = 0;
            return n;
        }
        finally {
            try {
                rst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            try {
                pst.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildIndex(Connection connection, SearchBuilderItem controlItem, SearchIndexBuilderWorker worker) throws SQLException {
        log.info((Object)"DELETE ALL RECORDS ==========================================================");
        Statement stm = null;
        try {
            stm = connection.createStatement();
            if ("global".equals(controlItem.getContext())) {
                stm.execute("delete from searchbuilderitem where itemscope = " + SearchBuilderItem.ITEM + " or itemscope = " + SearchBuilderItem.ITEM_SITE_MASTER);
            } else {
                stm.execute("delete from searchbuilderitem where itemscope = " + SearchBuilderItem.ITEM);
                stm.execute("delete from searchbuilderitem where context = '" + controlItem.getContext() + "' and name <> '" + controlItem.getName() + "' ");
            }
            log.debug((Object)"DONE DELETE ALL RECORDS ===========================================================");
            connection.commit();
            log.debug((Object)"ADD ALL RECORDS ===========================================================");
            long lastupdate = System.currentTimeMillis();
            ArrayList<String> contextList = new ArrayList<String>();
            if ("global".equals(controlItem.getContext())) {
                for (Site s : SiteService.getSites((SiteService.SelectionType)SiteService.SelectionType.ANY, null, null, null, (SiteService.SortType)SiteService.SortType.NONE, null)) {
                    if (SiteService.isSpecialSite((String)s.getId())) continue;
                    if (this.searchIndexBuilder.isOnlyIndexSearchToolSites()) {
                        ToolConfiguration t = s.getToolForCommonId("sakai.search");
                        if (t == null) continue;
                        contextList.add(s.getId());
                        continue;
                    }
                    if (this.searchIndexBuilder.isExcludeUserSites() && SiteService.isUserSite((String)s.getId())) continue;
                    contextList.add(s.getId());
                }
            } else {
                contextList.add(controlItem.getContext());
            }
            for (String siteContext : contextList) {
                log.debug((Object)("Rebuild for " + siteContext));
                for (EntityContentProducer ecp : this.searchIndexBuilder.getContentProducers()) {
                    Iterator contentIterator = null;
                    contentIterator = ecp.getSiteContentIterator(siteContext);
                    log.debug((Object)("Using ECP " + ecp));
                    int added = 0;
                    while (contentIterator.hasNext()) {
                        if (System.currentTimeMillis() - lastupdate > 60000L) {
                            lastupdate = System.currentTimeMillis();
                            if (!worker.getLockTransaction(900000L, true)) {
                                throw new RuntimeException("Transaction Lock Expired while Rebuilding Index ");
                            }
                        }
                        String resourceName = (String)contentIterator.next();
                        log.debug((Object)("Checking " + resourceName));
                        if (resourceName == null || resourceName.length() > 255) {
                            log.warn((Object)("Entity Reference Longer than 255 characters, ignored: Reference=" + resourceName));
                            continue;
                        }
                        SearchBuilderItemImpl sbi = new SearchBuilderItemImpl();
                        sbi.setName(resourceName);
                        sbi.setSearchaction(SearchBuilderItem.ACTION_ADD);
                        sbi.setSearchstate(SearchBuilderItem.STATE_PENDING);
                        sbi.setId(UUID.randomUUID().toString());
                        sbi.setVersion((java.util.Date)new Date(System.currentTimeMillis()));
                        sbi.setItemscope(SearchBuilderItem.ITEM);
                        String context = null;
                        try {
                            context = ecp.getSiteId(resourceName);
                        }
                        catch (Exception ex) {
                            log.debug((Object)("No context for resource " + resourceName + " defaulting to none"));
                        }
                        if (context == null || context.length() == 0) {
                            context = "none";
                        }
                        sbi.setContext(context);
                        try {
                            this.updateOrSave(connection, (SearchBuilderItem)sbi);
                        }
                        catch (SQLException sqlex) {
                            log.error((Object)("Failed to update " + sqlex.getMessage()));
                        }
                        connection.commit();
                    }
                    log.debug((Object)(" Added " + added));
                }
            }
            log.info((Object)"DONE ADD ALL RECORDS ===========================================================");
            controlItem.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
            this.updateOrSave(connection, controlItem);
            connection.commit();
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIndex(Connection connection, SearchBuilderItem controlItem) throws SQLException {
        log.debug((Object)"UPDATE ALL RECORDS ==========================================================");
        Statement stm = null;
        try {
            stm = connection.createStatement();
            if ("global".equals(controlItem.getContext())) {
                stm.execute("update searchbuilderitem set searchstate = " + SearchBuilderItem.STATE_PENDING + " where itemscope = " + SearchBuilderItem.ITEM);
            } else {
                stm.execute("update searchbuilderitem set searchstate = " + SearchBuilderItem.STATE_PENDING + " where itemscope = " + SearchBuilderItem.ITEM_SITE_MASTER + " and context = '" + controlItem.getContext() + "' and name <> '" + controlItem.getName() + "'");
            }
            controlItem.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
            this.updateOrSave(connection, controlItem);
            connection.commit();
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
    }

    public IndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    public void setIndexStorage(IndexStorage indexStorage) {
        this.indexStorage = indexStorage;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean isLockRequired() {
        return !this.indexStorage.isMultipleIndexers();
    }

    public boolean indexExists() {
        return this.indexStorage.centralIndexExists();
    }

    public RDFSearchService getRdfSearchService() {
        return this.rdfSearchService;
    }

    public void setRdfSearchService(RDFSearchService rdfSearchService) {
        this.rdfSearchService = rdfSearchService;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

