/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.service.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.api.NotificationEdit;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.search.api.InvalidSearchQueryException;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.SearchStatus;
import org.sakaiproject.search.api.TermFrequency;
import org.sakaiproject.search.component.Messages;
import org.sakaiproject.search.component.service.impl.SearchListImpl;
import org.sakaiproject.search.component.service.impl.SearchListResponseImpl;
import org.sakaiproject.search.component.service.impl.SearchNotificationAction;
import org.sakaiproject.search.filter.SearchItemFilter;
import org.sakaiproject.search.index.IndexReloadListener;
import org.sakaiproject.search.index.IndexStorage;
import org.sakaiproject.search.journal.impl.JournalSettings;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.util.DidYouMeanParser;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;

public abstract class BaseSearchServiceImpl
implements SearchService {
    private static Log log = LogFactory.getLog(BaseSearchServiceImpl.class);
    private SearchIndexBuilder searchIndexBuilder;
    private NotificationService notificationService;
    private EventTrackingService eventTrackingService;
    private UserDirectoryService userDirectoryService;
    private SessionManager sessionManager;
    private static final String DIGEST_STORE_FOLDER = "/searchdigest/";
    private List<String> triggerFunctions;
    private NotificationEdit notification = null;
    protected IndexStorage indexStorage;
    protected boolean initComplete = false;
    private SearchItemFilter filter;
    private Map luceneFilters = new HashMap();
    private Map luceneSorters = new HashMap();
    private String defaultFilter = null;
    private String defaultSorter = null;
    private String sharedKey = null;
    private String searchServerUrl = null;
    private boolean searchServer = false;
    private ThreadLocal<String> localSearch = new ThreadLocal();
    private HttpClient httpClient;
    private HttpConnectionManagerParams httpParams = new HttpConnectionManagerParams();
    private HttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
    protected boolean autoDdl = false;
    private boolean diagnostics;
    private boolean enabled;
    private JournalSettings journalSettings;
    Directory spellIndexDirectory = null;

    public void setJournalSettings(JournalSettings journalSettings) {
        this.journalSettings = journalSettings;
    }

    public abstract String getStatus();

    public abstract SearchStatus getSearchStatus();

    public abstract boolean removeWorkerLock();

    public void setAutoDdl(String value) {
        this.autoDdl = Boolean.valueOf(value);
    }

    public String getAutoDdl() {
        return String.valueOf(this.autoDdl);
    }

    public void init() {
        try {
            this.notification = this.notificationService.addTransientNotification();
            this.notification.setFunction("search.update");
            if (this.triggerFunctions != null) {
                for (String function : this.triggerFunctions) {
                    this.notification.addFunction(function);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding Search Register " + function));
                }
            }
            this.notification.setResourceFilter("/");
            this.notification.setAction((NotificationAction)new SearchNotificationAction(this.searchIndexBuilder));
            this.httpParams.setDefaultMaxConnectionsPerHost(20);
            this.httpParams.setMaxTotalConnections(30);
            this.httpParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 20);
            this.httpConnectionManager.setParams(this.httpParams);
            this.httpClient = new HttpClient(this.httpConnectionManager);
            if (this.diagnostics) {
                this.indexStorage.enableDiagnostics();
            } else {
                this.indexStorage.disableDiagnostics();
            }
            this.indexStorage.addReloadListener(new IndexReloadListener(){

                @Override
                public void reloaded(long reloadStart, long reloadEnd) {
                    if (BaseSearchServiceImpl.this.diagnostics) {
                        log.info((Object)("Index Reloaded containing " + BaseSearchServiceImpl.this.getNDocs() + " active documents and  " + BaseSearchServiceImpl.this.getPendingDocs() + " pending documents in " + (reloadEnd - reloadStart) + "ms"));
                    }
                }
            });
        }
        catch (Throwable t) {
            log.error((Object)"Failed to start ", t);
        }
    }

    public List<String> getTriggerFunctions() {
        return this.triggerFunctions;
    }

    public void setTriggerFunctions(List<String> triggerFunctions) {
        if (this.initComplete) {
            throw new RuntimeException(" use register function at runtime, setTriggerFucntions is for Spring IoC only");
        }
        this.triggerFunctions = triggerFunctions;
    }

    public void registerFunction(String function) {
        this.notification.addFunction(function);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Function " + function));
        }
    }

    public SearchList search(String searchTerms, List<String> contexts, int start, int end) throws InvalidSearchQueryException {
        return this.search(searchTerms, contexts, start, end, this.defaultFilter, this.defaultSorter);
    }

    public SearchList search(String searchTerms, List<String> contexts, int start, int end, String filterName, String sorterName) throws InvalidSearchQueryException {
        try {
            BooleanQuery query = new BooleanQuery();
            QueryParser qp = new QueryParser(Version.LUCENE_29, "contents", this.getAnalyzer());
            Query textQuery = qp.parse(searchTerms);
            if (contexts != null && contexts.size() > 0) {
                BooleanQuery contextQuery = new BooleanQuery();
                Iterator<String> i = contexts.iterator();
                while (i.hasNext()) {
                    contextQuery.add((Query)new TermQuery(new Term("siteid", i.next())), BooleanClause.Occur.SHOULD);
                }
                query.add((Query)contextQuery, BooleanClause.Occur.MUST);
            }
            query.add(textQuery, BooleanClause.Occur.MUST);
            log.debug((Object)("Compiled Query is " + query.toString()));
            if (this.localSearch.get() == null && this.searchServerUrl != null && this.searchServerUrl.length() > 0) {
                try {
                    PostMethod post = new PostMethod(this.searchServerUrl);
                    String userId = this.sessionManager.getCurrentSessionUserId();
                    StringBuilder sb = new StringBuilder();
                    Iterator<String> ci = contexts.iterator();
                    while (ci.hasNext()) {
                        sb.append(ci.next()).append(";");
                    }
                    String contextParam = sb.toString();
                    post.setParameter("cs", this.digestCheck(userId, searchTerms));
                    post.setParameter("ctx", contextParam);
                    post.setParameter("e", String.valueOf(end));
                    post.setParameter("s", String.valueOf(start));
                    post.setParameter("q", searchTerms);
                    post.setParameter("u", userId);
                    int status = this.httpClient.executeMethod((HttpMethod)post);
                    if (status != 200) {
                        throw new RuntimeException("Failed to perform remote search, http status was " + status);
                    }
                    String response = post.getResponseBodyAsString();
                    return new SearchListResponseImpl(response, textQuery, start, end, this.getAnalyzer(), this.filter, this.searchIndexBuilder, this);
                }
                catch (Exception ex) {
                    log.error((Object)"Remote Search Failed ", (Throwable)ex);
                    throw new IOException(ex.getMessage());
                }
            }
            IndexSearcher indexSearcher = this.getIndexSearcher(false);
            if (indexSearcher != null) {
                Hits h = null;
                Filter indexFilter = (Filter)this.luceneFilters.get(filterName);
                Sort indexSorter = (Sort)this.luceneSorters.get(sorterName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Filter " + filterName + ":" + indexFilter + " and " + sorterName + ":" + indexSorter));
                }
                h = indexFilter != null && indexSorter != null ? indexSearcher.search((Query)query, indexFilter, indexSorter) : (indexFilter != null ? indexSearcher.search((Query)query, indexFilter) : (indexSorter != null ? indexSearcher.search((Query)query, indexSorter) : indexSearcher.search((Query)query)));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got " + h.length() + " hits"));
                }
                String context = null;
                if (contexts != null && contexts.size() > 0) {
                    context = contexts.get(0);
                }
                this.eventTrackingService.post(this.eventTrackingService.newEvent("search.query", "/search/query/" + textQuery.toString(), context, true, 3));
                return new SearchListImpl(h, textQuery, start, end, this.getAnalyzer(), this.filter, this.searchIndexBuilder, this);
            }
            throw new RuntimeException("Failed to start the Lucene Searche Engine");
        }
        catch (ParseException e) {
            throw new InvalidSearchQueryException("Failed to parse Query ", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to run Search ", e);
        }
    }

    public void refreshInstance() {
        this.searchIndexBuilder.refreshIndex();
    }

    public void rebuildInstance() {
        this.searchIndexBuilder.rebuildIndex();
    }

    public void refreshSite(String currentSiteId) {
        this.searchIndexBuilder.refreshIndex(currentSiteId);
    }

    public void rebuildSite(String currentSiteId) {
        this.searchIndexBuilder.rebuildIndex(currentSiteId);
    }

    public void reload() {
        this.getIndexSearcher(true);
    }

    public void forceReload() {
        this.indexStorage.forceNextReload();
    }

    public IndexSearcher getIndexSearcher(boolean reload) {
        try {
            return this.indexStorage.getIndexSearcher(reload);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to get an index searcher ", (Throwable)ex);
            throw new RuntimeException("Failed to get an index searcher ", ex);
        }
    }

    public int getNDocs() {
        try {
            return this.getIndexSearcher(false).getIndexReader().numDocs();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getPendingDocs() {
        return this.searchIndexBuilder.getPendingDocuments();
    }

    public List<SearchBuilderItem> getAllSearchItems() {
        return this.searchIndexBuilder.getAllSearchItems();
    }

    public List<SearchBuilderItem> getSiteMasterSearchItems() {
        return this.searchIndexBuilder.getSiteMasterSearchItems();
    }

    public List<SearchBuilderItem> getGlobalMasterSearchItems() {
        return this.searchIndexBuilder.getGlobalMasterSearchItems();
    }

    public SearchItemFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SearchItemFilter filter) {
        this.filter = filter;
    }

    public String getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(String defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public String getDefaultSorter() {
        return this.defaultSorter;
    }

    public void setDefaultSorter(String defaultSorter) {
        this.defaultSorter = defaultSorter;
    }

    public Map getLuceneFilters() {
        return this.luceneFilters;
    }

    public void setLuceneFilters(Map luceneFilters) {
        this.luceneFilters = luceneFilters;
    }

    public Map getLuceneSorters() {
        return this.luceneSorters;
    }

    public void setLuceneSorters(Map luceneSorters) {
        this.luceneSorters = luceneSorters;
    }

    public TermFrequency getTerms(int documentId) throws IOException {
        final TermFreqVector tf = this.getIndexSearcher(false).getIndexReader().getTermFreqVector(documentId, "contents");
        return new TermFrequency(){

            public String[] getTerms() {
                if (tf != null) {
                    return tf.getTerms();
                }
                return new String[0];
            }

            public int[] getFrequencies() {
                if (tf != null) {
                    return tf.getTermFrequencies();
                }
                return new int[0];
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String searchXML(Map parameterMap) {
        String string;
        String check;
        String userid = null;
        String searchTerms = null;
        String checksum = null;
        String contexts = null;
        String ss = null;
        String se = null;
        if (!this.searchServer) {
            throw new Exception(Messages.getString("SearchServiceImpl.49"));
        }
        String[] useridA = (String[])parameterMap.get("u");
        String[] searchTermsA = (String[])parameterMap.get("q");
        String[] checksumA = (String[])parameterMap.get("cs");
        String[] contextsA = (String[])parameterMap.get("ctx");
        String[] ssA = (String[])parameterMap.get("s");
        String[] seA = (String[])parameterMap.get("e");
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        boolean requestError = false;
        if (useridA == null || useridA.length != 1) {
            requestError = true;
        } else {
            userid = useridA[0];
        }
        if (searchTermsA == null || searchTermsA.length != 1) {
            requestError = true;
        } else {
            searchTerms = searchTermsA[0];
        }
        if (checksumA == null || checksumA.length != 1) {
            requestError = true;
        } else {
            checksum = checksumA[0];
        }
        if (contextsA == null || contextsA.length != 1) {
            requestError = true;
        } else {
            contexts = contextsA[0];
        }
        if (ssA == null || ssA.length != 1) {
            requestError = true;
        } else {
            ss = ssA[0];
        }
        if (seA == null || seA.length != 1) {
            requestError = true;
        } else {
            se = seA[0];
        }
        if (requestError) {
            throw new Exception(Messages.getString("SearchServiceImpl.34"));
        }
        int searchStart = Integer.parseInt(ss);
        int searchEnd = Integer.parseInt(se);
        String[] ctxa = contexts.split(";");
        ArrayList<String> ctx = new ArrayList<String>(ctxa.length);
        for (int i = 0; i < ctxa.length; ++i) {
            ctx.add(ctxa[i]);
        }
        if (this.sharedKey != null && this.sharedKey.length() > 0 && !(check = this.digestCheck(userid, searchTerms)).equals(checksum)) {
            throw new Exception(Messages.getString("SearchServiceImpl.53"));
        }
        Session s = this.sessionManager.startSession();
        User u = this.userDirectoryService.getUser("admin");
        s.setUserId(u.getId());
        this.sessionManager.setCurrentSession(s);
        this.localSearch.set("localsearch");
        try {
            SearchList sl = this.search(searchTerms, ctx, searchStart, searchEnd);
            sb.append("<results ");
            sb.append(" fullsize=\"").append(sl.getFullSize()).append("\" ");
            sb.append(" start=\"").append(sl.getStart()).append("\" ");
            sb.append(" size=\"").append(sl.size()).append("\" ");
            sb.append(" >");
            for (SearchResult sr : sl) {
                sr.toXMLString(sb);
            }
            sb.append("</results>");
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                this.sessionManager.setCurrentSession(null);
                this.localSearch.set(null);
                throw throwable;
            }
            catch (Exception ex) {
                log.error((Object)"Search Service XML response failed ", (Throwable)ex);
                StringBuilder sb2 = new StringBuilder();
                sb2.append("<?xml version=\"1.0\"?>");
                sb2.append("<fault>");
                sb2.append("<request>");
                sb2.append("<![CDATA[");
                sb2.append(" userid = ").append(StringEscapeUtils.escapeXml(userid)).append("\n");
                sb2.append(" searchTerms = ").append(StringEscapeUtils.escapeXml(searchTerms)).append("\n");
                sb2.append(" checksum = ").append(StringEscapeUtils.escapeXml(checksum)).append("\n");
                sb2.append(" contexts = ").append(StringEscapeUtils.escapeXml(contexts)).append("\n");
                sb2.append(" ss = ").append(StringEscapeUtils.escapeXml(ss)).append("\n");
                sb2.append(" se = ").append(StringEscapeUtils.escapeXml(se)).append("\n");
                sb2.append("]]>");
                sb2.append("</request>");
                sb2.append("<error>");
                sb2.append("<![CDATA[");
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    sb2.append(sw.toString());
                    pw.close();
                    sw.close();
                }
                catch (Exception ex2) {
                    sb2.append("Failed to serialize exception " + ex.getMessage()).append("\n");
                    sb2.append("Case:  " + ex2.getMessage());
                }
                sb2.append("]]>");
                sb2.append("</error>");
                sb2.append("</fault>");
                return sb2.toString();
            }
        }
        this.sessionManager.setCurrentSession(null);
        this.localSearch.set(null);
        return string;
    }

    private String digestCheck(String userid, String searchTerms) throws GeneralSecurityException, IOException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        String chstring = this.sharedKey + userid + searchTerms;
        return BaseSearchServiceImpl.byteArrayToHexStr(sha1.digest(chstring.getBytes("UTF-8")));
    }

    private static String byteArrayToHexStr(byte[] data) {
        char[] chars = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte current = data[i];
            int hi = (current & 0xF0) >> 4;
            int lo = current & 0xF;
            chars[2 * i] = (char)(hi < 10 ? 48 + hi : 65 + hi - 10);
            chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 65 + lo - 10);
        }
        return new String(chars);
    }

    public String getSharedKey() {
        return this.sharedKey;
    }

    public void setSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
    }

    public String getSearchServerUrl() {
        return this.searchServerUrl;
    }

    public void setSearchServerUrl(String searchServerUrl) {
        this.searchServerUrl = searchServerUrl;
    }

    public boolean isSearchServer() {
        return this.searchServer;
    }

    public void setSearchServer(boolean searchServer) {
        this.searchServer = searchServer;
    }

    public boolean getDiagnostics() {
        return this.hasDiagnostics();
    }

    public void setDiagnostics(boolean diagnostics) {
        if (diagnostics) {
            this.enableDiagnostics();
        } else {
            this.disableDiagnostics();
        }
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public IndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    public void setIndexStorage(IndexStorage indexStorage) {
        this.indexStorage = indexStorage;
    }

    protected Analyzer getAnalyzer() {
        return this.indexStorage.getAnalyzer();
    }

    public void disableDiagnostics() {
        this.diagnostics = false;
        if (this.indexStorage != null) {
            this.indexStorage.disableDiagnostics();
        }
    }

    public void enableDiagnostics() {
        this.diagnostics = true;
        if (this.indexStorage != null) {
            this.indexStorage.enableDiagnostics();
        }
    }

    public boolean hasDiagnostics() {
        return this.diagnostics;
    }

    public List getSegmentInfo() {
        return this.indexStorage.getSegmentInfoList();
    }

    public boolean isEnabled() {
        this.enabled = ServerConfigurationService.getBoolean((String)"search.enable", (boolean)false);
        log.info((Object)("Enable = " + ServerConfigurationService.getString((String)"search.enable", (String)"false")));
        this.enabled = this.enabled && ServerConfigurationService.getBoolean((String)"search.indexbuild", (boolean)true);
        return this.enabled;
    }

    public String getDigestStoragePath() {
        String customPath = ServerConfigurationService.getString((String)"search.digestPath");
        String storePath = null;
        if (customPath == null || "".equals(customPath)) {
            storePath = ServerConfigurationService.getString((String)"bodyPath@org.sakaiproject.content.api.ContentHostingService");
            if (storePath == null || "".equals(storePath)) {
                return null;
            }
        } else {
            storePath = customPath;
        }
        return storePath + "/" + DIGEST_STORE_FOLDER;
    }

    public String getSearchSuggestion(String queryString) {
        log.info((Object)("getSearchSuggestion( " + queryString + ")"));
        if (!ServerConfigurationService.getBoolean((String)"search.experimental.didyoumean", (boolean)false)) {
            log.info((Object)"did you mean feature is not enabled");
            return null;
        }
        if (this.spellIndexDirectory == null) {
            this.spellIndexDirectory = this.indexStorage.getSpellDirectory();
        }
        if (this.spellIndexDirectory == null) {
            log.info((Object)"Spell index is not available");
            return null;
        }
        IndexReader indexReaderOrigional = null;
        try {
            indexReaderOrigional = this.indexStorage.getIndexReader();
        }
        catch (CorruptIndexException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        DidYouMeanParser parser = new DidYouMeanParser("contents", this.spellIndexDirectory, indexReaderOrigional);
        try {
            Query query = parser.suggest(queryString);
            if (query != null) {
                log.debug((Object)("got suggestion: " + query.toString("contents")));
                return query.toString("contents");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }
}

