/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.indexer.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.StoredDigestContentProducer;
import org.sakaiproject.search.api.rdf.RDFIndexException;
import org.sakaiproject.search.api.rdf.RDFSearchService;
import org.sakaiproject.search.indexer.api.IndexUpdateTransaction;
import org.sakaiproject.search.indexer.api.IndexWorker;
import org.sakaiproject.search.indexer.api.IndexWorkerDocumentListener;
import org.sakaiproject.search.indexer.api.IndexWorkerListener;
import org.sakaiproject.search.indexer.api.NoItemsToIndexException;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.search.transaction.api.IndexTransaction;
import org.sakaiproject.search.transaction.api.IndexTransactionException;
import org.sakaiproject.search.transaction.api.TransactionIndexManager;
import org.sakaiproject.search.util.DigestStorageUtil;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class TransactionalIndexWorker
implements IndexWorker {
    private static final Log log = LogFactory.getLog(TransactionalIndexWorker.class);
    private SearchIndexBuilder searchIndexBuilder;
    private TransactionIndexManager transactionIndexManager;
    private ServerConfigurationService serverConfigurationService;
    private RDFSearchService rdfSearchService;
    private SearchService searchService;
    private List<IndexWorkerListener> indexWorkerListeners = new ArrayList<IndexWorkerListener>();
    private List<IndexWorkerDocumentListener> indexWorkerDocumentListeners = new ArrayList<IndexWorkerDocumentListener>();
    private ThreadLocalManager threadLocalManager;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void init() {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(int batchSize) {
        IndexTransaction t = null;
        try {
            long start = System.currentTimeMillis();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("batch-size", batchSize);
            t = this.transactionIndexManager.openTransaction(m);
            int n = this.processTransaction(t);
            t.prepare();
            long transactionID = t.getTransactionId();
            t.commit();
            long end = System.currentTimeMillis();
            long time = end - start;
            if (time == 0L) {
                log.info((Object)("Indexed " + n + " documents in " + time + " ms into save point " + transactionID));
            } else {
                double dps = n * 1000;
                log.info((Object)("Indexed " + n + " documents in " + time + " ms " + (dps /= 1.0 * (double)time) + " documents/second into save point " + transactionID));
            }
            int n2 = n;
            return n2;
        }
        catch (NoItemsToIndexException nodx) {
            log.info((Object)"No Items To Index ");
            if (t != null) {
                try {
                    t.rollback();
                }
                catch (Exception ex) {
                    log.warn((Object)"Transaction Rollback Failed ", (Throwable)ex);
                }
            }
            int ex = 0;
            return ex;
        }
        catch (IndexTransactionException iex) {
            if (t == null) {
                log.warn((Object)"Transaction Failed to open ", (Throwable)iex);
            } else {
                log.warn((Object)"Transaction Failed ", (Throwable)iex);
                try {
                    t.rollback();
                }
                catch (Exception ex) {
                    log.warn((Object)"Transaction Rollback Failed ", (Throwable)ex);
                }
            }
            int n = -1;
            return n;
        }
        finally {
            if (t != null) {
                try {
                    t.close();
                }
                catch (Exception ex) {
                    log.warn((Object)"Transaction Close Failed ", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processTransaction(IndexTransaction transaction) throws IndexTransactionException {
        IndexWriter indexWrite = null;
        IndexReader indexReader = null;
        int nprocessed = 0;
        DigestStorageUtil digestStorageUtil = new DigestStorageUtil(this.searchService);
        try {
            this.fireIndexStart();
            HashMap<String, SearchBuilderItem> finalState = new HashMap<String, SearchBuilderItem>();
            Iterator<SearchBuilderItem> tditer = ((IndexUpdateTransaction)transaction).lockedItemIterator();
            while (tditer.hasNext()) {
                SearchBuilderItem sbi = tditer.next();
                finalState.put(sbi.getId(), sbi);
            }
            for (SearchBuilderItem sbi : finalState.values()) {
                int ndel;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Item [" + sbi.getName() + "] state [" + (sbi.isLocked() ? "Locked to " + sbi.getLock() : SearchBuilderItem.states[sbi.getSearchstate()]) + " action [" + SearchBuilderItem.actions[sbi.getSearchaction()] + "]"));
                }
                if (SearchBuilderItem.ACTION_ADD.equals(sbi.getSearchaction())) {
                    indexReader = ((IndexUpdateTransaction)transaction).getIndexReader();
                    ndel = indexReader.deleteDocuments(new Term("reference", sbi.getName()));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(ndel + " index documents deleted"));
                    continue;
                }
                if (!SearchBuilderItem.ACTION_DELETE.equals(sbi.getSearchaction())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("-------------------Delete " + sbi.getId()));
                }
                indexReader = ((IndexUpdateTransaction)transaction).getIndexReader();
                ndel = indexReader.deleteDocuments(new Term("reference", sbi.getName()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(ndel + " index documents deleted"));
                }
                digestStorageUtil.deleteAllDigests(sbi.getName());
                ++nprocessed;
            }
            for (SearchBuilderItem sbi : finalState.values()) {
                String ref;
                Reader contentReader;
                block55: {
                    if (ComponentManager.hasBeenClosed()) {
                        log.warn((Object)"component Manager is shuting down won't attempt to index");
                        return nprocessed;
                    }
                    contentReader = null;
                    ref = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Item [" + sbi.getName() + "] state [" + (sbi.isLocked() ? "Locked to " + sbi.getLock() : SearchBuilderItem.states[sbi.getSearchstate()]) + " action [" + SearchBuilderItem.actions[sbi.getSearchaction()] + "]"));
                    }
                    if (SearchBuilderItem.ACTION_ADD.equals(sbi.getSearchaction())) {
                        ref = sbi.getName();
                        this.fireStartDocument(ref);
                        try {
                            EntityContentProducer sep = this.searchIndexBuilder.newEntityContentProducer(ref);
                            boolean indexDoc = true;
                            if (this.searchIndexBuilder.isOnlyIndexSearchToolSites()) {
                                try {
                                    String siteId = sep.getSiteId(sbi.getName());
                                    Site s = SiteService.getSite((String)siteId);
                                    ToolConfiguration t = s.getToolForCommonId("sakai.search");
                                    if (t == null) {
                                        indexDoc = false;
                                        log.debug((Object)("Not indexing " + sbi.getName() + " as it has no search tool"));
                                    }
                                }
                                catch (Exception ex) {
                                    indexDoc = false;
                                    log.debug((Object)("Not indexing  " + sbi.getName() + " as it has no site"), (Throwable)ex);
                                }
                            }
                            if (indexDoc && sep != null && sep.isForIndex(ref) && sep.getSiteId(ref) != null) {
                                Document doc = new Document();
                                String container = sep.getContainer(ref);
                                if (container == null) {
                                    container = "";
                                }
                                doc.add((Fieldable)new Field("indexdate", String.valueOf(System.currentTimeMillis()), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("container", this.filterNull(container), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("id", this.filterNull(sep.getId(ref)), Field.Store.COMPRESS, Field.Index.NO));
                                doc.add((Fieldable)new Field("type", this.filterNull(sep.getType(ref)), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("subtype", this.filterNull(sep.getSubType(ref)), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("reference", this.filterNull(ref), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                String idIndex = sep.getId(ref);
                                if (idIndex != null && idIndex.indexOf("/") > 0) {
                                    idIndex = idIndex.substring(idIndex.lastIndexOf("/"));
                                }
                                idIndex = this.filterPunctuation(idIndex);
                                doc.add((Fieldable)new Field("contents", idIndex, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
                                String title = this.filterPunctuation(sep.getTitle(ref));
                                doc.add((Fieldable)new Field("contents", title, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
                                if (sep.isContentFromReader(ref)) {
                                    contentReader = sep.getContentReader(ref);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Adding Content for " + ref + " using " + contentReader));
                                    }
                                    doc.add((Fieldable)new Field("contents", contentReader, Field.TermVector.YES));
                                } else {
                                    String content = sep.getContent(ref);
                                    if (content != null && content.trim().length() > 0) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Adding Content for " + ref + " as [" + content + "]"));
                                        }
                                        int docCount = digestStorageUtil.getDocCount(ref) + 1;
                                        doc.add((Fieldable)new Field("contents", this.filterNull(content), Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
                                        if (sep instanceof StoredDigestContentProducer) {
                                            doc.add((Fieldable)new Field("digestCount", Integer.valueOf(docCount).toString(), Field.Store.COMPRESS, Field.Index.NO, Field.TermVector.NO));
                                            digestStorageUtil.saveContentToStore(ref, content, docCount);
                                            if (docCount > 2) {
                                                digestStorageUtil.cleanOldDigests(ref);
                                            }
                                        }
                                    }
                                }
                                doc.add((Fieldable)new Field("title", this.filterNull(sep.getTitle(ref)), Field.Store.COMPRESS, Field.Index.ANALYZED, Field.TermVector.YES));
                                doc.add((Fieldable)new Field("tool", this.filterNull(sep.getTool()), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("url", this.filterUrl(this.filterNull(sep.getUrl(ref))), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                doc.add((Fieldable)new Field("siteid", this.filterNull(sep.getSiteId(ref)), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                Map m = sep.getCustomProperties(ref);
                                if (m != null) {
                                    for (String key : m.keySet()) {
                                        Object value = m.get(key);
                                        String[] values = null;
                                        if (value instanceof String) {
                                            values = new String[]{(String)value};
                                        }
                                        if (value instanceof String[]) {
                                            values = (String[])value;
                                        }
                                        if (values == null) {
                                            log.info((Object)("Null Custom Properties value has been suppled by " + sep + " in index " + key));
                                            continue;
                                        }
                                        for (int i = 0; i < values.length; ++i) {
                                            if (key.startsWith("T")) {
                                                key = key.substring(1);
                                                doc.add((Fieldable)new Field(key, this.filterNull(values[i]), Field.Store.COMPRESS, Field.Index.ANALYZED, Field.TermVector.YES));
                                                continue;
                                            }
                                            doc.add((Fieldable)new Field(key, this.filterNull(values[i]), Field.Store.COMPRESS, Field.Index.NOT_ANALYZED));
                                        }
                                    }
                                }
                                log.debug((Object)("Indexing Document " + doc));
                                indexWrite = ((IndexUpdateTransaction)transaction).getIndexWriter();
                                indexWrite.addDocument(doc);
                                log.debug((Object)("Done Indexing Document " + doc));
                                this.processRDF(ref, sep);
                                sbi.setSearchstate(SearchBuilderItem.STATE_COMPLETED);
                                ++nprocessed;
                            } else {
                                if (log.isDebugEnabled()) {
                                    if (!indexDoc) {
                                        log.debug((Object)("Ignored Document: Filtered out by site " + ref));
                                    } else if (sep == null) {
                                        log.debug((Object)("Ignored Document: No EntityContentProducer " + ref));
                                    } else if (!sep.isForIndex(ref)) {
                                        log.debug((Object)("Ignored Document: Marked as Ignore " + ref));
                                    } else if (sep.getSiteId(ref) == null) {
                                        log.debug((Object)("Ignored Document: No Site ID " + ref));
                                    } else {
                                        log.debug((Object)("Ignored Document: Reason Unknown " + ref));
                                    }
                                }
                                sbi.setSearchstate(SearchBuilderItem.STATE_FAILED);
                            }
                        }
                        catch (Exception e1) {
                            log.warn((Object)(" Failed to index document for " + ref + " cause: " + e1.getMessage()), (Throwable)e1);
                            sbi.setSearchstate(SearchBuilderItem.STATE_FAILED);
                        }
                    }
                    if (contentReader == null) break block55;
                    try {
                        contentReader.close();
                    }
                    catch (IOException ioex) {
                        log.warn((Object)"Error closing contentReader", (Throwable)ioex);
                    }
                }
                this.fireEndDocument(ref);
                continue;
                catch (Throwable throwable) {
                    if (contentReader != null) {
                        try {
                            contentReader.close();
                        }
                        catch (IOException ioex) {
                            log.warn((Object)"Error closing contentReader", (Throwable)ioex);
                        }
                    }
                    this.fireEndDocument(ref);
                    throw throwable;
                    return nprocessed;
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to Add Documents ", (Throwable)ex);
            throw new IndexTransactionException(ex);
        }
        finally {
            this.fireIndexEnd();
        }
    }

    private String filterPunctuation(String term) {
        if (term == null) {
            return "";
        }
        char[] endTerm = term.toCharArray();
        for (int i = 0; i < endTerm.length; ++i) {
            if (Character.isLetterOrDigit(endTerm[i])) continue;
            endTerm[i] = 32;
        }
        return new String(endTerm);
    }

    private void fireIndexStart() {
        for (IndexWorkerListener iwl : this.indexWorkerListeners) {
            iwl.indexWorkerStart(this);
        }
    }

    private void fireStartDocument(String ref) {
        for (IndexWorkerDocumentListener iwl : this.indexWorkerDocumentListeners) {
            iwl.indexDocumentStart(this, ref);
        }
    }

    private void fireEndDocument(String ref) {
        for (IndexWorkerDocumentListener iwl : this.indexWorkerDocumentListeners) {
            iwl.indexDocumentEnd(this, ref);
        }
    }

    private void fireIndexEnd() {
        for (IndexWorkerListener iwl : this.indexWorkerListeners) {
            iwl.indexWorkerEnd(this);
        }
    }

    private void processRDF(String ref, EntityContentProducer sep) throws RDFIndexException {
        String s;
        if (this.rdfSearchService != null && (s = sep.getCustomRDF(ref)) != null) {
            this.rdfSearchService.addData(s);
        }
    }

    @Override
    public void addIndexWorkerListener(IndexWorkerListener indexWorkerListener) {
        ArrayList<IndexWorkerListener> tl = new ArrayList<IndexWorkerListener>();
        tl.addAll(this.indexWorkerListeners);
        tl.add(indexWorkerListener);
        this.indexWorkerListeners = tl;
    }

    @Override
    public void removeIndexWorkerListener(IndexWorkerListener indexWorkerListener) {
        ArrayList<IndexWorkerListener> tl = new ArrayList<IndexWorkerListener>();
        tl.addAll(this.indexWorkerListeners);
        tl.remove(indexWorkerListener);
        this.indexWorkerListeners = tl;
    }

    @Override
    public void addIndexWorkerDocumentListener(IndexWorkerDocumentListener indexWorkerDocumentListener) {
        ArrayList<IndexWorkerDocumentListener> tl = new ArrayList<IndexWorkerDocumentListener>();
        tl.addAll(this.indexWorkerDocumentListeners);
        tl.add(indexWorkerDocumentListener);
        this.indexWorkerDocumentListeners = tl;
    }

    @Override
    public void removeIndexWorkerDocumentListener(IndexWorkerDocumentListener indexWorkerDocumentListener) {
        ArrayList<IndexWorkerDocumentListener> tl = new ArrayList<IndexWorkerDocumentListener>();
        tl.addAll(this.indexWorkerDocumentListeners);
        tl.remove(indexWorkerDocumentListener);
        this.indexWorkerDocumentListeners = tl;
    }

    public List<IndexWorkerDocumentListener> getIndexWorkerDocumentListeners() {
        return this.indexWorkerDocumentListeners;
    }

    public void setIndexWorkerDocumentListeners(List<IndexWorkerDocumentListener> indexWorkerDocumentListeners) {
        this.indexWorkerDocumentListeners = indexWorkerDocumentListeners;
    }

    public List<IndexWorkerListener> getIndexWorkerListeners() {
        return this.indexWorkerListeners;
    }

    public void setIndexWorkerListeners(List<IndexWorkerListener> indexWorkerListeners) {
        this.indexWorkerListeners = indexWorkerListeners;
    }

    private String filterNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private String filterUrl(String url) {
        String serverURL = this.serverConfigurationService.getServerUrl();
        if (url != null && url.startsWith(serverURL)) {
            String absUrl = url.substring(serverURL.length());
            if (!absUrl.startsWith("/")) {
                absUrl = "/" + absUrl;
            }
            return absUrl;
        }
        return url;
    }

    public RDFSearchService getRdfSearchService() {
        return this.rdfSearchService;
    }

    public void setRdfSearchService(RDFSearchService rdfSearchService) {
        this.rdfSearchService = rdfSearchService;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public TransactionIndexManager getTransactionIndexManager() {
        return this.transactionIndexManager;
    }

    public void setTransactionIndexManager(TransactionIndexManager transactionIndexManager) {
        this.transactionIndexManager = transactionIndexManager;
    }

    public ThreadLocalManager getThreadLocalManager() {
        return this.threadLocalManager;
    }

    public void setThreadLocalManager(ThreadLocalManager threadLocalManager) {
        this.threadLocalManager = threadLocalManager;
    }
}

