/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.mbeans;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.indexer.api.IndexWorker;
import org.sakaiproject.search.indexer.api.IndexWorkerDocumentListener;
import org.sakaiproject.search.indexer.api.IndexWorkerListener;
import org.sakaiproject.search.journal.api.IndexListener;
import org.sakaiproject.search.journal.api.IndexStorageProvider;
import org.sakaiproject.search.journal.impl.IndexListenerCloser;
import org.sakaiproject.search.journal.impl.RefCountIndexSearcher;
import org.sakaiproject.search.journal.impl.RefCountMultiReader;
import org.sakaiproject.search.mbeans.SearchServiceManagementMBean;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class SearchServiceManagement
extends NotificationBroadcasterSupport
implements SearchServiceManagementMBean {
    private static final Log log = LogFactory.getLog(SearchServiceManagement.class);
    private static final String MBEAN_COMPONENT_BASE = "Sakai:type=SearchService";
    private SearchService searchService;
    protected long notificationNo = 0L;
    private IndexStorageProvider indexStorageProvider;
    private IndexWorker indexWorker;
    private IndexListenerCloser indexListenerCloser;
    private ThreadLocalManager threadLocalManager;
    private String name;

    public SearchServiceManagement() {
        this.name = "";
    }

    public SearchServiceManagement(String instanceName) {
        this.name = ",instance=" + instanceName;
    }

    public void init() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            final ObjectName searchServiceON = new ObjectName(MBEAN_COMPONENT_BASE + this.name);
            mbs.registerMBean(this, searchServiceON);
            this.indexStorageProvider.addIndexListener(new IndexListener(){

                @Override
                public void doIndexReaderClose(IndexReader oldMultiReader) throws IOException {
                    SearchServiceManagement.this.sendNotification(new Notification("index-reader-close", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Closed oldMultiReader"));
                }

                @Override
                public void doIndexReaderOpen(IndexReader newMultiReader) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-reader-open", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Opened newMultiReader"));
                }

                @Override
                public void doIndexSearcherClose(IndexSearcher indexSearcher) throws IOException {
                    SearchServiceManagement.this.sendNotification(new Notification("index-searcher-close", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Closed " + indexSearcher.toString()));
                }

                @Override
                public void doIndexSearcherOpen(IndexSearcher indexSearcher) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-searcher-open", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Opened " + indexSearcher.toString()));
                }
            });
            this.indexWorker.addIndexWorkerDocumentListener(new IndexWorkerDocumentListener(){

                @Override
                public void indexDocumentEnd(IndexWorker worker, String ref) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-document-start", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Doc Ref " + ref));
                }

                @Override
                public void indexDocumentStart(IndexWorker worker, String ref) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-document-end", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Doc Ref " + ref));
                }
            });
            this.indexWorker.addIndexWorkerListener(new IndexWorkerListener(){

                @Override
                public void indexWorkerEnd(IndexWorker worker) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-woker-start", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Worker " + worker));
                }

                @Override
                public void indexWorkerStart(IndexWorker worker) {
                    SearchServiceManagement.this.sendNotification(new Notification("index-woker-end", (Object)searchServiceON, SearchServiceManagement.this.notificationNo++, "Worker " + worker));
                }
            });
        }
        catch (Exception ex) {
            log.warn((Object)"Failed to register mbean for search service ", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenIndexSearchers() {
        try {
            int n = RefCountIndexSearcher.getOpened();
            return n;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenMultiReaders() {
        try {
            int n = RefCountMultiReader.getOpened();
            return n;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfDocuments() {
        try {
            int n = this.searchService.getNDocs();
            return n;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfPendingDocuments() {
        try {
            int n = this.searchService.getPendingDocs();
            return n;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus() {
        try {
            String string = this.searchService.getStatus();
            return string;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfPendingOpenIndexes() {
        try {
            int n = this.indexListenerCloser.size();
            return n;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getOpenIndexes() {
        try {
            String[] stringArray = this.indexListenerCloser.getOpenIndexNames();
            return stringArray;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSegments() {
        try {
            List segments = this.searchService.getSegmentInfo();
            String[] segmentInfo = new String[segments.size()];
            for (int i = 0; i < segmentInfo.length; ++i) {
                StringBuilder sb = new StringBuilder();
                for (Object o : (Object[])segments.get(i)) {
                    sb.append(o).append(" ");
                }
                segmentInfo[i] = sb.toString();
            }
            String[] stringArray = segmentInfo;
            return stringArray;
        }
        finally {
            this.threadLocalManager.clear();
        }
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public IndexStorageProvider getIndexStorageProvider() {
        return this.indexStorageProvider;
    }

    public void setIndexStorageProvider(IndexStorageProvider indexStorageProvider) {
        this.indexStorageProvider = indexStorageProvider;
    }

    public IndexWorker getIndexWorker() {
        return this.indexWorker;
    }

    public void setIndexWorker(IndexWorker indexWorker) {
        this.indexWorker = indexWorker;
    }

    public IndexListenerCloser getIndexListenerCloser() {
        return this.indexListenerCloser;
    }

    public void setIndexListenerCloser(IndexListenerCloser indexListenerCloser) {
        this.indexListenerCloser = indexListenerCloser;
    }

    public ThreadLocalManager getThreadLocalManager() {
        return this.threadLocalManager;
    }

    public void setThreadLocalManager(ThreadLocalManager threadLocalManager) {
        this.threadLocalManager = threadLocalManager;
    }
}

