/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.index.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.index.SegmentInfo;
import org.sakaiproject.search.index.impl.JDBCClusterIndexStore;
import org.sakaiproject.search.index.impl.SegmentInfoImpl;

public class ClusterSegmentsStorage {
    private static final String PACKFILE = "packet";
    private static final Log log = LogFactory.getLog(ClusterSegmentsStorage.class);
    private String searchIndexDirectory;
    private boolean debug = false;
    private boolean localStructuredStorage = false;
    private JDBCClusterIndexStore clusterIndexStore;
    private SearchService searchService;

    public ClusterSegmentsStorage(SearchService searchService, String searchIndexDirectory, JDBCClusterIndexStore clusterIndexStore, boolean localStructuredStorage, boolean debug) {
        this.localStructuredStorage = localStructuredStorage;
        this.clusterIndexStore = clusterIndexStore;
        this.searchIndexDirectory = searchIndexDirectory;
        this.debug = debug;
        this.searchService = searchService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpackSegment(SegmentInfo addsi, InputStream packetStream, long version) throws IOException {
        log.debug((Object)"================================Starting Unpack Segment==============================");
        ZipInputStream zin = new ZipInputStream(packetStream);
        ZipEntry zipEntry = null;
        FileOutputStream fout = null;
        try {
            File loc = addsi.getSegmentLocation();
            boolean locationExists = false;
            File unpackBase = new File(this.searchIndexDirectory);
            if (loc.exists()) {
                locationExists = true;
                unpackBase = new File(this.searchIndexDirectory, "unpack");
            }
            byte[] buffer = new byte[4096];
            while ((zipEntry = zin.getNextEntry()) != null) {
                int len;
                long ts = zipEntry.getTime();
                File f = new File(unpackBase, zipEntry.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("         Unpack " + f.getAbsolutePath()));
                }
                if (!f.getParentFile().mkdirs()) {
                    log.warn((Object)"unpackSegment: failed to delete parent folders");
                }
                fout = new FileOutputStream(f);
                while ((len = zin.read(buffer)) > 0) {
                    fout.write(buffer, 0, len);
                }
                zin.closeEntry();
                fout.close();
                if (f.setLastModified(ts)) continue;
                log.warn((Object)"unpackSegments: failed to setlastmodified");
            }
            if (locationExists) {
                HashMap<String, File> moved = new HashMap<String, File>();
                this.moveAll(new File(unpackBase, loc.getName()), loc, moved);
                this.deleteAll(unpackBase);
                this.deleteSome(loc, moved);
                this.searchService.reload();
            }
            try {
                addsi.checkSegmentValidity(this.searchService.hasDiagnostics(), "Unpack Segment");
            }
            catch (Exception ex) {
                try {
                    addsi.checkSegmentValidity(true, "Unpack Segment Failed");
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
                throw new RuntimeException("Segment " + addsi.getName() + " is corrupted ");
            }
            addsi.setVersion(version);
            addsi.setCreated();
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        log.debug((Object)"================================Done Unpack Segment==============================");
    }

    private void deleteSome(File f, Map<String, File> moved) {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.deleteSome(fs[i], moved);
            }
            if (moved.get(f.getPath()) == null) {
                if (!f.delete()) {
                    log.warn((Object)("Failed to delte file: " + f.getPath()));
                }
                log.debug((Object)("          deleted " + f.getPath()));
            }
        } else if (moved.get(f.getPath()) == null) {
            if (!f.delete()) {
                log.warn((Object)("Failed to delte file: " + f.getPath()));
            }
            log.debug((Object)("          deleted " + f.getPath()));
        }
    }

    private void moveAll(File src, File dest, Map<String, File> moved) {
        if (src.isDirectory()) {
            File[] fs = src.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.moveAll(fs[i], new File(dest, fs[i].getName()), moved);
            }
        } else {
            if (dest.exists()) {
                if (!dest.delete()) {
                    log.warn((Object)("Failed to delte file: " + dest.getPath()));
                }
            } else {
                File p = dest.getParentFile();
                if (!p.exists() && !p.mkdirs()) {
                    log.warn((Object)("Failed to create directories in " + p.getPath()));
                }
            }
            if (!src.renameTo(dest)) {
                log.warn((Object)("failed to rename: " + src.getPath() + " to: " + dest.getPath()));
            }
            log.debug((Object)("          renamed " + src.getPath() + " to " + dest.getPath()));
        }
        moved.put(dest.getPath(), dest);
    }

    private void deleteAll(File f) {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                this.deleteAll(fs[i]);
            }
            if (!f.delete()) {
                log.warn((Object)("deleteAll(): failed to delete " + f.getPath()));
            } else {
                log.debug((Object)("          deleted " + f.getPath()));
            }
        } else if (!f.delete()) {
            log.warn((Object)("deleteAll(): failed to delete " + f.getPath()));
        } else {
            log.debug((Object)("          deleted " + f.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unpackPatch(InputStream packetStream) throws IOException {
        log.debug((Object)"================================Start Unpack Patch==============================");
        ZipInputStream zin = new ZipInputStream(packetStream);
        ZipEntry zipEntry = null;
        FileOutputStream fout = null;
        try {
            byte[] buffer = new byte[4096];
            while ((zipEntry = zin.getNextEntry()) != null) {
                int len;
                long ts = zipEntry.getTime();
                File f = new File(this.searchIndexDirectory, zipEntry.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("                Unpack " + f.getAbsolutePath()));
                }
                if (!f.getParentFile().mkdirs()) {
                    log.warn((Object)("upackpatch():  failes to create dirs in " + f.getParentFile().getPath()));
                }
                fout = new FileOutputStream(f);
                while ((len = zin.read(buffer)) > 0) {
                    fout.write(buffer, 0, len);
                }
                zin.closeEntry();
                fout.close();
                if (f.setLastModified(ts)) continue;
                log.warn((Object)("Failed to set modification time on: " + f.getPath()));
            }
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
        }
        log.debug((Object)"================================Done Unpack Patch==============================");
    }

    protected File packSegment(SegmentInfo addsi, long newVersion) throws IOException {
        log.debug((Object)"================================Start Pack Segment==============================");
        addsi.setCreated();
        File tmpFile = new File(this.searchIndexDirectory, PACKFILE + String.valueOf(System.currentTimeMillis()) + ".zip");
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmpFile));
        addsi.setTimeStamp(newVersion);
        byte[] buffer = new byte[4096];
        this.addFile(addsi.getSegmentLocation(), zout, buffer, 0L);
        zout.close();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("    Packed Name[" + tmpFile.getName() + "]length[" + tmpFile.length() + "][" + addsi + "]"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug((Object)"================================Done Pack Segment==============================");
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File packPatch() throws IOException {
        log.debug((Object)"================================Start Pack Patch==============================");
        File tmpFile = new File(this.searchIndexDirectory, PACKFILE + String.valueOf(System.currentTimeMillis()) + ".zip");
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmpFile));
        byte[] buffer = new byte[4096];
        ZipEntry ze = new ZipEntry("lastpatchmarker");
        ze.setTime(System.currentTimeMillis());
        zout.putNextEntry(ze);
        try {
            ByteArrayInputStream fin = new ByteArrayInputStream("--PATCH MARKER--".getBytes());
            try {
                int len = 0;
                while ((len = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, len);
                }
            }
            finally {
                fin.close();
            }
        }
        finally {
            zout.closeEntry();
        }
        List<SegmentInfo> l = this.clusterIndexStore.getLocalSegments();
        for (SegmentInfoImpl segmentInfoImpl : l) {
            if (!segmentInfoImpl.isCreated()) continue;
            File f = segmentInfoImpl.getSegmentLocation();
            this.addFile(f, zout, buffer, segmentInfoImpl.getVersion());
        }
        zout.close();
        log.debug((Object)"================================Done Pack Patch==============================");
        return tmpFile;
    }

    private void addFile(File f, ZipOutputStream zout, byte[] buffer, long modtime) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.addFile(files[i], zout, buffer, modtime);
                        continue;
                    }
                    if (files[i].lastModified() > modtime) {
                        log.debug((Object)("               Add " + files[i].getPath()));
                        this.addSingleFile(files[i], zout, buffer);
                        continue;
                    }
                    log.debug((Object)("              Ignore " + files[i].getPath()));
                }
            }
        } else if (f.lastModified() > modtime) {
            this.addSingleFile(f, zout, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSingleFile(File file, ZipOutputStream zout, byte[] buffer) throws IOException {
        String path = file.getPath();
        if (path.startsWith(this.searchIndexDirectory)) {
            path = path.substring(this.searchIndexDirectory.length());
        }
        ZipEntry ze = new ZipEntry(path);
        ze.setTime(file.lastModified());
        zout.putNextEntry(ze);
        try {
            FileInputStream fin = new FileInputStream(file);
            try {
                int len = 0;
                while ((len = ((InputStream)fin).read(buffer)) > 0) {
                    zout.write(buffer, 0, len);
                }
            }
            finally {
                ((InputStream)fin).close();
            }
        }
        finally {
            zout.closeEntry();
        }
    }
}

