/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.journal.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.sakaiproject.search.journal.api.IndexCloser;
import org.sakaiproject.search.journal.api.ManagementOperation;
import org.sakaiproject.search.journal.api.ThreadBinder;
import org.sakaiproject.search.journal.impl.ConcurrentIndexManager;
import org.sakaiproject.search.journal.impl.JournaledFSIndexStorage;
import org.sakaiproject.search.util.FileUtils;
import org.sakaiproject.thread_local.api.ThreadBound;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

public class RefCountMultiReader
extends MultiReader
implements ThreadBound,
ThreadBinder,
IndexCloser {
    private static final Log log = LogFactory.getLog(RefCountMultiReader.class);
    private IndexReader[] indexReaders;
    private JournaledFSIndexStorage storage;
    private int count = 0;
    private boolean doclose = false;
    private boolean closing = false;
    private ThreadLocalManager threadLocalManager;
    private ConcurrentHashMap<Object, Object> parents = new ConcurrentHashMap();
    private ThreadLocal<String> unbindingMonitor = new ThreadLocal();
    private Object closeMonitor = new Object();
    private ManagementOperation managementOperation = ConcurrentIndexManager.getCurrentManagementOperation();
    private static int opened = 0;

    public RefCountMultiReader(IndexReader[] indexReaders, JournaledFSIndexStorage storage) throws IOException {
        super(indexReaders);
        ++opened;
        this.indexReaders = indexReaders;
        this.storage = storage;
    }

    protected synchronized void doClose() throws IOException {
        this.doclose = true;
        this.unbind();
        this.storage.fireIndexReaderClose((IndexReader)this);
    }

    @Override
    public boolean doFinalClose() {
        log.debug((Object)("doFinalClose() on " + this));
        if (this.canClose()) {
            return this.forceClose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceClose() {
        log.debug((Object)("forceClose() on " + this));
        Object object = this.closeMonitor;
        synchronized (object) {
            if (this.closing) {
                return true;
            }
            this.closing = true;
        }
        --opened;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing Index " + this));
        }
        for (IndexReader ir : this.indexReaders) {
            try {
                File f = null;
                boolean deleteme = false;
                try {
                    Directory d = ir.directory();
                    if (!(ir instanceof IndexCloser) && d instanceof FSDirectory) {
                        FSDirectory fsd = (FSDirectory)d;
                        f = fsd.getFile();
                        File deleteMarker = new File(f, "deleteOnClose");
                        deleteme = deleteMarker.exists();
                    }
                    ir.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closed indexreader " + ir));
                    }
                }
                catch (AlreadyClosedException acex) {
                    log.debug((Object)"Already closed");
                }
                if (f == null || !deleteme) continue;
                FileUtils.deleteAll(f);
                log.debug((Object)("Deleting Index on Close " + f));
            }
            catch (IOException ioex) {
                log.debug((Object)ioex);
            }
        }
        try {
            super.doClose();
        }
        catch (IOException ex) {
            log.debug((Object)ex);
        }
        try {
            FSDirectory fsd;
            File f;
            File deleteMarker;
            Directory d = this.directory();
            if (d instanceof FSDirectory && (deleteMarker = new File(f = (fsd = (FSDirectory)d).getFile(), "deleteOnClose")).exists()) {
                FileUtils.deleteAll((File)f);
                log.debug((Object)("Deleting Index on Close " + f));
            }
        }
        catch (AlreadyClosedException acex) {
            log.debug((Object)"Already closed");
        }
        catch (UnsupportedOperationException uoex) {
            log.debug((Object)uoex);
        }
        catch (IOException ioex) {
            log.debug((Object)ioex);
        }
        return true;
    }

    public boolean isCurrent() throws IOException {
        for (IndexReader ir : this.indexReaders) {
            if (ir.isCurrent()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind() {
        String unbinding = this.unbindingMonitor.get();
        if (unbinding == null) {
            try {
                this.unbindingMonitor.set("unbinding");
                if (this.threadLocalManager != null) {
                    Object o = this.threadLocalManager.get(String.valueOf(this));
                    if (o != null) {
                        --this.count;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Unbound " + this + " " + this.count));
                        }
                        this.threadLocalManager.set(String.valueOf(this), null);
                    }
                    for (IndexReader ir : this.indexReaders) {
                        if (!(ir instanceof ThreadBound)) continue;
                        log.debug((Object)("Calling unbind for " + ir));
                        ((ThreadBound)ir).unbind();
                    }
                }
                if (this.canClose()) {
                    log.debug((Object)("Calling forceClose for " + this));
                    this.forceClose();
                }
            }
            finally {
                this.unbindingMonitor.set(null);
            }
        }
    }

    @Override
    public void bind(ThreadLocalManager tlm) {
        this.threadLocalManager = tlm;
        Object o = tlm.get(String.valueOf(this));
        if (o == null) {
            ++this.count;
            tlm.set(String.valueOf(this), (Object)this);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + this + " " + this.count));
            }
        } else if (o != this) {
            log.warn((Object)" More than one object bound to the same key ");
        }
        for (IndexReader ir : this.indexReaders) {
            if (!(ir instanceof ThreadBinder)) continue;
            ((ThreadBinder)ir).bind(tlm);
        }
    }

    @Override
    public boolean canClose() {
        return this.count <= 0 && this.doclose && this.parents.size() == 0;
    }

    @Override
    public void addParent(Object searcher) {
        this.parents.put(searcher, searcher);
    }

    @Override
    public void removeParent(Object searcher) {
        this.parents.remove(searcher);
    }

    public static int getOpened() {
        return opened;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.managementOperation).append(" ");
        sb.append(this.toString()).append(" RefCount:").append(this.count);
        for (IndexReader ir : this.indexReaders) {
            sb.append("[").append(ir.directory().toString()).append("]");
        }
        return sb.toString();
    }
}

