/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.StoredDigestContentProducer;
import org.sakaiproject.search.component.adapter.contenthosting.ContentDigester;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.sakaiproject.site.api.SiteService;

public class ContentHostingContentProducer
implements EntityContentProducer,
StoredDigestContentProducer {
    private static Log log = LogFactory.getLog(ContentHostingContentProducer.class);
    private SearchService searchService = null;
    private ContentHostingService contentHostingService = null;
    private SearchIndexBuilder searchIndexBuilder = null;
    private EntityManager entityManager = null;
    private SiteService siteService = null;
    private ArrayList<ContentDigester> digesters = new ArrayList();
    private ContentDigester defaultDigester;
    private int readerSizeLimit = 0x200000;
    private int digesterSizeLimit = 0x500000;
    private List<String> customProperties = new ArrayList<String>();
    private ServerConfigurationService serverConfigurationService;

    public ContentHostingContentProducer() {
        this.customProperties.add("dc_created.http://purl.org/dc/terms/created");
        this.customProperties.add("Tdc_publisher.http://purl.org/dc/elements/1.1/publisher");
        this.customProperties.add("Tdc_audience.http://purl.org/dc/terms/audience");
        this.customProperties.add("Tdc_subject.http://purl.org/dc/elements/1.1/subject");
        this.customProperties.add("Tdc_creator.http://purl.org/dc/elements/1.1/creator");
        this.customProperties.add("Tdc_educationlevel.http://purl.org/dc/terms/educationLevel");
        this.customProperties.add("Tdc_alternative.http://purl.org/dc/elements/1.1/alternative");
        this.customProperties.add("dc_issued.http://purl.org/dc/terms/issued");
        this.customProperties.add("Tdc_abstract.http://purl.org/dc/terms/abstract");
        this.customProperties.add("Tdc_contributor.http://purl.org/dc/elements/1.1/contributor");
        this.customProperties.add("tag.tag");
        this.customProperties.add("Tlom_role.http://ltsc.ieee.org/xsd/lomv1.0/role");
        this.customProperties.add("Tlom_coverage.http://ltsc.ieee.org/xsd/lomv1.0/coverage");
        this.customProperties.add("Tlom_status.http://ltsc.ieee.org/xsd/lomv1.0/status");
        this.customProperties.add("Tlom_engagement.http://ltsc.ieee.org/xsd/lomv1.0/engagement");
        this.customProperties.add("Tlom_learning_resource_type.http://ltsc.ieee.org/xsd/lomv1.0/learning_resource_type");
        this.customProperties.add("Tlom_interactivity_level.http://ltsc.ieee.org/xsd/lomv1.0/interactivity_level");
        this.customProperties.add("Tlom_context_level.http://ltsc.ieee.org/xsd/lomv1.0/context_level");
        this.customProperties.add("Tlom_difficulty.http://ltsc.ieee.org/xsd/lomv1.0/difficulty");
        this.customProperties.add("Tlom_assumed_knowledge.http://ltsc.ieee.org/xsd/lomv1.0/assumed_knowledge");
        this.customProperties.add("Tlom_technical_requirements.http://ltsc.ieee.org/xsd/lomv1.0/technical_requirements");
        this.customProperties.add("Tlom_install_remarks.http://ltsc.ieee.org/xsd/lomv1.0/install_remarks");
        this.customProperties.add("Tlom_other_requirements.http://ltsc.ieee.org/xsd/lomv1.0/other_requirements");
        this.customProperties.add("Tlom_level.http://ltsc.ieee.org/xsd/lomv1.0/granularity_level");
        this.customProperties.add("Tlom_structure.http://ltsc.ieee.org/xsd/lomv1.0/structure");
        this.customProperties.add("Tlom_relation.http://ltsc.ieee.org/xsd/lomv1.0/relation");
        this.customProperties.add("Tlom_reviewer.http://ltsc.ieee.org/xsd/lomv1.0/reviewer");
        this.customProperties.add("Tlom_review_comments.http://ltsc.ieee.org/xsd/lomv1.0/review_comments");
    }

    public void init() {
        try {
            if ("true".equals(this.serverConfigurationService.getString("search.enable", "false"))) {
                this.searchService.registerFunction("content.new");
                this.searchService.registerFunction("content.revise");
                this.searchService.registerFunction("content.delete");
                this.searchIndexBuilder.registerEntityContentProducer((EntityContentProducer)this);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to init Service ", t);
        }
    }

    public void addDigester(ContentDigester digester) {
        this.digesters.add(digester);
    }

    public void removeDigester(ContentDigester digester) {
        this.digesters.remove(digester);
    }

    public boolean isContentFromReader(String ref) {
        ContentResource contentResource;
        boolean debug = log.isDebugEnabled();
        try {
            Reference reference = this.entityManager.newReference(ref);
            contentResource = this.contentHostingService.getResource(reference.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve resource " + ref, e);
        }
        if (contentResource.getContentLength() > (long)this.readerSizeLimit) {
            if (debug) {
                log.debug((Object)("ContentHosting.isContentFromReader" + ref + ":yes"));
            }
            return true;
        }
        if (debug) {
            log.debug((Object)("ContentHosting.isContentFromReader" + ref + ":yes"));
        }
        return false;
    }

    public Reader getContentReader(String ref) {
        ContentResource contentResource;
        boolean debug = log.isDebugEnabled();
        try {
            Reference reference = this.entityManager.newReference(ref);
            contentResource = this.contentHostingService.getResource(reference.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve resource " + ref, e);
        }
        if (contentResource.getContentLength() <= 0L) {
            if (debug) {
                log.debug((Object)("ContentHosting.getContentReader" + ref + ": empty"));
            }
            return new StringReader("");
        }
        ContentDigester digester = this.getDigester(contentResource);
        Reader reader = null;
        try {
            reader = digester.getContentReader(contentResource);
        }
        catch (Exception ex) {
            log.debug((Object)("Failed to digest " + ref + " with " + digester), (Throwable)ex);
            log.warn((Object)("Failed to digest " + ref + " with " + digester + " cause: " + ex.getMessage()));
            if (!digester.equals(this.defaultDigester)) {
                try {
                    reader = this.defaultDigester.getContentReader(contentResource);
                    log.info((Object)("Digested " + ref + " into a Reader with Default Digester "));
                }
                catch (Exception ex2) {
                    log.debug((Object)("Failed to extract content from " + contentResource + " using " + this.defaultDigester), (Throwable)ex2);
                    throw new RuntimeException("Failed to extract content from " + contentResource + " using " + this.defaultDigester + " and " + digester, ex);
                }
            }
            throw new RuntimeException("Failed to extract content from " + ref + " using " + digester, ex);
        }
        if (debug) {
            log.debug((Object)("ContentHosting.getContentReader" + ref + ":" + reader));
        }
        return reader;
    }

    public String getContent(String ref) {
        return this.getContent(ref, 3);
    }

    public String getContent(String ref, int minWordLenght) {
        ContentResource contentResource;
        log.info((Object)("Digesting " + ref));
        boolean debug = log.isDebugEnabled();
        try {
            Reference reference = this.entityManager.newReference(ref);
            contentResource = this.contentHostingService.getResource(reference.getId());
        }
        catch (Exception e) {
            if (debug) {
                log.debug((Object)"Failed To resolve Resource", (Throwable)e);
            }
            throw new RuntimeException("Failed to resolve resource ", e);
        }
        if (contentResource.getContentLength() <= 0L) {
            if (debug) {
                log.debug((Object)("ContentHosting.getContent" + ref + ":empty"));
            }
            return "";
        }
        ContentDigester digester = this.getDigester(contentResource);
        String content = null;
        try {
            content = digester.getContent(contentResource);
        }
        catch (Exception ex) {
            log.debug((Object)("Failed to digest " + ref + " with " + digester), (Throwable)ex);
            log.warn((Object)("Failed to digest " + ref + " with " + digester + " cause: " + ex));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            if (!digester.equals(this.defaultDigester)) {
                try {
                    content = this.defaultDigester.getContent(contentResource);
                    log.info((Object)("Digested " + ref + " into " + content.length() + " characters with Default Digester "));
                }
                catch (Exception ex2) {
                    log.debug((Object)("Failed to extract content from " + ref + " using " + this.defaultDigester), (Throwable)ex2);
                    throw new RuntimeException("Failed to extract content from " + ref + " using " + this.defaultDigester + " and " + digester, ex);
                }
            }
            if (debug) {
                log.debug((Object)"Failed To extract content");
            }
            throw new RuntimeException("Failed to extract content from " + ref + " using " + digester, ex);
        }
        if (debug) {
            log.debug((Object)("ContentHosting.getContent" + ref + ":" + content));
        }
        return content;
    }

    public ContentDigester getDigester(ContentResource cr) {
        if (cr.getContentLength() > (long)this.digesterSizeLimit) {
            return this.defaultDigester;
        }
        String mimeType = cr.getContentType();
        for (ContentDigester digester : this.digesters) {
            if (!digester.accept(mimeType)) continue;
            return digester;
        }
        return this.defaultDigester;
    }

    public String getTitle(String ref) {
        ContentResource contentResource;
        boolean debug = log.isDebugEnabled();
        try {
            Reference reference = this.entityManager.newReference(ref);
            contentResource = this.contentHostingService.getResource(reference.getId());
        }
        catch (Exception e) {
            if (debug) {
                log.debug((Object)"Failed To resolve Resource", (Throwable)e);
            }
            throw new RuntimeException("Failed to resolve resource ", e);
        }
        ResourceProperties rp = contentResource.getProperties();
        String displayNameProp = rp.getNamePropDisplayName();
        String title = rp.getProperty(displayNameProp);
        if (debug) {
            log.debug((Object)("ContentHosting.getTitle" + ref + ":" + title));
        }
        return title;
    }

    public boolean matches(String ref) {
        boolean debug = log.isDebugEnabled();
        try {
            Reference reference = this.entityManager.newReference(ref);
            EntityProducer ep = reference.getEntityProducer();
            boolean m = ep instanceof ContentHostingService;
            if (debug) {
                log.debug((Object)("ContentHosting.matches" + ref + ":" + m));
            }
            return m;
        }
        catch (Exception ex) {
            if (debug) {
                log.debug((Object)("ContentHosting.matches" + ref + ":fail-no-match"));
            }
            return false;
        }
    }

    public Integer getAction(Event event) {
        boolean debug = log.isDebugEnabled();
        String eventName = event.getEvent();
        if ("content.new".equals(eventName) || "content.revise".equals(eventName)) {
            if (debug) {
                log.debug((Object)("ContentHosting.getAction" + event + ":add"));
            }
            if (this.isForIndex(event.getResource())) {
                return SearchBuilderItem.ACTION_ADD;
            }
        }
        if ("content.delete".equals(eventName)) {
            if (debug) {
                log.debug((Object)("ContentHosting.getAction" + event + ":delete"));
            }
            if (this.isForIndexDelete(event.getResource())) {
                return SearchBuilderItem.ACTION_DELETE;
            }
        }
        if (debug) {
            log.debug((Object)("ContentHosting.getAction" + event + ":unknown"));
        }
        return SearchBuilderItem.ACTION_UNKNOWN;
    }

    public boolean matches(Event event) {
        boolean m;
        boolean debug = log.isDebugEnabled();
        boolean bl = m = !SearchBuilderItem.ACTION_UNKNOWN.equals(this.getAction(event));
        if (debug) {
            log.debug((Object)("ContentHosting.matches" + event + ":" + m));
        }
        return m;
    }

    public String getTool() {
        return "content";
    }

    public String getUrl(String ref) {
        boolean debug = log.isDebugEnabled();
        Reference reference = this.entityManager.newReference(ref);
        String url = reference.getUrl();
        if (debug) {
            log.debug((Object)("ContentHosting.getAction" + ref + ":" + url));
        }
        return url;
    }

    private String getSiteId(Reference ref) {
        String r = ref.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ContentHosting.getSiteId" + ref + ":" + r));
        }
        return r;
    }

    public String getSiteId(String resourceName) {
        String r = this.getSiteId(this.entityManager.newReference(resourceName));
        if (log.isDebugEnabled()) {
            log.debug((Object)("ContentHosting.getSiteId" + resourceName + ":" + r));
        }
        return r;
    }

    public Iterator<String> getSiteContentIterator(String context) {
        boolean debug = log.isDebugEnabled();
        String siteCollection = this.contentHostingService.getSiteCollection(context);
        if (debug) {
            log.debug((Object)("Getting content for site info " + siteCollection));
        }
        List siteContent = null;
        siteContent = "/".equals(siteCollection) ? new ArrayList() : this.contentHostingService.getAllResources(siteCollection);
        final Iterator scIterator = siteContent.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return scIterator.hasNext();
            }

            @Override
            public String next() {
                ContentResource resource = (ContentResource)scIterator.next();
                return resource.getReference();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not implimented ");
            }
        };
    }

    public int getReaderSizeLimit() {
        return this.readerSizeLimit;
    }

    public void setReaderSizeLimit(int readerSizeLimit) {
        this.readerSizeLimit = readerSizeLimit;
    }

    public ContentDigester getDefaultDigester() {
        return this.defaultDigester;
    }

    public void setDefaultDigester(ContentDigester defaultDigester) {
        this.defaultDigester = defaultDigester;
    }

    private boolean isForIndexDelete(String ref) {
        return ref.length() <= "/content".length() || !this.contentHostingService.isInDropbox(ref.substring("/content".length()));
    }

    public boolean isForIndex(String ref) {
        try {
            if (ref.length() > "/content".length() && this.contentHostingService.isInDropbox(ref.substring("/content".length()))) {
                return false;
            }
            String[] parts = ref.split("/");
            if (parts.length > 4 && "/attachment/".equals("/" + parts[2] + "/") && "Assignments".equals(parts[4])) {
                return false;
            }
            Reference reference = this.entityManager.newReference(ref);
            String r = reference.getId();
            ContentResource contentResource = this.contentHostingService.getResource(r);
            if (contentResource == null || contentResource.isCollection()) {
                return false;
            }
        }
        catch (IdUnusedException idun) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource Not present in CHS " + ref));
            }
            return false;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed To resolve Resource", (Throwable)e);
            }
            throw new RuntimeException("Failed to resolve resource ", e);
        }
        return true;
    }

    public boolean canRead(String ref) {
        log.debug((Object)("canRead(" + ref));
        try {
            Reference reference = this.entityManager.newReference(ref);
            this.contentHostingService.checkResource(reference.getId());
            return true;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Current user cannot read ref: " + ref), (Throwable)ex);
            }
            return false;
        }
    }

    public Map<String, String[]> getCustomProperties(String ref) {
        try {
            Reference reference = this.entityManager.newReference(ref);
            ContentResource contentResource = this.contentHostingService.getResource(reference.getId());
            HashMap<String, String[]> cp = new HashMap<String, String[]>();
            for (String propname : this.customProperties) {
                List prop;
                String[] propKey = propname.split("\\.", 2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prop: " + propKey[0] + "=" + propKey[1]));
                }
                if (propKey.length != 2 || (prop = contentResource.getProperties().getPropertyList(propKey[1])) == null) continue;
                cp.put(propKey[0], prop.toArray(new String[0]));
            }
            return cp;
        }
        catch (PermissionException e) {
            log.debug((Object)e);
        }
        catch (IdUnusedException e) {
            log.debug((Object)e);
        }
        catch (TypeException e) {
            log.debug((Object)e);
        }
        return null;
    }

    public String getCustomRDF(String ref) {
        return null;
    }

    public int getDigesterSizeLimit() {
        return this.digesterSizeLimit;
    }

    public void setDigesterSizeLimit(int digesterSizeLimit) {
        this.digesterSizeLimit = digesterSizeLimit;
    }

    private Reference getReference(String reference) {
        try {
            return this.entityManager.newReference(reference);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed To resolve Resource", (Throwable)ex);
            }
            return null;
        }
    }

    public String getId(String reference) {
        boolean debug = log.isDebugEnabled();
        try {
            return this.getReference(reference).getId();
        }
        catch (Exception ex) {
            if (debug) {
                log.debug((Object)"Failed To resolve Resource", (Throwable)ex);
            }
            return "";
        }
    }

    public String getSubType(String reference) {
        boolean debug = log.isDebugEnabled();
        try {
            String r = this.getReference(reference).getSubType();
            if (debug) {
                log.debug((Object)("ContentHosting.getSubType" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getType(String reference) {
        boolean debug = log.isDebugEnabled();
        try {
            String r = this.getReference(reference).getType();
            if (debug) {
                log.debug((Object)("ContentHosting.getType" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getContainer(String reference) {
        boolean debug = log.isDebugEnabled();
        try {
            String r = this.getReference(reference).getContainer();
            if (debug) {
                log.debug((Object)("ContentHosting.getContainer" + reference + ":" + r));
            }
            return r;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public List<String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(List<String> customProperties) {
        this.customProperties = customProperties;
    }

    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public SearchIndexBuilder getSearchIndexBuilder() {
        return this.searchIndexBuilder;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

