/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;

public class PPTContentDigester
extends BaseContentDigester {
    private static Log log = LogFactory.getLog(PPTContentDigester.class);

    @Override
    public String getContent(ContentResource contentResource) {
        if (contentResource == null) {
            throw new RuntimeException("Null contentResource passed to getContent");
        }
        InputStream contentStream = null;
        try {
            final ByteArrayOutputStream os = new ByteArrayOutputStream();
            POIFSReaderListener listener = new POIFSReaderListener(){

                public void processPOIFSReaderEvent(POIFSReaderEvent event) {
                    try {
                        if (!event.getName().equalsIgnoreCase("PowerPoint Document")) {
                            return;
                        }
                        DocumentInputStream input = event.getStream();
                        byte[] buffer = new byte[input.available()];
                        input.read(buffer, 0, input.available());
                        for (int i = 0; i < buffer.length - 20; ++i) {
                            long type = LittleEndian.getUShort((byte[])buffer, (int)(i + 2));
                            long size = LittleEndian.getUInt((byte[])buffer, (int)(i + 4));
                            if (type != 4008L) continue;
                            os.write(buffer, i + 4 + 1, (int)size + 3);
                            i = i + 4 + 1 + (int)size - 1;
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
            };
            POIFSReader reader = new POIFSReader();
            reader.registerListener(listener);
            contentStream = contentResource.streamContent();
            reader.read(contentStream);
            os.flush();
            StringBuilder sb = new StringBuilder();
            SearchUtils.appendCleanString((String)new String(os.toByteArray(), "UTF-8"), (StringBuilder)sb);
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read content for indexing ", e);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            }
        }
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }

    static {
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.NullLogger");
    }
}

