/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.adapter;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.Notification;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.model.SearchBuilderItem;

public class SearchIndexBuilderAdapter
implements SearchIndexBuilder {
    private static Log log = LogFactory.getLog(SearchIndexBuilderAdapter.class);
    private static final String SEARCH_BUILDER_IMPL_PROPERTY = "search.indexbuilder.impl";
    private static final String DEFAULT_IMPL = "org.sakaiproject.search.elasticsearch.ElasticSearchIndexBuilder";
    private final SearchIndexBuilder searchIndexBuilder;

    public SearchIndexBuilderAdapter() {
        String searchIndexBuilderImplementation = ServerConfigurationService.getString((String)SEARCH_BUILDER_IMPL_PROPERTY, (String)DEFAULT_IMPL);
        this.searchIndexBuilder = (SearchIndexBuilder)ComponentManager.get((String)searchIndexBuilderImplementation);
    }

    public void addResource(Notification notification, Event event) {
        this.searchIndexBuilder.addResource(notification, event);
    }

    public void registerEntityContentProducer(EntityContentProducer ecp) {
        this.searchIndexBuilder.registerEntityContentProducer(ecp);
    }

    public void refreshIndex() {
        this.searchIndexBuilder.refreshIndex();
    }

    public void rebuildIndex() {
        this.searchIndexBuilder.rebuildIndex();
    }

    public boolean isBuildQueueEmpty() {
        return this.searchIndexBuilder.isBuildQueueEmpty();
    }

    public List<EntityContentProducer> getContentProducers() {
        return this.searchIndexBuilder.getContentProducers();
    }

    public void destroy() {
        this.searchIndexBuilder.destroy();
    }

    public int getPendingDocuments() {
        return this.searchIndexBuilder.getPendingDocuments();
    }

    public void rebuildIndex(String currentSiteId) {
        this.searchIndexBuilder.rebuildIndex(currentSiteId);
    }

    public void refreshIndex(String currentSiteId) {
        this.searchIndexBuilder.refreshIndex(currentSiteId);
    }

    public List<SearchBuilderItem> getAllSearchItems() {
        return this.searchIndexBuilder.getAllSearchItems();
    }

    public EntityContentProducer newEntityContentProducer(Event event) {
        return this.searchIndexBuilder.newEntityContentProducer(event);
    }

    public EntityContentProducer newEntityContentProducer(String ref) {
        return this.searchIndexBuilder.newEntityContentProducer(ref);
    }

    public List<SearchBuilderItem> getSiteMasterSearchItems() {
        return this.searchIndexBuilder.getSiteMasterSearchItems();
    }

    public List<SearchBuilderItem> getGlobalMasterSearchItems() {
        return this.searchIndexBuilder.getGlobalMasterSearchItems();
    }

    public boolean isOnlyIndexSearchToolSites() {
        return this.searchIndexBuilder.isOnlyIndexSearchToolSites();
    }

    public boolean isExcludeUserSites() {
        return this.searchIndexBuilder.isExcludeUserSites();
    }

    public void setOnlyIndexSearchToolSites(boolean onlyIndexSearchToolSites) {
        try {
            Method method = this.searchIndexBuilder.getClass().getMethod("setOnlyIndexSearchToolSites", Boolean.TYPE);
            method.invoke((Object)this.searchIndexBuilder, onlyIndexSearchToolSites);
            log.trace((Object)("######### searchIndexBuilder.getSearchServer() = " + this.searchIndexBuilder.isOnlyIndexSearchToolSites()));
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)(this.searchIndexBuilder.getClass().getName() + " does not have a method called setOnlyIndexSearchToolSites."));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setExcludeUserSites(boolean excludeUserSites) {
        try {
            Method method = this.searchIndexBuilder.getClass().getMethod("setExcludeUserSites", Boolean.TYPE);
            method.invoke((Object)this.searchIndexBuilder, excludeUserSites);
            log.trace((Object)("######### searchIndexBuilder.getSearchServer() = " + this.searchIndexBuilder.isExcludeUserSites()));
        }
        catch (NoSuchMethodException e) {
            log.debug((Object)(this.searchIndexBuilder.getClass().getName() + " does not have a method called setExcludeUserSites."));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

