/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.adapter;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.search.api.InvalidSearchQueryException;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.search.api.SearchStatus;
import org.sakaiproject.search.api.TermFrequency;
import org.sakaiproject.search.model.SearchBuilderItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchServiceAdapter
implements SearchService {
    private static Logger log = LoggerFactory.getLogger(SearchServiceAdapter.class);
    private static final String SEARCH_IMPL_PROPERTY = "search.service.impl";
    private static final String DEFAULT_IMPL = "org.sakaiproject.search.elasticsearch.ElasticSearchService";
    private final SearchService searchService;

    public SearchServiceAdapter() {
        String searchServiceImplementation = ServerConfigurationService.getString((String)SEARCH_IMPL_PROPERTY, (String)DEFAULT_IMPL);
        this.searchService = (SearchService)ComponentManager.get((String)searchServiceImplementation);
    }

    public SearchList search(String searchTerms, List<String> contexts, int searchStart, int searchEnd) throws InvalidSearchQueryException {
        return this.searchService.search(searchTerms, contexts, searchStart, searchEnd);
    }

    public SearchList search(String searchTerms, List<String> contexts, int start, int end, String filterName, String sorterName) throws InvalidSearchQueryException {
        return this.searchService.search(searchTerms, contexts, start, end, filterName, sorterName);
    }

    public void registerFunction(String function) {
        this.searchService.registerFunction(function);
    }

    public void reload() {
        this.searchService.reload();
    }

    public void refreshInstance() {
        this.searchService.refreshInstance();
    }

    public void rebuildInstance() {
        this.searchService.rebuildInstance();
    }

    public void refreshSite(String currentSiteId) {
        this.searchService.refreshSite(currentSiteId);
    }

    public void rebuildSite(String currentSiteId) {
        this.searchService.rebuildSite(currentSiteId);
    }

    public String getStatus() {
        return this.searchService.getStatus();
    }

    public int getNDocs() {
        return this.searchService.getNDocs();
    }

    public int getPendingDocs() {
        return this.searchService.getPendingDocs();
    }

    public List<SearchBuilderItem> getAllSearchItems() {
        return this.searchService.getAllSearchItems();
    }

    public List<SearchBuilderItem> getSiteMasterSearchItems() {
        return this.searchService.getSiteMasterSearchItems();
    }

    public List<SearchBuilderItem> getGlobalMasterSearchItems() {
        return this.searchService.getGlobalMasterSearchItems();
    }

    public SearchStatus getSearchStatus() {
        return this.searchService.getSearchStatus();
    }

    public boolean removeWorkerLock() {
        return this.searchService.removeWorkerLock();
    }

    public List getSegmentInfo() {
        return this.searchService.getSegmentInfo();
    }

    public void forceReload() {
        this.searchService.forceReload();
    }

    public TermFrequency getTerms(int documentId) throws IOException {
        return this.searchService.getTerms(documentId);
    }

    public String searchXML(Map parameterMap) {
        return this.searchService.searchXML(parameterMap);
    }

    public boolean isEnabled() {
        return this.searchService.isEnabled();
    }

    public String getDigestStoragePath() {
        return this.searchService.getDigestStoragePath();
    }

    public String getSearchSuggestion(String searchString) {
        return this.searchService.getSearchSuggestion(searchString);
    }

    public String[] getSearchSuggestions(String searchString, String currentSite, boolean allMySites) {
        return this.searchService.getSearchSuggestions(searchString, currentSite, allMySites);
    }

    public void setSearchServer(boolean searchServer) {
        try {
            Method method = this.searchService.getClass().getMethod("setSearchServer", Boolean.TYPE);
            method.invoke((Object)this.searchService, searchServer);
            log.trace("######### searchService.getSearchServer() = " + this.searchService.isSearchServer());
        }
        catch (NoSuchMethodException e) {
            log.debug(this.searchService.getClass().getName() + " does not have a method called setSearchServer.");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isSearchServer() {
        return this.searchService.isSearchServer();
    }

    public void enableDiagnostics() {
        this.searchService.enableDiagnostics();
    }

    public void disableDiagnostics() {
        this.searchService.disableDiagnostics();
    }

    public boolean hasDiagnostics() {
        return this.searchService.hasDiagnostics();
    }
}

