/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.util.Map;
import org.sakaiproject.search.component.adapter.contenthosting.ContentDigester;
import org.sakaiproject.search.component.adapter.contenthosting.ContentHostingContentProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContentDigester
implements ContentDigester {
    private static Logger log = LoggerFactory.getLogger(BaseContentDigester.class);
    private ContentHostingContentProducer contentProducer = null;
    protected int maxDigestSize = 0x500000;
    private Map mimeTypes = null;

    public void init() {
        try {
            this.contentProducer.addDigester(this);
        }
        catch (Throwable t) {
            log.error("Failed to init", t);
        }
    }

    public void destroy() {
        this.contentProducer.removeDigester(this);
    }

    @Override
    public boolean accept(String mimeType) {
        return this.mimeTypes.get(mimeType) != null;
    }

    public Map getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(Map mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public ContentHostingContentProducer getContentProducer() {
        return this.contentProducer;
    }

    public void setContentProducer(ContentHostingContentProducer contentProducer) {
        this.contentProducer = contentProducer;
    }

    public int getMaxDigestSize() {
        return this.maxDigestSize;
    }

    public void setMaxDigestSize(int maxDigestSize) {
        this.maxDigestSize = maxDigestSize;
    }
}

