/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiContentDigester
extends BaseContentDigester {
    private static Logger log = LoggerFactory.getLogger(PoiContentDigester.class);

    @Override
    public String getContent(ContentResource contentResource) {
        log.debug("Digesting with PoiContentDigester");
        if (contentResource == null) {
            throw new RuntimeException("Attempt to digest null document!");
        }
        if (contentResource != null && contentResource.getContentLength() > (long)this.maxDigestSize) {
            throw new RuntimeException("Attempt to get too much content as a string on " + contentResource.getReference());
        }
        InputStream contentStream = null;
        try {
            contentStream = contentResource.streamContent();
            POITextExtractor DocExt = ExtractorFactory.createExtractor((InputStream)contentStream);
            String string = DocExt.getText();
            return string;
        }
        catch (Exception e) {
            log.warn("Poi can't digest: " + contentResource.getId() + " POI returned: " + e);
            throw new RuntimeException("Failed to read content for indexing ", e);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                }
            }
        }
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }

    static {
        System.setProperty("org.apache.poi.util.POILogger", "org.apache.poi.util.NullLogger");
    }
}

