/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.api.SearchUtils;
import org.sakaiproject.search.component.adapter.contenthosting.DefaultContentDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFullContentDigester
extends DefaultContentDigester {
    private static final Logger log = LoggerFactory.getLogger(DefaultFullContentDigester.class);
    private int maxDigestSize = 0x500000;

    @Override
    public String getContent(ContentResource contentResource) {
        if (contentResource == null) {
            throw new RuntimeException("null contentResource passed to getContent");
        }
        try {
            return SearchUtils.appendCleanString((String)new String(contentResource.getContent(), "UTF-8"), null).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get content", e);
        }
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        InputStream contentStream = null;
        try {
            contentStream = contentResource.streamContent();
            FilterStreamReader filterReader = new FilterStreamReader(contentStream, this.maxDigestSize);
            return filterReader;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stream content ", e);
        }
    }

    @Override
    public boolean accept(String mimeType) {
        return true;
    }

    @Override
    public int getMaxDigestSize() {
        return this.maxDigestSize;
    }

    @Override
    public void setMaxDigestSize(int maxDigestSize) {
        this.maxDigestSize = maxDigestSize;
    }

    public class FilterStreamReader
    extends FilterReader {
        private InputStream inputStream;
        private int maxDigestSize;
        private int nread;

        @Override
        public int read() throws IOException {
            if (this.nread > this.maxDigestSize) {
                return -1;
            }
            char i = (char)super.read();
            ++this.nread;
            if (Character.isLetterOrDigit(i)) {
                return i;
            }
            return 32;
        }

        @Override
        public int read(char[] buffer, int start, int end) throws IOException {
            if (this.nread > this.maxDigestSize) {
                return -1;
            }
            int size = super.read(buffer, start, end);
            this.nread += size;
            int last = start + size;
            for (int i = size; i < last; ++i) {
                if (Character.isLetterOrDigit(buffer[i])) continue;
                buffer[i] = 32;
            }
            return size;
        }

        protected FilterStreamReader(Reader arg0) {
            super(arg0);
            this.inputStream = null;
            this.nread = 0;
        }

        public FilterStreamReader(InputStream stream, int maxDigestSize) {
            super(new InputStreamReader(stream));
            this.inputStream = null;
            this.nread = 0;
            this.inputStream = stream;
            this.maxDigestSize = maxDigestSize;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.in.close();
            }
            catch (Exception ex) {
                log.debug(ex.getMessage());
            }
            try {
                this.inputStream.close();
            }
            catch (Exception ex) {
                log.debug(ex.getMessage());
            }
            this.inputStream = null;
        }
    }
}

