/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;
import org.sakaiproject.search.component.adapter.contenthosting.TikaContentDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanslanContentDigester
extends BaseContentDigester {
    private static Logger log = LoggerFactory.getLogger(TikaContentDigester.class);

    @Override
    public String getContent(ContentResource contentResource) {
        log.debug("digesting: " + contentResource.getId());
        InputStream contentStream = null;
        IImageMetadata metadata = null;
        try {
            contentStream = contentResource.streamContent();
            ResourceProperties resourceProperties = contentResource.getProperties();
            String fileName = resourceProperties.getProperty(resourceProperties.getNamePropDisplayName());
            try {
                metadata = Sanselan.getMetadata((InputStream)contentStream, (String)fileName);
                StringBuffer sb = new StringBuffer();
                if (metadata instanceof JpegImageMetadata) {
                    JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
                    sb.append(this.getFieldValue(jpegMetadata, TiffConstants.EXIF_TAG_MAKE));
                    sb.append(this.getFieldValue(jpegMetadata, TiffConstants.EXIF_TAG_MODEL));
                    sb.append(this.getFieldValue(jpegMetadata, TiffConstants.EXIF_TAG_ARTIST));
                    sb.append(this.getFieldValue(jpegMetadata, TiffConstants.EXIF_TAG_USER_COMMENT));
                    TiffImageMetadata exifMetadata = jpegMetadata.getExif();
                    if (exifMetadata != null) {
                        try {
                            TiffImageMetadata.GPSInfo gpsInfo = exifMetadata.getGPS();
                            if (null != gpsInfo) {
                                double longitude = gpsInfo.getLongitudeAsDegreesEast();
                                double latitude = gpsInfo.getLatitudeAsDegreesNorth();
                                sb.append("GPS Description: " + gpsInfo + "\n");
                                sb.append("GPS Longitude: " + longitude + "\n");
                                sb.append("GPS Latitude: " + latitude + "\n");
                            }
                        }
                        catch (ImageReadException e) {
                            e.printStackTrace();
                        }
                    }
                }
                log.debug("got metadata: " + sb.toString());
                return sb.toString();
            }
            catch (ImageReadException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (ServerOverloadException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getFieldValue(JpegImageMetadata metadata, TagInfo tagInfo) {
        TiffField field = metadata.findEXIFValue(tagInfo);
        if (field == null) {
            return "";
        }
        return tagInfo.name + ": " + field.getValueDescription() + "\n";
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }
}

