/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.component.adapter.contenthosting;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.search.component.adapter.contenthosting.BaseContentDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class TikaContentDigester
extends BaseContentDigester {
    private static Logger log = LoggerFactory.getLogger(TikaContentDigester.class);

    @Override
    public String getContent(ContentResource contentResource) {
        log.debug("Digesting with TikaContentDigester");
        if (contentResource == null) {
            throw new RuntimeException("Null contentResource passed to getContent");
        }
        InputStream contentStream = null;
        try {
            contentStream = contentResource.streamContent();
            Metadata metadata = new Metadata();
            metadata.set("Content-Type", contentResource.getContentType());
            BodyContentHandler handler = new BodyContentHandler();
            AutoDetectParser parser = new AutoDetectParser();
            parser.parse(contentStream, (ContentHandler)handler, metadata, new ParseContext());
            String string = handler.toString();
            return string;
        }
        catch (Exception e) {
            log.debug("Cannot index", (Throwable)e);
            throw new RuntimeException("Failed to read content for indexing ", e);
        }
        finally {
            if (contentStream != null) {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                }
            }
        }
    }

    @Override
    public Reader getContentReader(ContentResource contentResource) {
        return new StringReader(this.getContent(contentResource));
    }
}

