/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.entitybroker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.search.api.EntityContentProducer;
import org.sakaiproject.search.api.InvalidSearchQueryException;
import org.sakaiproject.search.api.SearchIndexBuilder;
import org.sakaiproject.search.api.SearchList;
import org.sakaiproject.search.api.SearchResult;
import org.sakaiproject.search.api.SearchService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.user.api.UserDirectoryService;

public class SearchEntityProvider
extends AbstractEntityProvider
implements ActionsExecutable,
Outputable,
Describeable {
    private static final int DEFAULT_RESULT_COUNT = 10;
    private UserDirectoryService userDirectoryService;
    private SearchService searchService;
    private SearchIndexBuilder searchIndexBuilder;
    private SiteService siteService;

    public String getEntityPrefix() {
        return "search";
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json", "xml"};
    }

    @EntityCustomAction(action="search", viewKey="list")
    public List<SearchResultEntity> search(EntityReference ref, Search search) {
        try {
            String query = this.extractQuery(search.getRestrictionByProperty("searchTerms"));
            List<String> contexts = this.extractContexts(search.getRestrictionByProperty("contexts"));
            if (search.getLimit() < 0L) {
                search.setLimit(10L);
            }
            SearchList searchResults = this.searchService.search(query, contexts, (int)search.getStart(), (int)search.getLimit());
            ArrayList<SearchResultEntity> results = new ArrayList<SearchResultEntity>(searchResults.size());
            for (SearchResult result : searchResults) {
                results.add(new SearchResultEntity(result));
            }
            return results;
        }
        catch (InvalidSearchQueryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @EntityCustomAction(action="tools", viewKey="show")
    public Set<String> getTools() {
        List entityContentProducers = this.searchIndexBuilder.getContentProducers();
        HashSet<String> tools = new HashSet<String>(entityContentProducers.size());
        for (EntityContentProducer entityContentProducer : entityContentProducers) {
            tools.add(entityContentProducer.getTool());
        }
        return tools;
    }

    private String extractQuery(Restriction searchTermsRestriction) {
        if (searchTermsRestriction == null) {
            throw new IllegalArgumentException("No searchTerms supplied");
        }
        StringBuilder searchQuery = new StringBuilder();
        for (String term : (String[])searchTermsRestriction.getArrayValue()) {
            searchQuery.append(term).append(' ');
        }
        return searchQuery.toString();
    }

    private List<String> extractContexts(Restriction contextsRestriction) {
        List<String> contexts = contextsRestriction != null ? Arrays.asList((String[])contextsRestriction.getArrayValue()) : this.getAllSites();
        return contexts;
    }

    private List<String> getAllSites() {
        List sites = this.siteService.getSites(SiteService.SelectionType.ACCESS, null, null, null, null, null);
        ArrayList<String> siteIds = new ArrayList<String>(sites.size());
        for (Site site : sites) {
            if (site == null || site.getId() == null) continue;
            siteIds.add(site.getId());
        }
        siteIds.add(this.siteService.getUserSiteId(this.userDirectoryService.getCurrentUser().getId()));
        return siteIds;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setSearchIndexBuilder(SearchIndexBuilder searchIndexBuilder) {
        this.searchIndexBuilder = searchIndexBuilder;
    }

    public class SearchResultEntity {
        private final SearchResult searchResult;

        private SearchResultEntity(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        public String getReference() {
            return this.searchResult.getReference();
        }

        public String getContentId() {
            return this.searchResult.getId();
        }

        public float getScore() {
            return this.searchResult.getScore();
        }

        public String getSearchResult() {
            return this.searchResult.getSearchResult();
        }

        public String getTitle() {
            return this.searchResult.getTitle();
        }

        public String getTool() {
            return this.searchResult.getTool();
        }

        public String getUrl() {
            return this.searchResult.getUrl();
        }
    }
}

