/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.model.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.sakaiproject.search.model.SearchBuilderItem;

public class SearchBuilderItemImpl
implements SearchBuilderItem {
    private static final int OBJECT_VERSION = 1;
    private String id = null;
    private String name = null;
    private Integer searchaction = SearchBuilderItem.ACTION_UNKNOWN;
    private Integer searchstate = SearchBuilderItem.STATE_UNKNOWN;
    private Integer itemscope = SearchBuilderItem.ITEM;
    private Date version = null;
    private String context = null;
    private int lock = 0;

    public Integer getSearchaction() {
        return this.searchaction;
    }

    public void setSearchaction(Integer searchaction) {
        this.searchaction = searchaction;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getVersion() {
        return this.version;
    }

    public void setVersion(Date version) {
        this.version = version;
    }

    public Integer getSearchstate() {
        return this.searchstate;
    }

    public void setSearchstate(Integer searchstate) {
        this.searchstate = searchstate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String toString() {
        String action = "invalid";
        if (this.searchaction != null && this.searchaction >= 0 && this.searchaction < SearchBuilderItem.actions.length) {
            action = SearchBuilderItem.actions[this.searchaction];
        }
        String state = "invalid:" + this.searchstate;
        if (this.searchstate != null && this.searchstate >= 0 && this.searchstate < SearchBuilderItem.states.length) {
            state = SearchBuilderItem.states[this.searchstate];
        }
        String locked = " Not Locked";
        if (this.isLocked()) {
            locked = " Locked:" + this.getLock();
        }
        return "Action:" + action + " State:" + state + locked + " Resource:" + this.name;
    }

    public Integer getItemscope() {
        return this.itemscope;
    }

    public void setItemscope(Integer itemscope) {
        this.itemscope = itemscope;
    }

    public void output(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(this.searchaction);
        dataOutputStream.writeInt(this.searchstate);
        dataOutputStream.writeInt(this.itemscope);
        dataOutputStream.writeLong(this.version.getTime());
        dataOutputStream.writeUTF(this.id);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.context);
    }

    public void input(DataInputStream dataInputStream) throws IOException {
        int objectVersion = dataInputStream.readInt();
        switch (objectVersion) {
            case 1: {
                this.searchaction = dataInputStream.readInt();
                this.searchstate = dataInputStream.readInt();
                this.itemscope = dataInputStream.readInt();
                this.version = new Date(dataInputStream.readLong());
                this.id = dataInputStream.readUTF();
                this.name = dataInputStream.readUTF();
                this.context = dataInputStream.readUTF();
                break;
            }
            default: {
                throw new RuntimeException("Unknown object Version while loading SearchBuiderItem");
            }
        }
    }

    public int getLock() {
        if (this.lock == 0 && this.isLocked()) {
            return this.searchstate;
        }
        return this.lock;
    }

    public void setLock(int nodeLock) {
        this.lock = nodeLock;
    }

    public boolean isLocked() {
        return this.lock > 0 || this.searchstate >= SearchBuilderItem.states.length || this.searchstate < 0;
    }
}

