/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static final Log log = LogFactory.getLog(FileUtils.class);

    public static void deleteAll(File f) throws IOException {
        FileUtils.recurse(f, new RecurseAction(){

            public void doFile(File file) throws IOException {
                if (file != null && !file.delete() && file.exists()) {
                    throw new IOException("Failed to delete  " + file.getPath());
                }
            }

            public void doBeforeFile(File f) {
            }

            public void doAfterFile(File f) {
            }
        });
    }

    public static void recurse(File f, RecurseAction action) throws IOException {
        File[] files;
        action.doBeforeFile(f);
        if (f != null && f.isDirectory() && (files = f.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.recurse(files[i], action);
                    continue;
                }
                action.doFile(files[i]);
            }
        }
        action.doFile(f);
    }

    public static void recurseGrouped(File f, RecurseAction action) throws IOException {
        File[] files;
        action.doBeforeFile(f);
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            int i;
            for (i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) continue;
                action.doFile(files[i]);
            }
            action.doAfterFile(f);
            for (i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                FileUtils.recurseGrouped(files[i], action);
            }
        }
        action.doFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(File source, final String basePath, final String replacePath, OutputStream output, boolean compress) throws IOException {
        log.debug((Object)("Packing " + source + " repacing " + basePath + " with " + replacePath));
        final ZipOutputStream zout = new ZipOutputStream(output);
        if (compress) {
            zout.setLevel(8);
        } else {
            zout.setLevel(0);
        }
        final byte[] buffer = new byte[102400];
        try {
            FileUtils.recurse(source, new RecurseAction(){

                public void doFile(File file) throws IOException {
                    if (!file.isDirectory()) {
                        log.debug((Object)("               Add " + file.getPath()));
                        FileUtils.addSingleFile(basePath, replacePath, file, zout, buffer);
                    } else {
                        log.debug((Object)("              Ignore " + file.getPath()));
                    }
                }

                public void doBeforeFile(File f) {
                }

                public void doAfterFile(File f) {
                }
            });
        }
        finally {
            zout.flush();
            try {
                zout.close();
            }
            catch (Exception e) {
                log.warn((Object)"Exception closing output zip", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSingleFile(String basePath, String replacePath, File file, ZipOutputStream zout, byte[] buffer) throws IOException {
        String path = file.getPath();
        if (path.startsWith(basePath)) {
            path = replacePath + path.substring(basePath.length());
        }
        ZipEntry ze = new ZipEntry(path);
        ze.setTime(file.lastModified());
        zout.putNextEntry(ze);
        try {
            FileInputStream fin = new FileInputStream(file);
            try {
                int len = 0;
                while ((len = ((InputStream)fin).read(buffer)) > 0) {
                    zout.write(buffer, 0, len);
                }
            }
            finally {
                ((InputStream)fin).close();
            }
        }
        finally {
            zout.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(InputStream source, File destination) throws IOException {
        ZipInputStream zin = new ZipInputStream(source);
        ZipEntry zipEntry = null;
        FileOutputStream fout = null;
        try {
            byte[] buffer = new byte[4096];
            while ((zipEntry = zin.getNextEntry()) != null) {
                int len;
                long ts = zipEntry.getTime();
                File f = new File(destination, zipEntry.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("         Unpack " + f.getAbsolutePath()));
                }
                if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                    log.warn((Object)("unpack(): Failed to create parent folder: " + f.getParentFile().getPath()));
                }
                fout = new FileOutputStream(f);
                while ((len = zin.read(buffer)) > 0) {
                    fout.write(buffer, 0, len);
                }
                zin.closeEntry();
                fout.close();
                if (f.setLastModified(ts)) continue;
                log.warn((Object)("upack(): failes to set modified date on " + f.getPath()));
            }
        }
        finally {
            try {
                fout.close();
            }
            catch (Exception ex) {
                log.warn((Object)"Exception closing file output stream", (Throwable)ex);
            }
        }
    }

    public static String digest(String token) throws GeneralSecurityException, IOException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        return FileUtils.byteArrayToHexStr(sha1.digest(token.getBytes("UTF-8")));
    }

    private static String byteArrayToHexStr(byte[] data) {
        char[] chars = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte current = data[i];
            int hi = (current & 0xF0) >> 4;
            int lo = current & 0xF;
            chars[2 * i] = (char)(hi < 10 ? 48 + hi : 65 + hi - 10);
            chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 65 + lo - 10);
        }
        return new String(chars);
    }

    public static void listDirectory(File f) throws IOException {
        FileUtils.recurseGrouped(f, new RecurseAction(){
            long total = 0L;

            public void doFile(File file) throws IOException {
                if (!file.isDirectory()) {
                    this.listFile(file);
                    this.total += file.length();
                }
            }

            private void listFile(File file) {
                char[] c = new char[4];
                c[0] = 45;
                c[0] = file.isDirectory() ? 100 : c[0];
                c[0] = file.isFile() ? 102 : c[0];
                c[1] = file.isHidden() ? 104 : 45;
                c[2] = file.canRead() ? 114 : 45;
                c[3] = file.canWrite() ? 119 : 45;
                log.info((Object)(new String(c) + "  " + this.getSizeStr(file.length()) + " " + file.getName()));
            }

            private String getSizeStr(long size) {
                String sizeStr = String.valueOf(size) + "B";
                if (size > 0x280000000L) {
                    sizeStr = String.valueOf(size / 0x40000000L) + "G";
                } else if (size > 0xA00000L) {
                    sizeStr = String.valueOf(size / 0x100000L) + "M";
                } else if (size > 10240L) {
                    sizeStr = String.valueOf(size / 1024L) + "K";
                }
                return sizeStr;
            }

            public void doBeforeFile(File f) {
                if (f.isDirectory()) {
                    char[] c = new char[4];
                    c[0] = 45;
                    c[0] = f.isDirectory() ? 100 : c[0];
                    c[0] = f.isFile() ? 102 : c[0];
                    c[1] = f.isHidden() ? 104 : 45;
                    c[2] = f.canRead() ? 114 : 45;
                    c[3] = f.canWrite() ? 119 : 45;
                    log.info((Object)(new String(c) + "  " + f.getAbsolutePath()));
                    log.info((Object)"--------------------------------------------------------");
                }
            }

            public void doAfterFile(File f) {
                if (f.isDirectory()) {
                    log.info((Object)("Total :" + this.getSizeStr(this.total) + " " + f.getAbsolutePath()));
                    log.info((Object)"--------------------------------------------------------");
                    this.total = 0L;
                } else {
                    log.info((Object)("Not A Directory " + f.getAbsolutePath()));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMarkerFile(File file) throws IOException {
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write("File Touched at " + new Date());
        }
        finally {
            fw.close();
        }
    }

    public static interface RecurseAction {
        public void doFile(File var1) throws IOException;

        public void doBeforeFile(File var1);

        public void doAfterFile(File var1);
    }
}

