/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.search.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTMLParser
implements Iterator<String> {
    private static Log log = LogFactory.getLog(HTMLParser.class);
    private static final char[][] IGNORE_TAGS = new char[][]{"script".toCharArray(), "head".toCharArray(), "style".toCharArray()};
    private static final String PAD = "                                                                                                                   ";
    private static final Map<String, String> entities = new HashMap<String, String>();
    private int[] elementStack = new int[1024];
    private int ignore = this.elementStack.length;
    private boolean notxml = false;
    private char[] cbuf;
    private int current = 0;
    private int clen = 0;
    private int endstack = 0;
    private int last = 0;

    public HTMLParser(String content) {
        this.cbuf = content == null ? new char[0] : content.toCharArray();
        this.current = 0;
        this.clen = this.cbuf.length;
    }

    public String getTagName(String tag, int start) {
        String[] words = (tag = tag.substring(start)).split("\\s", 2);
        if (words != null && words.length != 0) {
            return words[0];
        }
        return tag;
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.clen) {
            return false;
        }
        for (int i = this.current; i < this.clen; ++i) {
            if (this.cbuf[i] != '<') continue;
            this.current = i;
            return true;
        }
        this.current = this.clen - 1;
        return true;
    }

    @Override
    public String next() {
        int i;
        int i2;
        boolean ignoreBefore;
        int tagend = this.clen - 1;
        int elend = -1;
        int tagstart = this.current + 1;
        boolean ignoreAfter = ignoreBefore = this.ignore <= this.endstack;
        for (i2 = this.current; i2 < this.clen; ++i2) {
            if (elend == -1 && Character.isWhitespace(this.cbuf[i2])) {
                elend = i2;
            }
            if (this.cbuf[i2] != '>') continue;
            tagend = i2;
            if (elend != -1) break;
            elend = tagend;
            break;
        }
        if (tagstart < this.clen && this.cbuf[tagend - 1] != '/' && (tagstart + 2 >= this.clen || this.cbuf[tagstart] != '!' || this.cbuf[tagstart + 1] != '-' || this.cbuf[tagstart + 2] != '-')) {
            int j;
            if (this.cbuf[tagstart] == '/') {
                ++tagstart;
                if (!this.notxml) {
                    boolean match = true;
                    if (elend - tagstart == this.elementStack[this.endstack - 1] - this.elementStack[this.endstack - 2]) {
                        j = this.elementStack[this.endstack - 2];
                        for (i = 0; i < elend - tagstart; ++i) {
                            if (Character.toLowerCase(this.cbuf[tagstart + i]) == Character.toLowerCase(this.cbuf[j + i])) continue;
                            match = false;
                            break;
                        }
                    }
                    if (match) {
                        this.endstack -= 2;
                        ignoreAfter = this.ignore <= this.endstack;
                    } else {
                        this.notxml = true;
                    }
                }
            } else if (!this.notxml) {
                this.elementStack[this.endstack] = tagstart;
                this.elementStack[this.endstack + 1] = elend;
                this.endstack += 2;
                if (!ignoreAfter) {
                    for (i2 = 0; i2 < IGNORE_TAGS.length; ++i2) {
                        if (IGNORE_TAGS[i2].length != elend - tagstart) continue;
                        ignoreAfter = true;
                        for (j = 0; j < IGNORE_TAGS[i2].length; ++j) {
                            if (IGNORE_TAGS[i2][j] == Character.toLowerCase(this.cbuf[tagstart + j])) continue;
                            ignoreAfter = false;
                            break;
                        }
                        if (ignoreAfter) break;
                    }
                }
            }
        }
        String t = "";
        if (this.notxml || !ignoreBefore) {
            StringBuilder sb = new StringBuilder();
            block4: for (i = this.last; i < this.current; ++i) {
                if (this.cbuf[i] == '&') {
                    String entity;
                    int j;
                    if (this.cbuf[i + 1] == '#') {
                        for (j = i; j < this.current; ++j) {
                            if (this.cbuf[j] != ';') continue;
                            entity = new String(this.cbuf, i + 2, j - (i + 2));
                            sb.append((char)Integer.decode(entity).intValue());
                            i = j;
                            continue block4;
                        }
                        continue;
                    }
                    for (j = i; j < this.current; ++j) {
                        if (this.cbuf[j] != ';') continue;
                        entity = new String(this.cbuf, i, j - i + 1);
                        String s = entities.get(entity);
                        if (s == null) {
                            s = entity;
                        } else if (s.length() > 0) {
                            sb.append(s.charAt(0));
                        }
                        i = j;
                        continue block4;
                    }
                    continue;
                }
                sb.append(this.cbuf[i]);
            }
            t = sb.toString();
        }
        this.current = this.last = tagend + 1;
        if (ignoreAfter) {
            if (!ignoreBefore) {
                this.ignore = this.endstack;
            }
        } else {
            this.ignore = this.endstack + 2;
        }
        return t;
    }

    @Override
    public void remove() {
    }

    static {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(HTMLParser.class.getResourceAsStream("/org/sakaiproject/search/util/htmlentities.config")));
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    String[] parts = line.split("=");
                    char code = (char)Integer.parseInt(parts[1]);
                    entities.put(parts[0], new String(new char[]{code}));
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            log.error((Object)"Unable to load HTML Entities", (Throwable)ex);
        }
    }
}

