/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.downloadEvents;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;

public class CSVExport {
    List<SignupMeetingWrapper> wrappers;
    SakaiFacade sakaiFacade;
    private ResourceLoader rb = new ResourceLoader("messages");

    public CSVExport(List<SignupMeetingWrapper> meetingWrappers, SakaiFacade sakaiFacade) {
        this.wrappers = meetingWrappers;
        this.sakaiFacade = sakaiFacade;
    }

    public List<String> getHeaderRow() {
        ArrayList<String> header = new ArrayList<String>();
        header.add(this.rb.getString("wksheet_meeting_name", "Event Name"));
        header.add(this.rb.getString("wksheet_user_name", "Attendee Name"));
        header.add(this.rb.getString("wksheet_user_id", "Attendee User Id"));
        header.add(this.rb.getString("wksheet_user_email", "Email"));
        header.add(this.rb.getString("wksheet_site_name", "Site Title"));
        header.add(this.rb.getString("wksheet_appointment_start_time", "Appointment Time"));
        header.add(this.rb.getString("wksheet_appointment_duration", "Duration (min)"));
        header.add(this.rb.getString("wksheet_num_of_attendees", "#Num Attendees in Slot"));
        header.add(this.rb.getString("wksheet_user_comment", "User Comment"));
        header.add(this.rb.getString("wksheet_organizer", "Organizer"));
        header.add(this.rb.getString("wksheet_location", "Location"));
        header.add(this.rb.getString("wksheet_category", "Category"));
        header.add(this.rb.getString("wksheet_meeting_start_time", "Event Start Time"));
        header.add(this.rb.getString("wksheet_meeting_duration", "Event Duration (min)"));
        return header;
    }

    public List<List<String>> getDataRows() {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (SignupMeetingWrapper wrp : this.wrappers) {
            List tsItems = wrp.getMeeting().getSignupTimeSlots();
            if (tsItems == null) continue;
            for (SignupTimeslot tsItem : tsItems) {
                List attendees = tsItem == null ? null : this.getValidAttendees(tsItem.getAttendees());
                if (attendees == null) continue;
                for (SignupAttendee att : attendees) {
                    ArrayList<String> attendance = new ArrayList<String>();
                    User attendee = this.sakaiFacade.getUser(att.getAttendeeUserId());
                    attendance.add(wrp.getMeeting().getTitle());
                    attendance.add(attendee == null ? "--" : attendee.getDisplayName());
                    attendance.add(attendee == null ? "--" : attendee.getEid());
                    attendance.add(attendee == null ? "--" : attendee.getEmail());
                    attendance.add(this.getSiteTitle(att.getSignupSiteId()));
                    attendance.add(this.sakaiFacade.getTimeService().newTime(tsItem.getStartTime().getTime()).toStringLocalFull());
                    attendance.add(String.valueOf(this.getDurationLength(tsItem.getEndTime(), tsItem.getStartTime())));
                    attendance.add(String.valueOf(this.getValidAttendees(tsItem.getAttendees()).size()));
                    attendance.add(att.getComments());
                    attendance.add(this.sakaiFacade.getUserDisplayName(wrp.getMeeting().getCreatorUserId()));
                    attendance.add(wrp.getMeeting().getLocation());
                    attendance.add(wrp.getMeeting().getCategory());
                    attendance.add(this.sakaiFacade.getTimeService().newTime(wrp.getMeeting().getStartTime().getTime()).toStringLocalFull());
                    attendance.add(String.valueOf(this.getDurationLength(wrp.getMeeting().getEndTime(), wrp.getMeeting().getStartTime())));
                    data.add(attendance);
                }
            }
        }
        return data;
    }

    private List<SignupAttendee> getValidAttendees(List<SignupAttendee> attendees) {
        ArrayList<SignupAttendee> cleanedList = new ArrayList<SignupAttendee>();
        for (SignupAttendee attendee : attendees) {
            if (!this.sakaiFacade.checkForUser(attendee.getAttendeeUserId())) continue;
            cleanedList.add(attendee);
        }
        return cleanedList;
    }

    private String getSiteTitle(String siteId) {
        Site site;
        try {
            site = this.sakaiFacade.getSiteService().getSite(siteId);
        }
        catch (IdUnusedException e) {
            return "";
        }
        String title = site.getTitle();
        return title;
    }

    private double getDurationLength(Date endTime, Date startTime) {
        double duration = 0.0;
        duration = endTime.getTime() - startTime.getTime();
        return duration /= 60000.0;
    }
}

