/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.downloadEvents;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.downloadEvents.ExcelPlainTextFormat;
import org.sakaiproject.signup.tool.downloadEvents.WorksheetStyleClass;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.user.api.User;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventWorksheet
implements MeetingTypes,
SignupBeanConstants {
    private ResourceLoader rb = new ResourceLoader("messages");
    private String[] tabTitles_Organizor;
    private String[] tabTitles_Participant;
    private String[] tabTitles_shortVersion;
    private Workbook wb = null;
    private String[] currentTabTitles;
    private static int rowHigh = 15;
    private SimpleDateFormat dateFormat;
    Map<String, CellStyle> styles = null;
    CreationHelper createHelper = null;
    private SakaiFacade sakaiFacade;

    public EventWorksheet(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
        this.wb = new HSSFWorkbook();
        this.styles = WorksheetStyleClass.createStyles((Workbook)this.wb);
        this.dateFormat = new SimpleDateFormat("", this.rb.getLocale());
        this.dateFormat.setTimeZone(sakaiFacade.getTimeService().getLocalTimeZone());
        this.initTableThRow();
        this.createHelper = this.wb.getCreationHelper();
    }

    public Workbook getEventWorkbook(List<SignupMeetingWrapper> meetingWrappers, String downloadType) {
        if (meetingWrappers != null) {
            if ("full".equals(downloadType)) {
                if (meetingWrappers.size() > 1) {
                    this.createShortVersonWorksheet(meetingWrappers);
                }
                int serialNum = 1;
                boolean hasSerialNum = meetingWrappers.size() > 1;
                for (SignupMeetingWrapper smWrapper : meetingWrappers) {
                    if (!smWrapper.isToDownload()) continue;
                    this.createWorksheet(smWrapper, serialNum, hasSerialNum);
                    ++serialNum;
                }
            } else if ("full_data".equals(downloadType)) {
                boolean hasSerialNum;
                ArrayList<SignupMeetingWrapper> dataWrappers = new ArrayList<SignupMeetingWrapper>();
                for (SignupMeetingWrapper smWrapper : meetingWrappers) {
                    if (!smWrapper.isToDownload()) continue;
                    dataWrappers.add(smWrapper);
                }
                int serialNum = 1;
                boolean bl = hasSerialNum = meetingWrappers.size() > 1;
                if (dataWrappers.size() > 1) {
                    this.createAttendeeDataWorksheet(dataWrappers);
                    this.createShortVersonWorksheet(meetingWrappers);
                    for (SignupMeetingWrapper smWrapper : dataWrappers) {
                        this.createWorksheet(smWrapper, serialNum, hasSerialNum);
                        ++serialNum;
                    }
                    if (this.isAttendanceOn(dataWrappers)) {
                        this.createAttendanceDataWorksheet(dataWrappers);
                    }
                } else {
                    for (SignupMeetingWrapper smWrapper : dataWrappers) {
                        this.createWorksheet(smWrapper, serialNum, false);
                    }
                    this.createAttendeeDataWorksheet(dataWrappers);
                    if (this.isAttendanceOn(dataWrappers)) {
                        this.createAttendanceDataWorksheet(dataWrappers);
                    }
                }
            }
        }
        return this.wb;
    }

    private Workbook createAttendeeDataWorksheet(List<SignupMeetingWrapper> wrappers) {
        String eventTitle = this.rb.getString("sheet_name_Attendee_schedules", "Attendees' Schedules");
        Sheet sheet = this.wb.createSheet(eventTitle);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        sheet.setFitToPage(true);
        sheet.setHorizontallyCenter(true);
        int numberOfColumn = 13;
        sheet.setColumnWidth(0, 6400);
        sheet.setColumnWidth(1, 5120);
        sheet.setColumnWidth(2, 5120);
        sheet.setColumnWidth(3, 6400);
        sheet.setColumnWidth(4, 6400);
        sheet.setColumnWidth(5, 5120);
        sheet.setColumnWidth(6, 4096);
        sheet.setColumnWidth(7, 5632);
        sheet.setColumnWidth(8, 6400);
        sheet.setColumnWidth(9, 5120);
        sheet.setColumnWidth(10, 5120);
        sheet.setColumnWidth(11, 5120);
        sheet.setColumnWidth(12, 5120);
        sheet.setColumnWidth(13, 5120);
        if (wrappers == null) {
            return this.wb;
        }
        int rowNum = 0;
        Cell cell = null;
        Row titleRow = sheet.createRow(rowNum++);
        titleRow.setHeightInPoints((float)rowHigh);
        for (int i = 0; i <= numberOfColumn; ++i) {
            titleRow.createCell(i).setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        }
        int cellNum = 0;
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_meeting_name", "Event Name"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_user_name", "Attendee Name"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_user_id", "Attendee User Id"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_user_email", "Email"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_site_name", "Site Title"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_appointment_start_time", "Appointment Time"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_appointment_duration", "Duration (min)"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_num_of_attendees", "#Num Attendees in Slot"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_user_comment", "User Comment"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_organizer", "Organizer"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_location", "Location"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_category", "Category"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_meeting_start_time", "Event Start Time"));
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_meeting_duration", "Event Duration (min)"));
        for (SignupMeetingWrapper wrp : wrappers) {
            List tsItems = wrp.getMeeting().getSignupTimeSlots();
            if (tsItems == null) continue;
            for (SignupTimeslot tsItem : tsItems) {
                List attendees = tsItem == null ? null : this.getValidAttendees(tsItem.getAttendees());
                if (attendees == null) continue;
                for (SignupAttendee s : attendees) {
                    s.setDisplayName(this.sakaiFacade.getUserDisplayLastFirstName(s.getAttendeeUserId()));
                }
                Collections.sort(attendees);
                for (SignupAttendee att : attendees) {
                    Row row = sheet.createRow(rowNum++);
                    for (int i = 0; i <= numberOfColumn; ++i) {
                        row.createCell(i).setCellStyle((CellStyle)this.styles.get("item_left"));
                    }
                    User attendee = this.sakaiFacade.getUser(att.getAttendeeUserId());
                    cellNum = 0;
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(wrp.getMeeting().getTitle());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(attendee == null ? "--" : att.getDisplayName());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(attendee == null ? "--" : attendee.getDisplayId());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(attendee == null ? "--" : attendee.getEmail());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.getSiteTitle(att.getSignupSiteId()));
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.sakaiFacade.getTimeService().newTime(tsItem.getStartTime().getTime()).toStringLocalFull());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.getDurationLength(tsItem.getEndTime(), tsItem.getStartTime()));
                    cell = row.getCell(cellNum++);
                    cell.setCellValue((double)this.getValidAttendees(tsItem.getAttendees()).size());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(att.getComments());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.sakaiFacade.getUserDisplayName(wrp.getMeeting().getCreatorUserId()));
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(wrp.getMeeting().getLocation());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(wrp.getMeeting().getCategory());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.sakaiFacade.getTimeService().newTime(wrp.getMeeting().getStartTime().getTime()).toStringLocalFull());
                    cell = row.getCell(cellNum++);
                    cell.setCellValue(this.getDurationLength(wrp.getMeeting().getEndTime(), wrp.getMeeting().getStartTime()));
                }
            }
        }
        return this.wb;
    }

    private Workbook createShortVersonWorksheet(List<SignupMeetingWrapper> wrappers) {
        String eventTitle = this.rb.getString("event_overview", "Events Overview");
        Sheet sheet = this.wb.createSheet(eventTitle);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        sheet.setFitToPage(true);
        sheet.setHorizontallyCenter(true);
        sheet.setColumnWidth(0, 5120);
        sheet.setColumnWidth(1, 3840);
        sheet.setColumnWidth(2, 4096);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 6400);
        sheet.setColumnWidth(5, 4864);
        Row titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(35.0f);
        for (int i = 0; i <= 6; ++i) {
            titleRow.createCell(i).setCellStyle((CellStyle)this.styles.get("title"));
        }
        Cell titleCell = titleRow.getCell(0);
        titleCell.setCellValue(eventTitle);
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$A$1:$F$1"));
        Row row = sheet.createRow(2);
        row.setHeightInPoints((float)rowHigh);
        Cell cell = row.createCell(0);
        cell.setCellValue(this.rb.getString("event_viewer", "Viewer:"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(1);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getCurrentUserName());
        row = sheet.createRow(3);
        row.setHeightInPoints((float)rowHigh);
        cell = row.createCell(0);
        cell.setCellValue(this.rb.getString("event_site_title", "Site Title:"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(1);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getCurrentSiteTitle());
        row = sheet.createRow(5);
        row.setHeightInPoints((float)rowHigh);
        for (int i = 0; i <= 6; ++i) {
            row.createCell(i).setCellStyle((CellStyle)this.styles.get("tabColNames"));
        }
        cell = row.getCell(0);
        cell.setCellValue(this.tabTitles_shortVersion[0]);
        cell = row.getCell(1);
        cell.setCellValue(this.tabTitles_shortVersion[1]);
        cell = row.getCell(2);
        cell.setCellValue(this.tabTitles_shortVersion[2]);
        cell = row.getCell(3);
        cell.setCellValue(this.tabTitles_shortVersion[3]);
        cell = row.getCell(4);
        cell.setCellValue(this.tabTitles_shortVersion[4]);
        cell = row.getCell(5);
        cell.setCellValue(this.tabTitles_shortVersion[5]);
        cell = row.getCell(6);
        cell.setCellValue(this.tabTitles_shortVersion[6]);
        int rowNum = 6;
        int seqNum = 1;
        for (SignupMeetingWrapper wrp : wrappers) {
            if (!wrp.isToDownload()) continue;
            row = sheet.createRow(rowNum);
            boolean rowHighNum = true;
            ++rowNum;
            for (int i = 0; i <= 6; ++i) {
                row.createCell(i).setCellStyle((CellStyle)this.styles.get("tabItem_fields"));
            }
            cell = row.getCell(0);
            cell.setCellStyle((CellStyle)this.styles.get("item_left_wrap"));
            cell.setCellValue(wrp.getMeeting().getTitle());
            Hyperlink sheetLink = this.createHelper.createHyperlink(2);
            String validSheetName = EventWorksheet.CreateValidWorksheetName((String)wrp.getMeeting().getTitle(), (int)seqNum, (boolean)true);
            String hlinkAddr = "'" + validSheetName + "'" + "!A1";
            sheetLink.setAddress(hlinkAddr);
            cell.setHyperlink(sheetLink);
            cell.setCellStyle((CellStyle)this.styles.get("hyperLink"));
            ++seqNum;
            cell = row.getCell(1);
            cell.setCellValue(wrp.getCreator());
            cell = row.getCell(2);
            cell.setCellValue(wrp.getMeeting().getLocation());
            cell = row.getCell(3);
            cell.setCellValue(wrp.getMeeting().getCategory());
            cell = row.getCell(4);
            cell.setCellValue(this.getShortWeekDayName(wrp.getStartTime()) + ", " + this.getTime(wrp.getStartTime()).toStringLocalShortDate());
            cell = row.getCell(5);
            cell.setCellValue(this.getMeetingPeriodShortVersion(wrp));
            cell = row.getCell(6);
            cell.setCellValue(ExcelPlainTextFormat.convertFormattedHtmlTextToExcelPlaintext((String)wrp.getAvailableStatus()));
        }
        row = sheet.createRow(rowNum);
        for (int i = 0; i <= 6; ++i) {
            row.createCell(i).setCellStyle((CellStyle)this.styles.get("tab_endline"));
        }
        return this.wb;
    }

    private void createWorksheet(SignupMeetingWrapper wrapper, int serialNum, boolean hasSerialNum) {
        int i;
        String validSheetName = EventWorksheet.CreateValidWorksheetName((String)wrapper.getMeeting().getTitle(), (int)serialNum, (boolean)hasSerialNum);
        Sheet sheet = this.wb.createSheet(validSheetName);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        sheet.setFitToPage(true);
        sheet.setHorizontallyCenter(true);
        sheet.setColumnWidth(0, 768);
        sheet.setColumnWidth(1, 768);
        sheet.setColumnWidth(2, 4352);
        sheet.setColumnWidth(3, 3840);
        sheet.setColumnWidth(4, 5632);
        sheet.setColumnWidth(5, 5632);
        sheet.setColumnWidth(6, 5632);
        Row titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(35.0f);
        for (int i2 = 1; i2 <= 7; ++i2) {
            titleRow.createCell(i2).setCellStyle((CellStyle)this.styles.get("title"));
        }
        Cell titleCell = titleRow.getCell(2);
        titleCell.setCellValue(wrapper.getMeeting().getTitle());
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$C$1:$H$1"));
        Row timezoneRow = sheet.createRow(1);
        timezoneRow.setHeightInPoints(16.0f);
        for (int i3 = 1; i3 <= 7; ++i3) {
            timezoneRow.createCell(i3).setCellStyle((CellStyle)this.styles.get("tabItem_fields"));
        }
        Cell timezoneCell = timezoneRow.getCell(2);
        timezoneCell.setCellValue("(" + this.rb.getString("event_timezone") + " " + this.sakaiFacade.getTimeService().getLocalTimeZone().getID() + ")");
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$C$2:$H$2"));
        Row row = sheet.createRow(2);
        row.setHeightInPoints((float)rowHigh);
        Cell cell = row.createCell(2);
        cell.setCellValue(this.rb.getString("event_owner"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(wrapper.getCreator());
        row = sheet.createRow(3);
        row.setHeightInPoints((float)rowHigh);
        cell = row.createCell(2);
        cell.setCellValue(this.rb.getString("event_date"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getTime(wrapper.getStartTime()).toStringLocalDate());
        row = sheet.createRow(4);
        row.setHeightInPoints((float)rowHigh);
        cell = row.createCell(2);
        cell.setCellValue(this.rb.getString("event_time_period"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getMeetingPeriod(wrapper.getMeeting()));
        row = sheet.createRow(5);
        row.setHeightInPoints((float)rowHigh);
        cell = row.createCell(2);
        cell.setCellValue(this.rb.getString("event_signup_start"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getTime(wrapper.getMeeting().getSignupBegins()).toStringLocalDate() + ", " + this.getTime(wrapper.getMeeting().getSignupBegins()).toStringLocalTime());
        row = sheet.createRow(6);
        row.setHeightInPoints((float)rowHigh);
        cell = row.createCell(2);
        cell.setCellValue(this.rb.getString("event_signup_deadline"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.createCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left"));
        cell.setCellValue(this.getTime(wrapper.getMeeting().getSignupDeadline()).toStringLocalDate() + ", " + this.getTime(wrapper.getMeeting().getSignupDeadline()).toStringLocalTime());
        row = sheet.createRow(7);
        for (int i4 = 1; i4 <= 5; ++i4) {
            row.createCell(i4);
        }
        cell = row.getCell(2);
        cell.setCellValue(this.rb.getString("event_publish_to"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.getCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left_wrap"));
        String availSitesGroups = this.getAvailableSitesGroups(wrapper.getMeeting());
        cell.setCellValue(availSitesGroups);
        int rownum = this.getNumRows(availSitesGroups);
        row.setHeightInPoints((float)(rowHigh * rownum));
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$D$8:$F$8"));
        row = sheet.createRow(8);
        for (int i5 = 1; i5 <= 7; ++i5) {
            row.createCell(i5);
        }
        cell = row.getCell(2);
        cell.setCellValue(this.rb.getString("event_description"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        cell = row.getCell(3);
        cell.setCellStyle((CellStyle)this.styles.get("item_left_wrap_top"));
        String description = wrapper.getMeeting().getDescription();
        if (description != null && description.length() > 0) {
            description = ExcelPlainTextFormat.convertFormattedHtmlTextToExcelPlaintext((String)description);
            row.setHeightInPoints((float)(rowHigh * this.getDescRowNum(description)));
        }
        cell.setCellValue(description);
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$D$9:$H$9"));
        int cur_rowNum = 9;
        row = sheet.createRow(cur_rowNum);
        for (int i6 = 1; i6 <= 5; ++i6) {
            row.createCell(i6);
        }
        row.setHeightInPoints((float)rowHigh);
        cell = row.getCell(2);
        cell.setCellValue(this.rb.getString("attachments"));
        cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        List attachs = wrapper.getEventMainAttachments();
        if (attachs != null && !attachs.isEmpty()) {
            for (i = 0; i < attachs.size(); ++i) {
                SignupAttachment attach = (SignupAttachment)attachs.get(i);
                if (i > 0) {
                    row = sheet.createRow(++cur_rowNum);
                    row.setHeightInPoints((float)rowHigh);
                    for (int j = 1; j <= 5; ++j) {
                        row.createCell(j);
                    }
                }
                cell = row.getCell(3);
                cell.setCellStyle((CellStyle)this.styles.get("hyperLink"));
                cell.setCellValue(attach.getFilename());
                cell.setHyperlink((Hyperlink)this.setAttachmentURLLinks(attach));
            }
        } else {
            cell = row.getCell(3);
            cell.setCellStyle((CellStyle)this.styles.get("item_left_wrap"));
            cell.setCellValue(this.rb.getString("event_no_attachment"));
        }
        if ("announcement".equals(wrapper.getMeeting().getMeetingType())) {
            row = sheet.createRow(cur_rowNum + 3);
            row.setHeightInPoints((float)rowHigh);
            cell = row.createCell(3);
            cell.setCellValue(this.rb.getString("event_is_open_session", "This is an open session meeting. No sign-up is necessary."));
            cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
            return;
        }
        row = sheet.createRow(cur_rowNum += 2);
        row.setHeightInPoints((float)rowHigh);
        for (i = 2; i <= 7; ++i) {
            row.createCell(i).setCellStyle((CellStyle)this.styles.get("tabColNames"));
        }
        cell = row.getCell(2);
        this.currentTabTitles = this.isOrganizer(wrapper.getMeeting()) ? this.tabTitles_Organizor : this.tabTitles_Participant;
        cell.setCellValue(this.currentTabTitles[0]);
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)("$C$" + (cur_rowNum + 1) + ":$D$" + (cur_rowNum + 1))));
        cell = row.getCell(4);
        cell.setCellValue(this.currentTabTitles[1]);
        cell = row.getCell(5);
        cell.setCellValue(this.currentTabTitles[2]);
        cell = row.getCell(6);
        cell.setCellValue(this.currentTabTitles[3]);
        cell = row.getCell(7);
        cell.setCellValue(this.currentTabTitles[4]);
        int rowNum = cur_rowNum + 1;
        List tsItems = wrapper.getMeeting().getSignupTimeSlots();
        if (tsItems != null) {
            for (SignupTimeslot tsItem : tsItems) {
                if (tsItem == null) continue;
                row = sheet.createRow(rowNum);
                int rowHighNum = 1;
                ++rowNum;
                for (int i7 = 1; i7 <= 7; ++i7) {
                    row.createCell(i7).setCellStyle((CellStyle)this.styles.get("tabItem_fields"));
                }
                cell = row.getCell(2);
                cell.setCellValue(this.getTimeSlotPeriod(tsItem, wrapper.getMeeting().isMeetingCrossDays()));
                sheet.addMergedRegion(CellRangeAddress.valueOf((String)("$C$" + rowNum + ":$D$" + rowNum)));
                cell = row.getCell(4);
                if (tsItem.isUnlimitedAttendee()) {
                    cell.setCellValue(this.rb.getString("event_unlimited"));
                } else if (this.isOrganizer(wrapper.getMeeting())) {
                    cell.setCellValue((double)tsItem.getMaxNoOfAttendees());
                } else {
                    int availableSpots = this.getValidAttendees(tsItem.getAttendees()) != null ? tsItem.getMaxNoOfAttendees() - this.getValidAttendees(tsItem.getAttendees()).size() : tsItem.getMaxNoOfAttendees();
                    availableSpots = availableSpots < 1 ? 0 : availableSpots;
                    String value = String.valueOf(availableSpots);
                    if (tsItem.isLocked()) {
                        value = this.rb.getString("event_is_locked");
                    } else if (tsItem.isCanceled()) {
                        value = this.rb.getString("event_is_canceled");
                    }
                    cell.setCellValue(value);
                }
                List attendees = this.getValidAttendees(tsItem.getAttendees());
                cell = row.getCell(5);
                String aNames = this.rb.getString("event_show_no_attendee_info");
                if (this.isDisplayNames(wrapper.getMeeting())) {
                    if (attendees != null && attendees.size() > rowHighNum) {
                        rowHighNum = attendees.size();
                    }
                    aNames = this.getNames(attendees, true);
                }
                if (tsItem.isCanceled() && this.isOrganizer(wrapper.getMeeting())) {
                    aNames = this.rb.getString("event_is_canceled");
                }
                cell.setCellValue(aNames);
                cell.setCellStyle((CellStyle)this.styles.get("attendee_layout"));
                cell = row.getCell(6);
                String aIds = this.rb.getString("event_show_no_attendee_info");
                if (this.isDisplayNames(wrapper.getMeeting())) {
                    if (attendees != null && attendees.size() > rowHighNum) {
                        rowHighNum = attendees.size();
                    }
                    aIds = this.getIds(attendees);
                }
                if (tsItem.isCanceled() && this.isOrganizer(wrapper.getMeeting())) {
                    aIds = this.rb.getString("event_is_canceled");
                }
                cell.setCellValue(aIds);
                cell.setCellStyle((CellStyle)this.styles.get("attendee_layout"));
                cell = row.getCell(7);
                String fieldValue = "";
                if (this.isOrganizer(wrapper.getMeeting())) {
                    List waiters = tsItem.getWaitingList();
                    if (waiters != null && waiters.size() > rowHighNum) {
                        rowHighNum = waiters.size();
                    }
                    fieldValue = this.getNames(waiters, false);
                } else {
                    fieldValue = this.getYourStatus(tsItem);
                }
                cell.setCellValue(fieldValue);
                cell.setCellStyle((CellStyle)this.styles.get("attendee_layout"));
                row.setHeightInPoints((float)(rowHigh * rowHighNum));
            }
        }
        row = sheet.createRow(rowNum);
        for (int i8 = 2; i8 <= 7; ++i8) {
            row.createCell(i8).setCellStyle((CellStyle)this.styles.get("tab_endline"));
        }
        Row commentsRow = sheet.createRow(rowNum += 2);
        commentsRow.setHeightInPoints(25.0f);
        for (int i9 = 1; i9 <= 7; ++i9) {
            commentsRow.createCell(i9).setCellStyle((CellStyle)this.styles.get("commentTitle"));
        }
        Cell commentsCell = commentsRow.getCell(2);
        commentsCell.setCellValue(this.rb.getString("event_comments_title", "Participant's Comments"));
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)("$C$" + (rowNum + 1) + ":$H$" + (rowNum + 1))));
        row = sheet.createRow(++rowNum);
        for (int i10 = 2; i10 <= 4; ++i10) {
            row.createCell(i10).setCellStyle((CellStyle)this.styles.get("tab_endline"));
        }
        ++rowNum;
        boolean hasComment = false;
        if (tsItems != null) {
            for (SignupTimeslot ts : tsItems) {
                List attendees = ts != null ? this.getValidAttendees(ts.getAttendees()) : null;
                if (attendees == null) continue;
                for (SignupAttendee att : attendees) {
                    String comment;
                    if (!this.isOrganizer(wrapper.getMeeting()) && !this.isViewerSelf(att) || (comment = att.getComments()) == null || comment.trim().length() <= 0) continue;
                    row = sheet.createRow(rowNum++);
                    for (int i11 = 1; i11 <= 7; ++i11) {
                        row.createCell(i11);
                    }
                    cell = row.getCell(2);
                    cell.setCellValue(this.sakaiFacade.getUserDisplayName(att.getAttendeeUserId()) + ":");
                    cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
                    cell = row.getCell(3);
                    cell.setCellStyle((CellStyle)this.styles.get("item_left_wrap_top"));
                    comment = ExcelPlainTextFormat.convertFormattedHtmlTextToExcelPlaintext((String)comment);
                    row.setHeightInPoints((float)(rowHigh * this.getDescRowNum(comment)));
                    cell.setCellValue(comment);
                    sheet.addMergedRegion(CellRangeAddress.valueOf((String)("$D$" + rowNum + ":$H$" + rowNum)));
                    ++rowNum;
                    hasComment = true;
                }
            }
        }
        if (!hasComment) {
            row = sheet.createRow(rowNum);
            row.createCell(2);
            cell = row.getCell(2);
            cell.setCellValue(this.rb.getString("event_no_comments", "There is no comments written by participants."));
            cell.setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        }
    }

    private Time getTime(Date date) {
        Time time = this.sakaiFacade.getTimeService().newTime(date.getTime());
        return time;
    }

    private String getTimeSlotPeriod(SignupTimeslot ts, boolean isCrossDay) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTime(ts.getStartTime()).toStringLocalTime());
        if (isCrossDay) {
            sb.append(", " + this.getShortWeekDayName(ts.getStartTime()));
        }
        sb.append("  -  ");
        sb.append(this.getTime(ts.getEndTime()).toStringLocalTime());
        if (isCrossDay) {
            sb.append(", " + this.getShortWeekDayName(ts.getEndTime()));
            sb.append(", " + this.getTime(ts.getEndTime()).toStringLocalShortDate());
        }
        return sb.toString();
    }

    private String getMeetingPeriod(SignupMeeting sm) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTime(sm.getStartTime()).toStringLocalTime());
        if (sm.isMeetingCrossDays()) {
            sb.append(", " + this.getShortWeekDayName(sm.getStartTime()));
        }
        sb.append("  -  ");
        sb.append(this.getTime(sm.getEndTime()).toStringLocalTime());
        if (sm.isMeetingCrossDays()) {
            sb.append(", " + this.getShortWeekDayName(sm.getEndTime()) + ", ");
            sb.append(this.getTime(sm.getEndTime()).toStringLocalDate());
        }
        return sb.toString();
    }

    private String getMeetingPeriodShortVersion(SignupMeetingWrapper wrp) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTime(wrp.getStartTime()).toStringLocalTime());
        if (wrp.getMeeting().isMeetingCrossDays()) {
            sb.append(", " + this.getShortWeekDayName(wrp.getStartTime()));
        }
        sb.append("  -  ");
        sb.append(this.getTime(wrp.getEndTime()).toStringLocalTime());
        if (wrp.getMeeting().isMeetingCrossDays()) {
            sb.append(", " + this.getShortWeekDayName(wrp.getEndTime()) + ", ");
            sb.append(this.getTime(wrp.getEndTime()).toStringLocalDate());
        }
        return sb.toString();
    }

    private String getNames(List<SignupAttendee> attendees) {
        if (attendees == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (SignupAttendee att : attendees) {
            sb.append(this.sakaiFacade.getUserDisplayName(att.getAttendeeUserId()));
            sb.append("\n");
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : "";
    }

    private String getNames(List<SignupAttendee> attendees, boolean needSorting) {
        if (attendees == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (SignupAttendee s : attendees) {
            s.setDisplayName(this.sakaiFacade.getUserDisplayLastFirstName(s.getAttendeeUserId()));
        }
        if (needSorting) {
            Collections.sort(attendees);
        }
        for (SignupAttendee att : attendees) {
            sb.append(att.getDisplayName());
            sb.append("\n");
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : "";
    }

    private String getIds(List<SignupAttendee> attendees) {
        if (attendees == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (SignupAttendee att : attendees) {
            sb.append(this.sakaiFacade.getUser(att.getAttendeeUserId()).getDisplayId());
            sb.append("\n");
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : "";
    }

    private String getAvailableSitesGroups(SignupMeeting sm) {
        StringBuffer sb = new StringBuffer();
        List sites = sm.getSignupSites();
        for (SignupSite site : sites) {
            sb.append(site.getTitle());
            if (site.isSiteScope()) {
                sb.append(" " + this.rb.getString("event_site_level"));
                sb.append("\n");
                continue;
            }
            sb.append(" " + this.rb.getString("event_group_level"));
            sb.append("\n");
            List groups = site.getSignupGroups();
            if (groups == null) continue;
            for (SignupGroup grp : groups) {
                sb.append("   - " + grp.getTitle());
                sb.append("\n");
            }
        }
        return sb.length() > 1 ? sb.substring(0, sb.length() - 1) : "";
    }

    private int getNumRows(String s) {
        int num = 1;
        int pos = -1;
        if (s != null) {
            while (pos < s.length() && (pos = s.indexOf("\n", pos + 1)) > 0) {
                ++num;
            }
        }
        return num;
    }

    private int getDescRowNum(String description) {
        int newLineNum;
        if (description == null) {
            return 1;
        }
        int size = description.length();
        int descRows = size / 100;
        if (descRows < 1) {
            descRows = 1;
        }
        if ((newLineNum = this.getNumRows(description)) > descRows) {
            descRows = newLineNum;
        }
        return descRows;
    }

    private boolean isOrganizer(SignupMeeting sm) {
        return sm.getPermission().isUpdate() || sm.getPermission().isDelete();
    }

    private boolean isViewerSelf(SignupAttendee att) {
        return this.sakaiFacade.getCurrentUserId().equals(att.getAttendeeUserId());
    }

    private boolean isDisplayNames(SignupMeeting sm) {
        boolean display = false;
        if (sm.getPermission().isUpdate() || sm.getPermission().isDelete()) {
            display = true;
        } else if (sm.getSignupTimeSlots() != null && ((SignupTimeslot)sm.getSignupTimeSlots().get(0)).isDisplayAttendees()) {
            display = true;
        }
        return display;
    }

    private double getDurationLength(Date endTime, Date startTime) {
        double duration = 0.0;
        duration = endTime.getTime() - startTime.getTime();
        return duration /= 60000.0;
    }

    private String getYourStatus(SignupTimeslot ts) {
        List waiters;
        List atts = ts.getAttendees();
        if (atts != null) {
            for (SignupAttendee a : atts) {
                if (!a.getAttendeeUserId().equals(this.sakaiFacade.getCurrentUserId())) continue;
                return this.rb.getString("event_you_signed_up");
            }
        }
        if ((waiters = ts.getWaitingList()) != null) {
            for (SignupAttendee w : waiters) {
                if (!w.getAttendeeUserId().equals(this.sakaiFacade.getCurrentUserId())) continue;
                return this.rb.getString("event_you_on_wait_list", "on waiting list");
            }
        }
        return "";
    }

    private String getShortWeekDayName(Date date) {
        this.dateFormat.applyLocalizedPattern("EEE");
        return this.dateFormat.format(date);
    }

    private String getCurrentUserName() {
        return this.sakaiFacade.getUserDisplayName(this.sakaiFacade.getCurrentUserId());
    }

    private String getCurrentSiteTitle() {
        String siteId = this.sakaiFacade.getCurrentLocationId();
        return this.getSiteTitle(siteId);
    }

    private String getSiteTitle(String siteId) {
        Site site;
        try {
            site = this.sakaiFacade.getSiteService().getSite(siteId);
        }
        catch (IdUnusedException e) {
            return "";
        }
        String title = site.getTitle();
        return title;
    }

    private HSSFHyperlink setAttachmentURLLinks(SignupAttachment attach) {
        HSSFHyperlink hsHyperlink = new HSSFHyperlink(1);
        String link = this.sakaiFacade.getServerConfigurationService().getServerUrl() + attach.getLocation();
        hsHyperlink.setAddress(link);
        hsHyperlink.setLabel(attach.getFilename());
        return hsHyperlink;
    }

    private void initTableThRow() {
        this.tabTitles_Organizor = new String[5];
        this.tabTitles_Organizor[0] = this.rb.getString("tab_time_slot", "Time Slot");
        this.tabTitles_Organizor[1] = this.rb.getString("tab_max_attendee", "Max # of Participants");
        this.tabTitles_Organizor[2] = this.rb.getString("tab_attendees", "Participants");
        this.tabTitles_Organizor[3] = this.rb.getString("tab_attendees_eids", "Participants User IDs");
        this.tabTitles_Organizor[4] = this.rb.getString("tab_waiting_list", "Wait List");
        this.tabTitles_Participant = new String[5];
        this.tabTitles_Participant[0] = this.rb.getString("tab_time_slot", "Time Slot");
        this.tabTitles_Participant[1] = this.rb.getString("tab_event_available_slots", "Available Slots");
        this.tabTitles_Participant[2] = this.rb.getString("tab_attendees", "Participants");
        this.tabTitles_Participant[3] = this.rb.getString("tab_attendees_eids", "Participants User IDs");
        this.tabTitles_Participant[4] = this.rb.getString("tab_event_your_status", "Your Status");
        this.tabTitles_shortVersion = new String[7];
        this.tabTitles_shortVersion[0] = this.rb.getString("tab_event_name", "Meeting Title");
        this.tabTitles_shortVersion[1] = this.rb.getString("tab_event_owner", "Organizer");
        this.tabTitles_shortVersion[2] = this.rb.getString("tab_event_location", "Location");
        this.tabTitles_shortVersion[3] = this.rb.getString("tab_event_category", "Category");
        this.tabTitles_shortVersion[4] = this.rb.getString("tab_event_date", "Date");
        this.tabTitles_shortVersion[5] = this.rb.getString("tab_event_time", "Time");
        this.tabTitles_shortVersion[6] = this.rb.getString("tab_event_availability", "Status");
    }

    private static String CreateValidWorksheetName(String name, int serialNum, boolean hasSerialNum) {
        if (name == null || name.trim().length() < 1) {
            name = "sheet";
        }
        String suffix = "";
        if (hasSerialNum) {
            suffix = " (" + serialNum + ")";
        }
        StringBuilder escapedString = new StringBuilder();
        name = name.trim();
        for (int i = 0; i < name.length(); ++i) {
            char escapedStringCur_char = name.charAt(i);
            if (i == 0 && escapedStringCur_char == '\'') continue;
            if (escapedStringCur_char == ':' || escapedStringCur_char == '\\' || escapedStringCur_char == '/' || escapedStringCur_char == '?' || escapedStringCur_char == '*' || escapedStringCur_char == '[' || escapedStringCur_char == ']') {
                escapedString.append('_');
                continue;
            }
            escapedString.append(escapedStringCur_char);
        }
        String validSheetName = escapedString.toString().length() <= 31 - suffix.length() ? escapedString.toString() : escapedString.substring(0, 31 - suffix.length());
        validSheetName = validSheetName + suffix;
        return validSheetName;
    }

    private Workbook createAttendanceDataWorksheet(List<SignupMeetingWrapper> wrappers) {
        String eventTitle = this.rb.getString("sheet_name_Attendance_data", "Attendance");
        Sheet sheet = this.wb.createSheet(eventTitle);
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        sheet.setFitToPage(true);
        sheet.setHorizontallyCenter(true);
        HashMap<String, List<Integer>> m = new HashMap<String, List<Integer>>();
        if (wrappers == null) {
            return this.wb;
        }
        int numberOfColumn = wrappers.size() + 1;
        sheet.setColumnWidth(0, 6400);
        int rowNum = 0;
        Object cell = null;
        Row titleRow = sheet.createRow(rowNum++);
        titleRow.setHeightInPoints((float)rowHigh);
        for (int i = 0; i <= numberOfColumn; ++i) {
            titleRow.createCell(i).setCellStyle((CellStyle)this.styles.get("item_leftBold"));
        }
        int cellNum = 0;
        titleRow.getCell(cellNum++).setCellValue(this.rb.getString("wksheet_attendance_UserID", "UserID"));
        int index = -1;
        for (SignupMeetingWrapper wrp : wrappers) {
            if (!wrp.getMeeting().isAllowAttendance()) continue;
            ++index;
            titleRow.getCell(cellNum++).setCellValue(wrp.getMeeting().getTitle());
            List tsItems = wrp.getMeeting().getSignupTimeSlots();
            if (tsItems == null) continue;
            for (SignupTimeslot tsItem : tsItems) {
                List waitingList;
                List attendees;
                List list = attendees = tsItem == null ? null : this.getValidAttendees(tsItem.getAttendees());
                if (attendees != null) {
                    for (SignupAttendee att : attendees) {
                        User attendee;
                        String attendeeEID;
                        Integer attended = 0;
                        if (att.isAttended()) {
                            attended = 1;
                        }
                        if (m.containsKey(attendeeEID = (attendee = this.sakaiFacade.getUser(att.getAttendeeUserId())).getEid())) {
                            List attendanceList = (List)m.get(attendeeEID);
                            if (attendanceList.get(index) != null) {
                                attendanceList.set(index, (Integer)attendanceList.get(index) + attended);
                                continue;
                            }
                            attendanceList.set(index, attended);
                            continue;
                        }
                        List<Integer> newList = Arrays.asList(new Integer[wrappers.size()]);
                        newList.set(index, attended);
                        m.put(attendeeEID, newList);
                    }
                }
                if ((waitingList = tsItem == null ? null : tsItem.getWaitingList()) == null) continue;
                Integer attended = 1;
                for (SignupAttendee wt : waitingList) {
                    if (!wt.isAttended()) continue;
                    User attendee = this.sakaiFacade.getUser(wt.getAttendeeUserId());
                    String attendeeEID = attendee.getEid();
                    if (m.containsKey(attendeeEID)) {
                        List attendanceList = (List)m.get(attendeeEID);
                        if (attendanceList.get(index) != null) {
                            attendanceList.set(index, (Integer)attendanceList.get(index) + attended);
                            continue;
                        }
                        attendanceList.set(index, attended);
                        continue;
                    }
                    List<Integer> newList = Arrays.asList(new Integer[wrappers.size()]);
                    newList.set(index, attended);
                    m.put(attendeeEID, newList);
                }
            }
        }
        for (Map.Entry pairs : m.entrySet()) {
            Row row = sheet.createRow(rowNum++);
            for (int i = 0; i <= numberOfColumn; ++i) {
                row.createCell(i).setCellStyle((CellStyle)this.styles.get("item_left"));
            }
            cellNum = 0;
            row.getCell(cellNum++).setCellValue((String)pairs.getKey());
            List attendanceList = (List)pairs.getValue();
            for (int i = 0; i < attendanceList.size(); ++i) {
                if (attendanceList.get(i) != null) {
                    row.getCell(cellNum++).setCellValue((double)((Integer)attendanceList.get(i)).intValue());
                    continue;
                }
                row.getCell(cellNum++).setCellValue("");
            }
        }
        return this.wb;
    }

    public boolean isAttendanceOn(List<SignupMeetingWrapper> wrappers) {
        if ("true".equalsIgnoreCase(this.sakaiFacade.getServerConfigurationService().getString("signup.enableAttendance", "false"))) {
            for (SignupMeetingWrapper wrp : wrappers) {
                if (!wrp.getMeeting().isAllowAttendance()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public List<SignupAttendee> getValidAttendees(List<SignupAttendee> attendees) {
        ArrayList<SignupAttendee> cleanedList = new ArrayList<SignupAttendee>();
        for (SignupAttendee attendee : attendees) {
            if (!this.sakaiFacade.checkForUser(attendee.getAttendeeUserId())) continue;
            cleanedList.add(attendee);
        }
        return cleanedList;
    }
}

