/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.restful.SignupEvent;
import org.sakaiproject.signup.restful.SignupTargetSiteEventInfo;
import org.sakaiproject.signup.tool.entityproviders.SignupObjectConverter;
import org.sakaiproject.signup.tool.entityproviders.SignupRESTfulSessionManager;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddWaiter;
import org.sakaiproject.signup.tool.jsf.organizer.action.CancelAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.RemoveWaiter;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.sakaiproject.tool.cover.ToolManager;

public class EventProcessHandler
implements SignupBeanConstants {
    public static final String VIEW_SIGNUP_EVENTS_RANGE = "viewNextDays";
    protected SakaiFacade sakaiFacade;
    protected SignupMeetingService signupMeetingService;
    protected SignupRESTfulSessionManager signupRESTfulSessionManager;
    protected Log logger = LogFactoryImpl.getLog(this.getClass());

    public SignupEvent getSignupEvent(Long eventId, String siteId, String userId, boolean mustAccessDB) {
        SignupEvent event = null;
        event = this.signupRESTfulSessionManager.getExistedSignupEventInCache(siteId, eventId);
        if (event == null || event.getSignupSiteItems() == null || mustAccessDB) {
            SignupTargetSiteEventInfo sdMeeting = this.getSignupMeetingService().loadSignupMeetingWithAutoSelectedSite(eventId, userId, siteId);
            String targetSiteId = sdMeeting.getTargetSiteId();
            event = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)sdMeeting.getSignupMeeting(), (String)userId, (String)targetSiteId, (boolean)true, (boolean)false, (SakaiFacade)this.sakaiFacade);
            if (targetSiteId != null) {
                this.signupRESTfulSessionManager.updateSignupEventsCache(targetSiteId, event);
            }
        }
        return event;
    }

    public List<SignupEvent> getMySignupEvents(String userId, String viewRange) {
        if ((viewRange = this.validateViewRange(viewRange)) == null) {
            viewRange = "30";
        }
        List events = null;
        if (this.signupRESTfulSessionManager.isUpTodateDataAvailable(userId) && this.signupRESTfulSessionManager.isSameViewRange(userId, viewRange)) {
            events = this.signupRESTfulSessionManager.getSignupEventsCache(userId).getEvents();
        } else {
            List siteIds = this.getSakaiFacade().getUserPublishedSiteIds(userId);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int currentHour = calendar.get(11);
            int currentMinutes = calendar.get(12);
            calendar.add(10, -1 * currentHour);
            calendar.add(12, -1 * currentMinutes);
            String searchDateStr = viewRange;
            Date startDate = calendar.getTime();
            int timeFrameInDays = Integer.parseInt(searchDateStr);
            List sMeetings = this.signupMeetingService.getSignupMeetingsInSitesWithCache(siteIds, startDate, timeFrameInDays);
            events = this.getMySignedUpEvents(sMeetings, userId);
            this.signupRESTfulSessionManager.StoreSignupEventsData(userId, events, viewRange);
        }
        return events;
    }

    public List<SignupEvent> getSignupEvents(String siteId, String userId, String viewRange) {
        if ((viewRange = this.validateViewRange(viewRange)) == null) {
            viewRange = "all";
        }
        ArrayList<SignupEvent> events = null;
        if (this.signupRESTfulSessionManager.isUpTodateDataAvailable(siteId) && this.signupRESTfulSessionManager.isSameViewRange(siteId, viewRange)) {
            events = this.signupRESTfulSessionManager.getSignupEventsCache(siteId).getEvents();
        } else {
            List sMeetings = null;
            if ("all".equals(viewRange)) {
                sMeetings = this.getSignupMeetingService().getAllSignupMeetings(siteId, userId);
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                int currentHour = calendar.get(11);
                int currentMinutes = calendar.get(12);
                calendar.add(10, -1 * currentHour);
                calendar.add(12, -1 * currentMinutes);
                String searchDateStr = viewRange;
                sMeetings = this.signupMeetingService.getSignupMeetings(siteId, userId, calendar.getTime(), Utilities.getUserDefinedDate((int)Integer.parseInt(searchDateStr)));
            }
            events = new ArrayList<SignupEvent>();
            if (sMeetings != null && !sMeetings.isEmpty()) {
                for (SignupMeeting sMeeting : sMeetings) {
                    events.add(SignupObjectConverter.convertToSignupEventObj((SignupMeeting)sMeeting, (String)userId, (String)siteId, (boolean)false, (boolean)false, (SakaiFacade)this.sakaiFacade));
                }
            }
            this.signupRESTfulSessionManager.StoreSignupEventsData(siteId, events, viewRange);
        }
        return events;
    }

    public void updateAttendStatus(SignupEvent event) {
        String userAction = event.getUserActionType();
        SignupEvent updatedEvent = null;
        if ("signup".equals(userAction)) {
            updatedEvent = this.userSignup(event);
        } else if ("cancelSignup".equals(userAction)) {
            updatedEvent = this.userCancelSignup(event);
        } else if ("addToWaitList".equals(userAction)) {
            updatedEvent = this.userAddToWaitList(event);
        } else if ("removeWaitList".equals(userAction)) {
            updatedEvent = this.userRemoveFromWaitList(event);
        } else {
            this.logger.warn((Object)("The userAction:" + userAction + " is not defined!"));
        }
        this.signupRESTfulSessionManager.updateSignupEventsCache(event.getSiteId(), updatedEvent);
        this.signupRESTfulSessionManager.updateMySignupEventsCache(this.getSakaiFacade().getCurrentUserId(), updatedEvent, userAction);
    }

    private SignupEvent userRemoveFromWaitList(SignupEvent event) {
        String userActionWarningMsg = null;
        SignupMeeting meeting = null;
        try {
            meeting = this.getSignupMeeting(event);
            RemoveWaiter removeWaiter = new RemoveWaiter(this.signupMeetingService, this.getSakaiFacade().getCurrentUserId(), event.getSiteId(), "toBbottomOfList", false);
            SignupAttendee newWaiter = new SignupAttendee(this.getSakaiFacade().getCurrentUserId(), event.getSiteId());
            SignupTimeslot timeSlot = this.getSignupTimeSlot(meeting, event.getAllocToTSid());
            meeting = removeWaiter.removeFromWaitingList(meeting, timeSlot, newWaiter);
            if (ToolManager.getCurrentPlacement() == null) {
                Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_WL_S, (String)(event.getSiteId() + " meetingId:" + meeting.getId() + " -removed from wlist on TS:" + SignupDateFormat.format_date_h_mm_a((Date)timeSlot.getStartTime())));
            }
        }
        catch (SignupUserActionException ue) {
            userActionWarningMsg = ue.getMessage();
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            userActionWarningMsg = Utilities.rb.getString("error.occurred_try_again");
        }
        SignupEvent evt = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)meeting, (String)this.getSakaiFacade().getCurrentUserId(), (String)event.getSiteId(), (boolean)true, (boolean)false, (SakaiFacade)this.sakaiFacade);
        evt.setUserActionWarningMsg(userActionWarningMsg);
        return evt;
    }

    private SignupEvent userAddToWaitList(SignupEvent event) {
        String userActionWarningMsg = null;
        SignupMeeting meeting = null;
        try {
            meeting = this.getSignupMeeting(event);
            if (meeting.isAllowWaitList()) {
                AddWaiter addWaiter = new AddWaiter(this.signupMeetingService, this.getSakaiFacade().getCurrentUserId(), event.getSiteId(), "toBbottomOfList", false);
                SignupAttendee newWaiter = new SignupAttendee(this.sakaiFacade.getCurrentUserId(), event.getSiteId());
                SignupTimeslot timeSlot = this.getSignupTimeSlot(meeting, event.getAllocToTSid());
                meeting = addWaiter.addToWaitingList(meeting, timeSlot, newWaiter);
                if (ToolManager.getCurrentPlacement() == null) {
                    Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_WL_S, (String)(event.getSiteId() + " meetingId:" + meeting.getId() + " -added to wlist on TS:" + SignupDateFormat.format_date_h_mm_a((Date)timeSlot.getStartTime())));
                }
            } else {
                userActionWarningMsg = Utilities.rb.getString("user.not.allowed.to.waitlist");
            }
        }
        catch (SignupUserActionException ue) {
            userActionWarningMsg = ue.getMessage();
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            userActionWarningMsg = Utilities.rb.getString("error.occurred_try_again");
        }
        SignupEvent evt = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)meeting, (String)this.getSakaiFacade().getCurrentUserId(), (String)event.getSiteId(), (boolean)true, (boolean)false, (SakaiFacade)this.sakaiFacade);
        evt.setUserActionWarningMsg(userActionWarningMsg);
        return evt;
    }

    private SignupEvent userCancelSignup(SignupEvent event) {
        String userActionWarningMsg = null;
        SignupMeeting meeting = null;
        try {
            meeting = this.getSignupMeeting(event);
            CancelAttendee signup = new CancelAttendee(this.signupMeetingService, this.getSakaiFacade().getCurrentUserId(), event.getSiteId(), false);
            SignupAttendee removedAttendee = new SignupAttendee(this.getSakaiFacade().getCurrentUserId(), event.getSiteId());
            meeting = signup.cancelSignup(meeting, this.getSignupTimeSlot(meeting, event.getAllocToTSid()), removedAttendee);
            if (ToolManager.getCurrentPlacement() == null) {
                Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_S, (String)(event.getSiteId() + " meetingId:" + meeting.getId() + signup.getSignupEventTrackingInfo().getAllAttendeeTransferLogInfo()));
            }
            try {
                signup.getSignupEventTrackingInfo().getMeeting().setCurrentSiteId(event.getSiteId());
                this.signupMeetingService.sendCancellationEmail(signup.getSignupEventTrackingInfo());
            }
            catch (Exception e) {
                this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
            }
        }
        catch (SignupUserActionException ue) {
            userActionWarningMsg = ue.getMessage();
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            userActionWarningMsg = Utilities.rb.getString("error.occurred_try_again");
        }
        SignupEvent evt = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)meeting, (String)this.getSakaiFacade().getCurrentUserId(), (String)event.getSiteId(), (boolean)true, (boolean)false, (SakaiFacade)this.sakaiFacade);
        evt.setUserActionWarningMsg(userActionWarningMsg);
        return evt;
    }

    private SignupEvent userSignup(SignupEvent event) {
        String userActionWarningMsg = null;
        SignupMeeting meeting = null;
        try {
            meeting = this.getSignupMeeting(event);
            AddAttendee signup = new AddAttendee(this.signupMeetingService, this.getSakaiFacade().getCurrentUserId(), event.getSiteId(), false);
            SignupAttendee signupAttendee = new SignupAttendee(this.getSakaiFacade().getCurrentUserId(), event.getSiteId());
            meeting = signup.signup(meeting, this.getSignupTimeSlot(meeting, event.getAllocToTSid()), signupAttendee);
            if (ToolManager.getCurrentPlacement() == null) {
                Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_S, (String)(event.getSiteId() + " meetingId:" + meeting.getId() + signup.getSignupEventTrackingInfo().getAllAttendeeTransferLogInfo()));
            }
            if (meeting.isReceiveEmailByOwner()) {
                try {
                    signup.getSignupEventTrackingInfo().getMeeting().setCurrentSiteId(event.getSiteId());
                    this.signupMeetingService.sendEmailToOrganizer(signup.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SignupUserActionException ue) {
            userActionWarningMsg = ue.getMessage();
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            userActionWarningMsg = Utilities.rb.getString("error.occurred_try_again");
        }
        SignupEvent evt = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)meeting, (String)this.getSakaiFacade().getCurrentUserId(), (String)event.getSiteId(), (boolean)true, (boolean)false, (SakaiFacade)this.sakaiFacade);
        evt.setUserActionWarningMsg(userActionWarningMsg);
        return evt;
    }

    private SignupMeeting getSignupMeeting(SignupEvent event) {
        SignupMeeting meeting = this.signupMeetingService.loadSignupMeeting(event.getEventId(), this.getSakaiFacade().getCurrentUserId(), event.getSiteId());
        return meeting;
    }

    private SignupTimeslot getSignupTimeSlot(SignupMeeting sMeeting, String tsId) {
        List tsList = sMeeting.getSignupTimeSlots();
        if (tsList != null) {
            for (SignupTimeslot ts : tsList) {
                if (!ts.getId().toString().equals(tsId)) continue;
                return ts;
            }
        }
        return null;
    }

    private String validateViewRange(String viewRange) {
        String vRange = null;
        if (viewRange != null) {
            try {
                Integer.parseInt(viewRange);
                vRange = viewRange;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vRange;
    }

    private List<SignupEvent> getMySignedUpEvents(List<SignupMeeting> sMeeting, String currentUserId) {
        ArrayList<SignupEvent> events = new ArrayList<SignupEvent>();
        if (sMeeting != null && !sMeeting.isEmpty()) {
            for (SignupMeeting m : sMeeting) {
                List signupTimeSlots = m.getSignupTimeSlots();
                block1: for (SignupTimeslot timeslot : signupTimeSlots) {
                    List attendees = timeslot.getAttendees();
                    for (SignupAttendee attendee : attendees) {
                        if (!attendee.getAttendeeUserId().equals(currentUserId)) continue;
                        SignupEvent e = SignupObjectConverter.convertToSignupEventObj((SignupMeeting)m, (String)currentUserId, (String)m.getCurrentSiteId(), (boolean)false, (boolean)true, (SakaiFacade)this.sakaiFacade);
                        e.setSiteId(attendee.getSignupSiteId());
                        e.setMyStartTime(timeslot.getStartTime());
                        e.setMyEndTime(timeslot.getEndTime());
                        events.add(e);
                        continue block1;
                    }
                }
            }
        }
        return events;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public SignupRESTfulSessionManager getSignupRESTfulSessionManager() {
        return this.signupRESTfulSessionManager;
    }

    public void setSignupRESTfulSessionManager(SignupRESTfulSessionManager signupRESTfulSessionManager) {
        this.signupRESTfulSessionManager = signupRESTfulSessionManager;
    }
}

