/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;

public class SignupMeetingWrapper
implements SignupBeanConstants {
    private SignupMeeting meeting;
    private String creator;
    private final String currentUserId;
    private boolean selected;
    private boolean toDownload;
    private SakaiFacade sakaiFacade;
    private boolean subRecurringMeeting;
    private String recurId;
    private int recurEventsSize = 0;
    private String hideStyle = "display: none;";
    private Date startTime;
    private Date endTime;
    private boolean showMyAppointmentTimeFrame = false;
    private String availableStatus = null;
    private List<SignupAttachment> attendeeAttachments = new ArrayList();
    private List<SignupAttachment> eventMainAttachments = new ArrayList();
    private long lastUpdatedTime = new Date().getTime();
    private Calendar cal = Calendar.getInstance();

    public SignupMeetingWrapper(SignupMeeting signupMeeting, String creator, String currentUserId, SakaiFacade sakaiFacade) {
        this.meeting = signupMeeting;
        this.creator = creator;
        this.currentUserId = currentUserId;
        this.sakaiFacade = sakaiFacade;
        this.selected = false;
        this.subRecurringMeeting = false;
        this.toDownload = false;
        this.processSignupAttachments(signupMeeting.getSignupAttachments());
    }

    public SignupMeeting getMeeting() {
        return this.meeting;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getAvailableStatus() {
        if (this.availableStatus == null) {
            this.availableStatus = Utilities.retrieveAvailStatus((SignupMeeting)this.meeting, (String)this.currentUserId, (SakaiFacade)this.getSakaiFacade());
        }
        return this.availableStatus;
    }

    public String getStatusStyle() {
        String style = "";
        if (Utilities.rb.getString("event.inProgress").equals(this.getAvailableStatus())) {
            style = "font-weight:bold;";
        } else if (Utilities.rb.getString("event.youSignedUp").equals(this.getAvailableStatus()) || Utilities.rb.getString("event.youOnWaitList").equals(this.getAvailableStatus())) {
            style = "color:red;";
        }
        return style;
    }

    public void resetAvailableStatus() {
        this.availableStatus = null;
    }

    public boolean isAtleastOneTimeslotLockedOrCanceled() {
        List signupTimeSlots = this.meeting.getSignupTimeSlots();
        if (signupTimeSlots == null) {
            return false;
        }
        for (SignupTimeslot timeslot : signupTimeSlots) {
            if (!timeslot.isCanceled() && !timeslot.isLocked()) continue;
            return true;
        }
        return false;
    }

    public void setMeeting(SignupMeeting meeting) {
        this.meeting = meeting;
        this.setLastUpdatedTime(new Date().getTime());
        this.processSignupAttachments(meeting.getSignupAttachments());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isToDownload() {
        return this.toDownload;
    }

    public void setToDownload(boolean toDownload) {
        this.toDownload = toDownload;
    }

    public boolean isRefresh() {
        return new Date().getTime() - this.getLastUpdatedTime() > 300000L;
    }

    private long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    private void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    private SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public boolean isSubRecurringMeeting() {
        return this.subRecurringMeeting;
    }

    public void setSubRecurringMeeting(boolean subRecurringMeeting) {
        this.subRecurringMeeting = subRecurringMeeting;
    }

    public String getRecurId() {
        if (this.meeting.getRecurrenceId() != null && this.isSubRecurringMeeting()) {
            return this.recurId;
        }
        return this.meeting.getRecurrenceId() != null ? this.meeting.getRecurrenceId().toString() : this.meeting.getId().toString() + "_on";
    }

    public void setRecurId(String recurId) {
        this.recurId = recurId;
    }

    public String getHideStyle() {
        if (this.isSubRecurringMeeting()) {
            return this.hideStyle;
        }
        return "";
    }

    public void setHideStyle(String hideStyle) {
        this.hideStyle = hideStyle;
    }

    public boolean isFirstOneRecurMeeting() {
        return this.meeting.isRecurredMeeting() && !this.isSubRecurringMeeting();
    }

    public int getRecurEventsSize() {
        return this.recurEventsSize;
    }

    public void setRecurEventsSize(int recurEventsSize) {
        this.recurEventsSize = recurEventsSize;
    }

    public Date getStartTime() {
        if (!this.isShowMyAppointmentTimeFrame()) {
            return this.meeting.getStartTime();
        }
        return this.startTime != null ? this.startTime : this.meeting.getStartTime();
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        if (!this.isShowMyAppointmentTimeFrame()) {
            return this.meeting.getEndTime();
        }
        return this.endTime != null ? this.endTime : this.meeting.getEndTime();
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public boolean isShowMyAppointmentTimeFrame() {
        return this.showMyAppointmentTimeFrame;
    }

    public void setShowMyAppointmentTimeFrame(boolean showMyAppointmentTimeFrame) {
        this.showMyAppointmentTimeFrame = showMyAppointmentTimeFrame;
    }

    public boolean isMyAppointmentCrossDays() {
        this.cal.setTime(this.getStartTime());
        int startingDay = this.cal.get(6);
        this.cal.setTime(this.getEndTime());
        int endingDay = this.cal.get(6);
        return startingDay != endingDay;
    }

    public List<SignupAttachment> getAttendeeAttachments() {
        return this.attendeeAttachments;
    }

    public void setAttendeeAttachments(List<SignupAttachment> attendeeAttachments) {
        this.attendeeAttachments = attendeeAttachments;
    }

    public List<SignupAttachment> getEventMainAttachments() {
        return this.eventMainAttachments;
    }

    public void setEventMainAttachments(List<SignupAttachment> eventMainAttachments) {
        this.eventMainAttachments = eventMainAttachments;
    }

    public boolean getEmptyEventMainAttachment() {
        return this.eventMainAttachments == null || this.eventMainAttachments.isEmpty();
    }

    public boolean getEmptyAttendeeAttachment() {
        return this.attendeeAttachments == null || this.attendeeAttachments.isEmpty();
    }

    private void processSignupAttachments(List<SignupAttachment> attachments) {
        if (attachments != null) {
            this.eventMainAttachments.clear();
            this.attendeeAttachments.clear();
            for (SignupAttachment attach : attachments) {
                if (attach == null) continue;
                if (attach.getTimeslotId() != null && !attach.getViewByAll().booleanValue()) {
                    this.attendeeAttachments.add(attach);
                    continue;
                }
                if (!attach.getViewByAll().booleanValue()) continue;
                this.eventMainAttachments.add(attach);
            }
        }
    }
}

