/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.signup.logic.Permission;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.tool.jsf.NewSignupMeetingBean;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupSorter;
import org.sakaiproject.signup.tool.jsf.attendee.AttendeeSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.AttendanceSignupBean;
import org.sakaiproject.signup.tool.jsf.organizer.OrganizerSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateSitesGroups;
import org.sakaiproject.signup.tool.jsf.signupFilter;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;

public class SignupMeetingsBean
implements SignupBeanConstants {
    private static Log log = LogFactory.getLog(SignupMeetingsBean.class);
    protected UIData meetingTable;
    protected String viewDateRang = "10000";
    protected SignupMeetingService signupMeetingService;
    protected List<SignupMeetingWrapper> signupMeetings;
    protected SakaiFacade sakaiFacade;
    protected AttendeeSignupMBean attendeeSignupMBean;
    protected OrganizerSignupMBean organizerSignupMBean;
    protected AttendanceSignupBean attendanceSignupBean;
    private NewSignupMeetingBean newSignupMeetingBean;
    protected SignupSorter signupSorter = new SignupSorter();
    protected boolean showAllRecurMeetings = false;
    protected boolean enableExpandOption = false;
    protected List<SelectItem> viewDropDownList;
    protected final String disabledSelectView = "none";
    protected String meetingUnavailableMessages;
    protected Boolean categoriesExist = null;
    protected Boolean locationsExist = null;
    protected String categoryFilter = "_ALL_";
    private long lastUpdatedLocTime = 0L;
    private List<SelectItem> allLocations = null;
    private long lastUpdatedCatTime = 0L;
    private List<SelectItem> allCategories = null;
    private CreateSitesGroups createSitesGroups = null;
    private long lastUpdatedTime = new Date().getTime();
    private String iframeId = "";
    private boolean userLoggedInStatus = false;

    public String getCurrentUserDisplayName() {
        return this.sakaiFacade.getUserDisplayName(this.sakaiFacade.getCurrentUserId());
    }

    public String addMeeting() {
        this.getNewSignupMeetingBean().reset();
        return "addMeeting";
    }

    public String removeMeetings() {
        HashSet<SignupMeeting> meetingsSet = new HashSet<SignupMeeting>();
        try {
            for (SignupMeetingWrapper mWrapper : this.getSignupMeetings()) {
                if (!mWrapper.isSelected()) continue;
                if (mWrapper.isFirstOneRecurMeeting() && mWrapper.getRecurEventsSize() > 1) {
                    SignupMeeting topLevel = mWrapper.getMeeting();
                    List recurrentMeetings = this.signupMeetingService.getRecurringSignupMeetings(this.sakaiFacade.getCurrentLocationId(), this.sakaiFacade.getCurrentUserId(), topLevel.getRecurrenceId(), topLevel.getStartTime());
                    meetingsSet.addAll(recurrentMeetings);
                }
                meetingsSet.add(mWrapper.getMeeting());
            }
            ArrayList meetings = new ArrayList(meetingsSet);
            this.signupMeetingService.removeMeetings(meetings);
            for (SignupMeeting meeting : meetings) {
                log.info((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.sakaiFacade.getCurrentUserId() + " - has removed the meeting at meeting startTime:" + this.getSakaiFacade().getTimeService().newTime(meeting.getStartTime().getTime()).toStringLocalFull()));
                Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_MTNG_REMOVE, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId|title:" + meeting.getId() + "|" + meeting.getTitle() + " at startTime:" + this.getSakaiFacade().getTimeService().newTime(meeting.getStartTime().getTime()).toStringLocalFull()));
            }
            try {
                this.signupMeetingService.removeCalendarEvents(meetings);
            }
            catch (Exception e) {
                Utilities.addErrorMessage((String)Utilities.rb.getString("error.calendarEvent.removal_failed"));
                log.error((Object)(Utilities.rb.getString("error.calendarEvent.removal_failed") + " - " + e.getMessage()));
            }
            for (SignupMeeting m : meetings) {
                List attachs = m.getSignupAttachments();
                if (attachs == null) continue;
                for (SignupAttachment attach : attachs) {
                    this.getNewSignupMeetingBean().getAttachmentHandler().removeAttachmentInContentHost(attach);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)(Utilities.rb.getString("Failed.remove.event") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("Failed.remove.event"));
        }
        this.signupMeetings = null;
        return "listMeetings";
    }

    public List<SelectItem> getAllLocations() {
        long curr_time = new Date().getTime();
        if (this.allLocations == null || curr_time - this.lastUpdatedLocTime > 1000L) {
            ArrayList<SelectItem> locations = new ArrayList<SelectItem>();
            List allLocs = null;
            try {
                allLocs = this.signupMeetingService.getAllLocations(this.sakaiFacade.getCurrentLocationId());
            }
            catch (Exception e) {
                allLocs = null;
            }
            if (allLocs != null) {
                for (String lc : allLocs) {
                    if (!StringUtils.isNotBlank((String)lc)) continue;
                    locations.add(new SelectItem((Object)lc));
                }
            }
            this.locationsExist = !locations.isEmpty() ? new Boolean(true) : new Boolean(false);
            this.lastUpdatedLocTime = curr_time;
            this.allLocations = locations;
        }
        return this.allLocations;
    }

    public List<SelectItem> getAllCategories() {
        long curr_time = new Date().getTime();
        if (this.allCategories == null || curr_time - this.lastUpdatedCatTime > 1000L) {
            ArrayList<SelectItem> categories = new ArrayList<SelectItem>();
            List allCats = null;
            try {
                allCats = this.signupMeetingService.getAllCategories(this.sakaiFacade.getCurrentLocationId());
            }
            catch (Exception e) {
                allCats = null;
            }
            if (allCats != null) {
                for (String c : allCats) {
                    if (!StringUtils.isNotBlank((String)c)) continue;
                    categories.add(new SelectItem((Object)c));
                }
            }
            this.categoriesExist = !categories.isEmpty() ? new Boolean(true) : new Boolean(false);
            this.lastUpdatedCatTime = curr_time;
            categories.add(0, new SelectItem((Object)"_ALL_", Utilities.rb.getString("filter_categories_top")));
            this.allCategories = categories;
        }
        return this.allCategories;
    }

    public String processSignup() {
        SignupMeetingWrapper meetingWrapper = null;
        try {
            meetingWrapper = (SignupMeetingWrapper)this.meetingTable.getRowData();
        }
        catch (Exception ex) {
            this.setSignupMeetings(null);
            return "listMeetings";
        }
        Permission permission = meetingWrapper.getMeeting().getPermission();
        try {
            if (permission.isUpdate()) {
                this.organizerSignupMBean.init(meetingWrapper);
                return "organizerMeeting";
            }
            this.attendeeSignupMBean.init(meetingWrapper);
        }
        catch (Exception e) {
            return "listMeetings";
        }
        return "meeting";
    }

    public String processSignupAttendance() {
        SignupMeetingWrapper meetingWrapper = (SignupMeetingWrapper)this.meetingTable.getRowData();
        Permission permission = meetingWrapper.getMeeting().getPermission();
        try {
            if (permission.isUpdate()) {
                this.attendanceSignupBean.init(meetingWrapper);
                return "attendanceView";
            }
        }
        catch (Exception e) {
            return "attendanceView";
        }
        return "attendanceView";
    }

    public String processSelectedRange(ValueChangeEvent vce) {
        String viewRange = (String)vce.getNewValue();
        if ("none".equals(viewRange)) {
            return "listMeetings";
        }
        this.setViewDateRang(viewRange);
        this.setSignupMeetings(null);
        return "listMeetings";
    }

    public String processExpandAllRcurEvents(ValueChangeEvent vce) {
        Boolean expandAllEvents = (Boolean)vce.getNewValue();
        this.setShowAllRecurMeetings(expandAllEvents.booleanValue());
        List smWrappers = this.getSignupMeetings();
        if (smWrappers != null) {
            if (this.isShowAllRecurMeetings()) {
                for (SignupMeetingWrapper smWrp : smWrappers) {
                    smWrp.setRecurEventsSize(0);
                    smWrp.setSubRecurringMeeting(false);
                }
            } else {
                this.getSignupSorter().setSortAscending(true);
                this.getSignupSorter().setSortColumn("startTime");
                this.getSignupSorter().sort(smWrappers);
                this.markingRecurMeetings(smWrappers);
                this.setSignupMeetings(smWrappers);
            }
        }
        return "listMeetings";
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public List<SignupMeetingWrapper> getSignupMeetings() {
        try {
            if (this.signupMeetings == null || this.isRefresh()) {
                this.loadMeetings(this.getViewDateRang(), this.getCategoryFilter());
                this.setLastUpdatedTime(new Date().getTime());
            }
        }
        catch (Exception e) {
            log.error((Object)(Utilities.rb.getString("failed.fetch_allEvents_from_db") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("failed.fetch_allEvents_from_db"));
        }
        return this.signupMeetings;
    }

    public List<SignupMeetingWrapper> getAllSignupMeetings() {
        try {
            this.loadMeetings("all", null);
        }
        catch (Exception e) {
            log.error((Object)(Utilities.rb.getString("failed.fetch_allEvents_from_db") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("failed.fetch_allEvents_from_db"));
        }
        return this.signupMeetings;
    }

    private void loadMeetings(String viewRange, String categoryFilter) {
        List mWrappers = this.getMeetingWrappers(viewRange, categoryFilter);
        if (!this.isShowAllRecurMeetings()) {
            this.markingRecurMeetings(mWrappers);
        }
        this.setSignupMeetings(mWrappers);
    }

    private void markingRecurMeetings(List<SignupMeetingWrapper> smList) {
        if (smList == null || smList.size() == 0) {
            return;
        }
        for (int i = 0; i < smList.size(); ++i) {
            SignupMeetingWrapper smWrapper = smList.get(i);
            Long firstRecurId = smWrapper.getMeeting().getRecurrenceId();
            if (firstRecurId == null || firstRecurId < 0L || smWrapper.isSubRecurringMeeting()) continue;
            int index = 0;
            for (int j = i + 1; j < smList.size(); ++j) {
                SignupMeetingWrapper nextOne = smList.get(j);
                if (nextOne.getMeeting().getRecurrenceId() == null || nextOne.getMeeting().getRecurrenceId().longValue() != firstRecurId.longValue()) continue;
                nextOne.setSubRecurringMeeting(true);
                nextOne.setRecurId(firstRecurId + "_" + index++);
            }
            smWrapper.setRecurEventsSize(index + 1);
        }
    }

    private List<SignupMeetingWrapper> getMeetingWrappers(String viewRange, String categoryFilter) {
        String currentUserId = this.sakaiFacade.getCurrentUserId();
        if (!this.isUserLoggedInStatus()) {
            return null;
        }
        List signupMeetings = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if ("all".equals(viewRange)) {
            signupMeetings = this.signupMeetingService.getAllSignupMeetings(this.sakaiFacade.getCurrentLocationId(), currentUserId);
        } else if (!"-1".equals(viewRange)) {
            int currentHour = calendar.get(11);
            int currentMinutes = calendar.get(12);
            calendar.add(10, -1 * currentHour);
            calendar.add(12, -1 * currentMinutes);
            String searchDateStr = viewRange;
            if ("mySignUp".equals(viewRange) || "immediateAvail".equals(viewRange)) {
                searchDateStr = "10000";
            }
            signupMeetings = this.signupMeetingService.getSignupMeetings(this.sakaiFacade.getCurrentLocationId(), currentUserId, calendar.getTime(), Utilities.getUserDefinedDate((int)Integer.parseInt(searchDateStr)));
        } else if ("-1".equals(viewRange)) {
            signupMeetings = this.signupMeetingService.getSignupMeetings(this.sakaiFacade.getCurrentLocationId(), currentUserId, calendar.getTime());
        }
        if (signupMeetings == null || signupMeetings.isEmpty()) {
            return null;
        }
        ArrayList<SignupMeeting> filteredCategorySignupMeetings = new ArrayList<SignupMeeting>();
        if (StringUtils.isNotBlank((String)categoryFilter) && !StringUtils.equals((String)"_ALL_", (String)categoryFilter)) {
            for (SignupMeeting s : signupMeetings) {
                if (!StringUtils.equals((String)s.getCategory(), (String)categoryFilter)) continue;
                filteredCategorySignupMeetings.add(s);
            }
        } else {
            filteredCategorySignupMeetings.addAll(signupMeetings);
        }
        ArrayList<SignupMeetingWrapper> wrappers = new ArrayList<SignupMeetingWrapper>();
        for (SignupMeeting meeting : filteredCategorySignupMeetings) {
            SignupMeetingWrapper wrapper = new SignupMeetingWrapper(meeting, this.sakaiFacade.getUserDisplayName(meeting.getCreatorUserId()), this.sakaiFacade.getCurrentUserId(), this.getSakaiFacade());
            wrappers.add(wrapper);
        }
        signupFilter filter = new signupFilter(currentUserId, viewRange);
        filter.filterSignupMeetings(wrappers);
        this.setEnableExpandOption(false);
        for (SignupMeetingWrapper meetingWrp : wrappers) {
            if (!meetingWrp.getMeeting().isRecurredMeeting()) continue;
            this.setEnableExpandOption(true);
        }
        return wrappers;
    }

    public boolean isAllowedToDelete() {
        if (this.getSignupMeetings() == null) {
            return false;
        }
        for (SignupMeetingWrapper meetingW : this.signupMeetings) {
            if (!meetingW.getMeeting().getPermission().isDelete()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedToUpdate() {
        if (this.getSignupMeetings() == null) {
            return false;
        }
        for (SignupMeetingWrapper meetingW : this.signupMeetings) {
            if (!meetingW.getMeeting().getPermission().isUpdate()) continue;
            return true;
        }
        return false;
    }

    public boolean isMeetingsAvailable() {
        this.getSignupMeetings();
        return this.signupMeetings != null && !this.signupMeetings.isEmpty();
    }

    public boolean isCategoriesAvailable() {
        if (this.categoriesExist == null) {
            this.getAllCategories();
        }
        return this.categoriesExist;
    }

    public boolean isLocationsAvailable() {
        if (this.locationsExist == null) {
            this.getAllLocations();
        }
        return this.locationsExist;
    }

    public boolean isSelectedViewFutureMeetings() {
        boolean t = false;
        if (this.getViewDateRang().equals("10000")) {
            t = true;
        }
        return t;
    }

    public boolean isSelectedViewAllMeetings() {
        boolean t = false;
        if (this.getViewDateRang().equals("all")) {
            t = true;
        }
        return t;
    }

    public boolean isAllowedToCreate() {
        boolean allowed = this.signupMeetingService.isAllowedToCreateAnyInSite(this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId());
        if (allowed && this.createSitesGroups == null) {
            this.createSitesGroups = new CreateSitesGroups(null, this.sakaiFacade, this.signupMeetingService);
        }
        return allowed;
    }

    public CreateSitesGroups getCreateSitesGroups() {
        return this.createSitesGroups;
    }

    public void setSignupMeetings(List<SignupMeetingWrapper> signupMeetings) {
        this.signupMeetings = signupMeetings;
    }

    public UIData getMeetingTable() {
        return this.meetingTable;
    }

    public void setMeetingTable(UIData meetingTable) {
        this.meetingTable = meetingTable;
    }

    public AttendeeSignupMBean getAttendeeSignupMBean() {
        return this.attendeeSignupMBean;
    }

    public void setAttendeeSignupMBean(AttendeeSignupMBean attendeeSignupMBean) {
        this.attendeeSignupMBean = attendeeSignupMBean;
    }

    public OrganizerSignupMBean getOrganizerSignupMBean() {
        return this.organizerSignupMBean;
    }

    public void setOrganizerSignupMBean(OrganizerSignupMBean organizerSignupMBean) {
        this.organizerSignupMBean = organizerSignupMBean;
    }

    public String getViewDateRang() {
        return this.viewDateRang;
    }

    public void setViewDateRang(String viewDateRang) {
        this.viewDateRang = viewDateRang;
    }

    private boolean isRefresh() {
        return new Date().getTime() - this.lastUpdatedTime > 300000L;
    }

    private void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public SignupSorter getSignupSorter() {
        return this.signupSorter;
    }

    public void setSignupSorter(SignupSorter signupSorter) {
        this.signupSorter = signupSorter;
    }

    public boolean isShowAllRecurMeetings() {
        return this.showAllRecurMeetings;
    }

    public void setShowAllRecurMeetings(boolean showAllRecurMeetings) {
        this.showAllRecurMeetings = showAllRecurMeetings;
    }

    public String getIframeId() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String iFrameId = (String)request.getAttribute("sakai.tool.placement.id");
        return iFrameId;
    }

    public boolean isEnableExpandOption() {
        return this.enableExpandOption;
    }

    public void setEnableExpandOption(boolean enableExpandOption) {
        this.enableExpandOption = enableExpandOption;
    }

    public List<SelectItem> getViewDropDownList() {
        if (this.viewDropDownList == null) {
            this.initViewDropDownList();
        }
        return this.viewDropDownList;
    }

    private void initViewDropDownList() {
        ArrayList<SelectItem> viewDrpDwnList = new ArrayList<SelectItem>();
        viewDrpDwnList.add(new SelectItem((Object)"30", Utilities.rb.getString("view_current_month")));
        viewDrpDwnList.add(new SelectItem((Object)"90", Utilities.rb.getString("view_current_three_months")));
        viewDrpDwnList.add(new SelectItem((Object)"10000", Utilities.rb.getString("view_all_future_meetings")));
        viewDrpDwnList.add(new SelectItem((Object)"all", Utilities.rb.getString("view_all")));
        viewDrpDwnList.add(new SelectItem((Object)"none", Utilities.rb.getString("dropDown_line_separator"), "line-separator", true));
        viewDrpDwnList.add(new SelectItem((Object)"mySignUp", Utilities.rb.getString("view_my_signed_up")));
        viewDrpDwnList.add(new SelectItem((Object)"immediateAvail", Utilities.rb.getString("view_immediate_avail_ones")));
        this.setViewDropDownList(viewDrpDwnList);
    }

    private void setViewDropDownList(List<SelectItem> viewDropDownList) {
        this.viewDropDownList = viewDropDownList;
    }

    public String getMeetingUnavailableMessages() {
        this.meetingUnavailableMessages = "";
        if (this.isMeetingsAvailable()) {
            return this.meetingUnavailableMessages;
        }
        if (this.isAllowedToCreate() && this.isSelectedViewFutureMeetings()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_events_in_future_organizer"));
        } else if (this.isAllowedToCreate() && this.isSelectedViewAllMeetings()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_events_in_timeframe_organizer"));
        } else if (!this.isAllowedToCreate() && this.isSelectedViewAllMeetings()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_events_in_timeframe_attendee"));
        } else if (this.isSelectedViewImmediateAvail()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_future_events_in_immediate_available"));
        } else if (this.isSelectedViewMySignedUp()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_future_events_I_have_signed_up"));
        } else if (!this.isAllowedToCreate() && this.isSelectedViewFutureMeetings() || !this.isSelectedViewAllMeetings() && !this.isSelectedViewFutureMeetings()) {
            this.setMeetingUnavailableMessages(Utilities.rb.getString("no_events_in_this_period_attendee_orgnizer"));
        }
        return this.meetingUnavailableMessages;
    }

    public boolean isSelectedViewImmediateAvail() {
        boolean t = false;
        if (this.getViewDateRang().equals("immediateAvail")) {
            t = true;
        }
        return t;
    }

    public boolean isSelectedViewMySignedUp() {
        boolean t = false;
        if (this.getViewDateRang().equals("mySignUp")) {
            t = true;
        }
        return t;
    }

    private void setMeetingUnavailableMessages(String meetingUnavailableMessages) {
        this.meetingUnavailableMessages = meetingUnavailableMessages;
    }

    public NewSignupMeetingBean getNewSignupMeetingBean() {
        return this.newSignupMeetingBean;
    }

    public void setNewSignupMeetingBean(NewSignupMeetingBean newSignupMeetingBean) {
        this.newSignupMeetingBean = newSignupMeetingBean;
    }

    public AttendanceSignupBean getAttendanceSignupBean() {
        return this.attendanceSignupBean;
    }

    public void setAttendanceSignupBean(AttendanceSignupBean attendanceSignupBean) {
        this.attendanceSignupBean = attendanceSignupBean;
    }

    public boolean isShowMyAppointmentTime() {
        return "mySignUp".equals(this.viewDateRang);
    }

    public boolean isUserLoggedInStatus() {
        if (!this.userLoggedInStatus) {
            if (this.getSakaiFacade().getCurrentUserId() != null) {
                this.userLoggedInStatus = true;
            } else {
                return false;
            }
        }
        return this.userLoggedInStatus;
    }

    public boolean isAttendanceOn() {
        return "true".equalsIgnoreCase(this.getSakaiFacade().getServerConfigurationService().getString("signup.enableAttendance", "true"));
    }

    public List<SelectItem> getInstructors(SignupMeeting meeting) {
        List users = this.sakaiFacade.getUsersWithPermission("signup.create.site");
        ArrayList<SelectItem> instructors = new ArrayList<SelectItem>();
        if (meeting != null && StringUtils.isNotBlank((String)meeting.getCreatorUserId())) {
            User currentInstructor = this.sakaiFacade.getUser(meeting.getCreatorUserId());
            instructors.add(new SelectItem((Object)currentInstructor.getId(), currentInstructor.getDisplayName() + " (" + currentInstructor.getEid() + ")"));
            users.remove(currentInstructor);
        } else {
            User currentUser = this.sakaiFacade.getUser(this.sakaiFacade.getCurrentUserId());
            instructors.add(new SelectItem((Object)currentUser.getId(), currentUser.getDisplayName() + " (" + currentUser.getEid() + ")"));
            users.remove(currentUser);
        }
        for (User u : users) {
            instructors.add(new SelectItem((Object)u.getId(), u.getDisplayName() + " (" + u.getDisplayId() + ")"));
        }
        Collections.sort(instructors, SignupSorter.sortSelectItemComparator);
        return instructors;
    }

    public String getInstructorName(String userId) {
        User u = this.sakaiFacade.getUser(userId);
        if (u == null) {
            return null;
        }
        return u.getDisplayName() + " (" + u.getEid() + ")";
    }

    public boolean isCsvExportEnabled() {
        return this.sakaiFacade.isCsvExportEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCurrentUserAllowedUpdateSite() {
        String currentUserId = this.sakaiFacade.getCurrentUserId();
        String currentSiteId = this.sakaiFacade.getCurrentLocationId();
        if (this.sakaiFacade.isAllowedSite(currentUserId, "signup.update.site", currentSiteId)) return true;
        if (!this.sakaiFacade.isAllowedSite(currentUserId, "signup.create.site", currentSiteId)) return false;
        return true;
    }

    public List<SelectItem> getAllCategoriesForFilter() {
        List categories = this.getAllCategories();
        return categories;
    }

    public String processSelectedCategory(ValueChangeEvent vce) {
        String selectedCategory = (String)vce.getNewValue();
        if (!this.categoryFilter.equals(selectedCategory)) {
            this.setCategoryFilter(selectedCategory);
            this.setSignupMeetings(null);
        }
        return "";
    }

    public String getCategoryFilter() {
        return this.categoryFilter;
    }

    public void setCategoryFilter(String categoryFilter) {
        this.categoryFilter = categoryFilter;
    }
}

