/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.component.UIData;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.tool.jsf.RealmItem;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;

public class SignupPermissionsUpdateBean {
    private Log logger = LogFactoryImpl.getLog(this.getClass());
    private SakaiFacade sakaiFacade;
    private List<RealmItem> realmItems;
    private UIData permissionTable;
    private Boolean showPermissionLink = null;
    private static final boolean ENABLE_PERMISSION_FEATURE_FLAG = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.permission.update.enabled", (String)"true"));
    private static Boolean allowedToUpdate = null;

    public void init() {
        this.realmItems = this.getCurrentSiteRealmItems();
    }

    public String processPermission() {
        this.init();
        return "doPermission";
    }

    public String updatePermission() {
        RealmItem realmItem = (RealmItem)this.permissionTable.getRowData();
        String desc = "";
        Object[] params = null;
        if (realmItem.isSiteLevel()) {
            params = new Object[]{realmItem.getSiteTitle(), realmItem.getRefId()};
            desc = MessageFormat.format(Utilities.rb.getString("permission.info.for.site.scope"), params);
        } else {
            params = new Object[]{realmItem.getSiteTitle(), realmItem.getGroupTitle(), realmItem.getRefId()};
            desc = MessageFormat.format(Utilities.rb.getString("permission.info.for.group.scope"), params);
        }
        return this.doPermissions(realmItem.getRefId(), desc);
    }

    private String doPermissions(String siteRef, String description) {
        try {
            ToolSession currentToolSession = SessionManager.getCurrentToolSession();
            currentToolSession.setAttribute("sakaiproject.permissions.prefix", (Object)"signup.");
            currentToolSession.setAttribute("sakaiproject.permissions.targetRef", (Object)siteRef);
            currentToolSession.setAttribute("sakaiproject.permissions.description", (Object)description);
            ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
            context.redirect("sakai.permissions.helper.helper/tool");
        }
        catch (Exception e) {
            this.logger.error((Object)(this + ".processPermissionUpdateRedirect - " + e));
        }
        return null;
    }

    private List<RealmItem> getCurrentSiteRealmItems() {
        ArrayList<RealmItem> realmItemList = new ArrayList<RealmItem>();
        String cur_siteId = this.getSakaiFacade().getCurrentLocationId();
        try {
            Site site = SiteService.getSite((String)cur_siteId);
            RealmItem item = new RealmItem(site.getTitle(), "", SiteService.siteReference((String)cur_siteId), true);
            item.setAllowedUpd(this.getSakaiFacade().isAllowedSite(this.getSakaiFacade().getCurrentUserId(), "realm.upd", site.getId()));
            realmItemList.add(item);
            Collection groups = site.getGroups();
            if (groups != null) {
                for (Group grp : groups) {
                    item = new RealmItem(site.getTitle(), grp.getTitle(), SiteService.siteGroupReference((String)cur_siteId, (String)grp.getId()), false);
                    item.setAllowedUpd(this.getSakaiFacade().isAllowedGroup(this.getSakaiFacade().getCurrentUserId(), "realm.upd", site.getId(), grp.getId()));
                    realmItemList.add(item);
                }
            }
        }
        catch (IdUnusedException e) {
            this.logger.error((Object)("IdUnusedException: siteId is not found" + (Object)((Object)e)));
            Utilities.addErrorMessage((String)"No such site Id is found!");
        }
        return realmItemList;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public boolean isShowPermissionLink() {
        if (this.showPermissionLink == null) {
            boolean show = false;
            if (allowedToUpdate == null) {
                allowedToUpdate = new Boolean(ENABLE_PERMISSION_FEATURE_FLAG);
            }
            if (this.sakaiFacade.isUserAdmin(this.sakaiFacade.getCurrentUserId()) || this.hasSiteUpdatePermission() && (allowedToUpdate.booleanValue() || this.isUserHasAllRealmUpdPermissionsForGroupLevels())) {
                show = true;
            }
            this.showPermissionLink = new Boolean(show);
        }
        return this.showPermissionLink;
    }

    private boolean hasSiteUpdatePermission() {
        boolean allowed = false;
        if (this.getSakaiFacade().isAllowedSite(this.getSakaiFacade().getCurrentUserId(), SiteService.SECURE_UPDATE_SITE, this.getSakaiFacade().getCurrentLocationId())) {
            allowed = true;
        }
        return allowed;
    }

    private boolean isUserHasAllRealmUpdPermissionsForGroupLevels() {
        boolean hasPermission = true;
        this.realmItems = this.getCurrentSiteRealmItems();
        if (this.realmItems == null || this.realmItems.size() < 2) {
            return false;
        }
        for (RealmItem item : this.realmItems) {
            if (item.isAllowedUpd()) continue;
            hasPermission = false;
            break;
        }
        return hasPermission;
    }

    public List<RealmItem> getRealmItems() {
        return this.realmItems;
    }

    public UIData getPermissionTable() {
        return this.permissionTable;
    }

    public void setPermissionTable(UIData permissionTable) {
        this.permissionTable = permissionTable;
    }

    public boolean isAdmin() {
        return this.getSakaiFacade().isUserAdmin(this.getSakaiFacade().getCurrentUserId());
    }
}

