/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.model.SelectItem;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.AttendeeWrapper;
import org.sakaiproject.signup.util.SignupDateFormat;

public class TimeslotWrapper
implements Comparable {
    private final SignupTimeslot timeSlot;
    private String currentUserId;
    private List<AttendeeWrapper> attendeeWrappers;
    private List<AttendeeWrapper> waitingList;
    private SignupAttendee newAttendee;
    private int rankingOnWaiting;
    private List<SelectItem> swapDropDownList;
    private List<SelectItem> moveAvailableTimeSlots;
    private int positionInTSlist;
    private int tsMarker = Integer.MAX_VALUE;
    private boolean deleted = false;
    private String errorStyle = "";

    public TimeslotWrapper(SignupTimeslot slot) {
        this.timeSlot = slot;
    }

    public TimeslotWrapper(SignupTimeslot slot, String currentUserId) {
        this.timeSlot = slot;
        this.currentUserId = currentUserId;
    }

    public SignupTimeslot getTimeSlot() {
        return this.timeSlot;
    }

    public boolean isCurrentUserSignedUp() {
        return this.isAttendeeInList(this.timeSlot.getAttendees());
    }

    private boolean isAttendeeInList(List attendees) {
        if (attendees == null) {
            return false;
        }
        for (SignupAttendee attendee : attendees) {
            if (!this.currentUserId.equals(attendee.getAttendeeUserId())) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentUserOnWaitingList() {
        return this.isAttendeeInList(this.timeSlot.getWaitingList());
    }

    public void setCurrentUserId(String currentUserId) {
        this.currentUserId = currentUserId;
    }

    public String getCurrentUserId() {
        return this.currentUserId;
    }

    public AttendeeWrapper[] getDisplayAttendees() {
        List attendees = this.getAttendeeWrappers();
        AttendeeWrapper[] displayAttendees = attendees == null || attendees.size() < this.timeSlot.getMaxNoOfAttendees() ? new AttendeeWrapper[this.timeSlot.getMaxNoOfAttendees()] : new AttendeeWrapper[attendees.size()];
        if (attendees == null) {
            return displayAttendees;
        }
        for (int i = 0; i < attendees.size(); ++i) {
            displayAttendees[i] = (AttendeeWrapper)attendees.get(i);
        }
        return displayAttendees;
    }

    public List<AttendeeWrapper> getAttendeeWrappers() {
        return this.attendeeWrappers;
    }

    public void setAttendeeWrappers(List<AttendeeWrapper> attendeeWrappers) {
        this.attendeeWrappers = attendeeWrappers;
    }

    public List<AttendeeWrapper> getWaitingList() {
        return this.waitingList;
    }

    public int getSizeOfWaitingList() {
        return this.waitingList != null ? this.waitingList.size() : 0;
    }

    public void setWaitingList(List<AttendeeWrapper> waitingList) {
        this.waitingList = waitingList;
    }

    public boolean getAvailableForSignup() {
        if (this.timeSlot.getAttendees() == null) {
            return true;
        }
        return this.timeSlot.getAttendees().size() < this.timeSlot.getMaxNoOfAttendees();
    }

    public SignupAttendee getNewAttendee() {
        return this.newAttendee;
    }

    public void setNewAttendee(SignupAttendee newAttendee) {
        this.newAttendee = newAttendee;
    }

    public int getAvailability() {
        if (this.timeSlot.getAttendees() == null) {
            return this.timeSlot.getMaxNoOfAttendees();
        }
        int num = this.timeSlot.getMaxNoOfAttendees() - this.timeSlot.getAttendees().size();
        return num > -1 ? num : 0;
    }

    public int getNumberOnWaitingList() {
        if (this.timeSlot.getWaitingList() == null) {
            return 0;
        }
        return this.timeSlot.getWaitingList().size();
    }

    public int getRankingOnWaiting() {
        if (this.rankingOnWaiting == 0) {
            List waiters = this.timeSlot.getWaitingList();
            if (waiters == null) {
                this.setRankingOnWaiting(0);
                return this.rankingOnWaiting;
            }
            for (int i = 0; i < waiters.size(); ++i) {
                if (((SignupAttendee)waiters.get(i)).getAttendeeUserId().equals(this.currentUserId)) {
                    this.setRankingOnWaiting(i + 1);
                    break;
                }
                this.setRankingOnWaiting(0);
            }
        }
        return this.rankingOnWaiting;
    }

    public void setRankingOnWaiting(int rankingOnWaiting) {
        this.rankingOnWaiting = rankingOnWaiting;
    }

    public List<SelectItem> getSwapDropDownList() {
        return this.swapDropDownList;
    }

    public void setSwapDropDownList(List<SelectItem> swapDropDownList) {
        this.swapDropDownList = new ArrayList<SelectItem>(swapDropDownList);
        this.swapDropDownList = swapDropDownList;
    }

    public List<SelectItem> getMoveAvailableTimeSlots() {
        return this.moveAvailableTimeSlots;
    }

    public void setMoveAvailableTimeSlots(List<SelectItem> moveAvailableTimeSlots) {
        this.moveAvailableTimeSlots = moveAvailableTimeSlots;
    }

    public String getLabel() {
        return SignupDateFormat.format_h_mm_a((Date)this.timeSlot.getStartTime()) + " - " + SignupDateFormat.format_h_mm_a((Date)this.timeSlot.getEndTime());
    }

    public int getPositionInTSlist() {
        return this.positionInTSlist;
    }

    public void setPositionInTSlist(int positionInTSlist) {
        this.positionInTSlist = positionInTSlist;
    }

    public void addAttendee(SignupAttendee attendee, String displayName) {
        if (this.attendeeWrappers == null) {
            this.attendeeWrappers = new ArrayList();
        }
        this.timeSlot.getAttendees().add(attendee);
        AttendeeWrapper wrapper = new AttendeeWrapper(attendee, displayName);
        this.attendeeWrappers.add(wrapper);
        wrapper.setPositionIndex(this.attendeeWrappers.size() - 1);
    }

    public void removeAttendee(String attendeeUserId) {
        if (this.attendeeWrappers == null) {
            return;
        }
        Iterator iter = this.attendeeWrappers.iterator();
        while (iter.hasNext()) {
            AttendeeWrapper attendeeWrapper = (AttendeeWrapper)iter.next();
            if (!attendeeWrapper.getSignupAttendee().getAttendeeUserId().equals(attendeeUserId)) continue;
            iter.remove();
            break;
        }
        List attendees = this.timeSlot.getAttendees();
        Iterator iter2 = attendees.iterator();
        while (iter2.hasNext()) {
            SignupAttendee attendee = (SignupAttendee)iter2.next();
            if (!attendee.getAttendeeUserId().equals(attendeeUserId)) continue;
            iter2.remove();
            break;
        }
        this.updatePositionIndex(this.attendeeWrappers);
    }

    private void updatePositionIndex(List<AttendeeWrapper> attendeeWrappers) {
        int count = 0;
        for (AttendeeWrapper wrapper : attendeeWrappers) {
            wrapper.setPositionIndex(count++);
        }
    }

    public int compareTo(Object o) throws ClassCastException {
        if (!(o instanceof TimeslotWrapper)) {
            throw new ClassCastException("TimeslotWrapper object expected.");
        }
        int result = this.getTimeSlot().getStartTime().compareTo(((TimeslotWrapper)o).getTimeSlot().getStartTime());
        if (result == 0) {
            result = this.getTimeSlot().getEndTime().compareTo(((TimeslotWrapper)o).getTimeSlot().getEndTime());
        }
        return result;
    }

    public int getTsMarker() {
        return this.tsMarker;
    }

    public void setTsMarker(int tsMarker) {
        this.tsMarker = tsMarker;
    }

    public boolean getNewlyAddedTS() {
        return this.tsMarker == Integer.MAX_VALUE;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean getNewTimeslotBlock() {
        return this.tsMarker == Integer.MAX_VALUE;
    }

    public String getErrorStyle() {
        String style = this.errorStyle;
        this.errorStyle = "";
        return style;
    }

    public void setErrorStyle(String errorStyle) {
        this.errorStyle = errorStyle;
    }

    public String getGroupId() {
        return this.timeSlot.getGroupId();
    }
}

