/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.attendee;

import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupUIBaseBean;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.AddWaiter;
import org.sakaiproject.signup.tool.jsf.organizer.action.CancelAttendee;
import org.sakaiproject.signup.tool.jsf.organizer.action.RemoveWaiter;
import org.sakaiproject.signup.tool.util.Utilities;

public class AttendeeSignupMBean
extends SignupUIBaseBean {
    private UIData timeslotWrapperTable;
    private String currentUserId;
    private String currentSiteId;
    private boolean collapsedMeetingInfo;

    public void init(SignupMeetingWrapper meetingWrapper) throws Exception {
        this.setMeetingWrapper(meetingWrapper);
        this.updateTimeSlotWrappers(meetingWrapper);
        this.collapsedMeetingInfo = false;
    }

    public String attendeeSignup() {
        this.timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        SignupAttendee newAttendee = new SignupAttendee();
        String currentUserId = this.sakaiFacade.getCurrentUserId();
        newAttendee.setAttendeeUserId(currentUserId);
        newAttendee.setSignupSiteId(this.sakaiFacade.getCurrentLocationId());
        this.timeslotWrapper.setNewAttendee(newAttendee);
        if (this.meetingWrapper.getMeeting().isAllowComment()) {
            return "addSignupAttendee";
        }
        return this.attendeeSaveSignup();
    }

    public String attendeeSaveSignup() {
        SignupMeeting meeting = null;
        try {
            AddAttendee signup = new AddAttendee(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), false);
            meeting = signup.signup(this.meetingWrapper.getMeeting(), this.timeslotWrapper.getTimeSlot(), this.timeslotWrapper.getNewAttendee());
            if (meeting.isReceiveEmailByOwner()) {
                try {
                    this.signupMeetingService.sendEmailToOrganizer(signup.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
            boolean sendAttendeeEmail = Utilities.getSignupConfigParamVal((String)"signup.email.notification.attendee.signed.up", (boolean)true);
            if (this.sendEmail || sendAttendeeEmail) {
                try {
                    this.signupMeetingService.sendEmailToAttendee(signup.getSignupEventTrackingInfo());
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "meeting");
    }

    public String attendeeCancelSignup() {
        SignupMeeting meeting = null;
        this.timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        try {
            CancelAttendee signup = new CancelAttendee(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), false);
            SignupAttendee removedAttendee = new SignupAttendee(this.currentUserId(), this.currentSiteId());
            meeting = signup.cancelSignup(this.meetingWrapper.getMeeting(), this.timeslotWrapper.getTimeSlot(), removedAttendee);
            try {
                this.signupMeetingService.sendCancellationEmail(signup.getSignupEventTrackingInfo());
            }
            catch (Exception e) {
                this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
            }
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        if (Utilities.getSignupMeetingsBean().isShowMyAppointmentTime()) {
            Utilities.resetMeetingList();
        }
        return this.updateMeetingwrapper(meeting, "meeting");
    }

    public String attendeeAddToWaitingList() {
        this.timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        SignupMeeting meeting = null;
        try {
            AddWaiter addWaiter = new AddWaiter(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), "toBbottomOfList", false);
            SignupAttendee newWaiter = new SignupAttendee();
            newWaiter.setAttendeeUserId(this.sakaiFacade.getCurrentUserId());
            newWaiter.setSignupSiteId(this.sakaiFacade.getCurrentLocationId());
            meeting = addWaiter.addToWaitingList(this.meetingWrapper.getMeeting(), this.timeslotWrapper.getTimeSlot(), newWaiter);
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "meeting");
    }

    public String attendeeRemoveFromWaitingList() {
        this.timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        SignupMeeting meeting = null;
        try {
            RemoveWaiter removeWaiter = new RemoveWaiter(this.signupMeetingService, this.currentUserId(), this.currentSiteId(), "toBbottomOfList", false);
            SignupAttendee newWaiter = new SignupAttendee(this.currentUserId(), this.currentSiteId());
            meeting = removeWaiter.removeFromWaitingList(this.meetingWrapper.getMeeting(), this.timeslotWrapper.getTimeSlot(), newWaiter);
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
        return this.updateMeetingwrapper(meeting, "meeting");
    }

    public UIData getTimeslotWrapperTable() {
        return this.timeslotWrapperTable;
    }

    public void setTimeslotWrapperTable(UIData timeslotWrapperTable) {
        this.timeslotWrapperTable = timeslotWrapperTable;
    }

    private String currentUserId() {
        if (this.currentUserId == null) {
            this.currentUserId = this.sakaiFacade.getCurrentUserId();
        }
        return this.currentUserId;
    }

    private String currentSiteId() {
        if (this.currentSiteId == null) {
            this.currentSiteId = this.sakaiFacade.getCurrentLocationId();
        }
        return this.currentSiteId;
    }

    public boolean isCollapsedMeetingInfo() {
        return this.collapsedMeetingInfo;
    }

    public void setCollapsedMeetingInfo(boolean collapsedMeetingInfo) {
        this.collapsedMeetingInfo = collapsedMeetingInfo;
    }

    public String getIframeId() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String iFrameId = (String)request.getAttribute("sakai.tool.placement.id");
        return iFrameId;
    }

    public String getCurUserDisplayName() {
        return this.getSakaiFacade().getUserDisplayName(this.currentUserId());
    }

    public void downloadICSForTimeslot() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        this.downloadICSForMeetingTimeSlot(timeslotWrapper);
    }
}

