/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupUIBaseBean;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.organizer.OrganizerSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.UserDefineTimeslotBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.EditMeeting;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;

public class EditMeetingSignupMBean
extends SignupUIBaseBean {
    private SignupMeeting signupMeeting;
    private int maxNumOfAttendees;
    private boolean showAttendeeName;
    private String selectedLocation;
    private String selectedCategory;
    private String creatorUserId;
    private int durationOfTslot;
    private boolean unlimited;
    private int totalEventDuration;
    private int timeSlotDuration;
    private int numberOfSlots;
    private SignupMeeting originalMeetingCopy;
    private List<SignupAttachment> readyToModifyAttachmentCopyList;
    private boolean intentionToModfyAttachment;
    private String signupBeginsType;
    private int signupBegins;
    private String deadlineTimeType;
    private int deadlineTime;
    private EditMeeting editMeeting;
    private boolean convertToNoRecurrent;
    private List<SelectItem> meetingTypeRadioBttns;
    private boolean validationError;
    private boolean someoneSignedUp;
    private boolean autoReminderOptionChoice = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.autoRiminder.option.choice.setting", (String)"true"));
    private boolean userIdInputModeOptionChoice = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.userId.inputMode.choiceOption.setting", (String)"true"));
    private UserDefineTimeslotBean userDefineTimeslotBean;
    private List<TimeslotWrapper> customTimeSlotWrpList;
    private boolean userDefinedTS = false;
    List<SelectItem> slots;
    List<SignupUser> allPossibleCoordinators;
    private boolean sendEmailByOwner;
    private List<SelectItem> categories = null;
    private List<SelectItem> locations = null;
    private int copyDisplaySignupBegins;
    private String copyDisplaySignupBeginsType;
    private int originalSignupBegins;
    private String originalSignupBeginsType;

    public void reset() {
        this.maxNumOfAttendees = 0;
        this.showAttendeeName = false;
        this.sendEmail = DEFAULT_SEND_EMAIL;
        this.sendEmailToSelectedPeopleOnly = "organizers_only";
        this.unlimited = false;
        this.editMeeting = null;
        this.convertToNoRecurrent = false;
        this.signupMeeting = this.reloadMeeting(this.meetingWrapper.getMeeting());
        this.sendEmail = this.signupMeeting.isSendEmailByOwner();
        this.sendEmailByOwner = this.signupMeeting.isSendEmailByOwner();
        this.originalMeetingCopy = this.reloadMeeting(this.meetingWrapper.getMeeting());
        this.publishToCalendar = this.getOriginalMeetingCalendarPublishInfo(this.signupMeeting);
        this.cleanUpUnusedAttachmentCopies(this.readyToModifyAttachmentCopyList);
        this.readyToModifyAttachmentCopyList = this.createTempAttachmentCopies(this.meetingWrapper.getEventMainAttachments());
        this.intentionToModfyAttachment = false;
        List signupTimeSlots = this.getSignupMeeting().getSignupTimeSlots();
        if (signupTimeSlots != null && !signupTimeSlots.isEmpty()) {
            SignupTimeslot ts = (SignupTimeslot)signupTimeSlots.get(0);
            this.maxNumOfAttendees = ts.getMaxNoOfAttendees();
            this.unlimited = ts.isUnlimitedAttendee();
            this.showAttendeeName = ts.isDisplayAttendees();
            this.numberOfSlots = signupTimeSlots.size();
        } else {
            this.setNumberOfSlots(1);
        }
        this.populateDataForBeginDeadline(this.signupMeeting);
        this.someoneSignedUp = this.initSomeoneSignupInfo();
        this.customTimeSlotWrpList = null;
        this.userDefinedTS = false;
        this.updateTimeSlotWrappers(this.meetingWrapper);
        if ("custom_ts".equals(this.signupMeeting.getMeetingType())) {
            this.userDefinedTS = true;
            this.customTimeSlotWrpList = this.getTimeslotWrappers();
            this.markerTimeslots(this.customTimeSlotWrpList);
        }
        this.getUserDefineTimeslotBean().init(this.signupMeeting, "modifyMeeting", this.customTimeSlotWrpList, "modify_meeting");
        this.populateDropDown();
        this.creatorUserId = this.signupMeeting.getCreatorUserId();
        this.selectedLocation = this.signupMeeting.getLocation();
        this.selectedCategory = this.signupMeeting.getCategory();
        this.customLocation = "";
        this.customCategory = "";
        this.categories = null;
        this.locations = null;
        this.allPossibleCoordinators = this.sakaiFacade.getAllPossbileCoordinatorsOnFastTrack(this.signupMeeting);
        this.populateExistingCoordinators();
    }

    private void populateDataForBeginDeadline(SignupMeeting sMeeting) {
        long signupBeginsTime = sMeeting.getSignupBegins() == null ? new Date().getTime() : sMeeting.getSignupBegins().getTime();
        long signupDeadline = sMeeting.getSignupDeadline() == null ? new Date().getTime() : sMeeting.getSignupDeadline().getTime();
        long signupBeginBeforMeeting = (sMeeting.getStartTime().getTime() - signupBeginsTime) / 60000L;
        long signupDeadLineBeforMeetingEnd = (sMeeting.getEndTime().getTime() - signupDeadline) / 60000L;
        this.signupBeginsType = Utilities.getTimeScaleType((long)signupBeginBeforMeeting);
        this.signupBegins = Utilities.getRelativeTimeValue((String)this.signupBeginsType, (long)signupBeginBeforMeeting);
        this.deadlineTimeType = Utilities.getTimeScaleType((long)signupDeadLineBeforMeetingEnd);
        this.deadlineTime = Utilities.getRelativeTimeValue((String)this.deadlineTimeType, (long)signupDeadLineBeforMeetingEnd);
        this.originalSignupBegins = this.signupBegins;
        this.originalSignupBeginsType = this.signupBeginsType;
        if (this.signupBegins < 0) {
            this.signupBegins = 0;
        }
        if ("minutes".equals(this.signupBeginsType) && sMeeting.getSignupBegins().before(new Date()) && this.signupBegins > 500) {
            this.signupBeginsType = "days";
            this.signupBegins = Utilities.getRelativeTimeValue((String)"days", (long)signupBeginBeforMeeting);
            if (this.signupBegins == 0) {
                this.signupBegins = 1;
            }
        }
        this.copyDisplaySignupBegins = this.signupBegins;
        this.copyDisplaySignupBeginsType = this.signupBeginsType;
    }

    void populateDropDown() {
        this.slots = new ArrayList();
        for (int i = 1; i <= this.numberOfSlots; ++i) {
            this.slots.add(new SelectItem((Object)i, i + ""));
        }
    }

    boolean hasUserChangedSignupBeginTime() {
        return this.copyDisplaySignupBegins != this.getSignupBegins() || !this.getSignupBeginsType().equals(this.copyDisplaySignupBeginsType);
    }

    private boolean initSomeoneSignupInfo() {
        boolean someoneSignedUp = false;
        if (this.signupMeeting.isRecurredMeeting()) {
            List recurringMeetings = this.signupMeetingService.getRecurringSignupMeetings(this.sakaiFacade.getCurrentLocationId(), this.sakaiFacade.getCurrentUserId(), this.signupMeeting.getRecurrenceId(), new Date());
            for (SignupMeeting sm : recurringMeetings) {
                if (!this.hasAttendeeInMeeting(sm)) continue;
                return true;
            }
        }
        someoneSignedUp = this.hasAttendeeInMeeting(this.signupMeeting);
        return someoneSignedUp;
    }

    private boolean hasAttendeeInMeeting(SignupMeeting sm) {
        List tsItems = sm.getSignupTimeSlots();
        if (tsItems != null) {
            for (SignupTimeslot ts : tsItems) {
                List attendees = ts.getAttendees();
                if (attendees == null || attendees.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getOriginalMeetingCalendarPublishInfo(SignupMeeting sm) {
        this.publishToCalendar = DEFAULT_EXPORT_TO_CALENDAR_TOOL;
        List sites = sm.getSignupSites();
        if (sites != null && !sites.isEmpty()) {
            for (SignupSite s : sites) {
                if (s.getCalendarEventId() != null) {
                    return true;
                }
                List grps = s.getSignupGroups();
                if (grps == null || grps.isEmpty()) continue;
                for (SignupGroup g : grps) {
                    if (g.getCalendarEventId() == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String doCancelAction() {
        this.cleanUpUnusedAttachmentCopies(this.readyToModifyAttachmentCopyList);
        this.getUserDefineTimeslotBean().reset("modify_meeting");
        return "organizerMeeting";
    }

    public String addRemoveAttachments() {
        this.intentionToModfyAttachment = true;
        this.getAttachmentHandler().processAddAttachRedirect(this.readyToModifyAttachmentCopyList, this.signupMeeting, true);
        return null;
    }

    private List<SignupAttachment> createTempAttachmentCopies(List<SignupAttachment> attachList) {
        ArrayList<SignupAttachment> tempList = new ArrayList<SignupAttachment>();
        if (attachList != null) {
            for (SignupAttachment attach : attachList) {
                tempList.add(this.getAttachmentHandler().copySignupAttachment(this.signupMeeting, true, attach, "tmp"));
            }
        }
        return tempList;
    }

    public String processSaveModify() {
        if (this.validationError) {
            this.validationError = false;
            return "modifyMeeting";
        }
        try {
            double duration;
            SignupMeeting meeting = this.getSignupMeeting();
            EditMeeting editMeeting = new EditMeeting(this.getSakaiFacade().getCurrentUserId(), this.getSakaiFacade().getCurrentLocationId(), this.getSignupMeetingService(), this.getAttachmentHandler(), true);
            editMeeting.setCurrentNumberOfSlots(this.getNumberOfSlots());
            if (this.hasUserChangedSignupBeginTime()) {
                editMeeting.setSignupBegins(this.getSignupBegins());
                editMeeting.setSignupBeginsType(this.getSignupBeginsType());
                editMeeting.setSignupBeginModifiedByUser(true);
            } else {
                editMeeting.setSignupBegins(this.originalSignupBegins);
                editMeeting.setSignupBeginsType(this.originalSignupBeginsType);
                editMeeting.setSignupBeginModifiedByUser(false);
            }
            editMeeting.setDeadlineTime(this.getDeadlineTime());
            editMeeting.setDeadlineTimeType(this.getDeadlineTimeType());
            editMeeting.setTimeSlotDuration(this.getTimeSlotDuration());
            editMeeting.setMaxNumOfAttendees(this.getMaxNumOfAttendees());
            editMeeting.setShowAttendeeName(this.isShowAttendeeName());
            editMeeting.setOriginalMeetingCopy(this.originalMeetingCopy);
            editMeeting.setUnlimited(this.isUnlimited());
            editMeeting.setSendEmailByOwner(this.isSendEmailByOwner());
            editMeeting.setCoordinators(Utilities.getSelectedCoordinators((List)this.allPossibleCoordinators, (String)this.creatorUserId));
            editMeeting.setConvertToNoRecurrent(this.convertToNoRecurrent);
            editMeeting.setSakaiFacade(this.getSakaiFacade());
            editMeeting.setCreateGroups(meeting.isCreateGroups());
            if (this.isUserDefinedTS()) {
                if (this.customTimeSlotWrpList != null) {
                    editMeeting.setUserDefinedTS(true);
                    editMeeting.setUserDefineTimeslotBean(this.getUserDefineTimeslotBean());
                    editMeeting.setCustomTimeSlotWrpList(this.getUserDefineTimeslotBean().getDestTSwrpList());
                } else {
                    editMeeting.setUserDefinedTS(false);
                }
            }
            if (!this.areAttachmentChanges()) {
                editMeeting.setCurrentAttachList(null);
            } else {
                editMeeting.setCurrentAttachList(this.readyToModifyAttachmentCopyList);
            }
            editMeeting.saveModifiedMeeting(meeting);
            if (this.getIndividualType() && this.getNumberOfSlots() != 0 && (duration = (double)(this.getSignupMeeting().getEndTime().getTime() - this.getSignupMeeting().getStartTime().getTime()) / (double)(60000 * this.getNumberOfSlots())) != Math.floor(duration)) {
                Utilities.addErrorMessage((String)Utilities.rb.getString("event_endtime_auto_adjusted_warning"));
            }
            List successUpdatedMeetings = editMeeting.getSavedMeetings();
            Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_MTNG_MODIFY, (String)(ToolManager.getCurrentPlacement().getContext() + " title: " + meeting.getTitle()));
            if (meeting.getRecurrenceId() != null) {
                Utilities.resetMeetingList();
            }
            if (this.sendEmail) {
                try {
                    SignupMeeting sm = (SignupMeeting)successUpdatedMeetings.get(0);
                    sm.setSendEmailToSelectedPeopleOnly(this.getSendEmailToSelectedPeopleOnly());
                    this.signupMeetingService.sendEmail(sm, "signup.email.meeting.modified");
                    if (((SignupMeeting)successUpdatedMeetings.get(0)).getRecurrenceId() == null) {
                        this.signupMeetingService.sendEmailToParticipantsByOrganizerAction(editMeeting.getSignupEventTrackingInfo());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                    Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
                }
            }
            if (this.isPublishToCalendar()) {
                for (SignupMeeting savedMeeting : successUpdatedMeetings) {
                    try {
                        if ("custom_ts".equals(savedMeeting.getMeetingType())) {
                            boolean multipleCalBlocks = this.getUserDefineTimeslotBean().getPutInMultipleCalendarBlocks();
                            savedMeeting.setInMultipleCalendarBlocks(multipleCalBlocks);
                        }
                        this.signupMeetingService.modifyCalendar(savedMeeting);
                    }
                    catch (PermissionException pe) {
                        Utilities.addErrorMessage((String)Utilities.rb.getString("error.calendarEvent.updated_failed_due_to_permission"));
                        this.logger.debug((Object)(Utilities.rb.getString("error.calendarEvent.updated_failed_due_to_permission") + " - Meeting title:" + savedMeeting.getTitle()));
                    }
                    catch (Exception e) {
                        Utilities.addErrorMessage((String)Utilities.rb.getString("error.calendarEvent.updated_failed"));
                        this.logger.warn((Object)(Utilities.rb.getString("error.calendarEvent.updated_failed") + " - Meeting title:" + savedMeeting.getTitle()));
                    }
                }
            } else {
                this.signupMeetingService.removeCalendarEventsOnModifiedMeeting(successUpdatedMeetings);
            }
        }
        catch (PermissionException pe) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("no.permissoin.do_it"));
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        catch (Exception e) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("db.error_or_event.notExisted"));
            this.logger.error((Object)(Utilities.rb.getString("db.error_or_event.notExisted") + " - " + e.getClass() + ":" + e.getMessage()));
            Utilities.resetMeetingList();
            return "listMeetings";
        }
        this.reloadMeetingWrapperInOrganizerPage();
        this.cleanUpUnusedAttachmentCopies(this.readyToModifyAttachmentCopyList);
        this.getUserDefineTimeslotBean().reset("modify_meeting");
        return "organizerMeeting";
    }

    private boolean areAttachmentChanges() {
        List origList = this.originalMeetingCopy.getSignupAttachments();
        if (!this.intentionToModfyAttachment) {
            return false;
        }
        if ((this.readyToModifyAttachmentCopyList != null && !this.readyToModifyAttachmentCopyList.isEmpty()) == (origList == null || origList.isEmpty())) {
            return true;
        }
        if (this.readyToModifyAttachmentCopyList.size() != origList.size()) {
            return true;
        }
        for (SignupAttachment tempOne : this.readyToModifyAttachmentCopyList) {
            boolean found = false;
            for (SignupAttachment orig : origList) {
                String resourceId = orig.getResourceId();
                int index = resourceId.lastIndexOf("/");
                if (index > -1) {
                    resourceId = resourceId.substring(0, index + 1) + "tmp" + "/" + resourceId.substring(index + 1, resourceId.length());
                }
                if (!resourceId.equals(tempOne.getResourceId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private void reloadMeetingWrapperInOrganizerPage() {
        OrganizerSignupMBean bean = (OrganizerSignupMBean)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("OrganizerSignupMBean");
        SignupMeeting meeting = this.reloadMeeting(this.meetingWrapper.getMeeting());
        this.meetingWrapper.setMeeting(meeting);
        this.meetingWrapper.setCreator(this.sakaiFacade.getUserDisplayName(meeting.getCreatorUserId()));
        bean.reset(this.meetingWrapper);
    }

    private SignupMeeting reloadMeeting(SignupMeeting meeting) {
        return this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId());
    }

    public void validateModifyMeeting(ActionEvent e) {
        Date eventEndTime = this.signupMeeting.getEndTime();
        Date eventStartTime = this.signupMeeting.getStartTime();
        if (this.isUserDefinedTS()) {
            eventEndTime = this.getUserDefineTimeslotBean().getEventEndTime();
            eventStartTime = this.getUserDefineTimeslotBean().getEventStartTime();
            if (this.getUserDefineTimeslotBean().getDestTSwrpList() == null || this.getUserDefineTimeslotBean().getDestTSwrpList().isEmpty()) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.create_custom_defined_TS_blocks"));
                return;
            }
        }
        if (eventEndTime.before(eventStartTime) || eventStartTime.equals(eventEndTime)) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("event.endTime_should_after_startTime"));
            return;
        }
        if (!this.validationError && this.isUserDefinedTS()) {
            this.signupMeeting.setStartTime(eventStartTime);
            this.signupMeeting.setEndTime(eventEndTime);
            this.signupMeeting.setMeetingType("custom_ts");
        }
        if (("daily".equals(this.signupMeeting.getRepeatType()) || "wkdays_mon-fri".equals(this.signupMeeting.getRepeatType())) && this.isMeetingOverRepeatPeriod(this.signupMeeting.getStartTime(), this.signupMeeting.getEndTime(), 1)) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.daily.problem"));
            return;
        }
        if ("weekly".equals(this.signupMeeting.getRepeatType()) && this.isMeetingOverRepeatPeriod(this.signupMeeting.getStartTime(), this.signupMeeting.getEndTime(), 7)) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.weekly.problem"));
            return;
        }
        if ("biweekly".equals(this.signupMeeting.getRepeatType()) && this.isMeetingOverRepeatPeriod(this.signupMeeting.getStartTime(), this.signupMeeting.getEndTime(), 14)) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.biweekly.problem"));
            return;
        }
        int timeduration = this.getTimeSlotDuration();
        if (timeduration < 1) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("event.timeslot_duration_should_not_lessThan_one"));
            return;
        }
        if (StringUtils.isBlank((String)this.getCustomLocation())) {
            if (StringUtils.isBlank((String)this.selectedLocation) || this.selectedLocation.equals(Utilities.rb.getString("select_location"))) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.location_not_assigned"));
                return;
            }
            this.signupMeeting.setLocation(this.selectedLocation);
        } else {
            this.signupMeeting.setLocation(this.getCustomLocation());
        }
        this.selectedLocation = "";
        if (StringUtils.isBlank((String)this.getCustomCategory())) {
            if (!StringUtils.equals((String)this.selectedCategory, (String)Utilities.rb.getString("select_category"))) {
                this.signupMeeting.setCategory(this.selectedCategory);
            }
        } else {
            this.signupMeeting.setCategory(this.getCustomCategory());
        }
        this.selectedCategory = "";
        this.signupMeeting.setCreatorUserId(this.creatorUserId);
        this.creatorUserId = "";
    }

    public String editUserDefTimeSlots() {
        if (this.customTimeSlotWrpList == null) {
            this.customTimeSlotWrpList = this.getTimeslotWrappers();
            this.markerTimeslots(this.customTimeSlotWrpList);
            this.getUserDefineTimeslotBean().init(this.signupMeeting, "modifyMeeting", this.customTimeSlotWrpList, "modify_meeting");
        } else {
            if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"modify_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
                return "organizerMeeting";
            }
            this.customTimeSlotWrpList = this.getUserDefineTimeslotBean().getDestTSwrpList();
            this.getUserDefineTimeslotBean().init(this.signupMeeting, "modifyMeeting", this.customTimeSlotWrpList, "modify_meeting");
        }
        return "userDefinedTsBlocks";
    }

    public SignupMeetingWrapper getMeetingWrapper() {
        return this.meetingWrapper;
    }

    public boolean isShowAttendeeName() {
        return this.showAttendeeName;
    }

    public void setShowAttendeeName(boolean showAttendeeName) {
        this.showAttendeeName = showAttendeeName;
    }

    public int getMaxNumOfAttendees() {
        return this.maxNumOfAttendees;
    }

    public void setMaxNumOfAttendees(int maxNumOfAttendees) {
        this.maxNumOfAttendees = maxNumOfAttendees;
    }

    public SignupMeeting getSignupMeeting() {
        return this.signupMeeting;
    }

    public void setSignupMeeting(SignupMeeting signupMeeting) {
        this.signupMeeting = signupMeeting;
    }

    public List<SelectItem> getAllLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList();
            this.locations.addAll(Utilities.getSignupMeetingsBean().getAllLocations());
            this.locations.add(0, new SelectItem((Object)Utilities.rb.getString("select_location")));
        }
        return this.locations;
    }

    public List<SelectItem> getAllCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList();
            this.categories.addAll(Utilities.getSignupMeetingsBean().getAllCategories());
            this.categories.remove(0);
            this.categories.add(0, new SelectItem((Object)Utilities.rb.getString("select_category")));
        }
        return this.categories;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public String getselectedLocation() {
        return this.selectedLocation;
    }

    public void setselectedLocation(String selectedLocation) {
        this.selectedLocation = selectedLocation;
    }

    public String getselectedCategory() {
        return this.selectedCategory;
    }

    public void setselectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public String getcreatorUserId() {
        return this.creatorUserId;
    }

    public void setcreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public int getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(int deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineTimeType() {
        return this.deadlineTimeType;
    }

    public void setDeadlineTimeType(String deadlineTimeType) {
        this.deadlineTimeType = deadlineTimeType;
    }

    public int getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(int signupBegins) {
        this.signupBegins = signupBegins;
    }

    public String getSignupBeginsType() {
        return this.signupBeginsType;
    }

    public void setSignupBeginsType(String signupBeginsType) {
        this.signupBeginsType = signupBeginsType;
    }

    public boolean isConvertToNoRecurrent() {
        return this.convertToNoRecurrent;
    }

    public void setConvertToNoRecurrent(boolean convertToNoRecurrent) {
        this.convertToNoRecurrent = convertToNoRecurrent;
    }

    public int getTimeSlotDuration() {
        long duration = (this.getSignupMeeting().getEndTime().getTime() - this.getSignupMeeting().getStartTime().getTime()) / (long)(60000 * this.getNumberOfSlots());
        return (int)duration;
    }

    public void setTimeSlotDuration(int timeSlotDuration) {
        this.timeSlotDuration = timeSlotDuration;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public List<SelectItem> getMeetingTypeRadioBttns() {
        this.meetingTypeRadioBttns = Utilities.getMeetingTypeSelectItems((String)this.getSignupMeeting().getMeetingType(), (boolean)true);
        return this.meetingTypeRadioBttns;
    }

    public boolean isValidationError() {
        return this.validationError;
    }

    public void setValidationError(boolean validationError) {
        this.validationError = validationError;
    }

    public boolean getAutoReminderOptionChoice() {
        return this.autoReminderOptionChoice;
    }

    public void setAutoReminderOptionChoice(boolean autoReminderOptionChoice) {
        this.autoReminderOptionChoice = autoReminderOptionChoice;
    }

    public boolean getUserIdInputModeOptionChoice() {
        return this.userIdInputModeOptionChoice;
    }

    public void setUserIdInputModeOptionChoice(boolean userIdInputModeOptionChoice) {
        this.userIdInputModeOptionChoice = userIdInputModeOptionChoice;
    }

    public boolean getSignupAttachmentEmpty() {
        return this.readyToModifyAttachmentCopyList == null || this.readyToModifyAttachmentCopyList.isEmpty();
    }

    public List<SignupAttachment> getTempAttachmentCopyList() {
        return this.readyToModifyAttachmentCopyList;
    }

    public boolean getSomeoneSignedUp() {
        return this.someoneSignedUp;
    }

    public boolean getCustomTsType() {
        return "custom_ts".equals(this.originalMeetingCopy.getMeetingType());
    }

    public UserDefineTimeslotBean getUserDefineTimeslotBean() {
        return this.userDefineTimeslotBean;
    }

    public void setUserDefineTimeslotBean(UserDefineTimeslotBean userDefineTimeslotBean) {
        this.userDefineTimeslotBean = userDefineTimeslotBean;
    }

    public List<TimeslotWrapper> getCustomTimeSlotWrpList() {
        return this.customTimeSlotWrpList;
    }

    public void setCustomTimeSlotWrpList(List<TimeslotWrapper> customTimeSlotWrpList) {
        this.customTimeSlotWrpList = customTimeSlotWrpList;
    }

    public boolean isUserDefinedTS() {
        return this.userDefinedTS;
    }

    public void setUserDefinedTS(boolean userDefinedTS) {
        this.userDefinedTS = userDefinedTS;
    }

    public boolean isAttendanceOn() {
        return Utilities.getSignupMeetingsBean().isAttendanceOn();
    }

    public List<SelectItem> getInstructors() {
        return Utilities.getSignupMeetingsBean().getInstructors(this.signupMeeting);
    }

    public List<SelectItem> getSlots() {
        return this.slots;
    }

    public void setSlots(List<SelectItem> slots) {
        this.slots = slots;
    }

    public List<SignupUser> getAllPossibleCoordinators() {
        return this.allPossibleCoordinators;
    }

    public void setAllPossibleCoordinators(List<SignupUser> allPossibleCoordinators) {
        this.allPossibleCoordinators = allPossibleCoordinators;
    }

    private void populateExistingCoordinators() {
        List existingCoUserIds = this.getExistingCoordinatorIds(this.signupMeeting);
        for (SignupUser coord : this.allPossibleCoordinators) {
            if (!existingCoUserIds.contains(coord.getInternalUserId())) continue;
            coord.setChecked(true);
        }
    }

    private List<String> getExistingCoordinatorIds(SignupMeeting meeting) {
        ArrayList<String> coUsers = new ArrayList<String>();
        String coUserIdsString = meeting.getCoordinatorIds();
        if (coUserIdsString != null && coUserIdsString.trim().length() > 0) {
            StringTokenizer userIdTokens = new StringTokenizer(coUserIdsString, "|");
            while (userIdTokens.hasMoreTokens()) {
                String uId = userIdTokens.nextToken();
                coUsers.add(uId);
            }
        }
        return coUsers;
    }

    public boolean isSendEmailByOwner() {
        return this.sendEmailByOwner;
    }

    public void setSendEmailByOwner(boolean sendEmailByOwner) {
        this.sendEmailByOwner = sendEmailByOwner;
    }
}

