/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.attachment.AttachmentHandler;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;

public class CreateMeetings
extends SignupAction
implements MeetingTypes,
SignupMessageTypes,
SignupBeanConstants {
    private SignupMeeting signupMeeting;
    List<SignupMeeting> signupMeetings;
    private boolean sendEmail;
    private String sendEmailToSelectedPeopleOnly;
    private final SakaiFacade sakaiFacade;
    private AttachmentHandler attachmentHandler;
    private boolean assignParticitpantsToAllEvents;
    private boolean assignParticatpantsToFirstOne;
    private String signupBeginsType;
    private int signupBegins;
    private String deadlineTimeType;
    private int deadlineTime;
    private int signupBegin;
    private String signupBeginType;
    private String recurLengthDataType;
    private boolean publishToCalendar = true;
    private boolean createGroups;

    public CreateMeetings(SignupMeeting signupMeeting, boolean sendEmail, boolean assignParticatpantsToFirstOne, boolean assignParicitpantsToAllEvents, int signupBegin, String signupBeginType, int signupDeadline, String signupDeadlineType, String recurLengthDataType, SakaiFacade sakaiFacade, SignupMeetingService signupMeetingService, AttachmentHandler attachmentHandler, String currentUserId, String currentSiteId, boolean isOrganizer) {
        super(currentUserId, currentSiteId, signupMeetingService, isOrganizer);
        this.signupMeeting = signupMeeting;
        this.sendEmail = sendEmail;
        this.sendEmailToSelectedPeopleOnly = signupMeeting.getSendEmailToSelectedPeopleOnly();
        this.assignParticatpantsToFirstOne = assignParticatpantsToFirstOne;
        this.assignParticitpantsToAllEvents = assignParicitpantsToAllEvents;
        this.signupBegin = signupBegin;
        this.signupBeginType = signupBeginType;
        this.deadlineTime = signupDeadline;
        this.deadlineTimeType = signupDeadlineType;
        this.recurLengthDataType = recurLengthDataType;
        this.sakaiFacade = sakaiFacade;
        this.signupMeetings = new ArrayList();
        this.attachmentHandler = attachmentHandler;
    }

    public CreateMeetings(SignupMeeting signupMeeting, boolean sendEmail, boolean assignParticatpantsToFirstOne, boolean assignParicitpantsToAllEvents, SakaiFacade sakaiFacade, SignupMeetingService signupMeetingService, String currentUserId) {
        super(currentUserId, currentUserId, signupMeetingService, assignParicitpantsToAllEvents);
        this.signupMeeting = signupMeeting;
        this.sendEmail = sendEmail;
        this.assignParticatpantsToFirstOne = assignParticatpantsToFirstOne;
        this.assignParticitpantsToAllEvents = assignParicitpantsToAllEvents;
        this.sakaiFacade = sakaiFacade;
    }

    public void processSaveMeetings() throws Exception {
        Calendar calendar = Calendar.getInstance();
        int numOfRecurs = 0;
        if (!"no_repeat".equals(this.signupMeeting.getRepeatType())) {
            numOfRecurs = this.signupMeeting.getRepeatNum();
        }
        calendar.setLenient(true);
        calendar.setTime(this.signupMeeting.getStartTime());
        if ("daily".equals(this.signupMeeting.getRepeatType())) {
            this.createRecurMeetings(calendar, (long)numOfRecurs, 1);
        } else if ("wkdays_mon-fri".equals(this.signupMeeting.getRepeatType())) {
            this.createRecurMeetings(calendar, (long)numOfRecurs, 1);
            this.removeWeekendDays();
        } else if ("weekly".equals(this.signupMeeting.getRepeatType())) {
            this.createRecurMeetings(calendar, (long)numOfRecurs, 7);
        } else if ("biweekly".equals(this.signupMeeting.getRepeatType())) {
            this.createRecurMeetings(calendar, (long)numOfRecurs, 14);
        } else {
            this.createRecurMeetings(calendar, (long)numOfRecurs, 0);
        }
        this.postMeetings(this.signupMeetings);
    }

    public static int getNumOfRecurrence(String recurType, Date effectiveDate, Date untilDate) {
        int numOfRecurs = 0;
        long firstMeetingEndTime = effectiveDate.getTime();
        int availDaysForRepeat = 0;
        Calendar untilCal = Calendar.getInstance();
        untilCal.setTime(untilDate);
        untilCal.set(11, 23);
        untilCal.set(12, 59);
        untilCal.set(13, 59);
        availDaysForRepeat = (int)((untilCal.getTimeInMillis() - firstMeetingEndTime) / 86400000L);
        if ("daily".equals(recurType) || "wkdays_mon-fri".equals(recurType)) {
            numOfRecurs = availDaysForRepeat / 1;
        } else if ("weekly".equals(recurType)) {
            numOfRecurs = availDaysForRepeat / 7;
        } else if ("biweekly".equals(recurType)) {
            numOfRecurs = availDaysForRepeat / 14;
        }
        if ("wkdays_mon-fri".equals(recurType) && numOfRecurs < 2) {
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(effectiveDate);
            int dayname = startCal.get(7);
            if (dayname == 7) {
                numOfRecurs = 0;
            }
        }
        return numOfRecurs;
    }

    private void createRecurMeetings(Calendar calendar, long numOfRecurs, int intervalOfRecurs) {
        if (!"no_repeat".equals(this.signupMeeting.getRepeatType()) && numOfRecurs < 1L) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("event.repeatbeforestart"));
            return;
        }
        if (!"no_repeat".equals(this.signupMeeting.getRepeatType()) && "0".equals(this.recurLengthDataType)) {
            --numOfRecurs;
        }
        int i = 0;
        while ((long)i <= numOfRecurs) {
            int dayOfweek;
            SignupMeeting beta = new SignupMeeting();
            beta = this.prepareDeepCopy(this.signupMeeting, i * intervalOfRecurs);
            calendar.setTime(this.signupMeeting.getStartTime());
            int sday = calendar.get(5) + i * intervalOfRecurs;
            calendar.set(5, sday);
            beta.setStartTime(calendar.getTime());
            int makeupOnceDueToWeekend = 0;
            if ("wkdays_mon-fri".equals(this.signupMeeting.getRepeatType()) && "0".equals(this.recurLengthDataType) && ((dayOfweek = calendar.get(7)) == 7 || dayOfweek == 1)) {
                makeupOnceDueToWeekend = 1;
            }
            calendar.setTime(this.signupMeeting.getEndTime());
            int eday = calendar.get(5) + i * intervalOfRecurs;
            calendar.set(5, eday);
            beta.setEndTime(calendar.getTime());
            calendar.setTime(this.signupMeeting.getSignupBegins());
            int sdday = calendar.get(5) + i * intervalOfRecurs;
            calendar.set(5, sdday);
            if ("startNow".equals(this.signupBeginType)) {
                beta.setSignupBegins(Utilities.subTractTimeToDate((Date)new Date(), (int)6, (String)"startNow"));
            } else {
                beta.setSignupBegins(calendar.getTime());
            }
            calendar.setTime(this.signupMeeting.getSignupDeadline());
            int edday = calendar.get(5) + i * intervalOfRecurs;
            calendar.set(5, edday);
            beta.setSignupDeadline(calendar.getTime());
            beta.setSignupAttachments(this.copyAttachments(this.signupMeeting, numOfRecurs, i));
            beta.setInMultipleCalendarBlocks(this.signupMeeting.isInMultipleCalendarBlocks());
            if (this.assignParticatpantsToFirstOne) {
                this.assignParticitpantsToAllEvents = false;
                this.assignParticatpantsToFirstOne = false;
            }
            this.signupMeetings.add(beta);
            numOfRecurs += (long)makeupOnceDueToWeekend;
            ++i;
        }
    }

    private void removeWeekendDays() {
        if (this.signupMeetings != null && !this.signupMeetings.isEmpty()) {
            for (int i = this.signupMeetings.size() - 1; i >= 0; --i) {
                SignupMeeting sm = (SignupMeeting)this.signupMeetings.get(i);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(sm.getStartTime());
                int dayOfweek = startCal.get(7);
                if (dayOfweek != 7 && dayOfweek != 1) continue;
                this.signupMeetings.remove(i);
            }
        }
    }

    private List<SignupAttachment> copyAttachments(SignupMeeting sm, long numOfRecurs, int index) {
        if (numOfRecurs == 0L) {
            List attachs = sm.getSignupAttachments();
            if (attachs != null) {
                for (SignupAttachment attach : attachs) {
                    this.attachmentHandler.determineAndAssignPublicView(sm, attach);
                }
            }
            return sm.getSignupAttachments();
        }
        ArrayList<SignupAttachment> newOnes = new ArrayList<SignupAttachment>();
        List olds = sm.getSignupAttachments();
        if (olds != null) {
            for (SignupAttachment old : olds) {
                SignupAttachment newOne = this.attachmentHandler.copySignupAttachment(sm, true, old, "recur" + index);
                newOne.setTimeslotId(old.getTimeslotId());
                newOne.setViewByAll(old.getViewByAll());
                newOnes.add(newOne);
            }
        }
        return newOnes;
    }

    private void postMeetings(List<SignupMeeting> signupMeetings) throws PermissionException, Exception {
        if (this.isCreateGroups()) {
            this.logger.info((Object)"Creating groups for each timeslot ...");
            for (SignupMeeting s : signupMeetings) {
                List timeslots = s.getSignupTimeSlots();
                int index = 1;
                for (SignupTimeslot t : timeslots) {
                    String title = this.generateGroupTitle(s.getTitle(), t, index);
                    String description = this.generateGroupDescription(s.getTitle(), t);
                    List attendees = this.convertAttendeesToUuids(t.getAttendees());
                    String groupId = this.sakaiFacade.createGroup(this.sakaiFacade.getCurrentLocationId(), title, description, attendees);
                    this.logger.debug((Object)("Created group for timeslot: " + groupId));
                    t.setGroupId(groupId);
                    ++index;
                }
            }
        }
        this.signupMeetingService.saveMeetings(signupMeetings, this.sakaiFacade.getCurrentUserId());
        Utilities.resetMeetingList();
        SignupMeeting firstOne = signupMeetings.get(0);
        if (firstOne.isRecurredMeeting()) {
            Date lastRecurmeetingDate = signupMeetings.get(signupMeetings.size() - 1).getStartTime();
            firstOne.setRepeatUntil(lastRecurmeetingDate);
            firstOne.setApplyToAllRecurMeetings(this.assignParticitpantsToAllEvents);
        }
        if (this.sendEmail) {
            try {
                firstOne.setSendEmailToSelectedPeopleOnly(this.sendEmailToSelectedPeopleOnly);
                this.signupMeetingService.sendEmail(firstOne, "signup.email.new.meeting");
            }
            catch (Exception e) {
                this.logger.error((Object)(Utilities.rb.getString("email.exception") + " - " + e.getMessage()), (Throwable)e);
                Utilities.addErrorMessage((String)Utilities.rb.getString("email.exception"));
            }
        }
        if (this.isPublishToCalendar()) {
            for (int i = 0; i < signupMeetings.size(); ++i) {
                try {
                    this.signupMeetingService.postToCalendar(signupMeetings.get(i));
                    continue;
                }
                catch (PermissionException pe) {
                    Utilities.addErrorMessage((String)Utilities.rb.getString("error.calendarEvent.posted_failed_due_to_permission"));
                    this.logger.info((Object)(Utilities.rb.getString("error.calendarEvent.posted_failed_due_to_permission") + " - Meeting title:" + signupMeetings.get(i).getTitle()));
                    continue;
                }
                catch (Exception e) {
                    Utilities.addErrorMessage((String)Utilities.rb.getString("error.calendarEvent.posted_failed"));
                    this.logger.info((Object)(Utilities.rb.getString("error.calendarEvent.posted_failed") + " - Meeting title:" + signupMeetings.get(i).getTitle()));
                }
            }
        }
        String recurringInfo = firstOne.isRecurredMeeting() ? " recur_mtng" : "";
        for (int i = 0; i < signupMeetings.size(); ++i) {
            this.logger.info((Object)(recurringInfo + "title:" + signupMeetings.get(i).getTitle() + " - UserId:" + this.sakaiFacade.getCurrentUserId() + " - has created  new meeting(s) at meeting startTime:" + this.sakaiFacade.getTimeService().newTime(signupMeetings.get(i).getStartTime().getTime()).toStringLocalFull()));
            Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_MTNG_ADD, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId|title:" + signupMeetings.get(i).getId() + "|" + signupMeetings.get(i).getTitle() + " at startTime:" + this.sakaiFacade.getTimeService().newTime(signupMeetings.get(i).getStartTime().getTime()).toStringLocalFull() + recurringInfo));
        }
    }

    public SignupMeeting prepareDeepCopy(SignupMeeting s, int addDaysForRecurringLength) {
        List copySites = s.getSignupSites();
        ArrayList<SignupSite> indivSite = new ArrayList<SignupSite>();
        for (int j = 0; j < copySites.size(); ++j) {
            SignupSite ss = new SignupSite();
            ss.setSiteId(((SignupSite)copySites.get(j)).getSiteId());
            ss.setTitle(((SignupSite)copySites.get(j)).getTitle());
            ArrayList<SignupGroup> signupGroups = new ArrayList<SignupGroup>();
            if (((SignupSite)copySites.get(j)).getSignupGroups() != null) {
                for (int g = 0; g < ((SignupSite)copySites.get(j)).getSignupGroups().size(); ++g) {
                    SignupGroup newGroup = new SignupGroup();
                    newGroup.setGroupId(((SignupGroup)((SignupSite)copySites.get(j)).getSignupGroups().get(g)).getGroupId());
                    newGroup.setTitle(((SignupGroup)((SignupSite)copySites.get(j)).getSignupGroups().get(g)).getTitle());
                    signupGroups.add(newGroup);
                }
                ss.setSignupGroups(signupGroups);
            }
            indivSite.add(ss);
        }
        List origSlots = s.getSignupTimeSlots();
        ArrayList<SignupTimeslot> timeSlots = new ArrayList<SignupTimeslot>();
        if (origSlots != null && !origSlots.isEmpty()) {
            Calendar cal = Calendar.getInstance();
            for (int t = 0; t < origSlots.size(); ++t) {
                SignupTimeslot slot = new SignupTimeslot();
                slot.setMaxNoOfAttendees(((SignupTimeslot)origSlots.get(t)).getMaxNoOfAttendees());
                cal.setTime(((SignupTimeslot)origSlots.get(t)).getStartTime());
                int sday = cal.get(5) + addDaysForRecurringLength;
                cal.set(5, sday);
                slot.setStartTime(cal.getTime());
                cal.setTime(((SignupTimeslot)origSlots.get(t)).getEndTime());
                int eday = cal.get(5) + addDaysForRecurringLength;
                cal.set(5, eday);
                slot.setEndTime(cal.getTime());
                slot.setLocked(((SignupTimeslot)origSlots.get(t)).isLocked());
                slot.setCanceled(((SignupTimeslot)origSlots.get(t)).isCanceled());
                slot.setDisplayAttendees(((SignupTimeslot)origSlots.get(t)).isDisplayAttendees());
                if (this.assignParticatpantsToFirstOne || this.assignParticitpantsToAllEvents) {
                    ArrayList<SignupAttendee> attendees = new ArrayList<SignupAttendee>();
                    for (int a = 0; a < ((SignupTimeslot)origSlots.get(t)).getAttendees().size(); ++a) {
                        SignupAttendee newAttendee = new SignupAttendee();
                        newAttendee.setAttendeeUserId(((SignupAttendee)((SignupTimeslot)origSlots.get(t)).getAttendees().get(a)).getAttendeeUserId());
                        newAttendee.setSignupSiteId(((SignupAttendee)((SignupTimeslot)origSlots.get(t)).getAttendees().get(a)).getSignupSiteId());
                        attendees.add(newAttendee);
                    }
                    slot.setAttendees(attendees);
                }
                timeSlots.add(slot);
            }
        }
        SignupMeeting copy = new SignupMeeting();
        copy.setTitle(s.getTitle());
        copy.setLocation(s.getLocation());
        copy.setCategory(s.getCategory());
        copy.setDescription(s.getDescription());
        copy.setCreatorUserId(s.getCreatorUserId());
        copy.setStartTime(s.getStartTime());
        copy.setEndTime(s.getEndTime());
        copy.setMeetingType(s.getMeetingType());
        copy.setSignupTimeSlots(timeSlots);
        copy.setSignupSites(indivSite);
        Date sBegin = Utilities.subTractTimeToDate((Date)s.getStartTime(), (int)this.getSignupBegins(), (String)this.getSignupBeginsType());
        Date sDeadline = Utilities.subTractTimeToDate((Date)s.getEndTime(), (int)this.getDeadlineTime(), (String)this.getDeadlineTimeType());
        copy.setSignupBegins(sBegin);
        copy.setSignupDeadline(sDeadline);
        copy.setRepeatType(s.getRepeatType());
        copy.setRepeatUntil(s.getRepeatUntil());
        copy.setReceiveEmailByOwner(s.isReceiveEmailByOwner());
        copy.setAllowWaitList(s.isAllowWaitList());
        copy.setAllowComment(s.isAllowComment());
        copy.setAutoReminder(s.isAutoReminder());
        copy.setEidInputMode(s.isEidInputMode());
        copy.setAllowAttendance(s.isAllowAttendance());
        copy.setCreateGroups(s.isCreateGroups());
        copy.setMaxNumOfSlots(s.getMaxNumOfSlots());
        copy.setSendEmailByOwner(s.isSendEmailByOwner());
        copy.setCoordinatorIds(s.getCoordinatorIds());
        return copy;
    }

    public String getSignupBeginsType() {
        return this.signupBeginsType;
    }

    public void setSignupBeginsType(String signupBeginsType) {
        this.signupBeginsType = signupBeginsType;
    }

    public int getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(int signupBegins) {
        this.signupBegins = signupBegins;
    }

    public String getDeadlineTimeType() {
        return this.deadlineTimeType;
    }

    public void setDeadlineTimeType(String deadlineTimeType) {
        this.deadlineTimeType = deadlineTimeType;
    }

    public int getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(int deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public boolean isPublishToCalendar() {
        return this.publishToCalendar;
    }

    public void setPublishToCalendar(boolean publishToCalendar) {
        this.publishToCalendar = publishToCalendar;
    }

    public boolean isCreateGroups() {
        return this.createGroups;
    }

    public void setCreateGroups(boolean createGroups) {
        this.createGroups = createGroups;
    }
}

