/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.Date;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class LockUnlockTimeslot
extends SignupAction {
    private SignupMeeting meeting;
    private SignupTimeslot timeslot;

    public LockUnlockTimeslot(SignupMeeting meeting, SignupTimeslot timeslot, String userId, String siteId, SignupMeetingService signupMeetingService) {
        super(userId, siteId, signupMeetingService, true);
        this.meeting = meeting;
        this.timeslot = timeslot;
    }

    public SignupMeeting lockOrUnlock() throws Exception {
        boolean lockAction = !this.timeslot.isLocked();
        try {
            this.handleVersion(this.meeting, this.timeslot, lockAction);
            String signupEventType = this.timeslot.isLocked() ? SignupEventTypes.EVENT_SIGNUP_MTNG_TS_UNLOCK : SignupEventTypes.EVENT_SIGNUP_MTNG_TS_LOCK;
            Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + this.meeting.getId() + " on the TS:" + SignupDateFormat.format_date_h_mm_a((Date)this.timeslot.getStartTime())));
            this.logger.debug((Object)("Meeting Name:" + this.meeting.getTitle() + " - UserId:" + this.userId + " - has " + (lockAction ? "locked" : "unlocked") + " the timeslot started at:" + SignupDateFormat.format_date_h_mm_a((Date)this.timeslot.getStartTime())));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
        finally {
            this.meeting = this.signupMeetingService.loadSignupMeeting(this.meeting.getId(), this.userId, this.siteId);
        }
        return this.meeting;
    }

    private SignupMeeting handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, boolean lockAction) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                currentTimeslot = meeting.getTimeslot(currentTimeslot.getId());
                if (currentTimeslot.isLocked() == lockAction) {
                    throw new SignupUserActionException(Utilities.rb.getString("someone.already.changed.ts.lock_status"));
                }
                currentTimeslot.setLocked(lockAction);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return meeting;
            }
            catch (OptimisticLockingFailureException oe) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("failed.lock_or_unlock_ts"));
    }
}

