/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.downloadEvents;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.sakaiproject.signup.tool.downloadEvents.CSVExport;
import org.sakaiproject.signup.tool.downloadEvents.EventWorksheet;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupMeetingsBean;
import org.sakaiproject.signup.tool.util.Utilities;

public class DownloadEventBean
extends SignupMeetingsBean {
    private static Log log = LogFactory.getLog(DownloadEventBean.class);
    private static final String DOWNLOAD_ACT_URL = "downloadEvents";
    private static final String FROM_ATTENDEE_EVENT_PAGE = "signupMeeting";
    private static final String FROM_ORGANIZER_EVENT_PAGE = "orgSignupMeeting";
    private static final String DOWNLOAD_EVENT_DETAILS_XLS_FILE_NAME = "EventsWorksheet.xls";
    private static final String DOWNLOAD_EVENT_DETAILS_CSV_FILE_NAME = "EventsWorksheet.csv";
    private static final String XLS_MIME_TYPE = "application/vnd.ms-excel";
    private static final String CSV_MIME_TYPE = "text/csv";
    private static final int XLS = 1;
    private static final int CSV = 2;
    private String downloadVersion = "full";

    public DownloadEventBean() {
        this.setViewDateRang(null);
    }

    public String startXlsDownload() {
        if (this.hasSelectedOnes()) {
            String fileName = DOWNLOAD_EVENT_DETAILS_XLS_FILE_NAME;
            String downloadVersionType = "full";
            if (this.isCurrentUserAllowedUpdateSite()) {
                downloadVersionType = "full_data";
            }
            this.downloadExcelSpreadsheet(this.getSignupMeetings(), downloadVersionType, fileName);
        } else {
            Utilities.addErrorMessage((String)Utilities.rb.getString("you.need.select.one.toDownload"));
        }
        return DOWNLOAD_ACT_URL;
    }

    public String startCsvDownload() {
        if (this.hasSelectedOnes()) {
            this.downloadCsvSpreadsheet(this.getSignupMeetings(), DOWNLOAD_EVENT_DETAILS_CSV_FILE_NAME);
        } else {
            Utilities.addErrorMessage((String)Utilities.rb.getString("you.need.select.one.toDownload"));
        }
        return DOWNLOAD_ACT_URL;
    }

    public String downloadOneEventAsExcel() {
        SignupMeetingWrapper wrapper = null;
        String path = FacesContext.getCurrentInstance().getExternalContext().getRequestServletPath();
        if (path != null && path.indexOf(FROM_ORGANIZER_EVENT_PAGE) > 0) {
            wrapper = this.getOrganizerSignupMBean().getMeetingWrapper();
        } else if (path != null && path.indexOf(FROM_ATTENDEE_EVENT_PAGE) > 0) {
            wrapper = this.getAttendeeSignupMBean().getMeetingWrapper();
        }
        if (wrapper != null) {
            ArrayList<SignupMeetingWrapper> wrappers = new ArrayList<SignupMeetingWrapper>();
            wrapper.setToDownload(true);
            wrappers.add(wrapper);
            String downloadVersion = "full";
            if (wrapper.getMeeting().getPermission().isUpdate()) {
                downloadVersion = "full_data";
            }
            this.downloadExcelSpreadsheet(wrappers, downloadVersion, DOWNLOAD_EVENT_DETAILS_XLS_FILE_NAME);
            wrapper.setToDownload(false);
        }
        return "";
    }

    public String downloadOneEventAsCsv() {
        return this.downloadOneEvent(2);
    }

    private String downloadOneEvent(int type) {
        SignupMeetingWrapper wrapper = null;
        String path = FacesContext.getCurrentInstance().getExternalContext().getRequestServletPath();
        if (path != null && path.indexOf(FROM_ORGANIZER_EVENT_PAGE) > 0) {
            wrapper = this.getOrganizerSignupMBean().getMeetingWrapper();
        } else if (path != null && path.indexOf(FROM_ATTENDEE_EVENT_PAGE) > 0) {
            wrapper = this.getAttendeeSignupMBean().getMeetingWrapper();
        }
        if (wrapper != null) {
            ArrayList<SignupMeetingWrapper> wrappers = new ArrayList<SignupMeetingWrapper>();
            wrapper.setToDownload(true);
            wrappers.add(wrapper);
            String downloadVersion = "full";
            if (wrapper.getMeeting().getPermission().isUpdate()) {
                downloadVersion = "full_data";
            }
            switch (type) {
                case 1: {
                    this.downloadExcelSpreadsheet(wrappers, downloadVersion, DOWNLOAD_EVENT_DETAILS_XLS_FILE_NAME);
                    break;
                }
                case 2: {
                    this.downloadCsvSpreadsheet(wrappers, DOWNLOAD_EVENT_DETAILS_CSV_FILE_NAME);
                    break;
                }
                default: {
                    log.error((Object)("Invalid download type (" + type + "). Download aborted."));
                }
            }
            wrapper.setToDownload(false);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void downloadExcelSpreadsheet(List<SignupMeetingWrapper> smWrappers, String downloadType, String fileName) {
        fc = FacesContext.getCurrentInstance();
        out = null;
        try {
            response = (HttpServletResponse)fc.getExternalContext().getResponse();
            this.responseSettings(fileName, "application/vnd.ms-excel", response);
            out = response.getOutputStream();
            this.excelSpreadsheet((OutputStream)out, smWrappers, downloadType);
            out.flush();
            ** if (out == null) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                DownloadEventBean.log.warn((Object)("Error generating XLS spreadsheet for download event:" + ex.getMessage()));
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var7_8) {
                if (out != null) {
                    this.closeStream(out);
                }
                throw var7_8;
            }
lbl-1000:
            // 1 sources

            {
                this.closeStream(out);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.closeStream(out);
        }
lbl-1000:
        // 2 sources

        {
        }
        fc.responseComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void downloadCsvSpreadsheet(List<SignupMeetingWrapper> smWrappers, String fileName) {
        fc = FacesContext.getCurrentInstance();
        out = null;
        try {
            response = (HttpServletResponse)fc.getExternalContext().getResponse();
            this.responseSettings(fileName, "text/csv", response);
            out = response.getOutputStream();
            this.csvSpreadsheet((OutputStream)out, smWrappers);
            out.flush();
            ** if (out == null) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                DownloadEventBean.log.warn((Object)("Error generating CSV spreadsheet for download event:" + ex.getMessage()));
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var6_7) {
                if (out != null) {
                    this.closeStream(out);
                }
                throw var6_7;
            }
lbl-1000:
            // 1 sources

            {
                this.closeStream(out);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.closeStream(out);
        }
lbl-1000:
        // 2 sources

        {
        }
        fc.responseComplete();
    }

    private void clearSelectedOnes() {
        List sMeetings = this.signupMeetings;
        if (sMeetings == null) {
            return;
        }
        for (SignupMeetingWrapper wrapper : sMeetings) {
            wrapper.setToDownload(false);
        }
    }

    private boolean hasSelectedOnes() {
        List sMeetings = this.getSignupMeetings();
        if (sMeetings == null) {
            return false;
        }
        for (SignupMeetingWrapper wrapper : sMeetings) {
            if (!wrapper.isToDownload()) continue;
            return true;
        }
        return false;
    }

    public String downloadSelections() {
        if (this.getViewDateRang() == null) {
            if (this.isCurrentUserAllowedUpdateSite()) {
                this.setViewDateRang("10000");
            } else {
                this.setViewDateRang("mySignUp");
            }
        }
        return DOWNLOAD_ACT_URL;
    }

    private void excelSpreadsheet(OutputStream os, List<SignupMeetingWrapper> meetingWrappers, String downloadType) throws IOException {
        EventWorksheet worksheet = new EventWorksheet(this.getSakaiFacade());
        Workbook wb = worksheet.getEventWorkbook(meetingWrappers, downloadType);
        wb.write(os);
    }

    private void csvSpreadsheet(OutputStream os, List<SignupMeetingWrapper> meetingWrappers) throws IOException {
        CSVExport export = new CSVExport(meetingWrappers, this.getSakaiFacade());
        CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(os), ',');
        List header = export.getHeaderRow();
        int cols = header.size();
        String[] headerRow = new String[cols];
        headerRow = header.toArray(headerRow);
        writer.writeNext(headerRow);
        List data = export.getDataRows();
        for (List row : data) {
            String[] dataRow = new String[cols];
            dataRow = row.toArray(dataRow);
            writer.writeNext(dataRow);
        }
        writer.close();
    }

    private void responseSettings(String filename, String mimetype, HttpServletResponse response) {
        response.reset();
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "public, must-revalidate, post-check=0, pre-check=0, max-age=0");
        response.setContentType(mimetype);
        response.setHeader("Content-disposition", "attachment; filename=" + filename);
    }

    private void closeStream(ServletOutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            log.warn((Object)("Error closing the output stream: " + e.getMessage()));
        }
    }

    public String getDownloadVersion() {
        return this.downloadVersion;
    }

    public void setDownloadVersion(String downloadVersion) {
        this.downloadVersion = downloadVersion;
    }

    public String getMeetingUnavailableMessages() {
        String message = super.getMeetingUnavailableMessages();
        if (this.isAllowedToCreate() && (this.isSelectedViewFutureMeetings() || this.isSelectedViewAllMeetings())) {
            message = Utilities.rb.getString("no_events_in_this_period_attendee_orgnizer");
        }
        return message;
    }
}

