/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.signup.logic.Permission;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.restful.SignupEvent;
import org.sakaiproject.signup.restful.SignupGroupItem;
import org.sakaiproject.signup.restful.SignupParticipant;
import org.sakaiproject.signup.restful.SignupSiteItem;
import org.sakaiproject.signup.restful.SignupTimeslotItem;
import org.sakaiproject.signup.tool.util.Utilities;

/*
 * Exception performing whole class analysis ignored.
 */
public class SignupObjectConverter {
    private static final int MAX_COMMENT_DISPLAY_LENGTH = 300;

    public static SignupEvent convertToSignupEventObj(SignupMeeting sm, String userId, String currentSiteId, boolean isDeepCopy, boolean isMySignUp, SakaiFacade sakaiFacade) {
        if (sm == null) {
            return null;
        }
        SignupEvent se = new SignupEvent();
        se.setEventId(sm.getId());
        se.setTitle(sm.getTitle());
        se.setLocation(sm.getLocation());
        se.setDescription(sm.getDescription());
        se.setStartTime(sm.getStartTime());
        se.setEndTime(sm.getEndTime());
        se.setOrganizerName(sakaiFacade.getUserDisplayName(sm.getCreatorUserId()));
        se.setSignupBegins(sm.getSignupBegins());
        se.setSignupDeadline(sm.getSignupDeadline());
        se.setId(sm.getId() + "");
        se.setMeetingType(sm.getMeetingType());
        se.setRecurrenceId(sm.getRecurrenceId());
        se.setRepeatType(sm.getRepeatType());
        if (isMySignUp) {
            se.setAvailableStatus(Utilities.rb.getString("event.youSignedUp"));
        } else {
            se.setPermission(new Permission(sm.getPermission().isAttend(), sm.getPermission().isUpdate(), sm.getPermission().isDelete()));
            se.setAvailableStatus(Utilities.retrieveAvailStatus((SignupMeeting)sm, (String)userId, (SakaiFacade)sakaiFacade));
        }
        se.setSiteId(currentSiteId);
        se.setSignupSiteItems(null);
        se.setAllowWaitList(sm.isAllowWaitList());
        se.setAllowComment(sm.isAllowComment());
        se.setAllowAttendance(sm.isAllowAttendance());
        se.setAutoReminder(sm.isAutoReminder());
        se.setEidInputMode(sm.isEidInputMode());
        se.setMaxNumOfSlots(sm.getMaxNumOfSlots());
        if (isDeepCopy) {
            se.setSignupTimeSlotItems(SignupObjectConverter.getSignupTimeslotItems((List)sm.getSignupTimeSlots(), (boolean)sm.getPermission().isUpdate(), (SakaiFacade)sakaiFacade));
            se.setSignupSiteItems(SignupObjectConverter.getSignupSiteItems((List)sm.getSignupSites()));
            se.setSignupMainEventAttachItems(SignupObjectConverter.getSignupMainEventAttachmentItems((SignupMeeting)sm));
            se.setAllowedUserActionTypes(SignupEvent.USER_ATION_Types);
        }
        if (Utilities.rb.getString("event.youSignedUp").equals(se.getAvailableStatus())) {
            se.setCurrentUserSignedUp(true);
        }
        return se;
    }

    public static List<SignupSiteItem> getSignupSiteItems(List<SignupSite> sites) {
        ArrayList<SignupSiteItem> siteItems = new ArrayList<SignupSiteItem>();
        if (sites != null) {
            for (SignupSite site : sites) {
                SignupSiteItem sItem = new SignupSiteItem(site.getTitle(), site.getSiteId());
                sItem.setSignupGroupItems(SignupObjectConverter.getSignupGroupItems((List)site.getSignupGroups()));
                siteItems.add(sItem);
            }
        }
        return siteItems;
    }

    public static List<SignupGroupItem> getSignupGroupItems(List<SignupGroup> groups) {
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        ArrayList<SignupGroupItem> groupItems = new ArrayList<SignupGroupItem>();
        for (SignupGroup grp : groups) {
            SignupGroupItem grpItem = new SignupGroupItem(grp.getTitle(), grp.getGroupId());
            groupItems.add(grpItem);
        }
        return groupItems;
    }

    public static List<SignupTimeslotItem> getSignupTimeslotItems(List<SignupTimeslot> timeslots, boolean isOrganizer, SakaiFacade sakaiFacade) {
        ArrayList<SignupTimeslotItem> tsItems = new ArrayList<SignupTimeslotItem>();
        if (timeslots != null) {
            for (SignupTimeslot item : timeslots) {
                SignupTimeslotItem one = new SignupTimeslotItem();
                one.setId(item.getId());
                one.setStartTime(item.getStartTime());
                one.setEndTime(item.getEndTime());
                one.setLocked(item.isLocked());
                one.setCanceled(item.isCanceled());
                one.setDisplayAttendees(item.isDisplayAttendees());
                one.setMaxNoOfAttendees(item.getMaxNoOfAttendees());
                one.setAttendees(SignupObjectConverter.convertToSignupParticipants((SignupTimeslotItem)one, (List)item.getAttendees(), (boolean)item.isDisplayAttendees(), (boolean)false, (boolean)isOrganizer, (SakaiFacade)sakaiFacade));
                one.setWaitingList(SignupObjectConverter.convertToSignupParticipants((SignupTimeslotItem)one, (List)item.getWaitingList(), (boolean)item.isDisplayAttendees(), (boolean)true, (boolean)isOrganizer, (SakaiFacade)sakaiFacade));
                tsItems.add(one);
            }
        }
        return tsItems;
    }

    public static List<SignupParticipant> convertToSignupParticipants(SignupTimeslotItem timeslotItem, List<SignupAttendee> attendees, boolean showAttendeeName, boolean isWaitList, boolean isOrganizer, SakaiFacade sakaiFacade) {
        ArrayList<SignupParticipant> participants = new ArrayList<SignupParticipant>();
        if (attendees != null) {
            for (SignupAttendee one : attendees) {
                String comment;
                SignupParticipant sp = new SignupParticipant(one.getAttendeeUserId(), one.getSignupSiteId());
                if (sakaiFacade.getCurrentUserId().equals(one.getAttendeeUserId())) {
                    if (isWaitList) {
                        timeslotItem.setOnWaitList(true);
                    } else {
                        timeslotItem.setSignedUp(true);
                    }
                }
                if (!isOrganizer && !sakaiFacade.getCurrentUserId().equals(one.getAttendeeUserId())) {
                    sp.setAttendeeUserId("private");
                }
                if ((comment = one.getComments()) != null && comment.length() > 300) {
                    comment = comment.subSequence(0, 300) + ".....";
                }
                sp.setComments(comment);
                if (showAttendeeName || isOrganizer) {
                    sp.setDisplayName(sakaiFacade.getUserDisplayName(one.getAttendeeUserId()));
                }
                participants.add(sp);
            }
        }
        return participants;
    }

    public static List<SignupAttachment> getSignupMainEventAttachmentItems(SignupMeeting sm) {
        ArrayList<SignupAttachment> eventMainAttachments = new ArrayList<SignupAttachment>();
        if (sm.getSignupAttachments() != null) {
            for (SignupAttachment attach : sm.getSignupAttachments()) {
                if (attach.getTimeslotId() != null || !attach.getViewByAll().booleanValue()) continue;
                eventMainAttachments.add(attach);
            }
        }
        return eventMainAttachments;
    }
}

