/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.SignupSiteWrapper;
import org.sakaiproject.signup.tool.jsf.SignupUIBaseBean;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.organizer.UserDefineTimeslotBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateMeetings;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateSitesGroups;
import org.sakaiproject.signup.tool.util.Utilities;

public class CopyMeetingSignupMBean
extends SignupUIBaseBean {
    private SignupMeeting signupMeeting;
    private boolean keepAttendees;
    private int maxNumOfAttendees;
    private boolean unlimited;
    private String signupBeginsType;
    private int signupBegins;
    private String deadlineTimeType;
    private int deadlineTime;
    private String selectedLocation;
    private String selectedCategory;
    private String creatorUserId;
    private Date repeatUntil;
    private String repeatType;
    private String recurLengthChoice;
    private int occurrences;
    private int numberOfSlots;
    private boolean showAttendeeName;
    private SignupSiteWrapper currentSite;
    private List<SignupSiteWrapper> otherSites;
    private List<SignupUser> allowedUserList;
    private boolean missingSitGroupWarning;
    private List<String> missingSites;
    private List<String> missingGroups;
    private boolean assignParicitpantsToAllRecurEvents;
    private boolean validationError;
    private boolean repeatTypeUnknown = true;
    private List<SelectItem> meetingTypeRadioBttns;
    private UserDefineTimeslotBean userDefineTimeslotBean;
    private List<TimeslotWrapper> customTimeSlotWrpList;
    private boolean userDefinedTS = false;
    protected static boolean NEW_MEETING_SEND_EMAIL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.email.notification.mandatory.for.newMeeting", (String)"true"));
    private boolean mandatorySendEmail = NEW_MEETING_SEND_EMAIL;
    private List<SelectItem> categories = null;
    private List<SelectItem> locations = null;

    public void reset() {
        this.unlimited = false;
        this.keepAttendees = false;
        this.assignParicitpantsToAllRecurEvents = false;
        this.sendEmail = DEFAULT_SEND_EMAIL;
        if (NEW_MEETING_SEND_EMAIL) {
            this.sendEmail = true;
        }
        this.sendEmailToSelectedPeopleOnly = "all";
        this.publishToCalendar = DEFAULT_EXPORT_TO_CALENDAR_TOOL;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.repeatUntil = calendar.getTime();
        this.recurLengthChoice = "1";
        this.occurrences = 0;
        this.repeatType = "no_repeat";
        this.repeatTypeUnknown = true;
        this.showAttendeeName = false;
        this.missingSitGroupWarning = false;
        if (this.signupMeeting != null) {
            this.cleanUpUnusedAttachmentCopies(this.signupMeeting.getSignupAttachments());
        }
        this.signupMeeting = this.signupMeetingService.loadSignupMeeting(this.meetingWrapper.getMeeting().getId(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId());
        this.assignMainAttachmentsCopyToSignupMeeting();
        List signupTimeSlots = this.signupMeeting.getSignupTimeSlots();
        if (signupTimeSlots != null && !signupTimeSlots.isEmpty()) {
            SignupTimeslot ts = (SignupTimeslot)signupTimeSlots.get(0);
            this.maxNumOfAttendees = ts.getMaxNoOfAttendees();
            this.unlimited = ts.isUnlimitedAttendee();
            this.showAttendeeName = ts.isDisplayAttendees();
            this.numberOfSlots = signupTimeSlots.size();
        } else {
            this.setNumberOfSlots(1);
        }
        this.selectedLocation = this.signupMeeting.getLocation();
        this.selectedCategory = this.signupMeeting.getCategory();
        this.customLocation = "";
        this.customCategory = "";
        this.categories = null;
        this.locations = null;
        this.populateDataForBeginDeadline(this.signupMeeting);
        this.prepareRecurredEvents();
        this.initializeSitesGroups();
        this.customTimeSlotWrpList = null;
        this.userDefinedTS = false;
        this.updateTimeSlotWrappers(this.meetingWrapper);
        if ("custom_ts".equals(this.signupMeeting.getMeetingType())) {
            this.userDefinedTS = true;
            this.customTimeSlotWrpList = this.getTimeslotWrappers();
            this.markerTimeslots(this.customTimeSlotWrpList);
        }
        this.getUserDefineTimeslotBean().init(this.signupMeeting, "copyMeeting", this.customTimeSlotWrpList, "copy_meeting");
    }

    private void populateDataForBeginDeadline(SignupMeeting sMeeting) {
        long signupBeginsTime = sMeeting.getSignupBegins() == null ? new Date().getTime() : sMeeting.getSignupBegins().getTime();
        long signupDeadline = sMeeting.getSignupDeadline() == null ? new Date().getTime() : sMeeting.getSignupDeadline().getTime();
        long signupBeginBeforMeeting = (sMeeting.getStartTime().getTime() - signupBeginsTime) / 60000L;
        long signupDeadLineBeforMeetingEnd = (sMeeting.getEndTime().getTime() - signupDeadline) / 60000L;
        this.signupBeginsType = Utilities.getTimeScaleType((long)signupBeginBeforMeeting);
        this.signupBegins = Utilities.getRelativeTimeValue((String)this.signupBeginsType, (long)signupBeginBeforMeeting);
        this.deadlineTimeType = Utilities.getTimeScaleType((long)signupDeadLineBeforMeetingEnd);
        this.deadlineTime = Utilities.getRelativeTimeValue((String)this.deadlineTimeType, (long)signupDeadLineBeforMeetingEnd);
        if ("minutes".equals(this.signupBeginsType) && sMeeting.getSignupBegins().before(new Date()) && this.signupBegins > 500) {
            this.signupBeginsType = "days";
            this.signupBegins = Utilities.getRelativeTimeValue((String)"days", (long)signupBeginBeforMeeting);
            if (this.signupBegins == 0) {
                this.signupBegins = 1;
            }
        }
    }

    public SignupMeetingWrapper getMeetingWrapper() {
        return this.meetingWrapper;
    }

    public String processSaveCopy() {
        if (this.validationError) {
            this.validationError = false;
            return "copyMeeting";
        }
        SignupMeeting sMeeting = this.getSignupMeeting();
        try {
            this.prepareCopy(sMeeting);
            sMeeting.setRepeatUntil(this.getRepeatUntil());
            int repeatNum = this.getOccurrences();
            if ("1".equals(this.getRecurLengthChoice())) {
                repeatNum = CreateMeetings.getNumOfRecurrence((String)this.getRepeatType(), (Date)sMeeting.getStartTime(), (Date)this.getRepeatUntil());
            }
            sMeeting.setRepeatNum(repeatNum);
            sMeeting.setRepeatType(this.getRepeatType());
            if ("custom_ts".equals(this.signupMeeting.getMeetingType())) {
                boolean multipleCalBlocks = this.getUserDefineTimeslotBean().getPutInMultipleCalendarBlocks();
                sMeeting.setInMultipleCalendarBlocks(multipleCalBlocks);
            }
            sMeeting.setSendEmailToSelectedPeopleOnly(this.getSendEmailToSelectedPeopleOnly());
            CreateMeetings createMeeting = new CreateMeetings(sMeeting, this.sendEmail, this.keepAttendees && !this.assignParicitpantsToAllRecurEvents, this.keepAttendees && this.assignParicitpantsToAllRecurEvents, this.getSignupBegins(), this.getSignupBeginsType(), this.getDeadlineTime(), this.getDeadlineTimeType(), this.getRecurLengthChoice(), this.sakaiFacade, this.signupMeetingService, this.getAttachmentHandler(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), true);
            createMeeting.setPublishToCalendar(this.isPublishToCalendar());
            createMeeting.processSaveMeetings();
            this.signupMeeting.getSignupAttachments().clear();
        }
        catch (PermissionException e) {
            this.logger.info((Object)(Utilities.rb.getString("no.permission_create_event") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("no.permission_create_event"));
            return "organizerMeeting";
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
            return "copyMeeting";
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
            return "organizerMeeting";
        }
        this.getUserDefineTimeslotBean().reset("copy_meeting");
        return "listMeetings";
    }

    public void validateCopyMeeting(ActionEvent e) {
        Date eventEndTime = this.signupMeeting.getEndTime();
        Date eventStartTime = this.signupMeeting.getStartTime();
        if (this.isUserDefinedTS()) {
            eventEndTime = this.getUserDefineTimeslotBean().getEventEndTime();
            eventStartTime = this.getUserDefineTimeslotBean().getEventStartTime();
            this.signupMeeting.setStartTime(eventStartTime);
            this.signupMeeting.setEndTime(eventEndTime);
            if (this.getUserDefineTimeslotBean().getDestTSwrpList() == null || this.getUserDefineTimeslotBean().getDestTSwrpList().isEmpty()) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.create_custom_defined_TS_blocks"));
                return;
            }
        }
        if (eventEndTime.before(eventStartTime) || eventStartTime.equals(eventEndTime)) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("event.endTime_should_after_startTime"));
            return;
        }
        if (!this.getRepeatType().equals("no_repeat")) {
            int repeatNum = this.getOccurrences();
            if ("1".equals(this.getRecurLengthChoice())) {
                repeatNum = CreateMeetings.getNumOfRecurrence((String)this.getRepeatType(), (Date)eventStartTime, (Date)this.getRepeatUntil());
            }
            if (("daily".equals(this.getRepeatType()) || "wkdays_mon-fri".equals(this.getRepeatType())) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 1)) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.daily.problem"));
                return;
            }
            if ("weekly".equals(this.getRepeatType()) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 7)) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.weekly.problem"));
                return;
            }
            if ("biweekly".equals(this.getRepeatType()) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 14)) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.biweekly.problem"));
                return;
            }
            if (repeatNum < 1) {
                this.validationError = true;
                if ("1".equals(this.getRecurLengthChoice())) {
                    Utilities.addErrorMessage((String)Utilities.rb.getString("event.repeatbeforestart"));
                } else {
                    Utilities.addErrorMessage((String)Utilities.rb.getString("event.repeatNnum.bigger.than.one"));
                }
                return;
            }
        }
        if (!CreateSitesGroups.isAtleastASiteOrGroupSelected((SignupSiteWrapper)this.getCurrentSite(), (List)this.getOtherSites())) {
            this.validationError = true;
            Utilities.addErrorMessage((String)Utilities.rb.getString("select.atleast.oneGroup.for.copyMeeting"));
        }
        if (!this.validationError && this.isUserDefinedTS()) {
            this.signupMeeting.setStartTime(eventStartTime);
            this.signupMeeting.setEndTime(eventEndTime);
            this.signupMeeting.setMeetingType("custom_ts");
        }
        if (StringUtils.isBlank((String)this.getCustomLocation())) {
            if (StringUtils.isBlank((String)this.selectedLocation) || this.selectedLocation.equals(Utilities.rb.getString("select_location"))) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.location_not_assigned"));
                return;
            }
            this.signupMeeting.setLocation(this.selectedLocation);
        } else {
            this.signupMeeting.setLocation(this.getCustomLocation());
        }
        this.selectedLocation = "";
        if (StringUtils.isBlank((String)this.getCustomCategory())) {
            if (!StringUtils.equals((String)this.selectedCategory, (String)Utilities.rb.getString("select_category"))) {
                this.signupMeeting.setCategory(this.selectedCategory);
            }
        } else {
            this.signupMeeting.setCategory(this.getCustomCategory());
        }
        this.selectedCategory = "";
        this.signupMeeting.setCreatorUserId(this.creatorUserId);
        this.creatorUserId = "";
    }

    public String addRemoveAttachments() {
        this.getAttachmentHandler().processAddAttachRedirect(this.signupMeeting.getSignupAttachments(), null, true);
        return null;
    }

    public String doCancelAction() {
        this.cleanUpUnusedAttachmentCopies(this.signupMeeting.getSignupAttachments());
        this.getUserDefineTimeslotBean().reset("copy_meeting");
        this.selectedLocation = null;
        this.selectedCategory = null;
        return "organizerMeeting";
    }

    public String processGroup(ValueChangeEvent vce) {
        Boolean changeValue = (Boolean)vce.getNewValue();
        if (changeValue != null) {
            this.unlimited = changeValue;
            if (this.unlimited) {
                this.maxNumOfAttendees = 10;
            }
        }
        return "";
    }

    public String editUserDefTimeSlots() {
        if (this.customTimeSlotWrpList == null) {
            this.customTimeSlotWrpList = this.getTimeslotWrappers();
            this.markerTimeslots(this.customTimeSlotWrpList);
            this.getUserDefineTimeslotBean().init(this.signupMeeting, "copyMeeting", this.customTimeSlotWrpList, "copy_meeting");
        } else {
            if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"copy_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
                return "organizerMeeting";
            }
            this.customTimeSlotWrpList = this.getUserDefineTimeslotBean().getDestTSwrpList();
            this.getUserDefineTimeslotBean().init(this.signupMeeting, "copyMeeting", this.customTimeSlotWrpList, "copy_meeting");
        }
        return "userDefinedTsBlocks";
    }

    private void prepareCopy(SignupMeeting meeting) throws Exception {
        Calendar calendar;
        block16: {
            ArrayList<SignupTimeslot> cpTimeslotList;
            boolean lockOrCanceledTimeslot;
            block17: {
                UserDefineTimeslotBean uBean;
                block19: {
                    block18: {
                        block15: {
                            meeting.setId(null);
                            meeting.setRecurrenceId(null);
                            meeting.setSignupSites(CreateSitesGroups.getSelectedSignupSites((SignupSiteWrapper)this.getCurrentSite(), (List)this.getOtherSites()));
                            this.allowedUserList = this.LoadAllowedUsers(meeting);
                            List timeslots = meeting.getSignupTimeSlots();
                            lockOrCanceledTimeslot = false;
                            calendar = Calendar.getInstance();
                            calendar.setTime(meeting.getStartTime());
                            if (!this.getAnnouncementType() && timeslots != null && !timeslots.isEmpty()) break block15;
                            calendar.add(12, this.getTimeSlotDuration());
                            meeting.setMeetingType("announcement");
                            meeting.setSignupTimeSlots(null);
                            break block16;
                        }
                        cpTimeslotList = new ArrayList<SignupTimeslot>();
                        List origTsList = null;
                        if (!this.isUserDefinedTS() && (meeting.getMeetingType().equals("individual") || meeting.getMeetingType().equals("group"))) {
                            origTsList = meeting.getSignupTimeSlots();
                            SignupTimeslot origTs = null;
                            for (int i = 0; i < this.getNumberOfSlots(); ++i) {
                                SignupTimeslot cpTs = new SignupTimeslot();
                                int maxAttendees = this.unlimited ? Integer.MAX_VALUE : this.maxNumOfAttendees;
                                cpTs.setMaxNoOfAttendees(maxAttendees);
                                cpTs.setDisplayAttendees(this.showAttendeeName);
                                cpTs.setStartTime(calendar.getTime());
                                calendar.add(12, this.getTimeSlotDuration());
                                cpTs.setEndTime(calendar.getTime());
                                if (i < origTsList.size()) {
                                    origTs = (SignupTimeslot)origTsList.get(i);
                                    List attList = origTs.getAttendees();
                                    this.removeNotAllowedAttedees(attList);
                                    if (!this.unlimited && attList != null && attList.size() > maxAttendees) {
                                        for (int j = attList.size(); j > maxAttendees; --j) {
                                            attList.remove(j - 1);
                                        }
                                    }
                                    cpTs.setAttendees(attList);
                                    origTs.setAttendees(null);
                                    cpTs.setLocked(origTs.isLocked());
                                    cpTs.setCanceled(origTs.isCanceled());
                                    if (origTs.isCanceled() || origTs.isLocked()) {
                                        lockOrCanceledTimeslot = true;
                                    }
                                }
                                cpTimeslotList.add(cpTs);
                            }
                        }
                        if (!meeting.getMeetingType().equals("custom_ts") && !this.isUserDefinedTS()) break block17;
                        uBean = this.getUserDefineTimeslotBean();
                        if (uBean == null) break block18;
                        if ("copy_meeting".equals(uBean.getPlaceOrderBean())) break block19;
                    }
                    throw new SignupUserActionException(MessageFormat.format(Utilities.rb.getString("you.have.multiple.tabs.in.browser"), this.getSakaiFacade().getServerConfigurationService().getServerName()));
                }
                List tsWrpList = uBean.getDestTSwrpList();
                if (tsWrpList != null) {
                    for (TimeslotWrapper wrapper : tsWrpList) {
                        SignupTimeslot slot = wrapper.getTimeSlot();
                        List attList = slot.getAttendees();
                        this.removeNotAllowedAttedees(attList);
                        if (attList != null && attList.size() > slot.getMaxNoOfAttendees()) {
                            for (int j = attList.size(); j > slot.getMaxNoOfAttendees(); --j) {
                                attList.remove(j - 1);
                            }
                        }
                        if (slot.isLocked() || slot.isCanceled()) {
                            lockOrCanceledTimeslot = true;
                        }
                        cpTimeslotList.add(slot);
                    }
                }
                int duration = this.getUserDefineTimeslotBean().getEventDuration();
                calendar.add(12, duration);
            }
            meeting.setSignupTimeSlots(cpTimeslotList);
            if (lockOrCanceledTimeslot) {
                Utilities.addErrorMessage((String)Utilities.rb.getString("warning.some_timeslot_may_locked_canceled"));
            }
        }
        meeting.setEndTime(calendar.getTime());
        this.setSignupBeginDeadlineData(meeting, this.getSignupBegins(), this.getSignupBeginsType(), this.getDeadlineTime(), this.getDeadlineTimeType());
        meeting.setCoordinatorIds(this.getValidatedMeetingCoordinators(meeting));
    }

    public List<SelectItem> getAllLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList();
            this.locations.addAll(Utilities.getSignupMeetingsBean().getAllLocations());
            this.locations.add(0, new SelectItem((Object)Utilities.rb.getString("select_location")));
        }
        return this.locations;
    }

    public List<SelectItem> getAllCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList();
            this.categories.addAll(Utilities.getSignupMeetingsBean().getAllCategories());
            this.categories.remove(0);
            this.categories.add(0, new SelectItem((Object)Utilities.rb.getString("select_category")));
        }
        return this.categories;
    }

    public boolean isKeepAttendees() {
        return this.keepAttendees;
    }

    public void setKeepAttendees(boolean keepAttendees) {
        this.keepAttendees = keepAttendees;
    }

    public int getMaxNumOfAttendees() {
        return this.maxNumOfAttendees;
    }

    public void setMaxNumOfAttendees(int maxNumOfAttendees) {
        this.maxNumOfAttendees = maxNumOfAttendees;
    }

    public SignupMeeting getSignupMeeting() {
        return this.signupMeeting;
    }

    public void setSignupMeeting(SignupMeeting signupMeeting) {
        this.signupMeeting = signupMeeting;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public int getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(int deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineTimeType() {
        return this.deadlineTimeType;
    }

    public void setDeadlineTimeType(String deadlineTimeType) {
        this.deadlineTimeType = deadlineTimeType;
    }

    public String getselectedLocation() {
        return this.selectedLocation;
    }

    public void setselectedLocation(String selectedLocation) {
        this.selectedLocation = selectedLocation;
    }

    public String getselectedCategory() {
        return this.selectedCategory;
    }

    public void setselectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public String getcreatorUserId() {
        if (this.creatorUserId == null) {
            return this.sakaiFacade.getCurrentUserId();
        }
        return this.creatorUserId;
    }

    public void setcreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public int getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(int signupBegins) {
        this.signupBegins = signupBegins;
    }

    public String getSignupBeginsType() {
        return this.signupBeginsType;
    }

    public void setSignupBeginsType(String signupBeginsType) {
        this.signupBeginsType = signupBeginsType;
    }

    public Date getRepeatUntil() {
        return this.repeatUntil;
    }

    public void setRepeatUntil(Date repeatUntil) {
        this.repeatUntil = repeatUntil;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public int getTimeSlotDuration() {
        long duration = (this.getSignupMeeting().getEndTime().getTime() - this.getSignupMeeting().getStartTime().getTime()) / (long)(60000 * this.getNumberOfSlots());
        return (int)duration;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public List<SignupSiteWrapper> getOtherSites() {
        return this.otherSites;
    }

    public void setOtherSites(List<SignupSiteWrapper> signupSiteWrapperList) {
        this.otherSites = signupSiteWrapperList;
    }

    public SignupSiteWrapper getCurrentSite() {
        return this.currentSite;
    }

    public void setCurrentSite(SignupSiteWrapper currentSite) {
        this.currentSite = currentSite;
    }

    private void initializeSitesGroups() {
        CreateSitesGroups createSiteGroups = Utilities.getSignupMeetingsBean().getCreateSitesGroups();
        createSiteGroups.resetSiteGroupCheckboxMark();
        createSiteGroups.setSignupMeeting(this.getSignupMeeting());
        createSiteGroups.processSiteGroupSelectionMarks();
        this.setCurrentSite(createSiteGroups.getCurrentSite());
        this.setOtherSites(createSiteGroups.getOtherSites());
        this.setMissingSitGroupWarning(createSiteGroups.isSiteOrGroupTruncated());
        this.setMissingSites(createSiteGroups.getMissingSites());
        this.setMissingGroups(createSiteGroups.getMissingGroups());
    }

    private List<SignupUser> LoadAllowedUsers(SignupMeeting meeting) {
        return this.sakaiFacade.getAllUsers(this.getSignupMeeting());
    }

    private void removeNotAllowedAttedees(List<SignupAttendee> screenAttendeeList) {
        if (screenAttendeeList == null || screenAttendeeList.isEmpty()) {
            return;
        }
        boolean notFound = true;
        for (int i = screenAttendeeList.size(); i > 0; --i) {
            notFound = true;
            for (SignupUser allowedOne : this.allowedUserList) {
                if (!allowedOne.getInternalUserId().equals(screenAttendeeList.get(i - 1).getAttendeeUserId())) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            screenAttendeeList.remove(i - 1);
        }
    }

    private String getValidatedMeetingCoordinators(SignupMeeting meeting) {
        List allCoordinatorIds = this.getExistingCoordinatorIds(meeting);
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String couId : allCoordinatorIds) {
            if (!this.sakaiFacade.hasPermissionToCreate(meeting, couId)) continue;
            if (isFirst) {
                sb.append(couId);
                isFirst = false;
                continue;
            }
            if (sb.length() >= 1000) continue;
            sb.append("|" + couId);
        }
        return sb.length() < 1 ? null : sb.toString();
    }

    private List<String> getExistingCoordinatorIds(SignupMeeting meeting) {
        ArrayList<String> coUsers = new ArrayList<String>();
        String coUserIdsString = meeting.getCoordinatorIds();
        if (coUserIdsString != null && coUserIdsString.trim().length() > 0) {
            StringTokenizer userIdTokens = new StringTokenizer(coUserIdsString, "|");
            while (userIdTokens.hasMoreTokens()) {
                String uId = userIdTokens.nextToken();
                coUsers.add(uId);
            }
        }
        return coUsers;
    }

    public boolean isMissingSitGroupWarning() {
        return this.missingSitGroupWarning;
    }

    private void setMissingSitGroupWarning(boolean missingSitGroupWarning) {
        this.missingSitGroupWarning = missingSitGroupWarning;
    }

    public List<String> getMissingSites() {
        return this.missingSites;
    }

    private void setMissingSites(List<String> missingSites) {
        this.missingSites = missingSites;
    }

    public boolean isMissingSitesThere() {
        return this.missingSites != null && !this.missingSites.isEmpty();
    }

    public List<String> getMissingGroups() {
        return this.missingGroups;
    }

    private void setMissingGroups(List<String> missingGroups) {
        this.missingGroups = missingGroups;
    }

    public boolean isMissingGroupsThere() {
        return this.missingGroups != null && !this.missingGroups.isEmpty();
    }

    public boolean isAssignParicitpantsToAllRecurEvents() {
        return this.assignParicitpantsToAllRecurEvents;
    }

    public void setAssignParicitpantsToAllRecurEvents(boolean assignParicitpantsToAllRecurEvents) {
        this.assignParicitpantsToAllRecurEvents = assignParicitpantsToAllRecurEvents;
    }

    public List<SelectItem> getMeetingTypeRadioBttns() {
        this.meetingTypeRadioBttns = Utilities.getMeetingTypeSelectItems((String)this.getSignupMeeting().getMeetingType(), (boolean)true);
        return this.meetingTypeRadioBttns;
    }

    private void prepareRecurredEvents() {
        Long recurrenceId = this.signupMeeting.getRecurrenceId();
        if (recurrenceId != null && recurrenceId > 0L) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.signupMeeting.getStartTime());
            cal.add(10, -744);
            List recurredMeetings = this.signupMeetingService.getRecurringSignupMeetings(this.getSakaiFacade().getCurrentLocationId(), this.getSakaiFacade().getCurrentUserId(), recurrenceId, cal.getTime());
            this.retrieveRecurrenceData(recurredMeetings);
        }
    }

    private void retrieveRecurrenceData(List<SignupMeeting> upTodateOrginMeetings) {
        if (Utilities.testSignupBeginStartNowType(upTodateOrginMeetings)) {
            this.setSignupBeginsType("startNow");
            this.setSignupBegins(6);
        }
        Date lastDate = new Date();
        if (upTodateOrginMeetings == null || upTodateOrginMeetings.isEmpty()) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.signupMeeting.getStartTime());
        cal.set(12, 0);
        cal.set(13, 0);
        this.setRepeatUntil(cal.getTime());
        int listSize = upTodateOrginMeetings.size();
        if (listSize > 1) {
            lastDate = upTodateOrginMeetings.get(listSize - 1).getStartTime();
            cal.setTime(lastDate);
            cal.set(12, 0);
            cal.set(13, 0);
            this.setRepeatUntil(cal.getTime());
            String repeatType = upTodateOrginMeetings.get(listSize - 1).getRepeatType();
            if (repeatType != null && !"no_repeat".equals(repeatType)) {
                this.setRepeatType(repeatType);
                this.setRepeatTypeUnknown(false);
                return;
            }
            Calendar calFirst = Calendar.getInstance();
            Calendar calSecond = Calendar.getInstance();
            calFirst.setTime(upTodateOrginMeetings.get(listSize - 2).getStartTime());
            calFirst.set(13, 0);
            calFirst.set(14, 0);
            calSecond.setTime(upTodateOrginMeetings.get(listSize - 1).getStartTime());
            calSecond.set(13, 0);
            calSecond.set(14, 0);
            int tmp = calSecond.get(5);
            int daysDiff = (int)(calSecond.getTimeInMillis() - calFirst.getTimeInMillis()) / 86400000;
            this.setRepeatTypeUnknown(false);
            if (daysDiff == 1) {
                this.setRepeatType("daily");
            } else if (daysDiff == 7) {
                this.setRepeatType("weekly");
            } else if (daysDiff == 14) {
                this.setRepeatType("biweekly");
            } else if (daysDiff == 3 && calFirst.get(7) == 6) {
                this.setRepeatType("wkdays_mon-fri");
            } else {
                this.setRepeatTypeUnknown(true);
            }
        }
    }

    public boolean getRepeatTypeUnknown() {
        return this.repeatTypeUnknown;
    }

    public void setRepeatTypeUnknown(boolean repeatTypeUnknown) {
        this.repeatTypeUnknown = repeatTypeUnknown;
    }

    private void assignMainAttachmentsCopyToSignupMeeting() {
        ArrayList<SignupAttachment> attachList = new ArrayList<SignupAttachment>();
        if (attachList != null) {
            for (SignupAttachment attach : this.signupMeeting.getSignupAttachments()) {
                if (attach.getTimeslotId() != null || !attach.getViewByAll().booleanValue()) continue;
                attachList.add(attach);
            }
        }
        ArrayList<SignupAttachment> cpList = new ArrayList<SignupAttachment>();
        if (attachList.size() > 0) {
            for (SignupAttachment attach : attachList) {
                cpList.add(this.getAttachmentHandler().copySignupAttachment(this.signupMeeting, true, attach, "cp" + this.signupMeeting.getId().toString()));
            }
        }
        this.signupMeeting.setSignupAttachments(cpList);
    }

    public boolean getSignupAttachmentEmpty() {
        if (this.signupMeeting == null) {
            return true;
        }
        return this.signupMeeting.getSignupAttachments() == null || this.signupMeeting.getSignupAttachments().isEmpty();
    }

    public UserDefineTimeslotBean getUserDefineTimeslotBean() {
        return this.userDefineTimeslotBean;
    }

    public void setUserDefineTimeslotBean(UserDefineTimeslotBean userDefineTimeslotBean) {
        this.userDefineTimeslotBean = userDefineTimeslotBean;
    }

    public boolean isUserDefinedTS() {
        return this.userDefinedTS;
    }

    public void setUserDefinedTS(boolean userDefinedTS) {
        this.userDefinedTS = userDefinedTS;
    }

    public List<TimeslotWrapper> getCustomTimeSlotWrpList() {
        return this.customTimeSlotWrpList;
    }

    public void setCustomTimeSlotWrpList(List<TimeslotWrapper> customTimeSlotWrpList) {
        this.customTimeSlotWrpList = customTimeSlotWrpList;
    }

    public boolean getCustomTsType() {
        return "custom_ts".equals(this.signupMeeting.getMeetingType());
    }

    public String getRecurLengthChoice() {
        return this.recurLengthChoice;
    }

    public void setRecurLengthChoice(String recurLengthChoice) {
        this.recurLengthChoice = recurLengthChoice;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(int occurrences) {
        this.occurrences = occurrences;
    }

    public boolean isAttendanceOn() {
        return Utilities.getSignupMeetingsBean().isAttendanceOn();
    }

    public List<SelectItem> getInstructors() {
        return Utilities.getSignupMeetingsBean().getInstructors(this.signupMeeting);
    }

    public boolean isMandatorySendEmail() {
        return this.mandatorySendEmail;
    }
}

