/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.Iterator;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class CancelAttendee
extends SignupAction {
    public CancelAttendee(SignupMeetingService signupMeetingService, String currentUserId, String currentSiteId, boolean isOrganizer) {
        super(currentUserId, currentSiteId, signupMeetingService, isOrganizer);
    }

    public SignupMeeting cancelSignup(SignupMeeting meeting, SignupTimeslot timeSlot, SignupAttendee attendee) throws Exception {
        boolean hasException = false;
        try {
            this.handleVersion(meeting, timeSlot, attendee);
            if (ToolManager.getCurrentPlacement() != null) {
                String signupEventType = this.isOrganizer ? SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_L : SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_S;
                Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
            }
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        catch (PermissionException pe) {
            hasException = true;
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
        finally {
            meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
            if (!hasException) {
                try {
                    this.signupMeetingService.modifyCalendar(meeting);
                }
                catch (Exception e) {}
            }
        }
        return meeting;
    }

    public void actionsForOptimisticVersioning(SignupMeeting meeting, SignupTimeslot timeslot, SignupAttendee attendee) throws Exception {
        this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
        this.signupEventTrackingInfo.setMeeting(meeting);
        this.prepareCancelAttendee(meeting, timeslot, attendee);
    }

    private SignupMeeting handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee currentAttendee) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                this.actionsForOptimisticVersioning(meeting, currentTimeslot, currentAttendee);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return meeting;
            }
            catch (OptimisticLockingFailureException oe) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("someone.already.updated.db"));
    }

    private void prepareCancelAttendee(SignupMeeting meeting, SignupTimeslot currentTimeSlot, SignupAttendee removedAttendee) throws SignupUserActionException {
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot upToDateTS : signupTimeSlots) {
            if (!upToDateTS.getId().equals(currentTimeSlot.getId())) continue;
            currentTimeSlot = upToDateTS;
            break;
        }
        boolean foundUser = false;
        List attendees = currentTimeSlot.getAttendees();
        Iterator iter = attendees.iterator();
        while (iter.hasNext()) {
            SignupAttendee attendee = (SignupAttendee)iter.next();
            if (!removedAttendee.getAttendeeUserId().equals(attendee.getAttendeeUserId())) continue;
            iter.remove();
            this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(attendee, currentTimeSlot, "signup.email.attendee.cancel", true);
            foundUser = true;
            break;
        }
        if (!foundUser) {
            throw new SignupUserActionException(Utilities.rb.getString("someone.already.remove_you"));
        }
        this.promoteAttendeeFromWaitingList(meeting, currentTimeSlot);
    }
}

