/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.Date;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class CancelRestoreTimeslot
extends SignupAction {
    private SignupMeeting meeting;
    private SignupTimeslot timeslot;

    public CancelRestoreTimeslot(SignupMeeting meeting, SignupTimeslot timeslot, String userId, String siteId, SignupMeetingService signupMeetingService) {
        super(userId, siteId, signupMeetingService, true);
        this.meeting = meeting;
        this.timeslot = timeslot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignupMeeting cancelOrRestore() throws Exception {
        boolean cancelAction = !this.timeslot.isCanceled();
        try {
            this.handleVersion(this.meeting, this.timeslot, cancelAction);
            String signupEventType = this.timeslot.isCanceled() ? SignupEventTypes.EVENT_SIGNUP_MTNG_TS_UNCANCEL : SignupEventTypes.EVENT_SIGNUP_MTNG_TS_CANCEL;
            Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + this.meeting.getId() + " on the TS:" + SignupDateFormat.format_date_h_mm_a((Date)this.timeslot.getStartTime())));
            this.logger.debug((Object)("Meeting Name:" + this.meeting.getTitle() + " - UserId:" + this.userId + " - has " + (cancelAction ? "canceled" : "restored") + " the timeslot started at:" + SignupDateFormat.format_date_h_mm_a((Date)this.timeslot.getStartTime())));
        }
        catch (PermissionException pe) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("no.permissoin.do_it"));
        }
        catch (SignupUserActionException ue) {
            Utilities.addErrorMessage((String)ue.getMessage());
        }
        finally {
            this.meeting = this.signupMeetingService.loadSignupMeeting(this.meeting.getId(), this.userId, this.siteId);
        }
        return this.meeting;
    }

    private void cancel(SignupTimeslot timeslot, boolean cancelAction) {
        timeslot.setCanceled(cancelAction);
        List attendees = timeslot.getAttendees();
        if (cancelAction && attendees != null && !attendees.isEmpty()) {
            for (SignupAttendee attendee : attendees) {
                this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(attendee, timeslot, "signup.email.attendee.cancel", true);
            }
        }
        timeslot.setAttendees(null);
        timeslot.setWaitingList(null);
    }

    private SignupMeeting handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, boolean cancelAction) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
                this.signupEventTrackingInfo.setMeeting(meeting);
                currentTimeslot = meeting.getTimeslot(currentTimeslot.getId());
                if (currentTimeslot.isCanceled() == cancelAction) {
                    throw new SignupUserActionException(Utilities.rb.getString("someone.already.changed.ts.cancel_status"));
                }
                this.cancel(currentTimeslot, cancelAction);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return meeting;
            }
            catch (OptimisticLockingFailureException oe) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("failed.cancel_or_restore_ts"));
    }
}

