/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.attachment.AttachmentHandler;
import org.sakaiproject.signup.tool.jsf.attachment.RemoveAttachment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CopyFileProcessor
extends AttachmentHandler {
    private static Log log = LogFactory.getLog(CopyFileProcessor.class);

    public CopyFileProcessor(SakaiFacade sakaiFacade, SignupMeetingService signupMeetingService) {
        this.setSakaiFacade(sakaiFacade);
        this.setSignupMeetingService(signupMeetingService);
    }

    public String processAddAttachRedirect(List attachList, SignupMeeting sMeeting, boolean isOrganizer) {
        return null;
    }

    public SignupAttachment copySignupAttachment(SignupMeeting sMeeting, boolean isOrganizer, SignupAttachment attach, String fromContext, String toContext) {
        SignupAttachment newAttach = null;
        ContentResource cr = null;
        ContentResource newCr = null;
        if (attach == null || attach.getResourceId().trim().length() < 1) {
            return null;
        }
        String newResourceId = attach.getResourceId();
        if (newResourceId != null) {
            newResourceId = newResourceId.replaceAll(fromContext, toContext);
        }
        try {
            cr = this.getSakaiFacade().getContentHostingService().getResource(attach.getResourceId());
            if (cr != null) {
                String protocol = this.getSakaiFacade().getServerConfigurationService().getServerUrl();
                newResourceId = this.getSakaiFacade().getContentHostingService().copy(attach.getResourceId(), newResourceId);
                newCr = this.getSakaiFacade().getContentHostingService().getResource(newResourceId);
                Reference ref = EntityManager.newReference((String)newCr.getReference());
                if (ref != null) {
                    newAttach = this.createSignupAttachment(ref.getId(), ref.getProperties().getProperty(ref.getProperties().getNamePropDisplayName()), protocol);
                    this.determineAndAssignPublicView(sMeeting, newAttach);
                }
            }
        }
        catch (PermissionException e) {
            log.warn((Object)("ContentHostingService.getResource() throws PermissionException=" + e.getMessage()));
        }
        catch (IdUnusedException e) {
            log.warn((Object)("ContentHostingService.getResource() throws IdUnusedException=" + e.getMessage()));
            RemoveAttachment removeAttach = new RemoveAttachment(this.getSignupMeetingService(), this.getSakaiFacade().getCurrentUserId(), this.getSakaiFacade().getCurrentLocationId(), isOrganizer);
            removeAttach.removeAttachment(sMeeting, attach);
        }
        catch (TypeException e) {
            log.warn((Object)("ContentHostingService.getResource() throws TypeException=" + e.getMessage()));
        }
        catch (Exception e) {
            log.warn((Object)("ContentHostingService.getResource() throws Exception=" + e.getMessage()));
        }
        return newAttach;
    }

    public Element toXml(String element, Document doc, Stack stack) {
        Element ele = doc.createElement(element);
        if (stack.isEmpty()) {
            doc.appendChild(ele);
        } else {
            ((Element)stack.peek()).appendChild(ele);
        }
        stack.push(ele);
        stack.pop();
        return ele;
    }

    public static Element timeslotToXml(SignupTimeslot timeslot, Document doc, Stack<Element> stack) {
        Element element = doc.createElement("timeslot");
        if (stack.isEmpty()) {
            doc.appendChild(element);
        } else {
            stack.peek().appendChild(element);
        }
        stack.push(element);
        Date startTime = timeslot.getStartTime();
        Date endTime = timeslot.getEndTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strStartTime = formatter.format((Object)startTime);
        String strEndTime = formatter.format((Object)endTime);
        element.setAttribute("endTime", strEndTime);
        element.setAttribute("startTime", strStartTime);
        stack.pop();
        return element;
    }
}

