/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupGroup;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.entityproviders.CopyFileProcessor;
import org.sakaiproject.signup.tool.jsf.organizer.CopyMeetingSignupMBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateMeetings;
import org.sakaiproject.signup.tool.util.Utilities;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignupEntityProducer
implements MeetingTypes,
EntityProducer,
EntityTransferrer,
ApplicationContextAware {
    private static Log log = LogFactory.getLog(SignupEntityProducer.class);
    public static final String SIGNUP = "signup";
    public static final String REFERENCE_ROOT = "/signup";
    private EntityManager entityManager;
    private SakaiFacade sakaiFacade;
    ApplicationContext applicationContext;
    private CopyFileProcessor copyFileProcessor;
    private static boolean DEFAULT_ARCHIVE_SUPPORT = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.isarchive.support", (String)"false"));
    private SignupMeetingService signupMeetingService;
    private CreateMeetings createMeetings;
    private CopyMeetingSignupMBean copyMeetingSignupMBean;
    private SignupMeeting signupMeeting;
    private String currentUserID = null;
    private boolean sendEmail = true;
    private boolean assignParticatpantsToFirstOne = false;
    private boolean assignParticitpantsToAllEvents = false;
    CreateMeetings createMeeting = new CreateMeetings(this.signupMeeting, this.sendEmail, this.assignParticatpantsToFirstOne, this.assignParticitpantsToAllEvents, this.sakaiFacade, this.signupMeetingService, this.currentUserID);

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"signup EP.init()");
        }
        try {
            this.entityManager.registerEntityProducer((EntityProducer)this, REFERENCE_ROOT);
            log.info((Object)"Registered kaltura entity producer as: /signup");
            ApplicationContext sakaiAC = this.applicationContext.getParent();
            if (sakaiAC != null && sakaiAC instanceof ConfigurableApplicationContext) {
                Object currentKEP = ComponentManager.get((String)SignupEntityProducer.class.getName());
                if (currentKEP != null) {
                    log.info((Object)("Found existing " + SignupEntityProducer.class.getName() + " in the ComponentManager: " + currentKEP));
                    try {
                        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)sakaiAC.getAutowireCapableBeanFactory();
                        dlbf.destroySingleton(SignupEntityProducer.class.getName());
                        log.info((Object)("Removed existing " + SignupEntityProducer.class.getName() + " from the ComponentManager"));
                    }
                    catch (Exception e) {
                        log.warn((Object)("FAILED attempted removal of signup bean: " + e));
                    }
                }
                ((ConfigurableApplicationContext)sakaiAC).getBeanFactory().registerSingleton(SignupEntityProducer.class.getName(), (Object)this);
            }
            if (ComponentManager.get((String)SignupEntityProducer.class.getName()) != null) {
                log.info((Object)("Found " + SignupEntityProducer.class.getName() + " in the ComponentManager"));
            } else {
                log.warn((Object)("FAILED to insert and lookup " + SignupEntityProducer.class.getName() + " in the Sakai ComponentManager, archive imports for signup will not work"));
            }
        }
        catch (Exception ex) {
            log.warn((Object)("signup EP.init(): " + ex), (Throwable)ex);
        }
        this.copyFileProcessor = new CopyFileProcessor(this.getSakaiFacade(), this.getSignupMeetingService());
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public CopyMeetingSignupMBean getCopyMeetingSignupMBean() {
        return this.copyMeetingSignupMBean;
    }

    public void setCopyMeetingSignupMBean(CopyMeetingSignupMBean copyMeetingSignupMBean) {
        this.copyMeetingSignupMBean = copyMeetingSignupMBean;
    }

    public CreateMeetings getCreateMeetings() {
        return this.createMeetings;
    }

    public void setCreateMeetings(CreateMeetings createMeetings) {
        this.createMeetings = createMeetings;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids) {
        String currentUserId = this.getSakaiFacade().getCurrentUserId();
        List allMeetings = this.getSignupMeetingService().getAllSignupMeetings(fromContext, currentUserId);
        ArrayList<SignupMeeting> newMeetings = new ArrayList<SignupMeeting>();
        SignupMeeting copiedMeeting = new SignupMeeting();
        SignupMeeting meetingTemp = new SignupMeeting();
        ArrayList<Long> recurIDs = new ArrayList<Long>();
        int skip = 0;
        if (!allMeetings.isEmpty()) {
            for (int i = 0; i < allMeetings.size(); ++i) {
                SignupAttachment newOne;
                List olds;
                ArrayList<SignupAttachment> newOnes;
                meetingTemp = (SignupMeeting)allMeetings.get(i);
                if (meetingTemp.getRecurrenceId() != null && !recurIDs.contains(meetingTemp.getRecurrenceId())) {
                    recurIDs.add(meetingTemp.getRecurrenceId());
                    copiedMeeting = this.createMeeting.prepareDeepCopy(meetingTemp, 0);
                    copiedMeeting.setCoordinatorIds(currentUserId);
                    ((SignupSite)copiedMeeting.getSignupSites().get(0)).setSiteId(toContext);
                    copiedMeeting.setRepeatType("no_repeat");
                    newOnes = new ArrayList();
                    olds = meetingTemp.getSignupAttachments();
                    if (olds != null) {
                        for (SignupAttachment old : olds) {
                            newOne = this.copyFileProcessor.copySignupAttachment(meetingTemp, true, old, fromContext, toContext);
                            newOnes.add(newOne);
                        }
                    }
                    copiedMeeting.setSignupAttachments(newOnes);
                    newMeetings.add(i - skip, copiedMeeting);
                    continue;
                }
                if (recurIDs.contains(meetingTemp.getRecurrenceId())) {
                    ++skip;
                    continue;
                }
                copiedMeeting = this.createMeeting.prepareDeepCopy(meetingTemp, 0);
                copiedMeeting.setCoordinatorIds(currentUserId);
                ((SignupSite)copiedMeeting.getSignupSites().get(0)).setSiteId(toContext);
                copiedMeeting.setRepeatType("no_repeat");
                newOnes = new ArrayList<SignupAttachment>();
                olds = meetingTemp.getSignupAttachments();
                if (olds != null) {
                    for (SignupAttachment old : olds) {
                        newOne = this.copyFileProcessor.copySignupAttachment(meetingTemp, true, old, fromContext, toContext);
                        newOnes.add(newOne);
                    }
                }
                copiedMeeting.setSignupAttachments(newOnes);
                newMeetings.add(i - skip, copiedMeeting);
            }
            try {
                this.getSignupMeetingService().saveMeetings(newMeetings, currentUserId);
            }
            catch (PermissionException e) {
                log.warn((Object)("permission issue:" + e.getMessage()));
            }
        }
    }

    public String[] myToolIds() {
        return new String[]{"sakai.signup"};
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        String currentUserId = this.getSakaiFacade().getCurrentUserId();
        List oldMeetings = this.getSignupMeetingService().getAllSignupMeetings(toContext, currentUserId);
        try {
            this.getSignupMeetingService().removeMeetings(oldMeetings);
        }
        catch (Exception e1) {
            log.warn((Object)("remove oldmeeting error:" + e1.getMessage()));
        }
        this.transferCopyEntities(fromContext, toContext, ids);
    }

    public String getLabel() {
        return SIGNUP;
    }

    public boolean willArchiveMerge() {
        return DEFAULT_ARCHIVE_SUPPORT;
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        String currentUserId = this.getSakaiFacade().getCurrentUserId();
        StringBuilder results = new StringBuilder();
        results.append("archiving " + this.getLabel() + "/" + siteId + "/" + "main" + ".\n");
        Element rootElement = doc.createElement(SignupMeetingService.class.getName());
        ((Element)stack.peek()).appendChild(rootElement);
        stack.push(rootElement);
        List allMeetings = this.getSignupMeetingService().getAllSignupMeetings(siteId, currentUserId);
        if (allMeetings.size() > 0) {
            Element meetingListElement = this.copyFileProcessor.toXml("meetingList", doc, stack);
            for (int i = 0; allMeetings.size() > i; ++i) {
                try {
                    SignupMeeting meeting = (SignupMeeting)allMeetings.get(i);
                    Element meetingElement = this.copyFileProcessor.toXml("meeting", doc, stack);
                    Element titleElement = this.copyFileProcessor.toXml("title", doc, stack);
                    Element locElement = this.copyFileProcessor.toXml("location", doc, stack);
                    Element descElement = this.copyFileProcessor.toXml("description", doc, stack);
                    Element meetingTypeElement = this.copyFileProcessor.toXml("meetingType", doc, stack);
                    Element creatorIdElement = this.copyFileProcessor.toXml("creatorId", doc, stack);
                    titleElement.appendChild(doc.createTextNode(meeting.getTitle()));
                    locElement.appendChild(doc.createTextNode(meeting.getLocation()));
                    descElement.appendChild(doc.createTextNode(meeting.getDescription()));
                    meetingTypeElement.appendChild(doc.createTextNode(meeting.getMeetingType()));
                    creatorIdElement.appendChild(doc.createTextNode(meeting.getCreatorUserId()));
                    meetingElement.appendChild(titleElement);
                    meetingElement.appendChild(locElement);
                    meetingElement.appendChild(descElement);
                    meetingElement.appendChild(meetingTypeElement);
                    meetingElement.appendChild(creatorIdElement);
                    if (meeting.isRecurredMeeting()) {
                        Element recurElement = this.copyFileProcessor.toXml("recurrenceType", doc, stack);
                        recurElement.appendChild(doc.createTextNode(meeting.getRepeatType()));
                        meetingElement.appendChild(recurElement);
                    }
                    Element timeslotListElement = this.copyFileProcessor.toXml("timeslotList", doc, stack);
                    meetingElement.appendChild(timeslotListElement);
                    List timeslots = meeting.getSignupTimeSlots();
                    for (int j = 0; j < timeslots.size(); ++j) {
                        SignupTimeslot timeslot = (SignupTimeslot)timeslots.get(j);
                        List attendees = timeslot.getAttendees();
                        Element timeslotElement = CopyFileProcessor.timeslotToXml((SignupTimeslot)timeslot, (Document)doc, (Stack)stack);
                        timeslotListElement.appendChild(timeslotElement);
                        if (attendees.size() <= 0) continue;
                        Element attendeeListElement = this.copyFileProcessor.toXml("attendeeList", doc, stack);
                        timeslotElement.appendChild(attendeeListElement);
                        for (int q = 0; q < attendees.size(); ++q) {
                            SignupAttendee attendee = (SignupAttendee)attendees.get(q);
                            Element attendeeElement = this.copyFileProcessor.toXml("attendee", doc, stack);
                            Element attendeeIdElement = this.copyFileProcessor.toXml("attendeeId", doc, stack);
                            Element attendeeSiteIdElement = this.copyFileProcessor.toXml("attendeeSiteId", doc, stack);
                            attendeeIdElement.appendChild(doc.createTextNode(attendee.getAttendeeUserId()));
                            attendeeSiteIdElement.appendChild(doc.createTextNode(attendee.getSignupSiteId()));
                            attendeeElement.appendChild(attendeeIdElement);
                            attendeeElement.appendChild(attendeeSiteIdElement);
                            attendeeListElement.appendChild(attendeeElement);
                        }
                    }
                    if (meeting.hasSignupAttachments()) {
                        Element attachmentListElement = this.copyFileProcessor.toXml("attachmentList", doc, stack);
                        List allAttachments = meeting.getSignupAttachments();
                        meetingElement.appendChild(attachmentListElement);
                        for (int m = 0; m < allAttachments.size(); ++m) {
                            SignupAttachment attachment = (SignupAttachment)allAttachments.get(m);
                            Element attachmentElement = this.copyFileProcessor.toXml("attachment", doc, stack);
                            Element attachmentUrlElement = this.copyFileProcessor.toXml("attachmentUrl", doc, stack);
                            Element attachmentName = this.copyFileProcessor.toXml("attachmentName", doc, stack);
                            attachmentUrlElement.appendChild(doc.createTextNode(attachment.getResourceId()));
                            attachmentName.appendChild(doc.createTextNode(attachment.getFilename()));
                            attachmentElement.appendChild(attachmentUrlElement);
                            attachmentElement.appendChild(attachmentName);
                            attachmentListElement.appendChild(attachmentElement);
                        }
                    }
                    List allSitesInMeeting = meeting.getSignupSites();
                    Element availableToElement = this.copyFileProcessor.toXml("availableTo", doc, stack);
                    Element siteListElement = this.copyFileProcessor.toXml("siteList", doc, stack);
                    availableToElement.appendChild(siteListElement);
                    meetingElement.appendChild(availableToElement);
                    for (int n = 0; n < allSitesInMeeting.size(); ++n) {
                        SignupSite site = (SignupSite)allSitesInMeeting.get(n);
                        Element siteElement = this.copyFileProcessor.toXml("site", doc, stack);
                        Element siteIdElement = this.copyFileProcessor.toXml("siteId", doc, stack);
                        siteIdElement.appendChild(doc.createTextNode(site.getSiteId()));
                        siteElement.appendChild(siteIdElement);
                        siteListElement.appendChild(siteElement);
                        if (site.getSignupGroups().size() <= 0) continue;
                        List allGroupsInSite = site.getSignupGroups();
                        Element groupListElement = this.copyFileProcessor.toXml("groupList", doc, stack);
                        siteElement.appendChild(groupListElement);
                        for (int g = 0; g < allGroupsInSite.size(); ++g) {
                            SignupGroup group = (SignupGroup)allGroupsInSite.get(g);
                            Element groupElement = this.copyFileProcessor.toXml("group", doc, stack);
                            Element groupIdElement = this.copyFileProcessor.toXml("groupId", doc, stack);
                            groupIdElement.appendChild(doc.createTextNode(group.getGroupId()));
                            groupElement.appendChild(groupIdElement);
                            groupListElement.appendChild(groupElement);
                        }
                    }
                    meetingListElement.appendChild(meetingElement);
                    rootElement.appendChild(meetingListElement);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage());
                }
            }
        }
        stack.pop();
        return results.toString();
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        log.warn((Object)"Currently, Sign-up tool site archive will not support merging functionality from archive data into a site");
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        return false;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }
}

