/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.attachment;

import java.util.Iterator;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.springframework.dao.OptimisticLockingFailureException;

public class RemoveAttachment
extends SignupAction {
    public RemoveAttachment(SignupMeetingService signupMeetingService, String currentUserId, String currentSiteId, boolean isOrganizer) {
        super(currentUserId, currentSiteId, signupMeetingService, isOrganizer);
    }

    public void removeAttachment(SignupMeeting meeting, SignupAttachment remAttach) {
        try {
            if (meeting == null || meeting.getId() == null) {
                return;
            }
            this.handleVersion(meeting, remAttach);
        }
        catch (PermissionException pe) {
            this.logger.warn((Object)Utilities.rb.getString("no.permissoin.do_it"));
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
        }
    }

    public void actionsForOptimisticVersioning(SignupMeeting meeting, SignupAttachment remAttach) throws Exception {
        this.prepareRemoveAttachment(meeting, remAttach);
    }

    private void handleVersion(SignupMeeting meeting, SignupAttachment remAttach) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                this.actionsForOptimisticVersioning(meeting, remAttach);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                continue;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                // empty catch block
            }
        }
        throw new Exception("It's already removed");
    }

    private void prepareRemoveAttachment(SignupMeeting meeting, SignupAttachment remAttach) throws Exception {
        List attachList = meeting.getSignupAttachments();
        boolean found = false;
        if (attachList != null) {
            Iterator iter = attachList.iterator();
            while (iter.hasNext()) {
                SignupAttachment a = (SignupAttachment)iter.next();
                if (!a.getResourceId().equals(remAttach.getResourceId())) continue;
                iter.remove();
                found = true;
            }
        }
        if (!found) {
            throw new Exception("It's already removed");
        }
    }
}

