/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class AddWaiter
extends SignupAction
implements SignupBeanConstants {
    private final String operationType;

    public AddWaiter(SignupMeetingService signupMeetingService, String currentUserId, String currentSiteId, String operationType, boolean isOrganizer) {
        super(currentUserId, currentSiteId, signupMeetingService, isOrganizer);
        this.operationType = operationType;
    }

    public SignupMeeting addToWaitingList(SignupMeeting meeting, SignupTimeslot timeSlot, SignupAttendee newWaiter) throws Exception {
        try {
            this.handleVersion(meeting, timeSlot, newWaiter);
            if (ToolManager.getCurrentPlacement() != null) {
                String signupEventType = this.isOrganizer ? SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_WL_L : SignupEventTypes.EVENT_SIGNUP_ADD_ATTENDEE_WL_S;
                Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + " -added to wlist on TS:" + SignupDateFormat.format_date_h_mm_a((Date)timeSlot.getStartTime())));
            }
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + " - has added attendee(" + newWaiter.getAttendeeUserId() + ") into waiting list at timeslot started at:" + SignupDateFormat.format_date_h_mm_a((Date)timeSlot.getStartTime())));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
        finally {
            meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
        }
        return meeting;
    }

    private void prepareAddtoWaitingList(SignupMeeting meeting, SignupTimeslot timeSlot, SignupAttendee newWaiter) throws Exception {
        ArrayList<SignupAttendee> attendees;
        SignupTimeslot currentTimeSlot = timeSlot;
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot upToDateTimeslot : signupTimeSlots) {
            if (!currentTimeSlot.getId().equals(upToDateTimeslot.getId())) continue;
            currentTimeSlot = upToDateTimeslot;
            if (currentTimeSlot.isCanceled()) {
                throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.canceled"));
            }
            if (meeting.getPermission().isUpdate() || !currentTimeSlot.isLocked()) break;
            throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.locked"));
        }
        if ((attendees = currentTimeSlot.getAttendees()) != null && !attendees.isEmpty()) {
            for (SignupAttendee attendee : attendees) {
                if (!attendee.getAttendeeUserId().equals(newWaiter.getAttendeeUserId())) continue;
                throw new SignupUserActionException(Utilities.rb.getString("attendee.already.in.timeslot"));
            }
        }
        if (attendees == null || attendees.size() < currentTimeSlot.getMaxNoOfAttendees()) {
            if (attendees == null) {
                attendees = new ArrayList<SignupAttendee>();
                currentTimeSlot.setAttendees(attendees);
            }
            attendees.add(newWaiter);
            this.removeAttendeeFromWaitingList(meeting, newWaiter);
            this.removeAttendeeFromAttendeesList(meeting, currentTimeSlot, newWaiter);
            return;
        }
        if (!meeting.isAllowWaitList()) {
            throw new SignupUserActionException(Utilities.rb.getString("waitlist.option.just.turn.off"));
        }
        List waiters = currentTimeSlot.getWaitingList();
        if (waiters == null) {
            ArrayList<SignupAttendee> newWaiters = new ArrayList<SignupAttendee>();
            newWaiters.add(newWaiter);
            currentTimeSlot.setWaitingList(newWaiters);
            return;
        }
        for (SignupAttendee waiter : waiters) {
            if (!newWaiter.getAttendeeUserId().equals(waiter.getAttendeeUserId())) continue;
            throw new SignupUserActionException(Utilities.rb.getString("you.already.in_waiting_list"));
        }
        if ("toTopOfList".equals(this.operationType)) {
            waiters.add(0, newWaiter);
        } else {
            waiters.add(newWaiter);
        }
    }

    public void actionsForOptimisticVersioning(SignupMeeting meeting, SignupTimeslot timeSlot, SignupAttendee newWaiter) throws Exception {
        this.prepareAddtoWaitingList(meeting, timeSlot, newWaiter);
    }

    private SignupMeeting handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, SignupAttendee currentAttendee) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                this.actionsForOptimisticVersioning(meeting, currentTimeslot, currentAttendee);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return meeting;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("someone.already.updated.db"));
    }
}

