/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.logic.messages.SignupEventTrackingInfoImpl;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.organizer.action.SignupAction;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class MoveAttendee
extends SignupAction {
    public MoveAttendee(String userId, String siteId, SignupMeetingService signupMeetingService) {
        super(userId, siteId, signupMeetingService, true);
    }

    public void move(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String selectedTimeslotId) throws Exception {
        try {
            this.handleVersion(meeting, currentTimeslot, selectedAttendeeUserId, selectedTimeslotId);
            Utilities.postEventTracking((String)SignupEventTypes.EVENT_SIGNUP_MOVE_ATTENDEE_L, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.userId + this.signupEventTrackingInfo.getAllAttendeeTransferLogInfo()));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
    }

    private void moveAttendee(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String selectedTimeslotId) throws Exception {
        SignupAttendee signupAttendee = currentTimeslot.getAttendee(selectedAttendeeUserId);
        if (signupAttendee == null) {
            return;
        }
        currentTimeslot.getAttendees().remove(signupAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(signupAttendee, currentTimeslot, "signup.email.attendee.cancel", false);
        SignupTimeslot addTimeslot = meeting.getTimeslot(Long.valueOf(Long.parseLong(selectedTimeslotId)));
        if (addTimeslot.isCanceled()) {
            throw new SignupUserActionException(Utilities.rb.getString("timeslot.just.canceled"));
        }
        if (signupAttendee == null || addTimeslot.getAttendee(signupAttendee.getAttendeeUserId()) != null) {
            throw new SignupUserActionException(Utilities.rb.getString("failed.move.attendee_due_to_ts_isTaken"));
        }
        addTimeslot.getAttendees().add(signupAttendee);
        this.signupEventTrackingInfo.addOrUpdateAttendeeAllocationInfo(signupAttendee, addTimeslot, "signup.email.attendee.move", true);
        this.removeAttendeeFromWaitingList(addTimeslot, signupAttendee);
        this.promoteAttendeeFromWaitingList(meeting, currentTimeslot);
    }

    private void handleVersion(SignupMeeting meeting, SignupTimeslot currentTimeslot, String selectedAttendeeUserId, String selectedTimeslotId) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                this.signupEventTrackingInfo = new SignupEventTrackingInfoImpl();
                this.signupEventTrackingInfo.setMeeting(meeting);
                meeting = this.signupMeetingService.loadSignupMeeting(meeting.getId(), this.userId, this.siteId);
                currentTimeslot = meeting.getTimeslot(currentTimeslot.getId());
                if (currentTimeslot.getAttendee(selectedAttendeeUserId) == null) {
                    throw new SignupUserActionException(Utilities.rb.getString("failed.move.due_to_attendee_notExisted"));
                }
                this.moveAttendee(meeting, currentTimeslot, selectedAttendeeUserId, selectedTimeslotId);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                return;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        throw new SignupUserActionException(Utilities.rb.getString("failed.move.due_to_attendee_notExisted"));
    }
}

