/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf.organizer.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SignupEventTypes;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.signup.util.SignupDateFormat;
import org.sakaiproject.tool.cover.ToolManager;
import org.springframework.dao.OptimisticLockingFailureException;

public class RemoveWaiter
implements SignupBeanConstants {
    private static final int MAX_NUMBER_OF_RETRY = 20;
    private final SignupMeetingService signupMeetingService;
    private final String currentUserId;
    private final String currentSiteId;
    private Log logger = LogFactory.getLog(this.getClass());
    private final boolean isOrganizer;

    public RemoveWaiter(SignupMeetingService signupMeetingService, String currentUserId, String currentSiteId, String operationType, boolean isOrganizer) {
        this.signupMeetingService = signupMeetingService;
        this.currentUserId = currentUserId;
        this.currentSiteId = currentSiteId;
        this.isOrganizer = isOrganizer;
    }

    private SignupMeeting reloadMeeting(Long meetingId) {
        SignupMeeting m = this.signupMeetingService.loadSignupMeeting(meetingId, this.currentUserId, this.currentSiteId);
        return m;
    }

    public SignupMeeting removeFromWaitingList(SignupMeeting meeting, SignupTimeslot timeslot, SignupAttendee waiter) throws Exception {
        try {
            this.handleVersion(meeting, timeslot, waiter);
            if (ToolManager.getCurrentPlacement() != null) {
                String signupEventType = this.isOrganizer ? SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_WL_L : SignupEventTypes.EVENT_SIGNUP_REMOVE_ATTENDEE_WL_S;
                Utilities.postEventTracking((String)signupEventType, (String)(ToolManager.getCurrentPlacement().getContext() + " meetingId:" + meeting.getId() + " -removed from wlist on TS:" + SignupDateFormat.format_date_h_mm_a((Date)timeslot.getStartTime())));
            }
            this.logger.debug((Object)("Meeting Name:" + meeting.getTitle() + " - UserId:" + this.currentUserId + " - has removed attendee(userId):" + waiter.getAttendeeUserId() + " from waiting list" + " at timeslot started at:" + SignupDateFormat.format_date_h_mm_a((Date)timeslot.getStartTime())));
        }
        catch (PermissionException pe) {
            throw new SignupUserActionException(Utilities.rb.getString("no.permissoin.do_it"));
        }
        finally {
            meeting = this.reloadMeeting(meeting.getId());
        }
        return meeting;
    }

    private void handleVersion(SignupMeeting meeting, SignupTimeslot timeslot, SignupAttendee waiter) throws Exception {
        boolean success = false;
        for (int i = 0; i < 20; ++i) {
            try {
                meeting = this.reloadMeeting(meeting.getId());
                this.prepareRemoveFromWaitingList(meeting, timeslot, waiter);
                this.signupMeetingService.updateSignupMeeting(meeting, this.isOrganizer);
                success = true;
                break;
            }
            catch (OptimisticLockingFailureException optimisticLockingFailureException) {
                continue;
            }
        }
        if (!success) {
            throw new SignupUserActionException(Utilities.rb.getString("someone.already.updated.db"));
        }
    }

    private void prepareRemoveFromWaitingList(SignupMeeting meeting, SignupTimeslot timeSlot, SignupAttendee removedWaiter) throws Exception {
        SignupTimeslot currentTimeSlot = timeSlot;
        List signupTimeSlots = meeting.getSignupTimeSlots();
        for (SignupTimeslot upToDateTimeslot : signupTimeSlots) {
            if (!currentTimeSlot.getId().equals(upToDateTimeslot.getId())) continue;
            currentTimeSlot = upToDateTimeslot;
            break;
        }
        boolean found = false;
        List waiters = currentTimeSlot.getWaitingList();
        if (waiters != null) {
            Iterator iter = waiters.iterator();
            while (iter.hasNext()) {
                SignupAttendee waiter = (SignupAttendee)iter.next();
                if (!removedWaiter.getAttendeeUserId().equals(waiter.getAttendeeUserId())) continue;
                iter.remove();
                found = true;
            }
            if (!found) {
                throw new SignupUserActionException(Utilities.rb.getString("someone.already.removed_or_promoted_attendee"));
            }
        }
    }
}

