/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.downloadEvents;

import org.sakaiproject.util.FormattedText;

public class ExcelPlainTextFormat {
    private static final String BreakMark = "~@~";
    private static final String LINEBREAK_EXCEL = "\n";

    public static String convertFormattedHtmlTextToExcelPlaintext(String htmlText) {
        if (htmlText == null) {
            return "";
        }
        htmlText = htmlText.replaceAll("<p>", "");
        htmlText = htmlText.replaceAll("\r", "");
        htmlText = htmlText.replaceAll("</p>", BreakMark);
        htmlText = htmlText.replaceAll("<p />", BreakMark);
        htmlText = htmlText.replaceAll("<br />", BreakMark);
        htmlText = FormattedText.convertFormattedTextToPlaintext((String)htmlText);
        StringBuilder sb = new StringBuilder();
        int begin_pos = 0;
        int find_pos = 0;
        while (find_pos > -1 && find_pos < htmlText.length()) {
            find_pos = htmlText.indexOf(BreakMark, begin_pos);
            if (find_pos <= -1) continue;
            sb.append(htmlText.subSequence(begin_pos, find_pos));
            sb.append(LINEBREAK_EXCEL);
            begin_pos = find_pos += BreakMark.length();
        }
        if (begin_pos < htmlText.length()) {
            sb.append(htmlText.subSequence(begin_pos, htmlText.length() - 1));
        }
        htmlText = htmlText.replaceAll(BreakMark, LINEBREAK_EXCEL);
        return htmlText;
    }
}

