/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectDefinable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.extension.TemplateMap;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.restful.SignupEvent;
import org.sakaiproject.signup.tool.entityproviders.EventProcessHandler;

public class MySignupEventsProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
RequestStorable,
RedirectDefinable {
    protected SakaiFacade sakaiFacade;
    protected SignupMeetingService signupMeetingService;
    protected EventProcessHandler eventProcessHandler;
    public static String PREFIX = "mySignup";
    RequestStorage requestStorage = null;

    public String getEntityPrefix() {
        return PREFIX;
    }

    public TemplateMap[] defineURLMappings() {
        return new TemplateMap[]{new TemplateMap("/{prefix}/user/{userId}", "{prefix}{dot-extension}")};
    }

    public boolean entityExists(String id) {
        Long eventId;
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        try {
            eventId = new Long(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid event id (" + id + "), the id must be a number");
        }
        return this.getSignupMeetingService().isEventExisted(eventId);
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        SignupEvent event = (SignupEvent)entity;
        throw new IllegalArgumentException("Method: 'New' is not supported.");
    }

    public Object getSampleEntity() {
        return new SignupEvent();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String id = ref.getId();
        throw new IllegalArgumentException("Metho: 'updae' is not supported.");
    }

    public Object getEntity(EntityReference ref) {
        String id = ref.getId();
        throw new IllegalArgumentException("Metho: 'get' is not supported.");
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String id = ref.getId();
        throw new IllegalArgumentException("Metho: 'Delete' is not supported.");
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        Restriction userRes = search.getRestrictionByProperty("_userReference");
        String userId = null;
        if (userRes != null) {
            String currentUser = this.developerHelperService.getCurrentUserReference();
            String userReference = userRes.getStringValue();
            if (userReference == null) {
                throw new IllegalArgumentException("Invalid request: Cannot view event by user when the value is null");
            }
            if (this.developerHelperService.isUserAdmin(currentUser)) {
                userId = this.developerHelperService.getUserIdFromRef(userReference);
                if (this.getSakaiFacade().getUser(userId) == null) {
                    throw new IllegalArgumentException("Invalid User Id");
                }
            } else {
                userId = this.developerHelperService.getCurrentUserId();
                if (userId == null) {
                    throw new SecurityException("User is not logged in, so no event data can be retrieved");
                }
            }
        } else {
            userId = this.developerHelperService.getCurrentUserId();
            if (userId == null) {
                throw new SecurityException("User is not logged in, so no event data can be retrieved");
            }
        }
        String viewRange = (String)this.requestStorage.getStoredValueAsType(String.class, "viewNextDays");
        List events = this.getEventProcessHandler().getMySignupEvents(userId, viewRange);
        return events;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public EventProcessHandler getEventProcessHandler() {
        return this.eventProcessHandler;
    }

    public void setEventProcessHandler(EventProcessHandler eventProcessHandler) {
        this.eventProcessHandler = eventProcessHandler;
    }
}

