/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.List;
import java.util.Map;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectDefinable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestStorable;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestStorage;
import org.sakaiproject.entitybroker.entityprovider.extension.TemplateMap;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.restful.SignupEvent;
import org.sakaiproject.signup.tool.entityproviders.EventProcessHandler;

public class SignupEventEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
RESTful,
RequestStorable,
RedirectDefinable {
    protected SakaiFacade sakaiFacade;
    protected SignupMeetingService signupMeetingService;
    protected EventProcessHandler eventProcessHandler;
    public static String PREFIX = "signupEvent";
    RequestStorage requestStorage = null;

    public String getEntityPrefix() {
        return PREFIX;
    }

    public TemplateMap[] defineURLMappings() {
        return new TemplateMap[]{new TemplateMap("/{prefix}/site/{siteId}", "{prefix}{dot-extension}")};
    }

    public boolean entityExists(String id) {
        Long eventId;
        if (id == null) {
            return false;
        }
        if ("".equals(id)) {
            return true;
        }
        try {
            eventId = new Long(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid event id (" + id + "), the id must be a number");
        }
        return this.getSignupMeetingService().isEventExisted(eventId);
    }

    private SignupEvent getEventById(String id, boolean mustAccessDB) {
        Long eventId;
        try {
            eventId = new Long(id);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid event id (" + id + "), the id must be a number");
        }
        String siteId = this.developerHelperService.getCurrentLocationId();
        if (!(siteId != null && siteId.trim().length() >= 1 || (siteId = (String)this.requestStorage.getStoredValueAsType(String.class, "siteId")) != null && siteId.trim().length() >= 1)) {
            siteId = null;
        }
        SignupEvent event = this.getEventProcessHandler().getSignupEvent(eventId, siteId, this.sakaiFacade.getCurrentUserId(), mustAccessDB);
        event.setSiteId(siteId);
        return event;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        SignupEvent event = (SignupEvent)entity;
        throw new IllegalArgumentException("Method: 'New' is not supported currently.");
    }

    public Object getSampleEntity() {
        return new SignupEvent();
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String userAction;
        String userGoToTSid;
        String id = ref.getId();
        if (id == null) {
            throw new IllegalArgumentException("The reference must include an id for updates (id is currently null)");
        }
        String userReference = this.developerHelperService.getCurrentUserReference();
        if (userReference == null) {
            throw new SecurityException("anonymous user cannot update event: " + ref);
        }
        SignupEvent event = (SignupEvent)entity;
        String siteId = this.developerHelperService.getCurrentLocationId();
        if (siteId == null || siteId.trim().length() < 1) {
            String string = siteId = event != null ? event.getSiteId() : null;
            if (!(siteId != null && siteId.trim().length() >= 1 || (siteId = (String)this.requestStorage.getStoredValueAsType(String.class, "siteId")) != null && siteId.trim().length() >= 1)) {
                throw new IllegalArgumentException("Missing current site id: (" + id + "), it is required.");
            }
        }
        String string = userGoToTSid = event != null ? event.getAllocToTSid() : null;
        if (!(userGoToTSid != null && userGoToTSid.trim().length() >= 1 || (userGoToTSid = (String)this.requestStorage.getStoredValueAsType(String.class, "allocToTSid")) != null && userGoToTSid.trim().length() >= 1)) {
            throw new IllegalArgumentException("Missing allocToTSid, it is required.");
        }
        String string2 = userAction = event != null ? event.getUserActionType() : null;
        if (!(userAction != null && userAction.trim().length() >= 1 || (userAction = (String)this.requestStorage.getStoredValueAsType(String.class, "userActionType")) != null && userAction.trim().length() >= 1)) {
            throw new IllegalArgumentException("Missing userActionType, it is required.");
        }
        SignupEvent current = this.getEventById(id, true);
        if (current == null) {
            throw new IllegalArgumentException("No event found to update for the given reference: " + ref);
        }
        if (!current.getPermission().isAttend() && !current.getPermission().isUpdate()) {
            throw new SecurityException("Current user (" + userReference + ") cannot attend event in location (" + siteId + ")");
        }
        current.setAllocToTSid(userGoToTSid);
        current.setSiteId(siteId);
        current.setUserActionType(userAction);
        this.getEventProcessHandler().updateAttendStatus(current);
    }

    public Object getEntity(EntityReference ref) {
        String id = ref.getId();
        if (id == null) {
            return new SignupEvent();
        }
        String currentUserId = this.developerHelperService.getCurrentUserId();
        if (currentUserId == null) {
            throw new SecurityException("User must be logged in in order to access event data: " + ref);
        }
        SignupEvent event = this.getEventById(id, false);
        if (event == null) {
            throw new IllegalArgumentException("No event found for the given reference: " + ref);
        }
        String siteId = this.developerHelperService.getCurrentLocationId();
        if (siteId == null || siteId.trim().length() < 1) {
            siteId = (String)this.requestStorage.getStoredValueAsType(String.class, "siteId");
        }
        boolean allowedView = false;
        if (!this.developerHelperService.isEntityRequestInternal(ref + "")) {
            String userReference = this.developerHelperService.getCurrentUserReference();
            if (!event.getPermission().isAttend() && !event.getPermission().isUpdate()) {
                throw new SecurityException("User (" + userReference + ") not allowed to access event data: " + ref);
            }
        }
        return event;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
        String id = ref.getId();
        throw new IllegalArgumentException("Metho: 'Delete' is not supported currently.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<?> getEntities(EntityReference ref, Search search) {
        Restriction locRes = search.getRestrictionByProperty("_locationReference");
        String siteId = null;
        if (locRes != null) {
            siteId = this.developerHelperService.getLocationIdFromRef(locRes.getStringValue());
        }
        if (siteId == null) {
            throw new IllegalArgumentException("Missing site id, cannot retrieve signup events");
        }
        Restriction userRes = search.getRestrictionByProperty("_userReference");
        String userId = null;
        if (userRes != null) {
            String currentUser = this.developerHelperService.getCurrentUserReference();
            String userReference = userRes.getStringValue();
            if (userReference == null) {
                throw new IllegalArgumentException("Invalid request: Cannot limit event by user when the value is null");
            }
            if (!userReference.equals(currentUser)) {
                if (!this.developerHelperService.isUserAdmin(currentUser)) throw new SecurityException("Only the admin can get event for other users, you requested event for: " + userReference);
            }
            userId = this.developerHelperService.getUserIdFromRef(userReference);
        } else {
            userId = this.developerHelperService.getCurrentUserId();
            if (userId == null) {
                throw new SecurityException("No user is currently logged in so no event data can be retrieved");
            }
        }
        String viewRange = (String)this.requestStorage.getStoredValueAsType(String.class, "viewNextDays");
        return this.getEventProcessHandler().getSignupEvents(siteId, userId, viewRange);
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    public void setRequestStorage(RequestStorage requestStorage) {
        this.requestStorage = requestStorage;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public EventProcessHandler getEventProcessHandler() {
        return this.eventProcessHandler;
    }

    public void setEventProcessHandler(EventProcessHandler eventProcessHandler) {
        this.eventProcessHandler = eventProcessHandler;
    }
}

