/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.entityproviders;

import java.util.Date;
import java.util.List;
import org.sakaiproject.signup.restful.SignupEvent;
import org.sakaiproject.signup.restful.SignupParticipant;
import org.sakaiproject.signup.restful.SignupTimeslotItem;
import org.sakaiproject.signup.tool.entityproviders.SignupRESTfulSessionManager;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.tool.cover.SessionManager;

public class SignupRESTfulSessionManager {
    private static final String USER_SESSION_DATA = "signup.user.session.data";
    private static final long TIME_INTERVAL_TO_REFRESH = 300000L;

    SignupRESTfulSessionManager() {
    }

    public UserSignupSessionData getStoredUserSessionData() {
        return (UserSignupSessionData)SessionManager.getCurrentSession().getAttribute(USER_SESSION_DATA);
    }

    public SignupEventsCache getSignupEventsCache(String uniqueId) {
        if (uniqueId == null || this.getStoredUserSessionData() == null) {
            return null;
        }
        return this.getStoredUserSessionData().get(uniqueId);
    }

    public void StoreSignupEventsData(String uniqueId, List<SignupEvent> events, String viewRange) {
        SignupEventsCache signupEventsCache = new SignupEventsCache(this, uniqueId, events, viewRange);
        UserSignupSessionData userDataMap = this.getStoredUserSessionData();
        if (userDataMap == null) {
            userDataMap = new UserSignupSessionData(this);
        }
        userDataMap.add(uniqueId, signupEventsCache);
        this.storeUserDataInSession(userDataMap);
    }

    public void StoreSignupEventsData(String uniqueId, SignupEventsCache cache) {
        UserSignupSessionData userDataMap = this.getStoredUserSessionData();
        if (userDataMap == null) {
            userDataMap = new UserSignupSessionData(this);
        }
        userDataMap.add(uniqueId, cache);
        this.storeUserDataInSession(userDataMap);
    }

    public boolean isUpTodateDataAvailable(String uniqueId) {
        return this.getSignupEventsCache(uniqueId) != null && !this.isRefresh(this.getSignupEventsCache(uniqueId));
    }

    public boolean isSameViewRange(String id, String viewRange) {
        SignupEventsCache sec = this.getSignupEventsCache(id);
        return sec != null && sec.getViewRange().equals(viewRange);
    }

    public SignupEvent getExistedSignupEventInCache(String uniqueId, Long eventId) {
        if (this.getSignupEventsCache(uniqueId) != null) {
            return this.getSignupEventsCache(uniqueId).getSignupEvent(eventId);
        }
        return null;
    }

    public void updateSignupEventsCache(String uniqueId, SignupEvent event) {
        SignupEventsCache eCache = this.getSignupEventsCache(uniqueId);
        if (eCache == null) {
            return;
        }
        if (event == null) {
            this.cleanSignupEventsCache(uniqueId);
            return;
        }
        eCache.updateSignupEvent(event);
        this.StoreSignupEventsData(uniqueId, eCache);
    }

    public void updateMySignupEventsCache(String userId, SignupEvent event, String userAction) {
        SignupEventsCache eCache = this.getSignupEventsCache(userId);
        if (eCache == null) {
            return;
        }
        if (event == null) {
            this.cleanSignupEventsCache(userId);
            return;
        }
        if ("cancelSignup".equals(userAction)) {
            eCache.removeEvent(event);
        } else if ("signup".equals(userAction)) {
            this.populateMySignedUpEventData(event, userId);
            eCache.addEvent(event);
        }
        this.StoreSignupEventsData(userId, eCache);
    }

    private void populateMySignedUpEventData(SignupEvent event, String userId) {
        List tsList = event.getSignupTimeSlotItems();
        if (tsList != null) {
            for (SignupTimeslotItem ts : tsList) {
                List attList = ts.getAttendees();
                if (attList == null) continue;
                for (SignupParticipant p : attList) {
                    if (!p.getAttendeeUserId().equals(userId)) continue;
                    event.setMyStartTime(ts.getStartTime());
                    event.setMyEndTime(ts.getEndTime());
                    event.setAvailableStatus(Utilities.rb.getString("event.youSignedUp"));
                    return;
                }
            }
        }
    }

    private void storeUserDataInSession(UserSignupSessionData userSessionData) {
        SessionManager.getCurrentSession().setAttribute(USER_SESSION_DATA, (Object)userSessionData);
    }

    private void cleanSignupEventsCache(String uniqueId) {
        UserSignupSessionData userSnData = this.getStoredUserSessionData();
        userSnData.remove(uniqueId);
        this.storeUserDataInSession(userSnData);
    }

    private boolean isRefresh(SignupEventsCache cache) {
        Date current = new Date();
        return current.getTime() - cache.getLastUpdatedTime().getTime() > 300000L;
    }
}

