/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.tool.util.PlainTextFormat;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;

public class AttendeeWrapper
implements Comparable {
    private SignupAttendee signupAttendee;
    private String displayName;
    private int positionIndex = 0;
    private String timeslotPeriod;
    private String attendeeEmail;
    private static final int DISPLAY_LENGTH = 100;

    public AttendeeWrapper(SignupAttendee attendee, String displayName) {
        this.signupAttendee = attendee;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SignupAttendee getSignupAttendee() {
        return this.signupAttendee;
    }

    public void setSignupAttendee(SignupAttendee signupAttendee) {
        this.signupAttendee = signupAttendee;
    }

    public int getPositionIndex() {
        return this.positionIndex;
    }

    public void setPositionIndex(int positionIndex) {
        this.positionIndex = positionIndex;
    }

    public String getTimeslotPeriod() {
        return this.timeslotPeriod;
    }

    public void setTimeslotPeriod(String timeslotPeriod) {
        this.timeslotPeriod = timeslotPeriod;
    }

    public String getCommentForTooltips() {
        String comment = this.signupAttendee.getComments();
        if (comment == null || comment.trim().length() < 1) {
            return "No Comment";
        }
        int totalLength = comment.length();
        int diplayLength = totalLength > 100 ? 100 : totalLength;
        comment = comment.substring(0, diplayLength) + (totalLength > 100 ? "..." : "");
        return PlainTextFormat.convertFormattedHtmlTextToPlaintext((String)comment);
    }

    public boolean isComment() {
        String comment = this.signupAttendee.getComments();
        return comment != null && comment.trim().length() > 0;
    }

    public boolean isAttended() {
        return this.signupAttendee.isAttended();
    }

    public void setAttended(boolean attended) {
        this.signupAttendee.setAttended(attended);
    }

    public String getAttendeeEmail() {
        try {
            String userId = this.getSignupAttendee().getAttendeeUserId();
            User u = UserDirectoryService.getUser((String)userId);
            this.attendeeEmail = u.getEmail();
            if (this.attendeeEmail != null && this.attendeeEmail.trim().length() == 0) {
                this.attendeeEmail = null;
            }
        }
        catch (UserNotDefinedException e) {
            this.attendeeEmail = null;
        }
        return this.attendeeEmail;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof AttendeeWrapper)) {
            throw new ClassCastException("Not type of SignupUser");
        }
        AttendeeWrapper other = (AttendeeWrapper)o;
        if (this.displayName == null) {
            return -1;
        }
        int value = this.displayName.compareTo(other.getDisplayName());
        if (value != 0) {
            return value;
        }
        return 0;
    }
}

