/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlDataTable;
import org.apache.myfaces.custom.sortheader.HtmlCommandSortHeader;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlLinkRendererBase;

public class HtmlSortHeaderRenderer
extends HtmlLinkRendererBase {
    private static final Log log = LogFactory.getLog(HtmlSortHeaderRenderer.class);
    public static final String CURRENT_SORT_STYLE = "currentSort";
    public static final String NOT_CURRENT_SORT_STYLE = "notCurrentSort";

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandSortHeader) {
            String unStyleClass;
            String newStyleClass;
            HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)component;
            String styleClass = StringUtils.trimToNull((String)this.getStyleClass(facesContext, component));
            if (sortHeader.findParentDataTable().getSortColumn().equals(sortHeader.getColumnName())) {
                newStyleClass = CURRENT_SORT_STYLE;
                unStyleClass = NOT_CURRENT_SORT_STYLE;
            } else {
                newStyleClass = NOT_CURRENT_SORT_STYLE;
                unStyleClass = CURRENT_SORT_STYLE;
            }
            if (StringUtils.indexOf((String)styleClass, (String)newStyleClass) == -1) {
                styleClass = StringUtils.indexOf((String)styleClass, (String)unStyleClass) != -1 ? StringUtils.replace((String)styleClass, (String)unStyleClass, (String)newStyleClass) : (styleClass != null ? styleClass + ' ' + newStyleClass : newStyleClass);
                sortHeader.setStyleClass(styleClass);
            }
        }
        super.encodeBegin(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("encodeEnd rendering " + component));
        }
        if (!UserRoleUtils.isEnabledOnUserRole((UIComponent)component)) {
            super.encodeEnd(facesContext, component);
        } else {
            HtmlCommandSortHeader sortHeader = (HtmlCommandSortHeader)component;
            HtmlDataTable dataTable = sortHeader.findParentDataTable();
            if (sortHeader.isArrow() && sortHeader.getColumnName().equals(dataTable.getSortColumn())) {
                ResponseWriter writer = facesContext.getResponseWriter();
                writer.write("&#160;");
                HtmlGraphicImage image = new HtmlGraphicImage();
                if (dataTable.isSortAscending()) {
                    image.setValue((Object)"/library/image/sakai/sortascending.gif");
                } else {
                    image.setValue((Object)"/library/image/sakai/sortdescending.gif");
                }
                writer.startElement("img", (UIComponent)image);
                writer.writeURIAttribute("src", image.getValue(), null);
                writer.endElement("img");
            }
            super.encodeEnd(facesContext, component);
        }
    }
}

