/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.logic.SignupUser;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupSite;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.SignupSiteWrapper;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.attachment.AttachmentHandler;
import org.sakaiproject.signup.tool.jsf.organizer.UserDefineTimeslotBean;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateMeetings;
import org.sakaiproject.signup.tool.jsf.organizer.action.CreateSitesGroups;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;

public class NewSignupMeetingBean
implements MeetingTypes,
SignupMessageTypes,
SignupBeanConstants {
    private SignupMeetingService signupMeetingService;
    private SignupMeeting signupMeeting;
    private SakaiFacade sakaiFacade;
    private HtmlInputHidden currentStepHiddenInfo;
    private boolean unlimited;
    private int numberOfSlots;
    private int numberOfAttendees;
    private int maxOfAttendees;
    private int timeSlotDuration;
    private boolean recurrence;
    private String signupBeginsType;
    private String selectedLocation;
    private String customLocation;
    private List<SelectItem> locations = null;
    private String selectedCategory;
    private String customCategory;
    private List<SelectItem> categories = null;
    private String repeatType;
    private Date repeatUntil;
    private String recurLengthChoice;
    private int occurrences;
    private boolean assignParicitpantsToAllRecurEvents = false;
    private int signupBegins;
    private String deadlineTimeType;
    private int deadlineTime;
    private SignupSiteWrapper currentSite;
    private List<SignupSiteWrapper> otherSites;
    private static boolean DEFAULT_SEND_EMAIL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.email.notification", (String)"true"));
    protected boolean sendEmail = DEFAULT_SEND_EMAIL;
    private boolean receiveEmail;
    private boolean sendEmailByOwner;
    private static boolean DEFAULT_ALLOW_WAITLIST = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.allow.waitlist", (String)"true"));
    private static boolean DEFAULT_ALLOW_COMMENT = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.allow.comment", (String)"true"));
    private static boolean DEFAULT_AUTO_RIMINDER = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.event.default.auto.reminder", (String)"true"));
    private static boolean DEFAULT_AUTO_RMINDER_OPTION_CHOICE = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.autoRiminder.option.choice.setting", (String)"true"));
    private static boolean DEFAULT_USERID_INPUT_MODE_OPTION_CHOICE = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.userId.inputMode.choiceOption.setting", (String)"true"));
    private static boolean DEFAULT_EXPORT_TO_CALENDAR_TOOL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.export.to.calendar.setting", (String)"true"));
    private static boolean DEFAULT_CREATE_GROUPS = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.create.groups.setting", (String)"true"));
    protected static boolean NEW_MEETING_SEND_EMAIL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.email.notification.mandatory.for.newMeeting", (String)"true"));
    private boolean mandatorySendEmail = NEW_MEETING_SEND_EMAIL;
    private String sendEmailToSelectedPeopleOnly = "organizers_only";
    private boolean publishToCalendar = DEFAULT_EXPORT_TO_CALENDAR_TOOL;
    private boolean createGroups = DEFAULT_CREATE_GROUPS;
    private boolean allowWaitList = DEFAULT_ALLOW_WAITLIST;
    private boolean allowComment = DEFAULT_ALLOW_COMMENT;
    private boolean autoReminder = DEFAULT_AUTO_RIMINDER;
    private boolean autoReminderOptionChoice = DEFAULT_AUTO_RMINDER_OPTION_CHOICE;
    private boolean userIdInputModeOptionChoice = DEFAULT_USERID_INPUT_MODE_OPTION_CHOICE;
    private List<TimeslotWrapper> timeSlotWrappers;
    private List<SelectItem> meetingTypeRadioBttns;
    List<SignupUser> allSignupUsers;
    List<SignupUser> allPossibleCoordinators;
    private List<SelectItem> allAttendees;
    private UIInput newAttendeeInput;
    private String eidOrEmailInputByUser;
    private UIData timeslotWrapperTable;
    private boolean showParticipants;
    private boolean validationError;
    private boolean eidInputMode = false;
    private Boolean publishedSite;
    private boolean endTimeAutoAdjusted = false;
    private List<SignupAttachment> attachments;
    private AttachmentHandler attachmentHandler;
    private UserDefineTimeslotBean userDefineTimeslotBean;
    private List<TimeslotWrapper> customTimeSlotWrpList;
    private boolean otherSitesAvailability;
    private boolean userDefinedTS = false;
    private String creatorUserId;
    private int maxSlots;
    private int maxAttendeesPerSlot;
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String PARAM_NAME_FOR_ATTENDEE_USERID = "attendeeUserId";
    private int maxNumOfSlots;
    private List<SelectItem> slots;
    private String eventFreqType = "";
    private String iframeId = "";

    public int getMaxNumOfSlots() {
        return this.maxNumOfSlots;
    }

    public void setMaxNumOfSlots(int preferredSlot) {
        this.maxNumOfSlots = preferredSlot;
    }

    public List<SelectItem> getSlots() {
        this.slots = new ArrayList();
        for (int i = 1; i <= this.numberOfSlots; ++i) {
            this.slots.add(new SelectItem((Object)i, i + ""));
        }
        return this.slots;
    }

    public String getCurrentUserDisplayName() {
        return this.sakaiFacade.getUserDisplayName(this.sakaiFacade.getCurrentUserId());
    }

    public String getselectedLocation() {
        return this.selectedLocation;
    }

    public void setselectedLocation(String selectedLocation) {
        this.selectedLocation = selectedLocation;
    }

    public String getcustomLocation() {
        return this.customLocation;
    }

    public void setcustomLocation(String customLocation) {
        this.customLocation = customLocation;
    }

    public String getselectedCategory() {
        return this.selectedCategory;
    }

    public void setselectedCategory(String selectedCategory) {
        this.selectedCategory = selectedCategory;
    }

    public String getcustomCategory() {
        return this.customCategory;
    }

    public void setcustomCategory(String customCategory) {
        this.customCategory = customCategory;
    }

    public String getCreatorUserId() {
        if (this.creatorUserId == null) {
            return this.sakaiFacade.getCurrentUserId();
        }
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public boolean isOtherSitesAvailability() {
        String toolProperty = this.sakaiFacade.getToolManager().getCurrentPlacement().getConfig().getProperty("signup.other.sites.availability", "default");
        if (toolProperty.equals("default")) {
            String sakaiProperty;
            toolProperty = sakaiProperty = Boolean.valueOf(this.sakaiFacade.getServerConfigurationService().getBoolean("signup.otherSitesAvailability", true)).toString();
        }
        this.otherSitesAvailability = !"false".equalsIgnoreCase(toolProperty);
        return this.otherSitesAvailability;
    }

    public void setOtherSitesAvailability(boolean otherSitesAvailability) {
        this.otherSitesAvailability = otherSitesAvailability;
    }

    public int getMaxSlots() {
        String maxSlotsStringVal = Utilities.getSignupConfigParamVal((String)"signup.maxSlots", (String)"500");
        try {
            this.maxSlots = Integer.parseInt(maxSlotsStringVal);
        }
        catch (Exception e) {
            this.maxSlots = 500;
        }
        return this.maxSlots;
    }

    public void setMaxSlots(int maxSlots) {
        this.maxSlots = maxSlots;
    }

    public int getMaxAttendeesPerSlot() {
        String maxAttendeesStringVal = Utilities.getSignupConfigParamVal((String)"signup.maxAttendeesPerSlot", (String)"500");
        try {
            this.maxAttendeesPerSlot = Integer.parseInt(maxAttendeesStringVal);
        }
        catch (Exception e) {
            this.maxAttendeesPerSlot = 500;
        }
        return this.maxAttendeesPerSlot;
    }

    public void setMaxAttendeesPerSlot(int maxAttendeesPerSlot) {
        this.maxAttendeesPerSlot = maxAttendeesPerSlot;
    }

    public NewSignupMeetingBean() {
        this.init();
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public Date getRepeatUntil() {
        return this.repeatUntil;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public void setRepeatUntil(Date repeatUntil) {
        this.repeatUntil = repeatUntil;
    }

    private void init() {
        this.signupMeeting = new SignupMeeting();
        this.signupMeeting.setMeetingType("individual");
        Date date = new Date();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(date);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        this.signupMeeting.setStartTime(startCal.getTime());
        Calendar endCal = startCal;
        endCal.add(10, 1);
        this.signupMeeting.setEndTime(endCal.getTime());
        this.unlimited = false;
        this.recurrence = false;
        this.assignParicitpantsToAllRecurEvents = false;
        this.numberOfSlots = 4;
        this.numberOfAttendees = 1;
        this.maxOfAttendees = 10;
        this.timeSlotDuration = 0;
        this.signupBegins = 6;
        this.deadlineTime = 1;
        this.signupBeginsType = "days";
        this.deadlineTimeType = "hours";
        this.validationError = false;
        this.sendEmail = DEFAULT_SEND_EMAIL;
        if (NEW_MEETING_SEND_EMAIL) {
            this.sendEmail = NEW_MEETING_SEND_EMAIL;
        }
        this.sendEmailToSelectedPeopleOnly = "organizers_only";
        this.receiveEmail = false;
        this.sendEmailByOwner = DEFAULT_SEND_EMAIL;
        this.allowComment = DEFAULT_ALLOW_COMMENT;
        this.allowWaitList = DEFAULT_ALLOW_WAITLIST;
        this.autoReminder = DEFAULT_AUTO_RIMINDER;
        this.publishToCalendar = DEFAULT_EXPORT_TO_CALENDAR_TOOL;
        this.createGroups = DEFAULT_CREATE_GROUPS;
        this.currentStepHiddenInfo = null;
        this.eidInputMode = false;
        this.repeatType = "no_repeat";
        this.repeatUntil = startCal.getTime();
        this.recurLengthChoice = "1";
        this.occurrences = 0;
        this.publishedSite = null;
        this.userDefinedTS = false;
        this.customTimeSlotWrpList = null;
        this.otherSitesAvailability = true;
        this.creatorUserId = null;
        if (this.attachments != null && this.attachments.size() > 0) {
            for (SignupAttachment attach : this.attachments) {
                this.getAttachmentHandler().removeAttachmentInContentHost(attach);
            }
            this.attachments.clear();
        } else {
            this.attachments = new ArrayList();
        }
    }

    public void reset() {
        this.init();
        this.signupBeginsType = "days";
        this.deadlineTimeType = "hours";
        this.signupBegins = 6;
        this.deadlineTime = 1;
        this.timeSlotWrappers = null;
        this.currentSite = null;
        this.otherSites = null;
        Utilities.resetMeetingList();
        this.eidOrEmailInputByUser = null;
        this.selectedLocation = null;
        this.customLocation = "";
        this.selectedCategory = null;
        this.customCategory = "";
        this.creatorUserId = null;
        this.locations = null;
        this.categories = null;
        this.getUserDefineTimeslotBean().reset("new_meeting");
    }

    public List<SelectItem> getAllLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList();
            this.locations.addAll(Utilities.getSignupMeetingsBean().getAllLocations());
            this.locations.add(0, new SelectItem((Object)Utilities.rb.getString("select_location")));
        }
        return this.locations;
    }

    public List<SelectItem> getAllCategories() {
        if (this.categories == null) {
            this.categories = new ArrayList();
            this.categories.addAll(Utilities.getSignupMeetingsBean().getAllCategories());
            this.categories.remove(0);
            this.categories.add(0, new SelectItem((Object)Utilities.rb.getString("select_category")));
        }
        return this.categories;
    }

    public String goNext() {
        if (this.validationError) {
            this.validationError = false;
            return "addMeetingStep1";
        }
        String step = (String)this.currentStepHiddenInfo.getValue();
        if (step.equals("step1")) {
            this.setTimeSlotDuration(0);
            if (this.isUserDefinedTS()) {
                if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"new_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
                    return "addMeetingStep1";
                }
                this.customTimeSlotWrpList = this.getUserDefineTimeslotBean().getDestTSwrpList();
            }
            return "addMeetingStep2";
        }
        return "addMeetingStep1";
    }

    public String addRemoveAttachments() {
        this.getAttachmentHandler().processAddAttachRedirect(this.attachments, this.signupMeeting, true);
        return null;
    }

    public String createUserDefTimeSlots() {
        this.timeSlotDuration = 0;
        this.customTimeSlotWrpList = this.timeSlotWrappers();
        this.getUserDefineTimeslotBean().init(this.signupMeeting, "addMeetingStep1", this.customTimeSlotWrpList, "new_meeting");
        return "userDefinedTsBlocks";
    }

    public String editUserDefTimeSlots() {
        if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"new_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
            this.reset();
            return "addMeetingStep1";
        }
        this.customTimeSlotWrpList = this.getUserDefineTimeslotBean().getDestTSwrpList();
        this.getUserDefineTimeslotBean().init(this.signupMeeting, "addMeetingStep1", this.customTimeSlotWrpList, "new_meeting");
        return "userDefinedTsBlocks";
    }

    public boolean getPrePopulateValues() {
        if (this.signupMeeting.getStartTime() == null && this.isUserDefinedTS()) {
            this.signupMeeting.setStartTime(this.getUserDefineTimeslotBean().getEventStartTime());
            this.signupMeeting.setEndTime(this.getUserDefineTimeslotBean().getEventEndTime());
        }
        return false;
    }

    public void validateNewMeeting(ActionEvent e) {
        if (this.currentStepHiddenInfo == null) {
            return;
        }
        String step = (String)this.currentStepHiddenInfo.getValue();
        if (step.equals("step1")) {
            double duration;
            boolean locationSet = false;
            if (StringUtils.isNotBlank((String)this.customLocation)) {
                this.logger.debug((Object)("custom location set: " + this.customLocation));
                this.signupMeeting.setLocation(this.customLocation);
                locationSet = true;
            }
            if (!locationSet && StringUtils.isNotBlank((String)this.selectedLocation) && !StringUtils.equals((String)this.selectedLocation, (String)Utilities.rb.getString("select_location"))) {
                this.signupMeeting.setLocation(this.selectedLocation);
                this.logger.debug((Object)("chose a location: " + this.selectedLocation));
                locationSet = true;
            }
            if (!locationSet) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.location_not_assigned"));
                return;
            }
            if (StringUtils.isNotBlank((String)this.customCategory)) {
                this.signupMeeting.setCategory(this.customCategory);
            } else if (!StringUtils.equals((String)this.selectedCategory, (String)Utilities.rb.getString("select_category"))) {
                this.signupMeeting.setCategory(this.selectedCategory);
            }
            this.signupMeeting.setCreatorUserId(this.creatorUserId);
            Date eventEndTime = this.signupMeeting.getEndTime();
            Date eventStartTime = this.signupMeeting.getStartTime();
            if (this.isUserDefinedTS()) {
                eventEndTime = this.getUserDefineTimeslotBean().getEventEndTime();
                eventStartTime = this.getUserDefineTimeslotBean().getEventStartTime();
                this.signupMeeting.setStartTime(eventStartTime);
                this.signupMeeting.setEndTime(eventEndTime);
                if (this.getUserDefineTimeslotBean().getDestTSwrpList() == null || this.getUserDefineTimeslotBean().getDestTSwrpList().isEmpty()) {
                    this.validationError = true;
                    Utilities.addErrorMessage((String)Utilities.rb.getString("event.create_custom_defined_TS_blocks"));
                    return;
                }
            }
            if (eventEndTime.before(eventStartTime) || eventStartTime.equals(eventEndTime)) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("event.endTime_should_after_startTime"));
                return;
            }
            this.setRecurrence(false);
            if (!this.getRepeatType().equals("no_repeat")) {
                int repeatNum = this.getOccurrences();
                if ("1".equals(this.getRecurLengthChoice())) {
                    repeatNum = CreateMeetings.getNumOfRecurrence((String)this.getRepeatType(), (Date)eventStartTime, (Date)this.getRepeatUntil());
                }
                if (("daily".equals(this.getRepeatType()) || "wkdays_mon-fri".equals(this.getRepeatType())) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 1)) {
                    this.validationError = true;
                    Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.daily.problem"));
                    return;
                }
                if ("weekly".equals(this.getRepeatType()) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 7)) {
                    this.validationError = true;
                    Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.weekly.problem"));
                    return;
                }
                if ("biweekly".equals(this.getRepeatType()) && this.isMeetingOverRepeatPeriod(eventStartTime, eventEndTime, 14)) {
                    this.validationError = true;
                    Utilities.addErrorMessage((String)Utilities.rb.getString("crossDay.event.repeat.biweekly.problem"));
                    return;
                }
                if (repeatNum < 1) {
                    this.validationError = true;
                    if ("1".equals(this.getRecurLengthChoice())) {
                        Utilities.addErrorMessage((String)Utilities.rb.getString("event.repeatbeforestart"));
                    } else {
                        Utilities.addErrorMessage((String)Utilities.rb.getString("event.repeatNnum.bigger.than.one"));
                    }
                    return;
                }
                this.setRecurrence(true);
            }
            this.warnMeetingAccrossTwoDates(eventEndTime, eventStartTime);
            if (!CreateSitesGroups.isAtleastASiteOrGroupSelected((SignupSiteWrapper)this.getCurrentSite(), (List)this.getOtherSites())) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("select.atleast.oneGroup"));
            }
            if (this.signupMeeting.getMeetingType() == null) {
                this.validationError = true;
                Utilities.addErrorMessage((String)Utilities.rb.getString("signup.validator.selectMeetingType"));
            }
            this.setEndTimeAutoAdjusted(false);
            if (!this.isUserDefinedTS() && this.isIndividualType() && this.getNumberOfSlots() != 0 && (duration = (double)(this.getSignupMeeting().getEndTime().getTime() - this.getSignupMeeting().getStartTime().getTime()) / (double)(60000 * this.getNumberOfSlots())) != Math.floor(duration)) {
                this.setEndTimeAutoAdjusted(true);
                Utilities.addErrorMessage((String)Utilities.rb.getString("event_endtime_auto_adjusted_warning"));
            }
            if (!this.validationError && this.isUserDefinedTS()) {
                this.signupMeeting.setStartTime(eventStartTime);
                this.signupMeeting.setEndTime(eventEndTime);
                this.signupMeeting.setMeetingType("custom_ts");
            }
            if (!this.isUserDefinedTS() && "custom_ts".equals(this.signupMeeting.getMeetingType())) {
                this.signupMeeting.setMeetingType("individual");
            }
            this.signupMeeting.setSignupSites(CreateSitesGroups.getSelectedSignupSites((SignupSiteWrapper)this.getCurrentSite(), (List)this.getOtherSites()));
            this.allPossibleCoordinators = this.sakaiFacade.getAllPossbileCoordinatorsOnFastTrack(this.signupMeeting);
            for (SignupUser u : this.allPossibleCoordinators) {
                if (!StringUtils.equals((String)u.getInternalUserId(), (String)this.creatorUserId)) continue;
                u.setChecked(true);
            }
        }
    }

    private void warnMeetingAccrossTwoDates(Date endTime, Date startTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        int startYear = calendar.get(1);
        int startMonth = calendar.get(2);
        int startDay = calendar.get(5);
        calendar.setTime(endTime);
        int endYear = calendar.get(1);
        int endMonth = calendar.get(2);
        int endDay = calendar.get(5);
        if (startYear != endYear) {
            Utilities.addInfoMessage((String)Utilities.rb.getString("warning.event.crossed_twoYears"));
            return;
        }
        if (startMonth != endMonth) {
            Utilities.addInfoMessage((String)Utilities.rb.getString("warning.event.crossed_twoMonths"));
            return;
        }
        if (startDay != endDay) {
            Utilities.addInfoMessage((String)Utilities.rb.getString("warning.event.crossed_twoDays"));
            return;
        }
    }

    private boolean isMeetingOverRepeatPeriod(Date startTime, Date endTime, int repeatPeriodInDays) {
        long duration = endTime.getTime() - startTime.getTime();
        return (long)(24 * repeatPeriodInDays) - duration / 3600000L < 0L;
    }

    public String goBack() {
        if (this.currentStepHiddenInfo == null) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("publish.withAttendee.exception"));
            this.timeSlotWrappers = null;
            this.assignParicitpantsToAllRecurEvents = false;
            this.setEndTimeAutoAdjusted(false);
            return "addMeetingStep1";
        }
        String step = (String)this.currentStepHiddenInfo.getValue();
        if (step.equals("step2")) {
            return "addMeetingStep1";
        }
        if (step.equals("assignAttendee")) {
            this.timeSlotWrappers = null;
            this.assignParicitpantsToAllRecurEvents = false;
            this.setEndTimeAutoAdjusted(false);
            this.sendEmailToSelectedPeopleOnly = "organizers_only";
            return "addMeetingStep2";
        }
        return "addMeetingStep1";
    }

    public String processCancel() {
        this.reset();
        return "cancelAddMeeting";
    }

    public String processSelectedType(ValueChangeEvent vce) {
        String newMeetingType = (String)vce.getNewValue();
        this.signupMeeting.setMeetingType(newMeetingType);
        if (!"individual".equals(newMeetingType)) {
            this.setUserDefinedTS(false);
        }
        return "";
    }

    public String processGroup(ValueChangeEvent vce) {
        Boolean changeValue = (Boolean)vce.getNewValue();
        if (changeValue != null) {
            this.unlimited = changeValue;
            if (this.unlimited) {
                this.maxOfAttendees = 10;
            }
        }
        return "";
    }

    public String processSave() {
        if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"new_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
            this.reset();
            return "addMeetingStep1";
        }
        this.preSaveAction();
        this.processSaveMeetings();
        this.reset();
        return "listMeetings";
    }

    private void preSaveAction() {
        List slots = this.timeslots();
        this.signupMeeting.setSignupTimeSlots(slots);
        Date sBegin = Utilities.subTractTimeToDate((Date)this.signupMeeting.getStartTime(), (int)this.getSignupBegins(), (String)this.getSignupBeginsType());
        Date sDeadline = Utilities.subTractTimeToDate((Date)this.signupMeeting.getEndTime(), (int)this.getDeadlineTime(), (String)this.getDeadlineTimeType());
        this.signupMeeting.setSignupBegins(sBegin);
        this.signupMeeting.setSignupDeadline(sDeadline);
        this.signupMeeting.setSignupSites(CreateSitesGroups.getSelectedSignupSites((SignupSiteWrapper)this.getCurrentSite(), (List)this.getOtherSites()));
        this.signupMeeting.setCreatorUserId(this.creatorUserId);
        this.signupMeeting.setReceiveEmailByOwner(this.receiveEmail);
        this.signupMeeting.setSendEmailByOwner(this.sendEmailByOwner);
        this.signupMeeting.setAllowWaitList(this.allowWaitList);
        this.signupMeeting.setAllowComment(this.allowComment);
        this.signupMeeting.setAutoReminder(this.autoReminder);
        this.signupMeeting.setEidInputMode(this.eidInputMode);
        this.signupMeeting.setMaxNumOfSlots(new Integer(this.maxNumOfSlots));
        this.signupMeeting.setCoordinatorIds(Utilities.getSelectedCoordinators((List)this.allPossibleCoordinators, (String)this.creatorUserId));
        this.signupMeeting.setSignupAttachments(this.attachments);
        this.signupMeeting.setCreateGroups(this.createGroups);
    }

    public String proceesPreAssignAttendee() {
        if (!Utilities.isDataIntegritySafe((boolean)this.isUserDefinedTS(), (String)"new_meeting", (UserDefineTimeslotBean)this.getUserDefineTimeslotBean())) {
            this.reset();
            return "addMeetingStep1";
        }
        this.preSaveAction();
        this.loadAllAttendees(this.getSignupMeeting());
        return "assignStudents";
    }

    public String processAssignStudentsAndPublish() {
        this.preSaveAction();
        this.processSaveMeetings();
        this.reset();
        return "listMeetings";
    }

    public String addAttendee() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String attendeeEidOrEmail = null;
        attendeeEidOrEmail = this.isEidInputMode() ? this.getEidOrEmailInputByUser() : (String)this.newAttendeeInput.getValue();
        if (attendeeEidOrEmail == null || attendeeEidOrEmail.length() < 1) {
            return "assignStudents";
        }
        List associatedEids = this.getEidsForEmail(attendeeEidOrEmail.trim());
        if (associatedEids.size() > 1) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("exception.multiple.eids"), attendeeEidOrEmail, StringUtils.join((Collection)associatedEids, (String)", ")));
            return "assignStudents";
        }
        String attendeeUserId = this.getUserIdForEidOrEmail(attendeeEidOrEmail.trim());
        if (StringUtils.isBlank((String)attendeeEidOrEmail)) {
            Utilities.addErrorMessage((String)(Utilities.rb.getString("exception.no.such.user") + attendeeEidOrEmail));
            return "assignStudents";
        }
        SignupUser attendeeSignUser = this.getSakaiFacade().getSignupUser(this.signupMeeting, attendeeUserId);
        if (attendeeSignUser == null) {
            Utilities.addErrorMessage((String)MessageFormat.format(Utilities.rb.getString("user.has.no.permission.attend"), attendeeEidOrEmail));
            return "assignStudents";
        }
        SignupAttendee attendee = new SignupAttendee(attendeeUserId, attendeeSignUser.getMainSiteId());
        if (this.isDuplicateAttendee(timeslotWrapper.getTimeSlot(), attendee)) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("attendee.already.in.timeslot"));
        } else {
            timeslotWrapper.addAttendee(attendee, this.sakaiFacade.getUserDisplayLastFirstName(attendeeUserId));
        }
        return "assignStudents";
    }

    public String removeAttendee() {
        TimeslotWrapper timeslotWrapper = (TimeslotWrapper)this.timeslotWrapperTable.getRowData();
        String attendeeUserId = Utilities.getRequestParam((String)PARAM_NAME_FOR_ATTENDEE_USERID);
        timeslotWrapper.removeAttendee(attendeeUserId);
        return "";
    }

    private boolean isDuplicateAttendee(SignupTimeslot timeslot, SignupAttendee newAttendee) {
        List attendees = timeslot.getAttendees();
        if (attendees != null && !attendees.isEmpty()) {
            for (SignupAttendee attendee : attendees) {
                if (!attendee.getAttendeeUserId().equals(newAttendee.getAttendeeUserId())) continue;
                return true;
            }
        }
        return false;
    }

    private List<SignupTimeslot> timeslots() {
        ArrayList<SignupTimeslot> slots = new ArrayList<SignupTimeslot>();
        List timeSlotWrappers = this.getTimeSlotWrappers();
        if (timeSlotWrappers == null) {
            return null;
        }
        for (TimeslotWrapper wrapper : timeSlotWrappers) {
            SignupTimeslot slot = wrapper.getTimeSlot();
            slots.add(slot);
        }
        return slots;
    }

    public List<TimeslotWrapper> getTimeSlotWrappers() {
        if (this.timeSlotWrappers == null) {
            this.timeSlotWrappers = this.timeSlotWrappers();
        }
        return this.timeSlotWrappers;
    }

    private List<TimeslotWrapper> timeSlotWrappers() {
        String meetingType = this.signupMeeting.getMeetingType();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.signupMeeting.getStartTime());
        ArrayList<TimeslotWrapper> timeSlotWrappers = new ArrayList<TimeslotWrapper>();
        if (meetingType.equals("individual")) {
            for (int i = 0; i < this.numberOfSlots; ++i) {
                SignupTimeslot slot = new SignupTimeslot();
                slot.setMaxNoOfAttendees(this.numberOfAttendees);
                slot.setStartTime(calendar.getTime());
                calendar.add(12, this.getTimeSlotDuration());
                slot.setEndTime(calendar.getTime());
                slot.setDisplayAttendees(this.isShowParticipants());
                TimeslotWrapper wrapper = new TimeslotWrapper(slot);
                wrapper.setPositionInTSlist(i);
                timeSlotWrappers.add(wrapper);
            }
            this.getMeetingEndTime();
            return timeSlotWrappers;
        }
        if (meetingType.equals("group")) {
            SignupTimeslot slot = new SignupTimeslot();
            slot.setMaxNoOfAttendees(this.unlimited ? Integer.MAX_VALUE : this.maxOfAttendees);
            slot.setStartTime(this.signupMeeting.getStartTime());
            slot.setEndTime(this.signupMeeting.getEndTime());
            slot.setDisplayAttendees(this.isShowParticipants());
            TimeslotWrapper wrapper = new TimeslotWrapper(slot);
            timeSlotWrappers.add(wrapper);
            return timeSlotWrappers;
        }
        if (meetingType.equals("custom_ts")) {
            ArrayList<TimeslotWrapper> tmpTSList = new ArrayList<TimeslotWrapper>(this.customTimeSlotWrpList);
            for (TimeslotWrapper tsWrp : tmpTSList) {
                tsWrp.getTimeSlot().setDisplayAttendees(this.isShowParticipants());
            }
            return tmpTSList;
        }
        return null;
    }

    public Date getSignupBeginInDate() {
        return Utilities.subTractTimeToDate((Date)this.signupMeeting.getStartTime(), (int)this.signupBegins, (String)this.signupBeginsType);
    }

    public Date getSignupDeadlineInDate() {
        return Utilities.subTractTimeToDate((Date)this.signupMeeting.getEndTime(), (int)this.deadlineTime, (String)this.deadlineTimeType);
    }

    public Date getMeetingEndTime() {
        if (this.signupMeeting.getMeetingType().equals("individual")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.signupMeeting.getStartTime());
            int internval = this.getTimeSlotDuration() * this.numberOfSlots;
            calendar.add(12, internval);
            this.signupMeeting.setEndTime(calendar.getTime());
            return calendar.getTime();
        }
        return this.signupMeeting.getEndTime();
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public SignupMeeting getSignupMeeting() {
        return this.signupMeeting;
    }

    public void setSignupMeeting(SignupMeeting signupMeeting) {
        this.signupMeeting = signupMeeting;
    }

    public HtmlInputHidden getCurrentStepHiddenInfo() {
        return this.currentStepHiddenInfo;
    }

    public void setCurrentStepHiddenInfo(HtmlInputHidden htmlInputHidden) {
        this.currentStepHiddenInfo = htmlInputHidden;
    }

    public boolean isRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(boolean recurrence) {
        this.recurrence = recurrence;
    }

    public int getMaxOfAttendees() {
        if (this.unlimited) {
            return Integer.MAX_VALUE;
        }
        return this.maxOfAttendees;
    }

    public void setMaxOfAttendees(int maxOfAttendees) {
        this.maxOfAttendees = maxOfAttendees;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public int getTimeSlotDuration() {
        if (this.timeSlotDuration == 0) {
            long duration = (this.getSignupMeeting().getEndTime().getTime() - this.getSignupMeeting().getStartTime().getTime()) / (long)(60000 * this.getNumberOfSlots());
            this.setTimeSlotDuration((int)duration);
        }
        return this.timeSlotDuration;
    }

    public void setTimeSlotDuration(int timeSlotDuration) {
        this.timeSlotDuration = timeSlotDuration;
    }

    public int getNumberOfAttendees() {
        return this.numberOfAttendees;
    }

    public void setNumberOfAttendees(int numberOfAttendees) {
        this.numberOfAttendees = numberOfAttendees;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean unlimited) {
        this.unlimited = unlimited;
    }

    public int getSignupBegins() {
        return this.signupBegins;
    }

    public void setSignupBegins(int bookingTime) {
        this.signupBegins = bookingTime;
    }

    public String getSignupBeginsType() {
        return this.signupBeginsType;
    }

    public void setSignupBeginsType(String bookingTimeType) {
        this.signupBeginsType = bookingTimeType;
    }

    public int getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(int deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getDeadlineTimeType() {
        return this.deadlineTimeType;
    }

    public void setDeadlineTimeType(String deadlineTimeType) {
        this.deadlineTimeType = deadlineTimeType;
    }

    public List<SignupSiteWrapper> getOtherSites() {
        if (this.currentSite == null) {
            this.getAvailableSiteGroups();
        }
        return this.otherSites;
    }

    public void setOtherSites(List<SignupSiteWrapper> signupSiteWrapperList) {
        this.otherSites = signupSiteWrapperList;
    }

    public SignupSiteWrapper getCurrentSite() {
        if (this.currentSite == null) {
            this.getAvailableSiteGroups();
        }
        return this.currentSite;
    }

    private void getAvailableSiteGroups() {
        Utilities.getSignupMeetingsBean().getCreateSitesGroups().resetSiteGroupCheckboxMark();
        this.currentSite = Utilities.getSignupMeetingsBean().getCreateSitesGroups().getCurrentSite();
        this.otherSites = Utilities.getSignupMeetingsBean().getCreateSitesGroups().getOtherSites();
    }

    public void setCurrentSite(SignupSiteWrapper currentSite) {
        this.currentSite = currentSite;
    }

    public boolean getSendEmail() {
        if (!this.getPublishedSite().booleanValue()) {
            this.sendEmail = false;
        }
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public boolean getSendEmailByOwner() {
        return this.sendEmailByOwner;
    }

    public void setSendEmailByOwner(boolean sendEmailByOwner) {
        this.sendEmailByOwner = sendEmailByOwner;
    }

    public String getIndividual() {
        return "individual";
    }

    public String getGroup() {
        return "group";
    }

    public String getAnnouncement() {
        return "announcement";
    }

    public List<SelectItem> getAllAttendees() {
        return this.allAttendees;
    }

    public void setAllAttendees(List<SelectItem> allAttendees) {
        this.allAttendees = allAttendees;
    }

    public boolean isShowParticipants() {
        return this.showParticipants;
    }

    public void setShowParticipants(boolean showParticipants) {
        this.showParticipants = showParticipants;
    }

    private void loadAllAttendees(SignupMeeting meeting) {
        if (this.isEidInputMode()) {
            return;
        }
        try {
            Site site = this.getSakaiFacade().getSiteService().getSite(this.getSakaiFacade().getCurrentLocationId());
            if (site != null) {
                int allMemeberSize;
                int n = allMemeberSize = site.getMembers() != null ? site.getMembers().size() : 0;
                if (allMemeberSize > 600) {
                    this.setEidInputMode(true);
                    return;
                }
            }
        }
        catch (IdUnusedException e) {
            e.printStackTrace();
        }
        this.allSignupUsers = this.sakaiFacade.getAllPossibleAttendees(meeting);
        if (this.allSignupUsers != null && this.allSignupUsers.size() > 600) {
            this.setEidInputMode(true);
            return;
        }
        this.setEidInputMode(false);
        this.allAttendees = new ArrayList();
        SelectItem sItem = new SelectItem((Object)"", " " + Utilities.rb.getString("label.select.attendee"));
        this.allAttendees.add(sItem);
        String previous_displayName = "";
        int index = 0;
        for (SignupUser user : this.allSignupUsers) {
            if (user.getDisplayName().equals(previous_displayName)) {
                this.allAttendees.add(new SelectItem((Object)user.getEid(), user.getDisplayName() + "(" + user.getEid() + ")"));
                SelectItem prev_sItem = (SelectItem)this.allAttendees.get(index);
                if (!prev_sItem.getLabel().contains("(")) {
                    prev_sItem.setLabel(prev_sItem.getLabel() + " (" + prev_sItem.getValue() + ")");
                }
            } else {
                this.allAttendees.add(new SelectItem((Object)user.getEid(), user.getDisplayName()));
            }
            previous_displayName = user.getDisplayName();
            ++index;
        }
    }

    public UIInput getNewAttendeeInput() {
        return this.newAttendeeInput;
    }

    public void setNewAttendeeInput(UIInput newAttendeeInput) {
        this.newAttendeeInput = newAttendeeInput;
    }

    public UIData getTimeslotWrapperTable() {
        return this.timeslotWrapperTable;
    }

    public void setTimeslotWrapperTable(UIData timeslotWrapperTable) {
        this.timeslotWrapperTable = timeslotWrapperTable;
    }

    public boolean isReceiveEmail() {
        return this.receiveEmail;
    }

    public void setReceiveEmail(boolean receiveEmail) {
        this.receiveEmail = receiveEmail;
    }

    public String getAttendeeUserId() {
        return PARAM_NAME_FOR_ATTENDEE_USERID;
    }

    public boolean isAnnouncementType() {
        return "announcement".equals(this.getSignupMeeting().getMeetingType());
    }

    public boolean isGroupType() {
        return "group".equals(this.getSignupMeeting().getMeetingType());
    }

    public boolean isIndividualType() {
        return "individual".equals(this.getSignupMeeting().getMeetingType());
    }

    public boolean isCustomTimeslotType() {
        return "custom_ts".equals(this.getSignupMeeting().getMeetingType());
    }

    public String getDisplayCurrentMeetingType() {
        String mType = "";
        if (this.isIndividualType()) {
            mType = Utilities.rb.getString("label_individaul");
        } else if (this.isGroupType()) {
            mType = Utilities.rb.getString("label_group");
        } else if (this.isAnnouncementType()) {
            mType = Utilities.rb.getString("label_announcement");
        } else if (this.isUserDefinedTS()) {
            mType = Utilities.rb.getString("label_custom_timeslots");
        }
        return mType;
    }

    public boolean isEidInputMode() {
        return this.eidInputMode;
    }

    public void setEidInputMode(boolean eidInputMode) {
        this.eidInputMode = eidInputMode;
    }

    public String getUserInputEidOrEmail() {
        return "";
    }

    public void setUserInputEidOrEmail(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.eidOrEmailInputByUser = value;
        }
    }

    private String getEidOrEmailInputByUser() {
        String eid = this.eidOrEmailInputByUser;
        this.eidOrEmailInputByUser = null;
        return eid;
    }

    private void processSaveMeetings() {
        this.signupMeeting.setRepeatUntil(this.getRepeatUntil());
        int repeatNum = this.getOccurrences();
        if ("1".equals(this.getRecurLengthChoice())) {
            repeatNum = CreateMeetings.getNumOfRecurrence((String)this.getRepeatType(), (Date)this.signupMeeting.getStartTime(), (Date)this.getRepeatUntil());
        }
        this.signupMeeting.setRepeatNum(repeatNum);
        this.signupMeeting.setRepeatType(this.getRepeatType());
        if ("custom_ts".equals(this.signupMeeting.getMeetingType())) {
            boolean multipleCalBlocks = this.getUserDefineTimeslotBean().getPutInMultipleCalendarBlocks();
            this.signupMeeting.setInMultipleCalendarBlocks(multipleCalBlocks);
        }
        this.signupMeeting.setSendEmailToSelectedPeopleOnly(this.sendEmailToSelectedPeopleOnly);
        CreateMeetings createMeeting = new CreateMeetings(this.signupMeeting, this.sendEmail, !this.assignParicitpantsToAllRecurEvents, this.assignParicitpantsToAllRecurEvents, this.getSignupBegins(), this.getSignupBeginsType(), this.getDeadlineTime(), this.getDeadlineTimeType(), this.getRecurLengthChoice(), this.sakaiFacade, this.signupMeetingService, this.getAttachmentHandler(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId(), true);
        try {
            createMeeting.setPublishToCalendar(this.getPublishToCalendar());
            createMeeting.setCreateGroups(this.createGroups);
            createMeeting.processSaveMeetings();
            this.attachments.clear();
        }
        catch (PermissionException e) {
            this.logger.info((Object)(Utilities.rb.getString("no.permission_create_event") + " - " + e.getMessage()));
        }
        catch (Exception e) {
            this.logger.error((Object)(Utilities.rb.getString("error.occurred_try_again") + " - " + e.getMessage()));
            Utilities.addErrorMessage((String)Utilities.rb.getString("error.occurred_try_again"));
        }
    }

    public boolean isAssignParicitpantsToAllRecurEvents() {
        return this.assignParicitpantsToAllRecurEvents;
    }

    public void setAssignParicitpantsToAllRecurEvents(boolean assignParicitpantsToAllRecurEvents) {
        this.assignParicitpantsToAllRecurEvents = assignParicitpantsToAllRecurEvents;
    }

    public String getEventFreqType() {
        this.eventFreqType = "";
        if (this.getRepeatType().equals("daily")) {
            this.eventFreqType = Utilities.rb.getString("label_daily");
        } else if (this.getRepeatType().equals("wkdays_mon-fri")) {
            this.eventFreqType = Utilities.rb.getString("label_weekdays");
        } else if (this.getRepeatType().equals("weekly")) {
            this.eventFreqType = Utilities.rb.getString("label_weekly");
        } else if (this.getRepeatType().equals("biweekly")) {
            this.eventFreqType = Utilities.rb.getString("label_biweekly");
        }
        return this.eventFreqType;
    }

    public List<SignupSite> getSelectedSignupSites() {
        return CreateSitesGroups.getSelectedSignupSites((SignupSiteWrapper)this.currentSite, (List)this.otherSites);
    }

    public List<SelectItem> getMeetingTypeRadioBttns() {
        this.meetingTypeRadioBttns = Utilities.getMeetingTypeSelectItems((String)"", (boolean)false);
        return this.meetingTypeRadioBttns;
    }

    public Boolean getPublishedSite() {
        if (this.publishedSite == null) {
            try {
                boolean status = this.sakaiFacade.getSiteService().getSite(this.sakaiFacade.getCurrentLocationId()).isPublished();
                this.publishedSite = new Boolean(status);
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage());
                this.publishedSite = new Boolean(false);
            }
        }
        return (boolean)this.publishedSite;
    }

    public boolean isEndTimeAutoAdjusted() {
        return this.endTimeAutoAdjusted;
    }

    public void setEndTimeAutoAdjusted(boolean endTimeAutoAdjusted) {
        this.endTimeAutoAdjusted = endTimeAutoAdjusted;
    }

    public boolean isAllowWaitList() {
        return this.allowWaitList;
    }

    public void setAllowWaitList(boolean allowWaitList) {
        this.allowWaitList = allowWaitList;
    }

    public boolean isAllowComment() {
        return this.allowComment;
    }

    public void setAllowComment(boolean allowComment) {
        this.allowComment = allowComment;
    }

    public boolean isAutoReminder() {
        return this.autoReminder;
    }

    public void setAutoReminder(boolean autoReminder) {
        this.autoReminder = autoReminder;
    }

    public boolean isAutoReminderOptionChoice() {
        return this.autoReminderOptionChoice;
    }

    public void setAutoReminderOptionChoice(boolean autoReminderOptionChoice) {
        this.autoReminderOptionChoice = autoReminderOptionChoice;
    }

    public boolean isUserIdInputModeOptionChoice() {
        return this.userIdInputModeOptionChoice;
    }

    public void setUserIdInputModeOptionChoice(boolean userIdInputModeOptionChoice) {
        this.userIdInputModeOptionChoice = userIdInputModeOptionChoice;
    }

    public List<SignupAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<SignupAttachment> attachments) {
        this.attachments = attachments;
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public void setAttachmentHandler(AttachmentHandler attachmentHandler) {
        this.attachmentHandler = attachmentHandler;
    }

    public boolean isAttachmentsEmpty() {
        return this.attachments == null || this.attachments.size() <= 0;
    }

    public boolean isAllLocationsEmpty() {
        return this.getAllLocations().size() <= 1;
    }

    public boolean isCategoriesExist() {
        return this.getAllCategories().size() > 1;
    }

    public UserDefineTimeslotBean getUserDefineTimeslotBean() {
        return this.userDefineTimeslotBean;
    }

    public void setUserDefineTimeslotBean(UserDefineTimeslotBean userDefineTimeslotBean) {
        this.userDefineTimeslotBean = userDefineTimeslotBean;
    }

    public List<TimeslotWrapper> getCustomTimeSlotWrpList() {
        return this.customTimeSlotWrpList;
    }

    public void setCustomTimeSlotWrpList(List<TimeslotWrapper> customTimeSlotWrpList) {
        this.customTimeSlotWrpList = customTimeSlotWrpList;
    }

    public boolean isUserDefinedTS() {
        return this.userDefinedTS;
    }

    public void setUserDefinedTS(boolean userDefinedTS) {
        this.userDefinedTS = userDefinedTS;
    }

    public boolean getPublishToCalendar() {
        return this.publishToCalendar;
    }

    public void setPublishToCalendar(boolean publishToCalendar) {
        this.publishToCalendar = publishToCalendar;
    }

    public boolean getCreateGroups() {
        return this.createGroups;
    }

    public void setCreateGroups(boolean createGroups) {
        this.createGroups = createGroups;
    }

    public String getRecurLengthChoice() {
        return this.recurLengthChoice;
    }

    public void setRecurLengthChoice(String recurLengthChoice) {
        this.recurLengthChoice = recurLengthChoice;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public void setOccurrences(int occurrences) {
        this.occurrences = occurrences;
    }

    public boolean isAttendanceOn() {
        return Utilities.getSignupMeetingsBean().isAttendanceOn();
    }

    public List<SelectItem> getInstructors() {
        return Utilities.getSignupMeetingsBean().getInstructors(null);
    }

    public String getInstructorName() {
        return Utilities.getSignupMeetingsBean().getInstructorName(this.creatorUserId);
    }

    public String getUserIdForEidOrEmail(String value) {
        User u = this.sakaiFacade.getUserByEid(value);
        if (u == null) {
            u = this.sakaiFacade.getUserByEmail(value);
        }
        if (u != null) {
            return u.getId();
        }
        return null;
    }

    public List<String> getEidsForEmail(String email) {
        List users = this.sakaiFacade.getUsersByEmail(email);
        ArrayList<String> eids = new ArrayList<String>();
        for (User u : users) {
            eids.add(u.getEid());
        }
        return eids;
    }

    public List<SignupUser> getAllPossibleCoordinators() {
        return this.allPossibleCoordinators;
    }

    public void setAllPossibleCoordinators(List<SignupUser> allPossibleCoordinators) {
        this.allPossibleCoordinators = allPossibleCoordinators;
    }

    public boolean isMandatorySendEmail() {
        return this.mandatorySendEmail;
    }

    public String getSendEmailToSelectedPeopleOnly() {
        return this.sendEmailToSelectedPeopleOnly;
    }

    public void setSendEmailToSelectedPeopleOnly(String sendEmailToSelectedPeopleOnly) {
        this.sendEmailToSelectedPeopleOnly = sendEmailToSelectedPeopleOnly;
    }

    public String getIframeId() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String iFrameId = (String)request.getAttribute("sakai.tool.placement.id");
        return iFrameId;
    }

    public void setIframeId(String iframeId) {
        this.iframeId = iframeId;
    }
}

