/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.model.SelectItem;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;

public class SignupSorter {
    public static final String TITLE_COLUMN = "titleName";
    public static final String LOCATION_COLUMN = "location";
    public static final String CATEGORY_COLUMN = "category";
    public static final String CREATOR_COLUMN = "creator";
    public static final String DATE_COLUMN = "startTime";
    public static final String STATUS_COLUMN = "availability";
    private String sortColumn;
    private boolean sortAscending;
    public static final Comparator<SignupMeetingWrapper> sortTitleComparator;
    public static final Comparator<SignupMeetingWrapper> sortLocationComparator;
    public static final Comparator<SignupMeetingWrapper> sortCategoryComparator;
    public static final Comparator<SignupMeetingWrapper> sortOwnerComparator;
    public static final Comparator<SignupMeetingWrapper> sortDateComparator;
    public static final Comparator<SignupMeetingWrapper> sortStatusComparator;
    public static final Comparator<SelectItem> sortSelectItemComparator;

    public SignupSorter(String defaultColumn, boolean sortAscending) {
        this.sortColumn = defaultColumn;
        this.sortAscending = sortAscending;
    }

    public SignupSorter() {
        this.sortColumn = DATE_COLUMN;
        this.sortAscending = true;
    }

    public void sort(List<SignupMeetingWrapper> smList) {
        if (smList != null && !smList.isEmpty()) {
            Collections.sort(smList, this.getComparator());
            if (!this.sortAscending) {
                Collections.reverse(smList);
            }
        }
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(String sortColumn) {
        this.sortColumn = sortColumn;
    }

    protected Comparator<SignupMeetingWrapper> getComparator() {
        Comparator comparator = TITLE_COLUMN.equals(this.sortColumn) ? sortTitleComparator : (LOCATION_COLUMN.equals(this.sortColumn) ? sortLocationComparator : (CATEGORY_COLUMN.equals(this.sortColumn) ? sortCategoryComparator : (CREATOR_COLUMN.equals(this.sortColumn) ? sortOwnerComparator : (STATUS_COLUMN.equals(this.sortColumn) ? sortStatusComparator : sortDateComparator))));
        return comparator;
    }

    public String getTitleColumn() {
        return TITLE_COLUMN;
    }

    public String getCreateColumn() {
        return CREATOR_COLUMN;
    }

    public String getDateColumn() {
        return DATE_COLUMN;
    }

    public String getLocationColumn() {
        return LOCATION_COLUMN;
    }

    public String getCategoryColumn() {
        return CATEGORY_COLUMN;
    }

    public String getStatusColumn() {
        return STATUS_COLUMN;
    }

    static {
        sortSelectItemComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortTitleComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortLocationComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortCategoryComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortOwnerComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortDateComparator = new /* Unavailable Anonymous Inner Class!! */;
        sortStatusComparator = new /* Unavailable Anonymous Inner Class!! */;
    }
}

