/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.signup.tool.jsf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.sakaiproject.signup.logic.SakaiFacade;
import org.sakaiproject.signup.logic.SignupCalendarHelper;
import org.sakaiproject.signup.logic.SignupMeetingService;
import org.sakaiproject.signup.logic.SignupMessageTypes;
import org.sakaiproject.signup.logic.SignupUserActionException;
import org.sakaiproject.signup.model.MeetingTypes;
import org.sakaiproject.signup.model.SignupAttachment;
import org.sakaiproject.signup.model.SignupAttendee;
import org.sakaiproject.signup.model.SignupMeeting;
import org.sakaiproject.signup.model.SignupTimeslot;
import org.sakaiproject.signup.tool.jsf.AttendeeWrapper;
import org.sakaiproject.signup.tool.jsf.SignupMeetingWrapper;
import org.sakaiproject.signup.tool.jsf.TimeslotWrapper;
import org.sakaiproject.signup.tool.jsf.UserTimeZone;
import org.sakaiproject.signup.tool.jsf.attachment.AttachmentHandler;
import org.sakaiproject.signup.tool.util.SignupBeanConstants;
import org.sakaiproject.signup.tool.util.Utilities;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.user.api.User;

public abstract class SignupUIBaseBean
implements SignupBeanConstants,
SignupMessageTypes,
MeetingTypes {
    protected SakaiFacade sakaiFacade;
    protected SignupMeetingService signupMeetingService;
    protected SignupCalendarHelper calendarHelper;
    private AttachmentHandler attachmentHandler;
    protected SignupMeetingWrapper meetingWrapper;
    protected List<TimeslotWrapper> timeslotWrappers;
    protected TimeslotWrapper timeslotWrapper;
    protected boolean currentUserSignedup;
    protected static boolean DEFAULT_SEND_EMAIL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.email.notification", (String)"true"));
    protected static boolean DEFAULT_EXPORT_TO_CALENDAR_TOOL = "true".equalsIgnoreCase(Utilities.getSignupConfigParamVal((String)"signup.default.export.to.calendar.setting", (String)"true"));
    protected boolean publishToCalendar = DEFAULT_EXPORT_TO_CALENDAR_TOOL;
    protected boolean sendEmail = DEFAULT_SEND_EMAIL;
    protected Log logger = LogFactoryImpl.getLog(this.getClass());
    protected Boolean publishedSite;
    protected String sendEmailToSelectedPeopleOnly = "all";
    private int maxSlots;
    private int maxAttendeesPerSlot;
    protected String customLocation;
    protected String customCategory;
    protected static final String ICS_MIME_TYPE = "text/calendar";
    private UserTimeZone userTimeZone;
    private String iframeId = "";

    public SignupMeetingWrapper getMeetingWrapper() {
        if (this.meetingWrapper != null && this.meetingWrapper.isRefresh()) {
            try {
                SignupMeeting meeting = this.signupMeetingService.loadSignupMeeting(this.meetingWrapper.getMeeting().getId(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId());
                this.meetingWrapper.setMeeting(meeting);
                this.updateTimeSlotWrappers(this.meetingWrapper);
            }
            catch (Exception e) {
                Utilities.addErrorMessage((String)Utilities.rb.getString("db.error_or_event.notExisted"));
                this.logger.error((Object)(Utilities.rb.getString("db.error_or_event.notExisted") + " - " + e.getMessage()));
            }
        }
        return this.meetingWrapper;
    }

    protected void updateTimeSlotWrappers(SignupMeetingWrapper meetingWrapper) {
        SignupMeeting meeting = this.meetingWrapper.getMeeting();
        if (meeting == null) {
            return;
        }
        List timeslots = meeting.getSignupTimeSlots();
        if (timeslots == null) {
            return;
        }
        ArrayList<TimeslotWrapper> timeslotWrapperList = new ArrayList<TimeslotWrapper>();
        this.setCurrentUserSignedup(false);
        int i = 0;
        int totalSignedupSlots = 0;
        for (SignupTimeslot elm : timeslots) {
            TimeslotWrapper tsw = new TimeslotWrapper(elm, this.sakaiFacade.getCurrentUserId());
            ArrayList<AttendeeWrapper> attendeeWrp = new ArrayList<AttendeeWrapper>();
            int posIndex = 0;
            List cleanedList = this.getValidAttendees(elm.getAttendees());
            for (SignupAttendee attendee : cleanedList) {
                AttendeeWrapper attWrp = new AttendeeWrapper(attendee, this.sakaiFacade.getUserDisplayLastFirstName(attendee.getAttendeeUserId()));
                attWrp.setPositionIndex(posIndex++);
                attendeeWrp.add(attWrp);
                if (!attendee.getAttendeeUserId().equals(this.sakaiFacade.getCurrentUserId())) continue;
                ++totalSignedupSlots;
            }
            posIndex = 0;
            Collections.sort(attendeeWrp);
            for (AttendeeWrapper attWrp : attendeeWrp) {
                attWrp.setPositionIndex(posIndex++);
            }
            tsw.setAttendeeWrappers(attendeeWrp);
            tsw.setWaitingList(this.wrapWaiters(elm.getWaitingList()));
            tsw.setPositionInTSlist(i++);
            timeslotWrapperList.add(tsw);
        }
        int preferredSlot = meeting.getMaxNumOfSlots();
        if (totalSignedupSlots >= preferredSlot) {
            this.setCurrentUserSignedup(true);
        }
        this.setTimeslotWrappers(timeslotWrapperList);
    }

    protected String updateMeetingwrapper(SignupMeeting meeting, String destinationUrl) {
        try {
            if (meeting == null) {
                meeting = this.signupMeetingService.loadSignupMeeting(this.meetingWrapper.getMeeting().getId(), this.sakaiFacade.getCurrentUserId(), this.sakaiFacade.getCurrentLocationId());
            }
            this.getMeetingWrapper().setMeeting(meeting);
            this.getMeetingWrapper().resetAvailableStatus();
            this.updateTimeSlotWrappers(this.getMeetingWrapper());
            return destinationUrl;
        }
        catch (Exception e) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("db.error_or_event.notExisted"));
            this.logger.warn((Object)(Utilities.rb.getString("db.error_or_event.notExisted") + " - " + e.getMessage()));
            Utilities.resetMeetingList();
            return "listMeetings";
        }
    }

    protected void updateSignupAttachmentWrapper(SignupMeeting meeting) {
    }

    protected void setSignupBeginDeadlineData(SignupMeeting meeting, int signupBegin, String signupBeginType, int signupDeadline, String signupDeadlineType) throws Exception {
        Date sBegin = Utilities.subTractTimeToDate((Date)meeting.getStartTime(), (int)signupBegin, (String)signupBeginType);
        Date sDeadline = Utilities.subTractTimeToDate((Date)meeting.getEndTime(), (int)signupDeadline, (String)signupDeadlineType);
        if (!"startNow".equals(signupBeginType) && sBegin.before(new Date())) {
            Utilities.addErrorMessage((String)Utilities.rb.getString("warning.your.event.singup.begin.time.passed.today.time"));
        }
        meeting.setSignupBegins(sBegin);
        if (sBegin.after(sDeadline)) {
            throw new SignupUserActionException(Utilities.rb.getString("signup.deadline.is.before.signup.begin"));
        }
        meeting.setSignupDeadline(sDeadline);
    }

    public boolean isMeetingOverRepeatPeriod(Date startTime, Date endTime, int repeatPeriodInDays) {
        long duration = endTime.getTime() - startTime.getTime();
        return (long)(24 * repeatPeriodInDays) - duration / 3600000L < 0L;
    }

    private List<AttendeeWrapper> wrapWaiters(List<SignupAttendee> attendees) {
        ArrayList<AttendeeWrapper> attendeeWrp = new ArrayList<AttendeeWrapper>();
        for (SignupAttendee attendee : attendees) {
            attendeeWrp.add(new AttendeeWrapper(attendee, this.sakaiFacade.getUserDisplayLastFirstName(attendee.getAttendeeUserId())));
        }
        return attendeeWrp;
    }

    public void setMeetingWrapper(SignupMeetingWrapper meetingWrapper) {
        this.meetingWrapper = meetingWrapper;
    }

    public SakaiFacade getSakaiFacade() {
        return this.sakaiFacade;
    }

    public int getMaxSlots() {
        String maxSlotsStringVal = Utilities.getSignupConfigParamVal((String)"signup.maxSlots", (String)"500");
        try {
            this.maxSlots = Integer.parseInt(maxSlotsStringVal);
        }
        catch (Exception e) {
            this.maxSlots = 500;
        }
        return this.maxSlots;
    }

    public void setMaxSlots(int maxSlots) {
        this.maxSlots = maxSlots;
    }

    public int getMaxAttendeesPerSlot() {
        String maxAttendeesStringVal = Utilities.getSignupConfigParamVal((String)"signup.maxAttendeesPerSlot", (String)"500");
        try {
            this.maxAttendeesPerSlot = Integer.parseInt(maxAttendeesStringVal);
        }
        catch (Exception e) {
            this.maxAttendeesPerSlot = 500;
        }
        return this.maxAttendeesPerSlot;
    }

    public void setMaxAttendeesPerSlot(int maxAttendeesPerSlot) {
        this.maxAttendeesPerSlot = maxAttendeesPerSlot;
    }

    public void setSakaiFacade(SakaiFacade sakaiFacade) {
        this.sakaiFacade = sakaiFacade;
    }

    public SignupMeetingService getSignupMeetingService() {
        return this.signupMeetingService;
    }

    public void setSignupMeetingService(SignupMeetingService signupMeetingService) {
        this.signupMeetingService = signupMeetingService;
    }

    public boolean isCurrentUserSignedup() {
        return this.currentUserSignedup;
    }

    public void setCurrentUserSignedup(boolean currentUserSignedup) {
        this.currentUserSignedup = currentUserSignedup;
    }

    public List<TimeslotWrapper> getTimeslotWrappers() {
        return this.timeslotWrappers;
    }

    public void setTimeslotWrappers(List<TimeslotWrapper> timeslotWrappers) {
        this.timeslotWrappers = timeslotWrappers;
    }

    public boolean getAnnouncementType() {
        boolean anoun = false;
        if (this.meetingWrapper != null && this.meetingWrapper.getMeeting() != null && "announcement".equals(this.meetingWrapper.getMeeting().getMeetingType())) {
            anoun = true;
        }
        return anoun;
    }

    public boolean getIndividualType() {
        return "individual".equals(this.meetingWrapper.getMeeting().getMeetingType());
    }

    public boolean getGroupType() {
        return "group".equals(this.meetingWrapper.getMeeting().getMeetingType());
    }

    public boolean getCustomTsType() {
        return "custom_ts".equals(this.meetingWrapper.getMeeting().getMeetingType());
    }

    public TimeslotWrapper getTimeslotWrapper() {
        return this.timeslotWrapper;
    }

    public void setTimeslotWrapper(TimeslotWrapper timeslotWrapper) {
        this.timeslotWrapper = timeslotWrapper;
    }

    public boolean isSendEmail() {
        if (!this.getPublishedSite().booleanValue()) {
            this.sendEmail = false;
        }
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getIndividual() {
        return "individual";
    }

    public String getGroup() {
        return "group";
    }

    public String getAnnouncement() {
        return "announcement";
    }

    public Boolean getPublishedSite() {
        if (this.publishedSite == null) {
            try {
                boolean status = this.sakaiFacade.getSiteService().getSite(this.sakaiFacade.getCurrentLocationId()).isPublished();
                this.publishedSite = new Boolean(status);
            }
            catch (Exception e) {
                this.logger.warn((Object)e.getMessage());
                this.publishedSite = new Boolean(false);
            }
        }
        return (boolean)this.publishedSite;
    }

    public void cleanUpUnusedAttachmentCopies(List<SignupAttachment> attachList) {
        if (attachList != null) {
            for (SignupAttachment attach : attachList) {
                this.getAttachmentHandler().removeAttachmentInContentHost(attach);
            }
            attachList.clear();
        }
    }

    public boolean getSignupAttachmentEmpty() {
        return this.meetingWrapper.getEmptyEventMainAttachment();
    }

    public AttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public void setAttachmentHandler(AttachmentHandler attachmentHandler) {
        this.attachmentHandler = attachmentHandler;
    }

    protected void markerTimeslots(List<TimeslotWrapper> TimeSlotWrpList) {
        int i = 0;
        if (TimeSlotWrpList != null) {
            for (TimeslotWrapper tsWrp : TimeSlotWrpList) {
                tsWrp.setTsMarker(i);
                ++i;
            }
        }
    }

    public boolean isPublishToCalendar() {
        return this.publishToCalendar;
    }

    public void setPublishToCalendar(boolean publishToCalendar) {
        this.publishToCalendar = publishToCalendar;
    }

    public String getSendEmailToSelectedPeopleOnly() {
        return this.sendEmailToSelectedPeopleOnly;
    }

    public void setSendEmailToSelectedPeopleOnly(String sendEmailToSelectedPeopleOnly) {
        this.sendEmailToSelectedPeopleOnly = sendEmailToSelectedPeopleOnly;
    }

    public List<SignupAttendee> getValidAttendees(List<SignupAttendee> attendees) {
        ArrayList<SignupAttendee> cleanedList = new ArrayList<SignupAttendee>();
        for (SignupAttendee attendee : attendees) {
            if (!this.sakaiFacade.checkForUser(attendee.getAttendeeUserId())) continue;
            cleanedList.add(attendee);
        }
        return cleanedList;
    }

    public String getUserIdForEidOrEmail(String value) {
        User u = this.sakaiFacade.getUserByEid(value);
        if (u == null) {
            u = this.sakaiFacade.getUserByEmail(value);
        }
        if (u != null) {
            return u.getId();
        }
        return null;
    }

    public List<String> getEidsForEmail(String email) {
        List users = this.sakaiFacade.getUsersByEmail(email);
        ArrayList<String> eids = new ArrayList<String>();
        for (User u : users) {
            eids.add(u.getEid());
        }
        return eids;
    }

    public String generateGroupTitle(String meetingTitle, SignupTimeslot timeslot) {
        int SEPARATOR = 45;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        StringBuilder sb = new StringBuilder();
        sb.append(meetingTitle);
        sb.append('-');
        sb.append(df.format(timeslot.getStartTime()));
        sb.append('-');
        sb.append(df.format(timeslot.getEndTime()));
        return sb.toString();
    }

    public String generateGroupDescription(String meetingTitle, SignupTimeslot timeslot) {
        return Utilities.rb.getString("group.description.default");
    }

    public List<String> convertAttendeesToUuids(List<SignupAttendee> attendees) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (SignupAttendee a : attendees) {
            uuids.add(a.getAttendeeUserId());
        }
        return uuids;
    }

    public List<String> convertAttendeeWrappersToUuids(List<AttendeeWrapper> attendees) {
        ArrayList<String> uuids = new ArrayList<String>();
        for (AttendeeWrapper a : attendees) {
            uuids.add(a.getSignupAttendee().getAttendeeUserId());
        }
        return uuids;
    }

    public String getAllAttendeesEmailAddressesFormatted() {
        HashSet<String> emails = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (TimeslotWrapper tsWrapper : this.timeslotWrappers) {
            for (AttendeeWrapper atWrapper : tsWrapper.getAttendeeWrappers()) {
                String email = atWrapper.getAttendeeEmail();
                if (!StringUtils.isNotBlank((String)email)) continue;
                emails.add(email);
            }
        }
        for (String e : emails) {
            sb.append(e);
            sb.append(';');
        }
        return StringUtils.removeEnd((String)sb.toString(), (String)";");
    }

    public void downloadICSForMeeting() {
        String filePath;
        SignupMeeting meeting = this.meetingWrapper.getMeeting();
        Date defaultEndTime = meeting.getEndTime();
        Date dfaultStartTime = meeting.getStartTime();
        meeting.setEndTime(this.getUserTimezonePreferenceDate(defaultEndTime));
        meeting.setStartTime(this.getUserTimezonePreferenceDate(dfaultStartTime));
        try {
            filePath = this.calendarHelper.createCalendarFile(Collections.singletonList(this.calendarHelper.generateVEventForMeeting(meeting)));
            meeting.setEndTime(defaultEndTime);
            meeting.setStartTime(dfaultStartTime);
        }
        catch (NullPointerException ne) {
            meeting.setEndTime(defaultEndTime);
            meeting.setStartTime(dfaultStartTime);
            this.handleICSDownloadWarningToUser();
            return;
        }
        if (StringUtils.isNotBlank((String)filePath)) {
            this.logger.debug((Object)("filepath: " + filePath));
            this.sendDownload(filePath, ICS_MIME_TYPE);
        } else {
            this.logger.error((Object)"Could not generate file for download");
        }
    }

    public void downloadICSForMeetingTimeSlot(TimeslotWrapper timeslotWrapper) {
        String filePath;
        SignupMeeting meeting = this.meetingWrapper.getMeeting();
        SignupTimeslot currentTimeslot = timeslotWrapper.getTimeSlot();
        Date timeslotEndTime = currentTimeslot.getEndTime();
        Date timeslotStartTime = currentTimeslot.getStartTime();
        Date defaultEndTime = meeting.getEndTime();
        Date dfaultStartTime = meeting.getStartTime();
        meeting.setEndTime(this.getUserTimezonePreferenceDate(defaultEndTime));
        meeting.setStartTime(this.getUserTimezonePreferenceDate(dfaultStartTime));
        if (currentTimeslot != null) {
            currentTimeslot.setStartTime(this.getUserTimezonePreferenceDate(timeslotStartTime));
            currentTimeslot.setEndTime(this.getUserTimezonePreferenceDate(timeslotEndTime));
        }
        try {
            filePath = this.calendarHelper.createCalendarFile(Collections.singletonList(this.calendarHelper.generateVEventForTimeslot(meeting, currentTimeslot)));
            if (currentTimeslot != null) {
                currentTimeslot.setStartTime(timeslotStartTime);
                currentTimeslot.setEndTime(timeslotEndTime);
            }
            meeting.setEndTime(defaultEndTime);
            meeting.setStartTime(dfaultStartTime);
        }
        catch (NullPointerException ne) {
            if (currentTimeslot != null) {
                currentTimeslot.setStartTime(timeslotStartTime);
                currentTimeslot.setEndTime(timeslotEndTime);
            }
            meeting.setEndTime(defaultEndTime);
            meeting.setStartTime(dfaultStartTime);
            this.handleICSDownloadWarningToUser();
            return;
        }
        if (StringUtils.isNotBlank((String)filePath)) {
            this.logger.debug((Object)("filepath: " + filePath));
            this.sendDownload(filePath, ICS_MIME_TYPE);
        } else {
            this.logger.error((Object)"Could not generate file for download");
        }
    }

    private Date getUserTimezonePreferenceDate(Date dateBasedOnServerTimezone) {
        TimeService timeService = this.sakaiFacade.getTimeService();
        TimeZone currentUserTimeZone = timeService.getLocalTimeZone();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateBasedOnServerTimezone);
        cal.setTimeZone(currentUserTimeZone);
        int userPrefMinute = cal.get(12);
        int userPrefHour = cal.get(11);
        int userPrefDay = cal.get(5);
        int userPrefMonth = cal.get(2);
        int userPreYear = cal.get(1);
        Calendar calNew = Calendar.getInstance();
        calNew.setTime(dateBasedOnServerTimezone);
        calNew.set(12, userPrefMinute);
        calNew.set(11, userPrefHour);
        calNew.set(5, userPrefDay);
        calNew.set(2, userPrefMonth);
        calNew.set(1, userPreYear);
        return calNew.getTime();
    }

    private void handleICSDownloadWarningToUser() {
        this.logger.error((Object)"The site calendar could not be retrieved when using the Signup tool");
        String warningFileName = Utilities.rb.getString("ics_file_name_for_failure_warning");
        String warningMsg = Utilities.rb.getString("ics_message_for_failure_warning");
        this.sendDownloadWarning(warningFileName, warningMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDownload(String filePath, String mimeType) {
        FacesContext fc;
        block5: {
            fc = FacesContext.getCurrentInstance();
            ServletOutputStream out = null;
            FileInputStream in = null;
            String filename = StringUtils.substringAfterLast((String)filePath, (String)File.separator);
            try {
                HttpServletResponse response = (HttpServletResponse)fc.getExternalContext().getResponse();
                response.reset();
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "public, must-revalidate, post-check=0, pre-check=0, max-age=0");
                response.setContentType(mimeType);
                response.setHeader("Content-disposition", "attachment; filename=" + filename);
                in = FileUtils.openInputStream((File)new File(filePath));
                out = response.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Error generating file for download:" + ex.getMessage()));
                break block5;
            }
            finally {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        fc.responseComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDownloadWarning(String fileName, String warningMsg) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ServletOutputStream out = null;
        try {
            HttpServletResponse response = (HttpServletResponse)fc.getExternalContext().getResponse();
            response.reset();
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "public, must-revalidate, post-check=0, pre-check=0, max-age=0");
            response.setContentType("text/plain");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            out = response.getOutputStream();
            warningMsg = warningMsg != null ? warningMsg : "Missing Scheduler tool on site";
            out.print(warningMsg);
            out.flush();
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Error generating file for download:" + ex.getMessage()));
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        fc.responseComplete();
    }

    public boolean isIcsEnabled() {
        return this.calendarHelper.isIcsEnabled();
    }

    public String getIframeId() {
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String iFrameId = (String)request.getAttribute("sakai.tool.placement.id");
        return iFrameId;
    }

    public void setIframeId(String iframeId) {
        this.iframeId = iframeId;
    }

    public String getCustomLocation() {
        return this.customLocation;
    }

    public void setCustomLocation(String customLocation) {
        this.customLocation = customLocation;
    }

    public String getCustomCategory() {
        return this.customCategory;
    }

    public void setCustomCategory(String customCategory) {
        this.customCategory = customCategory;
    }

    public SignupCalendarHelper getCalendarHelper() {
        return this.calendarHelper;
    }

    public void setCalendarHelper(SignupCalendarHelper calendarHelper) {
        this.calendarHelper = calendarHelper;
    }
}

